/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.info.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.ApiParamItem;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.ApiTestDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.logicresource.dto.CanvasDebugDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiCanvasRuntimeService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiLogicApiVerifyService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.eai.common.util.WebSocketUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.info.service.impl.EaiLogicApiVerifyServiceImpl")
public class EaiLogicApiVerifyServiceImpl
implements EaiLogicApiVerifyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiLogicApiVerifyServiceImpl.class);
    private static final String RESULT_STR = "result";
    private static final String LEVEL_STR = "level";
    private static final String ERROR_STR = "error";
    private static final String LOGS_STR = "logs";
    private static final String MESSAGE_STR = "message";
    private static final String BODY_STR = "body";
    private static final String EXCEPTION_MESSAGE_STR = "exceptionMessage";
    @Resource
    IEaiApiInfoService eaiApiInfoService;
    @Resource
    EaiCanvasRuntimeService canvasRuntimeService;
    @Resource
    private IEaiEditApiService iEaiEditApiService;
    private final ExecutorService threadPoolExecutor = TtlExecutors.getTtlExecutorService((ExecutorService)Executors.newSingleThreadExecutor());
    @Resource
    private ICanvasInfoService eaiCanvasInfoService;

    public ApiResponse<EaiApiResponseVo> convertTest(ApiTestDto apiTestDto) {
        EaiParamsConvertDto eaiParamsConvertDto = new EaiParamsConvertDto();
        if (HussarUtils.isNotEmpty((Object)apiTestDto.getInParams())) {
            if (HussarUtils.isNotEmpty((Object)apiTestDto.getInParams().getBody())) {
                eaiParamsConvertDto.setBody((EaiParamsItems)apiTestDto.getInParams().getBody().get(0));
            }
            eaiParamsConvertDto.setHeader(apiTestDto.getInParams().getHeader());
            eaiParamsConvertDto.setQuery(apiTestDto.getInParams().getQuery());
        }
        apiTestDto.setRealInParams(eaiParamsConvertDto);
        AssertUtil.isNotNull((Object)apiTestDto.getApiId(), (String)"\u63a5\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
        ApiInfo apiInfo = (ApiInfo)this.eaiApiInfoService.getById((Serializable)apiTestDto.getApiId());
        if (HussarUtils.isNotEmpty((Object)apiInfo)) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(EditApi::getApiId, (Object)apiTestDto.getApiId());
            EditApi editApi = (EditApi)this.iEaiEditApiService.getOne((Wrapper)queryWrapper);
            CanvasDebugDto canvasDebugDto = this.convetTestParams(apiTestDto, apiInfo, editApi);
            ApiResponse apiResponse = null;
            try {
                apiResponse = this.canvasRuntimeService.runWithDebug(canvasDebugDto);
            }
            catch (BaseException e) {
                LOGGER.error("\u753b\u5e03\u8c03\u8bd5\u4ee3\u7801\u751f\u6210\u6216\u6267\u884c\u5f02\u5e38 id={}, code={}, name={}, app={}", new Object[]{canvasDebugDto.getId(), canvasDebugDto.getCode(), canvasDebugDto.getName(), canvasDebugDto.getApplicationCode(), e});
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
            catch (Exception ex) {
                LOGGER.error("\u753b\u5e03\u8c03\u8bd5\u4ee3\u7801\u751f\u6210\u6216\u6267\u884c\u5f02\u5e38 id={}, code={}, name={}, app={}", new Object[]{canvasDebugDto.getId(), canvasDebugDto.getCode(), canvasDebugDto.getName(), canvasDebugDto.getApplicationCode(), ex});
                throw new BaseException("\u9a8c\u8bc1\u5931\u8d25", (Throwable)ex);
            }
            finally {
                TempHttpCode.removeAll();
            }
            if (apiResponse.isSuccess()) {
                if (HussarUtils.isNotEmpty((Object)apiResponse.getData())) {
                    JSONObject debugResult = JSON.parseObject((String)JSON.toJSONString((Object)apiResponse.getData()));
                    EaiApiResponseVo apiResponseVo = new EaiApiResponseVo();
                    EaiApiResponse apiResponse1 = new EaiApiResponse();
                    Object obj = debugResult.get((Object)RESULT_STR);
                    apiResponse1.setBody(obj);
                    if (HussarUtils.isNotEmpty((Object)apiTestDto.getServiceId()) && HussarUtils.isNotEmpty((Object)debugResult.get((Object)LOGS_STR))) {
                        JSONArray logs = debugResult.getJSONArray(LOGS_STR);
                        this.threadPoolExecutor.execute(() -> logs.forEach(log -> {
                            JSONObject l = JSON.parseObject((String)JSON.toJSONString((Object)log));
                            String level = l.getString(LEVEL_STR);
                            WebSocketUtil.senMsg((String)apiTestDto.getServiceId(), (String)l.getString(MESSAGE_STR), (String)level, null);
                        }));
                    }
                    if (HussarUtils.isNotEmpty((Object)debugResult.getJSONObject(ERROR_STR))) {
                        apiResponse1.setException(debugResult.getJSONObject(ERROR_STR).getString(EXCEPTION_MESSAGE_STR));
                        apiResponseVo.setOuturlResponse(apiResponse1);
                        apiResponseVo.setOuturlRequestParams(this.dtoHeaderToMap(apiTestDto.getRealInParams()));
                        return ApiResponse.success((Object)apiResponseVo, (String)"\u9a8c\u8bc1\u5931\u8d25");
                    }
                    apiResponseVo.setOuturlResponse(apiResponse1);
                    apiResponseVo.setOuturlRequestParams(this.dtoHeaderToMap(apiTestDto.getRealInParams()));
                    apiResponseVo.setEscapeResponse((Object)ApiResponse.success((Object)obj));
                    return ApiResponse.success((Object)apiResponseVo);
                }
                return ApiResponse.success((Object)new EaiApiResponseVo());
            }
            throw new BaseException(apiResponse.getMsg());
        }
        throw new BaseException("\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38,\u672a\u77e5\u53c2\u6570\u5f02\u5e38");
    }

    private CanvasDebugDto convetTestParams(ApiTestDto apiTestDto, ApiInfo apiInfo, EditApi editApi) {
        CanvasInfo canvasInfo = (CanvasInfo)this.eaiCanvasInfoService.getById((Serializable)editApi.getCanvasId());
        CanvasDebugDto canvasDebugDto = new CanvasDebugDto();
        canvasDebugDto.setCode(apiInfo.getApiCode());
        canvasDebugDto.setCanvas(canvasInfo.getCanvasContent());
        canvasDebugDto.setResourceEnum(EaiResourcesEnum.API);
        canvasDebugDto.setName(apiInfo.getApiName());
        canvasDebugDto.setApplicationCode(apiInfo.getApplicationCode());
        Map<String, Object> map = this.headerToMap(apiTestDto.getHeader());
        canvasDebugDto.setHttpHeader(map);
        canvasDebugDto.setHttpBody(apiTestDto.getBody());
        canvasDebugDto.setId(apiInfo.getId());
        return canvasDebugDto;
    }

    private Map<String, Object> dtoHeaderToMap(EaiParamsConvertDto apiParamItems) {
        if (HussarUtils.isEmpty((Object)apiParamItems)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        EaiParamsItems body = apiParamItems.getBody();
        map.put(BODY_STR, this.paramsToMap(body));
        List header = apiParamItems.getHeader();
        map.put("header", this.paramsToMap(header));
        List query = apiParamItems.getQuery();
        map.put("query", this.paramsToMap(query));
        return map;
    }

    private Map<String, Object> paramsToMap(EaiParamsItems apiParamItems) {
        if (HussarUtils.isEmpty((Object)apiParamItems)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty((Object)apiParamItems.getItems())) {
            Map<String, Object> childMap = this.paramsToMap(apiParamItems.getItems());
            map.put(apiParamItems.getName(), childMap);
        } else {
            map.put(apiParamItems.getName(), apiParamItems.getValue());
        }
        return map;
    }

    private Map<String, Object> paramsToMap(List<EaiParamsItems> apiParamItems) {
        if (HussarUtils.isEmpty(apiParamItems)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(apiParamItems.size());
        apiParamItems.forEach(apiParamItem -> {
            if (HussarUtils.isNotEmpty((Object)apiParamItem.getItems())) {
                Map<String, Object> childMap = this.paramsToMap(apiParamItem.getItems());
                map.put(apiParamItem.getName(), childMap);
            } else {
                map.put(apiParamItem.getName(), apiParamItem.getValue());
            }
        });
        return map;
    }

    private Map<String, Object> headerToMap(List<ApiParamItem> apiParamItems) {
        if (HussarUtils.isEmpty(apiParamItems)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(apiParamItems.size());
        apiParamItems.forEach(apiParamItem -> map.put(apiParamItem.getName(), apiParamItem.getValue()));
        return map;
    }
}

