/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.info.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.api.canvas.support.service.EaiCanvasResourceService;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.StructureVersionVo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.CanvasInfoDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.info.service.EaiCanvasInfoService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonLogic;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonLogicService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.IEaiCanvaParamsConvertService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.info.service.impl.EaiCanvasInfoServiceImpl")
public class EaiCanvasInfoServiceImpl
implements EaiCanvasInfoService {
    @Resource
    private ICanvasInfoService canvasInfoService;
    @Resource
    private ICommonLogicService eaiCommonLogicService;
    @Resource
    IEaiCanvaParamsConvertService eaiCanvaParamsConvertService;
    @Resource
    private EaiCanvasResourceService canvasResourceService;
    @Resource
    ICommonStructureService commonStructureService;

    @HussarTransactional
    public Boolean saveCanvasInfo(CanvasInfoDto canvasInfoDto) {
        CommonLogic commonLogic = (CommonLogic)this.eaiCommonLogicService.getById((Serializable)canvasInfoDto.getLogicId());
        if (ToolUtil.isEmpty((Object)commonLogic)) {
            throw new BaseException("\u516c\u5171\u903b\u8f91\u83b7\u53d6\u5931\u8d25");
        }
        CanvasInfo canvasInfo = this.dtoToModel(canvasInfoDto);
        long canvasId = commonLogic.getCanvasId();
        if (ToolUtil.isNotEmpty((Object)canvasId) && canvasId != 0L) {
            canvasInfo.setId(Long.valueOf(commonLogic.getCanvasId()));
        }
        if (this.canvasInfoService.saveOrUpdate((Object)canvasInfo)) {
            commonLogic.setCanvasId(canvasInfo.getId().longValue());
            commonLogic.setLogicTest(canvasInfoDto.getLogicTest());
            if (HussarUtils.isNotEmpty((Object)canvasInfoDto.getCanvasInParams()) && HussarUtils.isNotEmpty((Object)canvasInfoDto.getCanvasInParams().getBody())) {
                commonLogic.setInParams(this.eaiCanvaParamsConvertService.convertInParamsStr(commonLogic.getApplicationCode(), commonLogic.getLogicCode(), canvasInfoDto.getCanvasInParams().getBody()));
            } else {
                commonLogic.setInParams("[]");
            }
            commonLogic.setOutParams(this.eaiCanvaParamsConvertService.convertOutParams(canvasInfoDto.getOutParams()));
            return this.eaiCommonLogicService.updateById((Object)commonLogic);
        }
        throw new BaseException("\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    private CanvasInfo dtoToModel(CanvasInfoDto canvasInfoDto) {
        CanvasInfo canvasInfo = new CanvasInfo();
        canvasInfo.setCanvasContent(canvasInfoDto.getCanvasInfo());
        canvasInfo.setCanvasResources(JSON.toJSONString((Object)canvasInfoDto.getRelateFiles()));
        canvasInfo.setApiCodes(JSON.toJSONString((Object)canvasInfoDto.getApiEventrelates()));
        return canvasInfo;
    }

    public Boolean deleteApiCanvasInfo(EditApi editApi) {
        Long id = editApi.getCanvasId();
        if (StringUtil.isNotEmpty((Object)id)) {
            return this.deleteCanvasInfos(id, editApi.getInParams());
        }
        return true;
    }

    public Boolean deleteApiCanvasInfos(List<EditApi> editApis) {
        List<Long> canvasIds = editApis.stream().map(EditApi::getCanvasId).collect(Collectors.toList());
        List<String> inparams = editApis.stream().map(EditApi::getInParams).collect(Collectors.toList());
        return this.deleteCanvasInfos(canvasIds, inparams);
    }

    public Boolean deleteLogicCanvasInfo(CommonLogic commonLogic) {
        Long id = commonLogic.getCanvasId();
        if (StringUtil.isNotEmpty((Object)id)) {
            return this.deleteCanvasInfos(id, commonLogic.getInParams());
        }
        return true;
    }

    public Boolean deleteLogicCanvasInfos(List<CommonLogic> commonLogics) {
        List<Long> canvasIds = commonLogics.stream().map(CommonLogic::getCanvasId).collect(Collectors.toList());
        List<String> inparams = commonLogics.stream().map(CommonLogic::getInParams).collect(Collectors.toList());
        return this.deleteCanvasInfos(canvasIds, inparams);
    }

    public ApiResponse<Object> getByIdForCanvas(String type, Long structVersionId) {
        ApiResponse response = this.canvasResourceService.getById("open", type, Boolean.valueOf(true), structVersionId);
        if (response.isSuccess()) {
            StructureVersion structureVersion = (StructureVersion)response.getData();
            StructureVersionVo structureVersionVo = new StructureVersionVo();
            BeanUtil.copy((Object)structureVersion, (Object)structureVersionVo);
            structureVersionVo.setName(structureVersion.getStructureCode());
            String desc = structureVersion.getStructureName();
            if (StringUtil.isEmpty((Object)desc)) {
                desc = structureVersion.getStructureCode();
            }
            structureVersionVo.setDesc(desc);
            return ApiResponse.success((Object)structureVersionVo);
        }
        return ApiResponse.success();
    }

    private Boolean deleteCanvasInfos(Long canvasId, String inparams) {
        List paramsItems = ParamsConvertUtil.toEaiParamsItems((String)inparams);
        if (HussarUtils.isNotEmpty((Object)paramsItems) && EaiDataType.DATA_TYPE_STRUCTURE.getType() == ((EaiParamsItems)paramsItems.get(0)).getType().intValue() && "Object".equals(((EaiParamsItems)paramsItems.get(0)).getValue())) {
            this.commonStructureService.removeById((Serializable)Long.valueOf(((EaiParamsItems)paramsItems.get(0)).getQuoteStructureId()));
        }
        return this.canvasInfoService.removeById((Serializable)canvasId);
    }

    private Boolean deleteCanvasInfos(List<Long> canvasIds, List<String> inparams) {
        List canvasIdsNew;
        ArrayList ids = new ArrayList();
        inparams.forEach(inparam -> {
            List paramsItems = ParamsConvertUtil.toEaiParamsItems((String)inparam);
            if (HussarUtils.isNotEmpty((Object)paramsItems) && EaiDataType.DATA_TYPE_STRUCTURE.getType() == ((EaiParamsItems)paramsItems.get(0)).getType().intValue() && HussarUtils.isEmpty((Object)((EaiParamsItems)paramsItems.get(0)).getName())) {
                ids.add(Long.valueOf(((EaiParamsItems)paramsItems.get(0)).getQuoteStructureId()));
            }
        });
        if (HussarUtils.isNotEmpty(ids)) {
            this.commonStructureService.removeByIds(ids);
        }
        if (HussarUtils.isNotEmpty(canvasIdsNew = canvasIds.stream().filter(id -> StringUtil.isNotEmpty((Object)id)).collect(Collectors.toList()))) {
            return this.canvasInfoService.removeByIds(canvasIds);
        }
        return true;
    }
}

