/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.copyresources;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.dto.CodeDto;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.dto.CopyParams;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.factory.CopyResourceServiceFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.service.CopyNumService;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.service.CopyResourceService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlogic.vo.CommonLogicInfoVo;
import com.jxdinfo.hussar.eai.common.annotation.EaiAuthCheck;
import com.jxdinfo.hussar.eai.common.annotation.EaiAuthResourceType;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.service.EaiConvertService;
import com.jxdinfo.hussar.eai.common.util.EaiCounterUtil;
import com.jxdinfo.hussar.eai.common.util.ResourcesNumUtil;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonLogic;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonLogicService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.copyresources.ApiToLogicServiceImpl")
public class ApiToLogicServiceImpl
implements CopyResourceService<CommonLogicInfoVo> {
    private static final String API_TO_LOGIC = "api_default_logic";
    @Resource
    private IEaiApiInfoService apiInfoService;
    @Resource
    private IEaiEditApiService eaiEditApiService;
    @Resource
    private ICanvasInfoService canvasInfoService;
    @Resource
    private ICommonLogicService commonLogicService;
    @Resource
    private CopyNumService copyNumService;
    @Resource
    protected EaiConvertService eaiConvertService;

    public void afterPropertiesSet() throws Exception {
        CopyResourceServiceFactory.registerCopyResourceService((String)API_TO_LOGIC, (CopyResourceService)this);
    }

    @EaiAuthCheck(paramName="id", paramType="id", sourceType=EaiAuthResourceType.API)
    public ApiResponse<CommonLogicInfoVo> copyResult(CopyParams copyParams) {
        ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)Long.valueOf(copyParams.getId()));
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)apiInfo.getId());
        EditApi editApi = (EditApi)this.eaiEditApiService.getOne((Wrapper)queryWrapper);
        CanvasInfo canvasInfo = (CanvasInfo)this.canvasInfoService.getById((Serializable)editApi.getCanvasId());
        CommonLogicInfoVo commonLogicVo = new CommonLogicInfoVo();
        String logicCode = apiInfo.getApiCode();
        String logicName = apiInfo.getApiName();
        String applicationCode = apiInfo.getApplicationCode();
        CodeDto codeDto = this.checkCode(logicCode, applicationCode, true);
        String newLogicCode = String.format("lj_%s_%d", codeDto.getCode(), codeDto.getNum());
        CodeDto nameDto = this.checkCode(logicName, applicationCode, false);
        String newLogicName = String.format("\u903b\u8f91_%s_%d", nameDto.getCode(), nameDto.getNum());
        EaiCounterUtil.getInstanceReduceQueue((String)String.format("%s_%s", codeDto.getCode(), EaiResourcesEnum.LOGIC.getType()));
        EaiCounterUtil.getInstanceReduceQueue((String)String.format("%s_%s", nameDto.getCode(), EaiResourcesEnum.LOGIC.getType()));
        commonLogicVo.setCanvasId(null);
        commonLogicVo.setCanvasInfo(canvasInfo.getCanvasContent());
        commonLogicVo.setLogicCode(newLogicCode);
        commonLogicVo.setLogicName(newLogicName);
        commonLogicVo.setInParams(this.eaiConvertService.toEaiParamsConvertDto(apiInfo.getInParams()));
        commonLogicVo.setOutParams(this.eaiConvertService.toEaiParamsConvertDto(apiInfo.getOutParams()));
        commonLogicVo.setLogicTest("0");
        commonLogicVo.setLogicId(null);
        return ApiResponse.success((Object)commonLogicVo);
    }

    private CodeDto checkCode(String logicCode, String applicationCode, boolean isCode) {
        String code = ResourcesNumUtil.getName((String)logicCode);
        CodeDto result = this.copyNumService.getChangeNum(logicCode, this.getNumFromList(code, isCode), EaiResourcesEnum.LOGIC.getType());
        logicCode = result.getCode();
        long num = result.getNum();
        String newLogicCode = String.format("%s_%d", logicCode, num);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CommonLogic::getApplicationCode, (Object)applicationCode);
        if (isCode) {
            queryWrapper.eq(CommonLogic::getLogicCode, (Object)newLogicCode);
        } else {
            queryWrapper.eq(CommonLogic::getLogicName, (Object)newLogicCode);
        }
        long b = this.commonLogicService.count((Wrapper)queryWrapper);
        boolean checkCode = b < 1L;
        result.setChecked(checkCode);
        while (!checkCode) {
            result = this.checkCode(logicCode, applicationCode, isCode);
            checkCode = result.getChecked();
        }
        return result;
    }

    private Long getNumFromList(String code, boolean isCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (isCode) {
            queryWrapper.like(CommonLogic::getLogicCode, (Object)code);
        } else {
            queryWrapper.like(CommonLogic::getLogicName, (Object)code);
        }
        Long num = 0L;
        List logics = this.commonLogicService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)logics)) {
            List<Object> list = new ArrayList();
            list = isCode ? logics.stream().map(CommonLogic::getLogicCode).collect(Collectors.toList()) : logics.stream().map(CommonLogic::getLogicName).collect(Collectors.toList());
            num = ResourcesNumUtil.getMaxNum(list);
        }
        return num;
    }
}

