/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.commonlink.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.appinfo.api.service.IAppStateService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.appinfo.api.vo.ApplicationManageVo;
import com.jxdinfo.hussar.eai.appinfo.server.common.EaiAppEditManager;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonConnectionVo;
import com.jxdinfo.hussar.eai.atomicbase.api.resourcerelation.service.EaiAppStatusBaseService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.dto.CommonConnectionDto;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.factory.EaiAppConnectionFactory;
import com.jxdinfo.hussar.eai.atomicenhancements.api.commonlink.service.EaiCommonConnectionService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.info.dao.EaiCommonConnectionMapper;
import com.jxdinfo.hussar.eai.common.enums.app.EaiAppConnectionEnum;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.commonlink.service.impl.EaiCommonConnectionServiceImpl")
public class EaiCommonConnectionServiceImpl
implements EaiCommonConnectionService {
    @Resource
    ICommonConnectionService commonConnectionService;
    @Resource
    private EaiAppStatusBaseService eaiAppStatusService;
    @Resource
    private IApplicationManagementService applicationManagementService;
    @Autowired
    EaiCommonConnectionMapper commonConnectionMapper;
    @Resource
    private IAppStateService appStateService;

    @HussarTransactional
    public Boolean addConnection(CommonConnectionDto commonConnectionDto) {
        AssertUtil.isNotNull((Object)commonConnectionDto, (String)"\u8fde\u63a5\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        this.extractedCanvas(commonConnectionDto);
        AssertUtil.isNotNull((Object)commonConnectionDto.getConnectionNameEn(), (String)"\u8fde\u63a5\u6807\u8bc6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        this.checkUniqueConnectionNameEn(commonConnectionDto.getApplicationCode(), commonConnectionDto.getConnectionNameEn(), null);
        commonConnectionDto.setCreateBy(BaseSecurityUtil.getUser().getUserName());
        String appConnectionKey = this.getAppConnectionKey(commonConnectionDto.getConnectionClassify(), commonConnectionDto.getClassifyChild());
        EaiAppEditManager.getInstance().call(commonConnectionDto.getApplicationCode());
        return EaiAppConnectionFactory.getInvokeAppConnection((String)appConnectionKey).saveConnection(commonConnectionDto);
    }

    private void extractedCanvas(CommonConnectionDto commonConnectionDto) {
        if (StringUtil.isNotEmpty((Object)commonConnectionDto.getName())) {
            commonConnectionDto.setConnectionNameEn(commonConnectionDto.getName());
        }
        if (StringUtil.isNotEmpty((Object)commonConnectionDto.getDesc())) {
            commonConnectionDto.setConnectionName(commonConnectionDto.getDesc());
        }
    }

    @HussarTransactional
    public Boolean updateConnection(CommonConnectionDto commonConnectionDto) {
        AssertUtil.isNotNull((Object)commonConnectionDto, (String)"\u8fde\u63a5\u4fe1\u606f\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        AssertUtil.isNotNull((Object)commonConnectionDto.getId(), (String)"\u8fde\u63a5\u4fe1\u606fId\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        AssertUtil.isNotNull((Object)commonConnectionDto.getApplicationCode(), (String)"\u6240\u5c5e\u5e94\u7528\u6807\u8bc6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        this.extractedCanvas(commonConnectionDto);
        AssertUtil.isNotNull((Object)commonConnectionDto.getConnectionNameEn(), (String)"\u8fde\u63a5\u6807\u8bc6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        this.appStateService.checkAppStatus(commonConnectionDto.getApplicationCode(), "\u516c\u5171\u8fde\u63a5");
        this.checkUniqueConnectionNameEn(commonConnectionDto.getApplicationCode(), commonConnectionDto.getName(), commonConnectionDto.getId());
        commonConnectionDto.setEditBy(BaseSecurityUtil.getUser().getUserName());
        String appConnectionKey = this.getAppConnectionKey(commonConnectionDto.getConnectionClassify(), commonConnectionDto.getClassifyChild());
        EaiAppEditManager.getInstance().call(commonConnectionDto.getApplicationCode());
        CommonConnection oldConnection = (CommonConnection)this.commonConnectionService.getById((Serializable)commonConnectionDto.getId());
        AssertUtil.isNotNull((Object)oldConnection, (String)"\u672a\u67e5\u8be2\u5230\u8fde\u63a5\u4fe1\u606f\uff01");
        return EaiAppConnectionFactory.getInvokeAppConnection((String)appConnectionKey).updateConnection(commonConnectionDto);
    }

    public CommonConnectionVo getConnectionById(Long connectionId) {
        AssertUtil.isNotNull((Object)connectionId, (String)"\u8fde\u63a5\u4fe1\u606fId\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        CommonConnection commonConnection = (CommonConnection)this.commonConnectionService.getById((Serializable)connectionId);
        String appConnectionKey = this.getAppConnectionKey(commonConnection.getConnectionClassify(), commonConnection.getClassifyChild());
        return EaiAppConnectionFactory.getInvokeAppConnection((String)appConnectionKey).getConnectionById(commonConnection);
    }

    public List<CommonConnectionVo> getConnectionsByAppCode(String appCode) {
        ArrayList commonConnectionVos = Lists.newArrayListWithCapacity((int)10);
        List commonConnections = this.commonConnectionService.list((Wrapper)new LambdaQueryWrapper().eq(CommonConnection::getApplicationCode, (Object)appCode));
        if (CollectionUtil.isNotEmpty((Collection)commonConnections)) {
            commonConnections.forEach(c -> {
                String appConnectionKey = this.getAppConnectionKey(c.getConnectionClassify(), c.getClassifyChild());
                CommonConnectionVo vo = EaiAppConnectionFactory.getInvokeAppConnection((String)appConnectionKey).getConnectionById(c);
                commonConnectionVos.add(vo);
            });
        }
        return commonConnectionVos;
    }

    public Page<CommonConnectionVo> connectionListPage(Page<CommonConnectionVo> pageInfo, CommonConnectionDto commonConnectionDto) {
        Page<CommonConnectionVo> pageConnetion;
        if (HussarUtils.isNotEmpty((Object)commonConnectionDto.getDesc())) {
            commonConnectionDto.setConnectionName(commonConnectionDto.getDesc());
        }
        if ((pageConnetion = this.commonConnectionMapper.connectionListPage(pageInfo, commonConnectionDto)).getSize() > 0L) {
            List records = pageConnetion.getRecords();
            records.forEach(c -> {
                ApplicationManageVo byAppCode;
                c.setName(c.getConnectionNameEn());
                c.setDesc(c.getConnectionName());
                if (EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_APP.getClassify().equals(c.getConnectionClassify()) && null != (byAppCode = this.applicationManagementService.getByAppCode(c.getClassifyChild()))) {
                    c.setAppName(byAppCode.getAppName());
                }
            });
        }
        return pageConnetion;
    }

    public Boolean connectionTest(CommonConnectionDto commonConnectionDto) {
        AssertUtil.isNotEmpty((String)commonConnectionDto.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtil.isNotEmpty((String)commonConnectionDto.getConnectionClassify(), (String)"\u8fde\u63a5\u5206\u7c7b\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        AssertUtil.isNotEmpty((Map)commonConnectionDto.getConnectionConfigMap(), (String)"\u8fde\u63a5\u914d\u7f6e\u4e0d\u53ef\u4ee5\u4e3a\u7a7a\uff01");
        String appConnectionKey = this.getAppConnectionKey(commonConnectionDto.getConnectionClassify(), commonConnectionDto.getClassifyChild());
        return EaiAppConnectionFactory.getInvokeAppConnection((String)appConnectionKey).connectionTest(commonConnectionDto);
    }

    public Boolean checkUniqueConnectionNameEn(String appCode, String connectionNameEn, Long connectionId) {
        List commonConnections;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CommonConnection::getConnectionNameEn, (Object)connectionNameEn);
        queryWrapper.eq(CommonConnection::getApplicationCode, (Object)appCode);
        if (HussarUtils.isNotEmpty((Object)connectionId)) {
            queryWrapper.ne(CommonConnection::getId, (Object)connectionId);
        }
        if (CollectionUtil.isNotEmpty((Collection)(commonConnections = this.commonConnectionService.list((Wrapper)queryWrapper)))) {
            throw new BaseException("\u8fde\u63a5\u6807\u8bc6\u4e0d\u5141\u8bb8\u91cd\u590d\uff01");
        }
        return true;
    }

    @HussarTransactional
    public Boolean deleteConnection(Long id) {
        CommonConnection commonConnection = (CommonConnection)this.commonConnectionService.getById((Serializable)id);
        String appConnectionKey = this.getAppConnectionKey(commonConnection.getConnectionClassify(), commonConnection.getClassifyChild());
        EaiAppEditManager.getInstance().call(commonConnection.getApplicationCode());
        return EaiAppConnectionFactory.getInvokeAppConnection((String)appConnectionKey).deleteConnection(commonConnection);
    }

    public Boolean checkUniqueConnectionName(String appCode, String connectionName, Long connectionId) {
        List commonConnections;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CommonConnection::getConnectionName, (Object)connectionName);
        queryWrapper.eq(CommonConnection::getApplicationCode, (Object)appCode);
        if (HussarUtils.isNotEmpty((Object)connectionId)) {
            queryWrapper.ne(CommonConnection::getId, (Object)connectionId);
        }
        if (CollectionUtil.isNotEmpty((Collection)(commonConnections = this.commonConnectionService.list((Wrapper)queryWrapper)))) {
            throw new BaseException("\u8fde\u63a5\u540d\u79f0\u4e0d\u5141\u8bb8\u91cd\u590d\uff01");
        }
        return true;
    }

    private String getAppConnectionKey(String classify, String classifyChild) {
        String appConnectionKey = null;
        appConnectionKey = EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_APP.getClassify().equals(classify) ? EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_APP.getClassify() + "_" + EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_APP.getClassifyChild() : (EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_RDB.getClassify().equals(classify) ? EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_RDB.getClassify() + "_" + EaiAppConnectionEnum.CLASSIFY_CLASSIFYCHILD_RDB.getClassifyChild() : classify + "_" + classifyChild);
        return appConnectionKey;
    }
}

