/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.ApiCanvasBaseInfo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.CanvasParams;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.CanvasVariableBaseInfo;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.CanvasVariableBaseInfoSet;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.dto.CanvasVariableResReferences;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.support.service.IEaiGenerateCanvasBaseInfoCommonService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.service.impl.EaiGenerateCanvasBaseInfoCommonServiceImpl")
public class EaiGenerateCanvasBaseInfoCommonServiceImpl
implements IEaiGenerateCanvasBaseInfoCommonService {
    private static final String KEY_STRUCTURE = "structure";
    @Resource
    private IApplicationManagementService managementService;

    public void canvasSlotsDefaultCommonPackage(ApiCanvasBaseInfo canvasSlotsDefault, boolean isContainer, String instanceKey, String parentInstanceKey, String logicName, String alias, String position, String goInPathesInsk, String goOutPathesInsk, AtomicInteger zIndex, Integer x, Integer y, Integer height, Integer width, Integer top, Integer left) {
        canvasSlotsDefault.setIsContainer(Boolean.valueOf(isContainer));
        canvasSlotsDefault.setInstanceKey(instanceKey);
        canvasSlotsDefault.setLabel(alias);
        canvasSlotsDefault.setAlias(canvasSlotsDefault.getLabel());
        canvasSlotsDefault.setInstanceDecoration(canvasSlotsDefault.getInstanceKey());
        canvasSlotsDefault.setParentInstanceKey(parentInstanceKey);
        canvasSlotsDefault.setName(logicName);
        canvasSlotsDefault.setPosition(position);
        canvasSlotsDefault.setLayout(canvasSlotsDefault.getPosition());
        if (StringUtil.isNotEmpty((Object)goInPathesInsk)) {
            canvasSlotsDefault.setGoInPathes(Arrays.asList(goInPathesInsk));
        }
        if (StringUtil.isNotEmpty((Object)goOutPathesInsk)) {
            canvasSlotsDefault.setGoOutPathes(Arrays.asList(goOutPathesInsk));
        }
        canvasSlotsDefault.setzIndex(Integer.valueOf(zIndex.incrementAndGet()));
        canvasSlotsDefault.setX(x);
        canvasSlotsDefault.setY(y);
        canvasSlotsDefault.setHeight(height);
        canvasSlotsDefault.setWidth(width);
        canvasSlotsDefault.setTop(top);
        canvasSlotsDefault.setLeft(left);
        canvasSlotsDefault.setLr(this.getLr(canvasSlotsDefault.getX(), canvasSlotsDefault.getWidth()));
        canvasSlotsDefault.setL(canvasSlotsDefault.getX());
        canvasSlotsDefault.setR(Integer.valueOf(canvasSlotsDefault.getX() + canvasSlotsDefault.getWidth()));
        canvasSlotsDefault.setT(canvasSlotsDefault.getY());
        canvasSlotsDefault.setB(this.getB(canvasSlotsDefault.getY(), canvasSlotsDefault.getHeight()));
        canvasSlotsDefault.setTb(this.getTb(canvasSlotsDefault.getY(), canvasSlotsDefault.getHeight()));
    }

    public Integer getLr(Integer x, Integer width) {
        return Math.round(Float.valueOf(x.intValue()).floatValue() + Float.valueOf(width.intValue()).floatValue() / 2.0f);
    }

    public Integer getR(Integer x, Integer width) {
        return Math.round(Float.valueOf(x.intValue()).floatValue() + Float.valueOf(width.intValue()).floatValue());
    }

    public Integer getTb(Integer y, Integer height) {
        return Math.round(Float.valueOf(y.intValue()).floatValue() + Float.valueOf(height.intValue()).floatValue() / 2.0f);
    }

    public Integer getB(Integer y, Integer height) {
        return Math.round(Float.valueOf(y.intValue()).floatValue() + Float.valueOf(height.intValue()).floatValue());
    }

    public void variableBaseInfoPackage(String variableName, List<CanvasVariableBaseInfo> params) {
        CanvasVariableBaseInfo variableBaseInfo = new CanvasVariableBaseInfo();
        variableBaseInfo.setVarName(variableName);
        variableBaseInfo.setChildren(null);
        variableBaseInfo.setParentInsKey("#");
        variableBaseInfo.setSource("hussar_0");
        params.add(variableBaseInfo);
    }

    public String getDefaultValue(EaiParamsItems paramsItems) {
        if (0 == EaiDataType.getEaiDataType((Integer)paramsItems.getType()).getType()) {
            return "false";
        }
        if (EaiDataType.DATA_TYPE_INTEGER.equals((Object)EaiDataType.getEaiDataType((Integer)paramsItems.getType()))) {
            return "0";
        }
        if (EaiDataType.DATA_TYPE_LONG.equals((Object)EaiDataType.getEaiDataType((Integer)paramsItems.getType()))) {
            return "0";
        }
        if (EaiDataType.DATA_TYPE_DOUBLE.equals((Object)EaiDataType.getEaiDataType((Integer)paramsItems.getType()))) {
            return "0.0";
        }
        if (EaiDataType.DATA_TYPE_STRING.equals((Object)EaiDataType.getEaiDataType((Integer)paramsItems.getType()))) {
            return "";
        }
        if (EaiDataType.DATA_TYPE_DATE.equals((Object)EaiDataType.getEaiDataType((Integer)paramsItems.getType()))) {
            return "1970-01-01 00:00:00";
        }
        if (EaiDataType.DATA_TYPE_LIST.equals((Object)EaiDataType.getEaiDataType((Integer)paramsItems.getType()))) {
            return "[]";
        }
        if (EaiDataType.DATA_TYPE_STRUCTURE.equals((Object)EaiDataType.getEaiDataType((Integer)paramsItems.getType()))) {
            return "{}";
        }
        return "";
    }

    public void variableResReferencePackage(String field, EaiParamsItems paramsItems, Map<String, CanvasVariableResReferences> resReferencesIndex) {
        HashSet structIdSet = Sets.newHashSetWithExpectedSize((int)1);
        this.getStructId(paramsItems, structIdSet);
        if (CollectionUtil.isEmpty((Collection)structIdSet)) {
            return;
        }
        String structId = (String)structIdSet.iterator().next();
        this.resReferencesIndexPackage(field, structId, resReferencesIndex);
    }

    public void variableResReferencePackageByLocalVar(String field, String structId, Map<String, CanvasVariableResReferences> resReferencesIndex) {
        this.resReferencesIndexPackage(field, structId, resReferencesIndex);
    }

    public void getStructId(EaiParamsItems paramsItems, Set<String> structIdSet) {
        if (null != EaiDataType.getBaseModelType((Integer)paramsItems.getType())) {
            return;
        }
        if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getType().intValue()) {
            String structId = paramsItems.getQuoteStructureId();
            structIdSet.add(structId);
            return;
        }
        if (null != EaiDataType.getBaseModelType((Integer)paramsItems.getItemType())) {
            return;
        }
        this.getStructId((EaiParamsItems)paramsItems.getItems().get(0), structIdSet);
    }

    private void resReferencesIndexPackage(String field, String structId, Map<String, CanvasVariableResReferences> resReferencesIndex) {
        CanvasVariableResReferences resReferences = new CanvasVariableResReferences();
        resReferences.setField(field);
        resReferences.setReferPath("");
        resReferences.setReferResId("");
        resReferences.setRefType("resource");
        resReferences.setFieldDesc("");
        resReferences.setReferPosId("hussar_0");
        resReferences.setId(structId + resReferences.getReferPosId() + resReferences.getField());
        resReferences.setUseType("dataStructure");
        resReferences.setType("propertyValue");
        resReferences.setResId(structId);
        resReferences.setInstanceKey("hussar_0");
        resReferencesIndex.put(resReferences.getId(), resReferences);
    }

    public CanvasParams paramsPackage(EaiParamsItems h, List<CanvasParams> params, String defaultValue, String icon, Boolean hasDefault) {
        CanvasParams canvasParams = new CanvasParams();
        canvasParams.setHasDefault(hasDefault);
        canvasParams.setChangedField("description");
        canvasParams.setDefaultValue(defaultValue);
        canvasParams.setName(h.getMappingName());
        canvasParams.setIcon(icon);
        canvasParams.setDescription(h.getMark());
        canvasParams.setId(UUID.randomUUID().toString());
        canvasParams.setTitle(h.getMappingName());
        ArrayList type = Lists.newArrayListWithCapacity((int)10);
        this.managementService.assembleType(h, (List)type, Boolean.valueOf(false));
        canvasParams.setType((List)type);
        canvasParams.setIsDisplay(Boolean.valueOf(false));
        params.add(canvasParams);
        return canvasParams;
    }

    public void componentVariablesPackage(String instancekey, CanvasVariableBaseInfoSet variableSets) {
        CanvasVariableBaseInfo backendWebserviceConnectorVariable = new CanvasVariableBaseInfo();
        backendWebserviceConnectorVariable.setVarName(instancekey);
        backendWebserviceConnectorVariable.setChildren(null);
        backendWebserviceConnectorVariable.setParentInsKey("hussar_0");
        backendWebserviceConnectorVariable.setSource(backendWebserviceConnectorVariable.getVarName());
        variableSets.setComponentVariables(Arrays.asList(backendWebserviceConnectorVariable));
    }

    public void countStructId(Map<String, Integer> relateFiles, String structId) {
        String relateFileKey = "structure:" + structId;
        if (CollectionUtil.isEmpty(relateFiles)) {
            relateFiles.put(relateFileKey, 1);
        } else if (relateFiles.containsKey(relateFileKey)) {
            Integer count = relateFiles.get(relateFileKey);
            relateFiles.put(relateFileKey, count + 1);
        } else {
            relateFiles.put(relateFileKey, 1);
        }
    }

    public Map<String, Object> getHeaderProps(int paramsSize) {
        HashMap props = Maps.newHashMapWithExpectedSize((int)5);
        ArrayList mapEntries = Lists.newArrayListWithCapacity((int)5);
        ArrayList mapValueSlots = Lists.newArrayListWithCapacity((int)5);
        ArrayList mapKeySlots = Lists.newArrayListWithCapacity((int)5);
        ArrayList items = Lists.newArrayListWithCapacity((int)5);
        for (int h = 0; h < paramsSize; ++h) {
            HashMap mapEntry = Maps.newHashMapWithExpectedSize((int)2);
            mapEntry.put("key", "expressionMapKey" + h);
            mapEntry.put("value", "expressionMapValue" + h);
            mapEntries.add(mapEntry);
            mapValueSlots.add("expressionMapValue" + h);
            mapKeySlots.add("expressionMapKey" + h);
            HashMap item = Maps.newHashMapWithExpectedSize((int)1);
            item.put("id", h);
            items.add(item);
        }
        props.put("mapEntries", mapEntries);
        props.put("mapValueSlots", mapValueSlots);
        props.put("mapKeySlots", mapKeySlots);
        props.put("items", items);
        props.put("exegesis", "");
        props.put("listItemType", "");
        props.put("currentId", paramsSize);
        props.put("ListCheckData", Lists.newArrayListWithCapacity((int)0));
        props.put("type", Arrays.asList("map", "string", "string"));
        props.put("result", null);
        props.put("MapCheckData", Arrays.asList("map", "string", "string"));
        props.put("mapping", Lists.newArrayListWithCapacity((int)0));
        props.put("kind", "map");
        props.put("mapKeyType", "string");
        props.put("inListType", Lists.newArrayListWithCapacity((int)0));
        props.put("isListType", false);
        props.put("checkDataKv", Arrays.asList("string", "string"));
        props.put("targetVariable", new Object());
        props.put("mapValueType", "string");
        props.put("isMapConsole", false);
        props.put("isMapSlots", true);
        props.put("sourceVariables", Lists.newArrayListWithCapacity((int)0));
        props.put("isListSlots", false);
        props.put("inMapType", Arrays.asList("string", "string"));
        props.put("isMapType", true);
        return props;
    }
}

