/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiLogicRuntimeService;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl.DebugResourceLoader;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.EaiLogicSource;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ILogicSourceService;
import com.jxdinfo.hussar.logic.engine.api.DebugRuntimePool;
import com.jxdinfo.hussar.logic.engine.api.LogicRuntime;
import com.jxdinfo.hussar.logic.engine.api.ResourceLoader;
import com.jxdinfo.hussar.logic.engine.bean.DebugError;
import com.jxdinfo.hussar.logic.engine.bean.DebugLog;
import com.jxdinfo.hussar.logic.engine.bean.DebugPosition;
import com.jxdinfo.hussar.logic.engine.bean.DebugResult;
import com.jxdinfo.hussar.logic.engine.context.LogicExecutionContext;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.ExceptionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl.EaiLogicRuntimeServiceImpl")
public class EaiLogicRuntimeServiceImpl
implements EaiLogicRuntimeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiLogicRuntimeServiceImpl.class);
    @Autowired
    private LogicRuntime logicRuntime;
    private static final String DEFAULT_ERROR = "\u53c2\u6570\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38";
    @Autowired
    DebugRuntimePool debugRuntimePool;
    @Autowired
    private ILogicSourceService eaiLogicSourceService;
    @Autowired
    DebugResourceLoader debugResourceLoader;
    private static final int ERROR_LENGTH = 4000;

    public ApiResponse<Object> run(LogicExecutionContext ctx, String className, Object ... args) {
        AssertUtil.isNotEmpty((String)className, (String)"\u672a\u67e5\u8be2\u5230\u6307\u5b9a\u7c7b\u540d");
        ApiResponse response = ApiResponse.success();
        try {
            response.setData(this.logicRuntime.contextualRunWithConvert(ctx, className, args));
        }
        catch (Exception e) {
            response.setCode(ResultCode.FAILURE.getCode());
            response.setSuccess(false);
            response.setMsg(HussarUtils.isEmpty((Object)e.getMessage()) ? DEFAULT_ERROR : e.getMessage());
            LOGGER.error("\u4e0a\u67b6\u63a5\u53e3\u753b\u5e03\u6267\u884c\u5f02\u5e38 class={}, arguments={}, context={}", new Object[]{className, Arrays.toString(args), ctx, e});
        }
        return response;
    }

    public ApiResponse<Object> run(String className, Object ... args) {
        return this.run(null, className, args);
    }

    public ApiResponse<Object> debug(LogicExecutionContext ctx, String className, Object ... args) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiLogicSource::getSourceCode, (Object)className);
        EaiLogicSource source = (EaiLogicSource)this.eaiLogicSourceService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)source)) {
            throw new BaseException("\u672a\u751f\u6210\u4ee3\u7801");
        }
        DebugResult debugResult = null;
        try {
            debugResult = this.debugRuntimePool.contextualCompileAndDebugWithConvert(ctx, source.getSourceContent(), className, Level.TRACE, (ResourceLoader)this.debugResourceLoader, args);
        }
        catch (Exception e) {
            debugResult = new DebugResult();
            debugResult.setSuccess(false);
            DebugError debugError = new DebugError();
            debugError.setExceptionMessage(e.getMessage());
            debugError.setJavaStacktrace(ExceptionUtil.stacktraceToString((Throwable)e, (int)4000));
            debugError.setExceptionName(e.getClass().getName());
            debugResult.setError(debugError);
            LOGGER.error("\u753b\u5e03\u8c03\u8bd5\u6267\u884c\u5f02\u5e38 class={}, arguments={}, context={}", new Object[]{className, Arrays.toString(args), ctx, e});
        }
        if (HussarUtils.isNotEmpty((Object)debugResult)) {
            debugResult.setResult(debugResult.getResult());
            this.logDebugResult(debugResult);
            return ApiResponse.success((Object)debugResult);
        }
        return ApiResponse.fail((String)"\u672a\u83b7\u53d6\u8c03\u8bd5\u4fe1\u606f");
    }

    private void logDebugResult(DebugResult debugResult) {
        if (!debugResult.isSuccess()) {
            Object result;
            DebugError debugError;
            if (HussarUtils.isEmpty((Object)debugResult.getLogs()) && HussarUtils.isNotEmpty((Object)(debugError = debugResult.getError()))) {
                DebugPosition debugPosition = DebugPosition.of((String)debugError.getExceptionName(), (String[])new String[]{debugError.getJavaStacktrace()});
                ArrayList<DebugLog> debugLogs = new ArrayList<DebugLog>();
                DebugLog debugLog = DebugLog.of((Level)Level.ERROR, (LocalDateTime)LocalDateTime.now(), (DebugPosition)debugPosition, (String)debugError.getExceptionMessage(), (DebugError)debugError);
                debugLogs.add(debugLog);
                debugResult.setLogs(debugLogs);
            }
            if (!((result = debugResult.getResult()) instanceof ApiResponse)) {
                debugResult.setResult((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)debugResult.getResult(), (String)debugResult.getError().getExceptionMessage()));
            }
        } else {
            debugResult.setResult((Object)ApiResponse.success((Object)debugResult.getResult()));
        }
    }
}

