/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.CommonResourcesIdMap;
import com.jxdinfo.hussar.eai.atomicbase.api.util.DistinctResources;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.logicresource.service.EaiLogicSourceService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiCanvasConvertService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.publish.dto.EaiPublishEnhancementResources;
import com.jxdinfo.hussar.eai.atomicenhancements.api.util.DistinctLogicResources;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.dto.EaiCanvasConvertDto;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.dto.GenerateDto;
import com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.support.manager.EaiCanvasCodeGenerateManager;
import com.jxdinfo.hussar.eai.common.constant.logic.EaiLogicConstant;
import com.jxdinfo.hussar.eai.common.enums.api.EaiCategoryEnum;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.StructureQuoteIdPattern;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonConnection;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CommonLogic;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonConnectionService;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICommonLogicService;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.ConnectionVersion;
import com.jxdinfo.hussar.eai.resourceexternalopen.api.model.LogicVersion;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateResult;
import com.jxdinfo.hussar.logic.structure.generate.result.LogicGenerateFile;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.runtime.impl.EaiCanvasConvertServiceImpl")
public class EaiCanvasConvertServiceImpl
extends EaiCanvasCodeGenerateManager
implements EaiCanvasConvertService {
    @Resource
    private ICommonStructureService structureService;
    @Resource
    private ICommonConnectionService commonConnectionService;
    @Resource
    private ICommonLogicService commonLogicService;
    @Resource
    private ICommonConstantService commonConstantService;
    @Resource
    private EaiLogicSourceService eaiLogicSourceService;
    @Resource
    ICanvasInfoService canvasInfoService;
    private static final String ID_ERROR = "\u753b\u5e03\u5f15\u7528\u8d44\u6e90id\u683c\u5f0f\u9519\u8bef:[%s]";
    private static final String OPEN = "open";

    public Map<Long, String> generatedCode(List<CanvasInfo> canvasInfos, Map<Long, EaiApiVersion> editApis, String applicationCode, String version) {
        if (HussarUtils.isEmpty(canvasInfos)) {
            return null;
        }
        HashMap<Long, String> result = new HashMap<Long, String>(canvasInfos.size());
        canvasInfos.forEach(canvasInfo -> {
            EaiApiVersion apiVersion = (EaiApiVersion)editApis.get(canvasInfo.getId());
            if (HussarUtils.isNotEmpty((Object)apiVersion)) {
                String name = this.generateCanvas(canvasInfo.getCanvasContent(), apiVersion, applicationCode, version);
                result.put(apiVersion.getApiVersionId(), name);
            }
        });
        return result;
    }

    private String generateCanvas(String canvas, EaiApiVersion apiVersion, String appCode, String version) {
        GenerateDto dto = new GenerateDto();
        dto.setAppCode(appCode);
        dto.setCanvas(canvas);
        dto.setDesc(apiVersion.getApiName());
        dto.setId(String.valueOf(apiVersion.getApiVersionId()));
        dto.setName(apiVersion.getApiCode());
        dto.setType(EaiResourcesEnum.API);
        dto.setVersion(version);
        LogicGenerateResult logicGenerateResult = this.generateResult(dto);
        String className = null;
        ArrayList<String> result = new ArrayList<String>();
        if (HussarUtils.isNotEmpty((Object)logicGenerateResult)) {
            List params = logicGenerateResult.getParameterNames();
            List files = logicGenerateResult.getFiles();
            className = EaiLogicConstant.getOpenPackageName((String)appCode, (EaiResourcesEnum)EaiResourcesEnum.API, (String)apiVersion.getApiCode(), (String)version);
            String clazz = null;
            if (HussarUtils.isNotEmpty((Object)files)) {
                clazz = ((LogicGenerateFile)files.get(0)).getContent();
            }
            this.eaiLogicSourceService.saveProdCode(className, clazz);
            result.add(className);
            result.addAll(params);
        }
        return JSON.toJSONString(result);
    }

    public EaiPublishEnhancementResources getCommonResourcesByCanvas(CommonResourcesIdMap commonResources, CanvasInfo canvas, Map<String, Integer> resourceMap, String version) {
        HashMap<Long, Long> constIdsMaps = new HashMap<Long, Long>();
        HashMap<Long, Long> structIdsMaps = new HashMap<Long, Long>();
        HashMap<Long, Long> connIdsMaps = new HashMap<Long, Long>();
        HashMap<Long, Long> logicIdsMaps = new HashMap<Long, Long>();
        return this.getResourcesInfo(commonResources, canvas, resourceMap, version, constIdsMaps, structIdsMaps, connIdsMaps, logicIdsMaps);
    }

    private String canvasId(Long id, String type) {
        return String.format("%s:%s", type, id);
    }

    private String logicId(Long id, String type) {
        return String.format("%s\":\"%s", type, id);
    }

    private ConnectionVersion toConnectionVersion(CommonConnection commonConnection, String appVersion) {
        ConnectionVersion connectionVersion = new ConnectionVersion();
        BeanUtil.copyProperties((Object)commonConnection, (Object)connectionVersion);
        connectionVersion.setId(EngineUtil.getId());
        connectionVersion.setConnVersion(appVersion);
        connectionVersion.setConnectionId(commonConnection.getId());
        return connectionVersion;
    }

    private ConstantVersion toConstantVersion(CommonConstant commonConstant, String version) {
        ConstantVersion constantVersion = new ConstantVersion();
        BeanUtil.copyProperties((Object)commonConstant, (Object)constantVersion);
        constantVersion.setId(EngineUtil.getId());
        constantVersion.setConstantVersion(version);
        constantVersion.setConstantId(commonConstant.getId());
        return constantVersion;
    }

    private StructureVersion toStructVersion(CommonStructure commonStructure, String version, Map<Long, Long> idMaps) {
        StructureVersion structureVersion = new StructureVersion();
        BeanUtil.copyProperties((Object)commonStructure, (Object)structureVersion);
        String value = StructureQuoteIdPattern.replaceIds((String)commonStructure.getStructureValues().trim(), idMaps);
        structureVersion.setStructureValues(value);
        structureVersion.setId(idMaps.get(commonStructure.getId()));
        structureVersion.setStructureVersion(version);
        structureVersion.setStructureId(commonStructure.getId());
        return structureVersion;
    }

    private EaiPublishEnhancementResources getResourcesInfo(CommonResourcesIdMap commonResources, CanvasInfo canvas, Map<String, Integer> resourceMap, String version, Map<Long, Long> constIdsMaps, Map<Long, Long> structIdsMaps, Map<Long, Long> connIdsMaps, Map<Long, Long> logicIdsMaps) {
        EaiPublishEnhancementResources resources = new EaiPublishEnhancementResources();
        ArrayList<Long> constIds = new ArrayList<Long>();
        ArrayList<Long> structIds = new ArrayList<Long>();
        ArrayList<Long> connIds = new ArrayList<Long>();
        ArrayList<Long> logicIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty((Object)commonResources)) {
            if (HussarUtils.isNotEmpty((Object)commonResources.getConstantMap())) {
                Map constantMap = commonResources.getConstantMap();
                constIdsMaps.putAll(constantMap);
            }
            if (HussarUtils.isNotEmpty((Object)commonResources.getStructureMap())) {
                Map structsMap = commonResources.getStructureMap();
                structIdsMaps.putAll(structsMap);
            }
            if (HussarUtils.isNotEmpty((Object)commonResources.getConnMap())) {
                Map connsMap = commonResources.getConnMap();
                connIdsMaps.putAll(connsMap);
            }
            if (HussarUtils.isNotEmpty((Object)commonResources.getLogicMap())) {
                Map logicsMap = commonResources.getLogicMap();
                logicIdsMaps.putAll(logicsMap);
            }
        }
        if (HussarUtils.isNotEmpty(resourceMap)) {
            for (Map.Entry<String, Integer> entry : resourceMap.entrySet()) {
                String k = entry.getKey();
                Integer v = entry.getValue();
                if (v == null || v <= 0) continue;
                String[] str = k.split(":");
                try {
                    if (EaiResourcesEnum.CONSTANT.getType().equals(str[0]) && !OPEN.equals(str[1])) {
                        constIds.add(Long.valueOf(str[1]));
                    }
                    if (EaiResourcesEnum.STRUCTURE.getType().equals(str[0]) && !OPEN.equals(str[1])) {
                        structIds.add(Long.valueOf(str[1]));
                    }
                    if (EaiResourcesEnum.LINK.getType().equals(str[0]) && !OPEN.equals(str[1])) {
                        connIds.add(Long.valueOf(str[1]));
                    }
                    if (!EaiResourcesEnum.LOGIC.getType().equals(str[0]) || OPEN.equals(str[1])) continue;
                    logicIds.add(Long.valueOf(str[1]));
                }
                catch (Exception e) {
                    throw new BaseException(String.format(ID_ERROR, k), (Throwable)e);
                }
            }
        }
        ArrayList logicVersions = new ArrayList();
        if (!logicIds.isEmpty()) {
            List<Long> selectLogicIds = this.getSelectIds(logicIds, logicIdsMaps);
            if (HussarUtils.isNotEmpty(selectLogicIds)) {
                List commonLogics = this.commonLogicService.listByIds(selectLogicIds);
                for (Object commonLogic : commonLogics) {
                    EaiCanvasConvertDto canvasConvertDto = new EaiCanvasConvertDto();
                    canvasConvertDto.setCommonLogic((CommonLogic)commonLogic);
                    canvasConvertDto.setVersion(version);
                    canvasConvertDto.setConnIds(connIdsMaps);
                    canvasConvertDto.setLogicIds(logicIdsMaps);
                    canvasConvertDto.setConstIds(constIdsMaps);
                    canvasConvertDto.setStructIds(structIdsMaps);
                    LogicVersion logicVersion = this.toLogicVersion(commonResources, canvasConvertDto, resources);
                    logicIdsMaps.put(logicVersion.getLogicId(), logicVersion.getId());
                }
                commonResources.setLogicMap(logicIdsMaps);
                if (HussarUtils.isNotEmpty((Object)resources.getLogicVersions())) {
                    logicVersions.addAll(resources.getLogicVersions());
                }
                resources.setLogicVersions(logicVersions);
            }
            this.reFreshCanvas(canvas, canvas.getCanvasContent(), logicIdsMaps, EaiResourcesEnum.LOGIC);
        }
        ArrayList<ConstantVersion> constantVersions = new ArrayList<ConstantVersion>();
        if (!constIds.isEmpty()) {
            List<Long> selectconstIds = this.getSelectIds(constIds, constIdsMaps);
            if (HussarUtils.isNotEmpty(selectconstIds)) {
                List commonConstants = this.commonConstantService.listByIds(selectconstIds);
                for (CommonConstant commonConstant : commonConstants) {
                    ConstantVersion constantVersion = this.toConstantVersion(commonConstant, version);
                    constIdsMaps.put(commonConstant.getId(), constantVersion.getId());
                    constantVersions.add(constantVersion);
                }
                commonResources.setConstantMap(constIdsMaps);
                if (HussarUtils.isNotEmpty((Object)resources.getInsertConstants())) {
                    constantVersions.addAll(resources.getInsertConstants());
                }
                resources.setInsertConstants(constantVersions);
            }
            this.reFreshCanvas(canvas, canvas.getCanvasContent(), constIdsMaps, EaiResourcesEnum.CONSTANT);
        }
        List<StructureVersion> structureVersions = new ArrayList();
        if (!structIds.isEmpty()) {
            List commonStructures;
            List<Long> selectstructIds = this.getSelectIds(structIds, structIdsMaps);
            if (HussarUtils.isNotEmpty(selectstructIds) && HussarUtils.isNotEmpty((Object)(commonStructures = this.structureService.listByIds(selectstructIds)))) {
                List child;
                List childs;
                ArrayList list = new ArrayList();
                commonStructures.forEach(commonStructure -> {
                    String values = commonStructure.getStructureValues();
                    List ids = StructureQuoteIdPattern.getIds((String)values);
                    if (HussarUtils.isNotEmpty((Object)ids)) {
                        for (Long id : ids) {
                            if (structIdsMaps.containsKey(id)) continue;
                            list.add(id);
                        }
                    }
                });
                if (HussarUtils.isNotEmpty(list) && HussarUtils.isNotEmpty((Object)(childs = this.structureService.listByIds(child = list.stream().distinct().collect(Collectors.toList()))))) {
                    commonStructures.addAll(childs);
                }
                commonStructures = DistinctResources.distinctStructures((List)commonStructures);
                commonStructures.forEach(commonStructure -> {
                    if (!structIdsMaps.containsKey(commonStructure.getId())) {
                        structIdsMaps.put(commonStructure.getId(), EngineUtil.getId());
                    }
                });
                commonResources.setStructureMap(structIdsMaps);
                for (CommonStructure commonStructure2 : commonStructures) {
                    StructureVersion structureVersion = this.toStructVersion(commonStructure2, version, structIdsMaps);
                    structureVersions.add(structureVersion);
                }
                if (HussarUtils.isNotEmpty((Object)resources.getInsertStructures())) {
                    structureVersions.addAll(resources.getInsertStructures());
                }
                structureVersions = DistinctResources.distinctStructureVersions(structureVersions);
                resources.setInsertStructures(structureVersions);
            }
            this.reFreshCanvas(canvas, canvas.getCanvasContent(), structIdsMaps, EaiResourcesEnum.STRUCTURE);
        }
        ArrayList<ConnectionVersion> connectionVersions = new ArrayList<ConnectionVersion>();
        if (!connIds.isEmpty()) {
            List<Long> selectconnIds = this.getSelectIds(connIds, connIdsMaps);
            if (HussarUtils.isNotEmpty(selectconnIds)) {
                List commonConnections = this.commonConnectionService.listByIds(selectconnIds);
                for (CommonConnection commonConnection : commonConnections) {
                    ConnectionVersion connectionVersion = this.toConnectionVersion(commonConnection, version);
                    connIdsMaps.put(commonConnection.getId(), connectionVersion.getId());
                    connectionVersions.add(connectionVersion);
                }
                commonResources.setConnMap(connIdsMaps);
                if (HussarUtils.isNotEmpty((Object)resources.getConnectionVersions())) {
                    connectionVersions.addAll(resources.getConnectionVersions());
                }
                resources.setConnectionVersions(connectionVersions);
            }
            this.reFreshCanvas(canvas, canvas.getCanvasContent(), connIdsMaps, EaiResourcesEnum.LINK);
        }
        if (HussarUtils.isNotEmpty((Object)canvas)) {
            if (HussarUtils.isNotEmpty((Object)resources.getCanvas())) {
                resources.getCanvas().add(canvas);
            } else {
                ArrayList<CanvasInfo> canvasInfos = new ArrayList<CanvasInfo>();
                canvasInfos.add(canvas);
                resources.setCanvas(canvasInfos);
            }
        }
        return resources;
    }

    private void reFreshCanvas(CanvasInfo canvas, String canvasConstant, Map<Long, Long> map, EaiResourcesEnum eaiResourcesEnum) {
        if (HussarUtils.isNotEmpty(map)) {
            HashMap<String, Integer> map1 = new HashMap<String, Integer>();
            for (Map.Entry<Long, Long> entry : map.entrySet()) {
                Long key = entry.getKey();
                Long value = entry.getValue();
                String canvasResources = canvas.getCanvasResources();
                this.filCanvasResources(canvasResources, key, value, eaiResourcesEnum.getType(), map1);
                canvasConstant = this.transFormResource(canvasConstant, key, value);
            }
            canvas.setCanvasResources(JSON.toJSONString(map1));
            canvas.setCanvasContent(canvasConstant);
        }
    }

    private List<Long> getSelectIds(List<Long> ids, Map<Long, Long> map) {
        ArrayList<Long> selectLogicIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty(ids)) {
            for (Long lId : ids) {
                if (map.containsKey(lId)) continue;
                selectLogicIds.add(lId);
            }
        }
        return selectLogicIds;
    }

    private LogicVersion toLogicVersion(CommonResourcesIdMap commonResources, EaiCanvasConvertDto canvasConvertDto, EaiPublishEnhancementResources parentResources) {
        CommonLogic commonLogic = canvasConvertDto.getCommonLogic();
        String version = canvasConvertDto.getVersion();
        Map<Long, Long> constIds = canvasConvertDto.getConnIds();
        Map<Long, Long> structIds = canvasConvertDto.getStructIds();
        Map<Long, Long> connIds = canvasConvertDto.getConnIds();
        Map<Long, Long> logicIds = canvasConvertDto.getLogicIds();
        CanvasInfo canvas = (CanvasInfo)this.canvasInfoService.getById((Serializable)Long.valueOf(commonLogic.getCanvasId()));
        String resource = canvas.getCanvasResources();
        String constant = canvas.getCanvasContent();
        if (HussarUtils.isNotEmpty((Object)resource) && HussarUtils.isNotEmpty((Object)constant)) {
            Map resourceMap = (Map)JSONObject.parseObject((String)resource, (TypeReference)new TypeReference<Map<String, Integer>>(){}, (Feature[])new Feature[0]);
            HashMap<String, Integer> childResourceMap = new HashMap<String, Integer>();
            this.filChild(canvas, constant, resource, resourceMap, constIds, structIds, connIds, logicIds, childResourceMap);
            EaiPublishEnhancementResources publishCommonResources = this.getResourcesInfo(commonResources, canvas, childResourceMap, version, constIds, structIds, connIds, logicIds);
            if (HussarUtils.isNotEmpty((Object)publishCommonResources)) {
                List connectionVersions;
                List structureVersions;
                List constantVersions;
                List logicVersions = publishCommonResources.getLogicVersions();
                if (HussarUtils.isNotEmpty((Object)logicVersions)) {
                    if (HussarUtils.isNotEmpty((Object)parentResources.getLogicVersions())) {
                        logicVersions.addAll(parentResources.getLogicVersions());
                    }
                    logicVersions = DistinctLogicResources.distinctLogics((List)logicVersions);
                    parentResources.setLogicVersions(logicVersions);
                }
                if (HussarUtils.isNotEmpty((Object)(constantVersions = publishCommonResources.getInsertConstants()))) {
                    if (HussarUtils.isNotEmpty((Object)parentResources.getInsertConstants())) {
                        constantVersions.addAll(parentResources.getInsertConstants());
                    }
                    constantVersions = DistinctResources.distinctConstants((List)constantVersions);
                    parentResources.setInsertConstants(constantVersions);
                }
                if (HussarUtils.isNotEmpty((Object)(structureVersions = publishCommonResources.getInsertStructures()))) {
                    if (HussarUtils.isNotEmpty((Object)parentResources.getInsertStructures())) {
                        structureVersions.addAll(parentResources.getInsertStructures());
                    }
                    structureVersions = DistinctResources.distinctStructureVersions((List)structureVersions);
                    parentResources.setInsertStructures(structureVersions);
                }
                if (HussarUtils.isNotEmpty((Object)(connectionVersions = publishCommonResources.getConnectionVersions()))) {
                    if (HussarUtils.isNotEmpty((Object)parentResources.getConnectionVersions())) {
                        connectionVersions.addAll(parentResources.getConnectionVersions());
                    }
                    connectionVersions = DistinctLogicResources.distinctConnections((List)connectionVersions);
                    parentResources.setConnectionVersions(connectionVersions);
                }
            }
        }
        LogicVersion logicVersion = new LogicVersion();
        BeanUtil.copyProperties((Object)commonLogic, (Object)logicVersion);
        logicVersion.setId(EngineUtil.getId());
        logicVersion.setLogicVersion(version);
        logicVersion.setLogicId(commonLogic.getId());
        String content = canvas.getCanvasContent();
        logicIds.put(commonLogic.getId(), logicVersion.getId());
        if (HussarUtils.isEmpty((Object)commonResources.getLogicMap())) {
            commonResources.setLogicMap(logicIds);
        } else {
            commonResources.getLogicMap().put(commonLogic.getId(), logicVersion.getId());
        }
        Long canvasId = EngineUtil.getId();
        canvas.setId(canvasId);
        this.filCanvas(canvas, commonLogic.getId(), logicVersion.getId(), EaiResourcesEnum.LOGIC.getType());
        content = this.transFormResource(content, commonLogic.getId(), logicVersion.getId());
        canvas.setCanvasContent(content);
        logicVersion.setLogicClassify(EaiCategoryEnum.OPEN.getCode());
        if (HussarUtils.isNotEmpty(structIds)) {
            String versionIn = commonLogic.getInParams();
            String versionOut = commonLogic.getOutParams();
            for (Map.Entry<Long, Long> entry : structIds.entrySet()) {
                if (ToolUtil.isNotEmpty((Object)versionIn)) {
                    versionIn = versionIn.replace(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
                if (!ToolUtil.isNotEmpty((Object)versionOut)) continue;
                versionOut = versionOut.replace(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            logicVersion.setInParams(versionIn);
            logicVersion.setOutParams(versionOut);
        }
        logicVersion.setCanvasId(canvasId.longValue());
        List currentLogicVersions = parentResources.getLogicVersions();
        if (HussarUtils.isEmpty((Object)currentLogicVersions)) {
            ArrayList<LogicVersion> logicVersions = new ArrayList<LogicVersion>(1);
            logicVersions.add(logicVersion);
            parentResources.setLogicVersions(logicVersions);
        } else {
            currentLogicVersions.add(logicVersion);
            parentResources.setLogicVersions(currentLogicVersions);
        }
        if (HussarUtils.isEmpty((Object)parentResources.getCanvas())) {
            ArrayList<CanvasInfo> logicVCanvas = new ArrayList<CanvasInfo>(1);
            logicVCanvas.add(canvas);
            parentResources.setCanvas(logicVCanvas);
        } else {
            parentResources.getCanvas().add(canvas);
        }
        return logicVersion;
    }

    private void filChild(CanvasInfo canvas, String constant, String resource, Map<String, Integer> resourceMap, Map<Long, Long> constIds, Map<Long, Long> structIds, Map<Long, Long> connIds, Map<Long, Long> logicIds, Map<String, Integer> childResourceMap) {
        HashMap<Long, Long> idMaps = new HashMap<Long, Long>();
        if (HussarUtils.isNotEmpty(structIds)) {
            idMaps.putAll(structIds);
        }
        if (HussarUtils.isNotEmpty(constIds)) {
            idMaps.putAll(constIds);
        }
        if (HussarUtils.isNotEmpty(connIds)) {
            idMaps.putAll(connIds);
        }
        if (HussarUtils.isNotEmpty(logicIds)) {
            idMaps.putAll(logicIds);
        }
        for (Map.Entry<String, Integer> entry : resourceMap.entrySet()) {
            String k = entry.getKey();
            Integer v = entry.getValue();
            if (v == null || v <= 0) continue;
            String[] str = k.split(":");
            Long id = Long.valueOf(str[1]);
            if (idMaps.containsKey(id)) {
                resource = this.transFormResource(resource, id, idMaps);
                constant = this.transFormResource(constant, id, idMaps);
                continue;
            }
            childResourceMap.put(k, v);
        }
        canvas.setCanvasContent(constant);
        canvas.setCanvasResources(resource);
    }

    private String transFormResource(String resource, Long id, Map<Long, Long> resourceIds) {
        return resource.replace(String.valueOf(id), String.valueOf(resourceIds.get(id)));
    }

    private String transFormResource(String resource, Long id, Long newId) {
        return resource.replace(String.valueOf(id), String.valueOf(newId));
    }

    private void filCanvas(CanvasInfo canvas, Long oldId, Long newId, String type) {
        String canvasResources = canvas.getCanvasResources();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        this.filCanvasResources(canvasResources, oldId, newId, type, map);
        if (HussarUtils.isNotEmpty(map)) {
            canvas.setCanvasResources(JSON.toJSONString(map));
        }
    }

    private void filCanvasResources(String canvasResources, Long oldId, Long newId, String type, Map<String, Integer> resourceMap) {
        if (HussarUtils.isNotEmpty((Object)canvasResources)) {
            JSONObject object = JSON.parseObject((String)canvasResources);
            object.forEach((k, v) -> {
                if (k.equals(this.canvasId(oldId, type))) {
                    resourceMap.remove(k);
                    resourceMap.put(this.canvasId(newId, type), Integer.valueOf(String.valueOf(v)));
                } else {
                    resourceMap.put((String)k, Integer.valueOf(String.valueOf(v)));
                }
            });
        }
    }
}

