/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.canvas.logicresources.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.api.canvas.support.service.EaiCanvasResourceService;
import com.jxdinfo.hussar.eai.atomicenhancements.api.canvas.runtime.service.EaiGenerateService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.logic.integration.eai.dto.EaiStructureGenerateSource;
import com.jxdinfo.hussar.logic.structure.eai.LogicEaiContextInfo;
import com.jxdinfo.hussar.logic.structure.generate.LogicGenerateConfigure;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.canvas.logicresources.service.impl.EaiStructureGenerateSourceManager")
public class EaiStructureGenerateSourceManager {
    @Resource
    private EaiCanvasResourceService resourceService;
    @Resource
    private EaiGenerateService eaiGenerateService;

    public EaiStructureGenerateSource generateStructureCode(Long id, String type, LogicGenerateConfigure configure) {
        return this.generateStructureCode(id, type, configure, true);
    }

    public EaiStructureGenerateSource generateStructureCode(Long id, String type, LogicGenerateConfigure configure, Boolean isChild) {
        Object data;
        EaiStructureGenerateSource structureGenerateSource = new EaiStructureGenerateSource();
        AssertUtil.isNotNull((Object)configure, (String)"configure can not be null");
        AssertUtil.isNotNull((Object)configure.getEaiInfo(), (String)"eaiInfo can not be null");
        AssertUtil.isNotEmpty((String)configure.getEaiInfo().getEnvironmentCategory(), (String)"category can not be null");
        LogicEaiContextInfo contentInfo = configure.getEaiInfo();
        ApiResponse result = this.resourceService.getById(contentInfo.getEnvironmentCategory(), type, Boolean.valueOf(configure.getDebug() == false), id);
        String className = this.eaiGenerateService.generatedClassName(contentInfo.getEnvironmentCategory(), type, id, contentInfo.getApplicationVersion(), Boolean.valueOf(configure.getDebug() == false));
        if (result.isSuccess() && HussarUtils.isNotEmpty((Object)(data = result.getData()))) {
            List structureItems;
            StructureVersion structureVersion = (StructureVersion)JSON.parseObject((String)JSON.toJSONString((Object)data), StructureVersion.class);
            structureGenerateSource.setName(structureVersion.getStructureCode());
            structureGenerateSource.setTitle(structureVersion.getStructureName());
            structureGenerateSource.setDescription(structureVersion.getRemark());
            String items = structureVersion.getStructureValues();
            if (HussarUtils.isNotEmpty((Object)items) && HussarUtils.isNotEmpty((Object)(structureItems = (List)JSONObject.parseObject((String)items, (TypeReference)new TypeReference<List<StructureItems>>(){}, (Feature[])new Feature[0])))) {
                ArrayList<EaiParamsItems> fields = new ArrayList<EaiParamsItems>(structureItems.size());
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(String.valueOf(id));
                this.fillItems(structureItems, fields, ids, isChild);
                structureGenerateSource.setFields(fields);
                ArrayList<String> list = new ArrayList<String>();
                String str = className.replace("com.jxdinfo.hussar.eai.generated", "");
                String[] modules = str.split("\\.");
                for (int i = 1; i < modules.length - 1; ++i) {
                    list.add(modules[i]);
                }
                structureGenerateSource.setModules(list);
            }
        }
        return structureGenerateSource;
    }

    private void fillItems(List<StructureItems> structureItems, List<EaiParamsItems> fields, List<String> ids, Boolean isChild) {
        structureItems.forEach(structureItem -> {
            if (HussarUtils.isNotEmpty((Object)ids) && ids.contains(structureItem.getQuoteStructureId())) {
                if (isChild.booleanValue()) {
                    EaiParamsItems eaiParamsItems = new EaiParamsItems();
                    eaiParamsItems.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                    eaiParamsItems.setMappingName(structureItem.getName());
                    eaiParamsItems.setMark(structureItem.getNickName());
                    eaiParamsItems.setQuoteStructureId(String.format(":%s", structureItem.getQuoteStructureId()));
                    fields.add(eaiParamsItems);
                } else {
                    EaiParamsItems eaiParamsItems = new EaiParamsItems();
                    eaiParamsItems.setType(structureItem.getType());
                    eaiParamsItems.setMappingName(structureItem.getName());
                    eaiParamsItems.setMark(structureItem.getNickName());
                    eaiParamsItems.setQuoteStructureId(String.format(":%s", structureItem.getQuoteStructureId()));
                    ArrayList<EaiParamsItems> childFields = new ArrayList<EaiParamsItems>();
                    this.fillItems(structureItems, childFields, ids, true);
                    eaiParamsItems.setItems(childFields);
                    fields.add(eaiParamsItems);
                }
                return;
            }
            EaiParamsItems eaiParamsItems = new EaiParamsItems();
            eaiParamsItems.setMappingName(structureItem.getName());
            eaiParamsItems.setMark(structureItem.getNickName());
            eaiParamsItems.setType(structureItem.getType());
            eaiParamsItems.setItemType(structureItem.getItemType());
            String childId = structureItem.getQuoteStructureId();
            if (HussarUtils.isNotEmpty((Object)childId)) {
                eaiParamsItems.setQuoteStructureId(childId);
            }
            if (HussarUtils.isNotEmpty((Object)structureItem.getItems())) {
                ArrayList<EaiParamsItems> childFields = new ArrayList<EaiParamsItems>();
                if (HussarUtils.isNotEmpty((Object)childId)) {
                    ids.add(childId);
                }
                this.fillItems(structureItem.getItems(), childFields, ids, isChild);
                eaiParamsItems.setItems(childFields);
            }
            fields.add(eaiParamsItems);
        });
    }
}

