/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicenhancements.server.appauth.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiCustomizeAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiCustomizeAuthSerivce;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpTemplateDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.factory.EaiHttpAuthenticationFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IEaiHttpAuthenticationManagerExtendService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpTemplateVo;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.CommomApplicationAuthWayManager;
import com.jxdinfo.hussar.eai.atomicenhancements.api.appauth.dto.EaiHttpCustomAuthDto;
import com.jxdinfo.hussar.eai.common.enums.app.HttpAuthTypeEnum;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.common.server.applicationrelease.applicationauth.manager.impl.HttpAuthenTicationCustomManagerServiceImpl")
public class HttpAuthenTicationCustomManagerServiceImpl
extends CommomApplicationAuthWayManager
implements IEaiHttpAuthenticationManagerExtendService<EaiHttpCustomAuthDto> {
    private static final String HTTPAUTH_TYPE_KEY = "EAIHTTPAUTH_TYPE_4";
    @Resource
    ICanvasInfoService eaiCanvasInfoService;
    @Resource
    IEaiCustomizeAuthSerivce customizeAuthSerivce;
    private static final String CANVAS_ERROR = "\u9274\u6743\u753b\u5e03\u4fe1\u606f\u5f02\u5e38";

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Long> httpAuthInfoSave(HttpAuthDto tokenDto) {
        List data = tokenDto.getHttpAuth();
        AssertUtil.isNotEmpty((Collection)data, (String)"\u65e0\u9274\u6743\u4fe1\u606f");
        AssertUtil.isFalse((data.size() == 2 ? 1 : 0) != 0, (String)"\u9274\u6743\u4fe1\u606f\u4e0d\u5b8c\u6574");
        JSONObject first = (JSONObject)tokenDto.getHttpAuth().get(0);
        EaiHttpTemplateDto templateDto = (EaiHttpTemplateDto)JSONObject.parseObject((String)first.toJSONString(), EaiHttpTemplateDto.class);
        Long templateIdExist = templateDto.getTemplateId();
        if (HussarUtils.isEmpty((Object)templateIdExist)) {
            templateIdExist = EngineUtil.getId();
        }
        templateDto.setTemplateId(templateIdExist);
        templateDto.setTemplateType("0");
        EaiHttpTemplate template = new EaiHttpTemplate();
        BeanUtil.copy((Object)templateDto, (Object)template);
        this.httpTemplateService.save((Object)template);
        EaiHttpExtend extendFirst = new EaiHttpExtend();
        extendFirst.setStepCode("1");
        extendFirst.setTemplateId(templateDto.getTemplateId());
        this.httpExtendService.save((Object)extendFirst);
        CanvasInfo canvasInfo = (CanvasInfo)JSONObject.parseObject((String)JSON.toJSONString(data.get(1)), CanvasInfo.class);
        Long cid = EngineUtil.getId();
        canvasInfo.setId(cid);
        this.eaiCanvasInfoService.save((Object)canvasInfo);
        Long lastId = EngineUtil.getId();
        EaiHttpExtend extendLast = new EaiHttpExtend();
        extendLast.setExtendId(lastId);
        extendLast.setStepCode("2");
        extendLast.setTemplateId(templateDto.getTemplateId());
        this.httpExtendService.save((Object)extendLast);
        EaiCustomizeAuth eaiCustomizeAuth = new EaiCustomizeAuth();
        eaiCustomizeAuth.setCanvasId(cid);
        eaiCustomizeAuth.setExtendId(lastId);
        eaiCustomizeAuth.setId(EngineUtil.getId());
        this.customizeAuthSerivce.save((Object)eaiCustomizeAuth);
        return ApiResponse.success((Object)templateIdExist);
    }

    public ApiResponse<Boolean> httpAuthEdit(HttpAuthDto tokenDto, EaiHttpTemplate eaiHttpTemplateOld, EaiHttpTemplateDto currentTemp) {
        EaiHttpExtend extendLast = this.getCertainStepByTemplateId(eaiHttpTemplateOld.getTemplateId(), "2");
        if (null != extendLast) {
            EaiCustomizeAuth customizeAuth = (EaiCustomizeAuth)this.customizeAuthSerivce.getById((Serializable)extendLast.getExtendId());
            this.eaiCanvasInfoService.removeById((Serializable)customizeAuth.getCanvasId());
            this.customizeAuthSerivce.removeById((Serializable)customizeAuth.getId());
        }
        this.httpTemplateService.removeById((Serializable)eaiHttpTemplateOld.getTemplateId());
        this.httpExtendService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)eaiHttpTemplateOld.getTemplateId()));
        return ApiResponse.success();
    }

    public ApiResponse<EaiApiResponseVo> httpAuthVerify(HttpAuthVerifyDto authVerifyDto, boolean isPublished, int repeatCount) {
        throw new BaseException("\u4e0d\u652f\u6301\u7684\u9a8c\u8bc1\u65b9\u5f0f");
    }

    public ApiResponse<EaiHttpTemplateVo> httpAuthDetail(EaiHttpTemplateVo eaiHttpTemplate) {
        Map commonConstantsMap = this.getCommonConstantsMap(eaiHttpTemplate.getApplicationCode(), false);
        Map applicationAuthMap = this.getEaiApplicationAuthMap(eaiHttpTemplate.getApplicationCode());
        EaiHttpExtend extendSecond = this.getCertainStepByTemplateId(eaiHttpTemplate.getTemplateId(), "2");
        List paramsPosissions = this.paramsPositionService.list((Wrapper)new LambdaQueryWrapper().eq(EaiParamsPosition::getExtendId, (Object)extendSecond.getExtendId()));
        Map paramsPosissionMap = paramsPosissions.stream().collect(Collectors.toMap(EaiParamsPosition::getParamsPosition, Function.identity()));
        this.getHttpAuthPosissionParams(eaiHttpTemplate, commonConstantsMap, applicationAuthMap, paramsPosissionMap);
        return ApiResponse.success((Object)eaiHttpTemplate);
    }

    public ApiResponse<EaiHttpCustomAuthDto> selectHttpTemplateInfos(String applicationCode, boolean published) {
        EaiHttpAuthDto dto = this.commonSelect(applicationCode, published);
        EaiHttpCustomAuthDto eaiHttpCustomAuthDto = new EaiHttpCustomAuthDto();
        BeanUtil.copyProperties((Object)dto, (Object)eaiHttpCustomAuthDto);
        HashMap map = new HashMap();
        List eaiHttpExtends = eaiHttpCustomAuthDto.getHttpExtend();
        if (HussarUtils.isNotEmpty((Object)eaiHttpExtends)) {
            List ids = eaiHttpExtends.stream().map(EaiHttpExtend::getExtendId).collect(Collectors.toList());
            ArrayList extendDtos = new ArrayList();
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiCustomizeAuth::getExtendId, ids);
            List list1 = this.customizeAuthSerivce.list((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)list1)) {
                if (list1.size() > 1) {
                    throw new BaseException(CANVAS_ERROR);
                }
                extendDtos.addAll(list1);
                Long canvasIds = ((EaiCustomizeAuth)list1.get(0)).getCanvasId();
                CanvasInfo canvasInfo = (CanvasInfo)this.eaiCanvasInfoService.getById((Serializable)canvasIds);
                eaiHttpCustomAuthDto.setCanvasInfo(canvasInfo);
            }
            String mapperFullPath = this.getKey();
            map.put(mapperFullPath, extendDtos);
            HashMap mapperDomain = Maps.newHashMapWithExpectedSize((int)1);
            mapperDomain.put(mapperFullPath, this.getDomain().get(mapperFullPath));
            eaiHttpCustomAuthDto.setMapperDomain((Map)mapperDomain);
            eaiHttpCustomAuthDto.setExtendDto(map);
        }
        return ApiResponse.success((Object)eaiHttpCustomAuthDto);
    }

    private String getKey() {
        return (String)EaiHttpAuthenticationFactory.getRegisterExtra((String)HttpAuthTypeEnum.HTTPTYPE_CUSTOM.getAuthKey()).get(0);
    }

    private Map<String, String> getDomain() {
        return EaiHttpAuthenticationFactory.getRegisterExtraDomain((String)HttpAuthTypeEnum.HTTPTYPE_CUSTOM.getAuthKey());
    }

    public ApiResponse<EaiHttpCustomAuthDto> selectHttpTemplateInfosWithNewIds(String applicationCode, Boolean publishing) {
        EaiHttpAuthDto dto = this.commonSelectNew(applicationCode, publishing);
        EaiHttpCustomAuthDto customAuthDto = new EaiHttpCustomAuthDto();
        BeanUtil.copyProperties((Object)dto, (Object)customAuthDto);
        HashMap map = new HashMap();
        List eaiHttpExtends = customAuthDto.getHttpExtend();
        if (HussarUtils.isNotEmpty((Object)eaiHttpExtends)) {
            List<Long> ids = eaiHttpExtends.stream().map(EaiHttpExtend::getExtendId).collect(Collectors.toList());
            ArrayList extendDtos = new ArrayList();
            Map cmaps = customAuthDto.getIdMaps();
            ids.forEach(id -> {
                if (cmaps.containsValue(id)) {
                    Long[] fid = new Long[]{id};
                    cmaps.forEach((k, v) -> {
                        if (v.equals(fid[0])) {
                            fid[0] = k;
                        }
                    });
                    LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiCustomizeAuth::getExtendId, (Object)fid[0]);
                    List list1 = this.customizeAuthSerivce.list((Wrapper)queryWrapper);
                    if (HussarUtils.isNotEmpty((Object)list1)) {
                        if (list1.size() > 1) {
                            throw new BaseException(CANVAS_ERROR);
                        }
                        ((EaiCustomizeAuth)list1.get(0)).setExtendId((Long)customAuthDto.getIdMaps().get(((EaiCustomizeAuth)list1.get(0)).getExtendId()));
                        extendDtos.addAll(list1);
                        Long canvasIds = ((EaiCustomizeAuth)list1.get(0)).getCanvasId();
                        CanvasInfo canvasInfo = (CanvasInfo)this.eaiCanvasInfoService.getById((Serializable)canvasIds);
                        customAuthDto.setCanvasInfo(canvasInfo);
                    }
                }
            });
            map.put(this.getKey(), extendDtos);
            customAuthDto.setExtendDto(map);
        }
        return ApiResponse.success((Object)customAuthDto);
    }

    public ApiResponse<Boolean> saveHttpTemplateInfos(EaiHttpCustomAuthDto eaiHttpAuthDto) {
        boolean common = this.commonSaveOrUpdateById((EaiHttpAuthDto)eaiHttpAuthDto, true);
        Map map = eaiHttpAuthDto.getExtendDto();
        boolean extra = true;
        List list = ((List)map.get(this.getKey())).stream().map(o -> (EaiCustomizeAuth)o).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(list)) {
            ((EaiCustomizeAuth)list.get(0)).setCanvasId(eaiHttpAuthDto.getCanvasInfo().getId());
            extra = this.customizeAuthSerivce.saveBatch(list);
        }
        if (common && extra) {
            return ApiResponse.success((Object)true);
        }
        throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
    }

    public ApiResponse<Boolean> updateHttpTemplateInfos(EaiHttpCustomAuthDto eaiHttpAuthDto) {
        Map map = eaiHttpAuthDto.getExtendDto();
        List list = JSONObject.parseArray((String)JSONObject.toJSONString(map.get(this.getKey())), EaiCustomizeAuth.class);
        boolean common = this.commonSaveOrUpdateById((EaiHttpAuthDto)eaiHttpAuthDto, false);
        boolean extra = true;
        if (HussarUtils.isNotEmpty((Object)list)) {
            if (HussarUtils.isNotEmpty((Object)eaiHttpAuthDto.getExtendIds())) {
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiCustomizeAuth::getExtendId, (Collection)eaiHttpAuthDto.getExtendIds());
                this.customizeAuthSerivce.remove((Wrapper)queryWrapper);
            }
            if (HussarUtils.isNotEmpty((Object)eaiHttpAuthDto.getCanvasInfo())) {
                ((EaiCustomizeAuth)list.get(0)).setCanvasId(eaiHttpAuthDto.getCanvasInfo().getId());
                extra = this.customizeAuthSerivce.saveBatch((Collection)list);
            }
        }
        if (common && extra) {
            return ApiResponse.success((Object)true);
        }
        throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
    }

    public void authParamsValueCleanImpl(EaiHttpTemplate eaiHttpTemplate, Long authParamId) {
    }

    public boolean verifyAuthParamHasUse(EaiHttpTemplate eaiHttpTemplate, Long authParamId, String paramsPosition) {
        EaiCustomizeAuth customizeAuth;
        CanvasInfo canvasInfo;
        String resources;
        EaiHttpExtend extendLast = this.getCertainStepByTemplateId(eaiHttpTemplate.getTemplateId(), "2");
        return null != extendLast && HussarUtils.isNotEmpty((Object)(resources = (canvasInfo = (CanvasInfo)this.eaiCanvasInfoService.getById((Serializable)(customizeAuth = (EaiCustomizeAuth)this.customizeAuthSerivce.getById((Serializable)extendLast.getExtendId())).getCanvasId())).getCanvasResources())) && resources.contains(String.format("%s:%s", "appauth", authParamId));
    }

    public void afterPropertiesSet() throws Exception {
        EaiHttpAuthenticationFactory.registerAuth((String)HTTPAUTH_TYPE_KEY, (IEaiHttpAuthenticationManagerExtendService)this);
    }
}

