/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.resourcerelation.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpParamsPackageVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpParamsVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpTemplateVo;
import com.jxdinfo.hussar.eai.atomicbase.api.commonstructure.vo.StructurePullDownItems;
import com.jxdinfo.hussar.eai.atomicbase.api.commonstructure.vo.StructurePullDownVo;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonStructureService;
import com.jxdinfo.hussar.eai.atomicbase.api.resourcerelation.dto.EaiRelationResource;
import com.jxdinfo.hussar.eai.atomicbase.api.resourcerelation.service.EaiResourceRelationBaseService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.resourcerelation.service.impl.EaiResourceRelationBaseServiceImpl")
public class EaiResourceRelationBaseServiceImpl
implements EaiResourceRelationBaseService {
    @Resource
    ICommonStructureService commonStructureService;
    @Resource
    ICommonConstantService commonConstantService;
    @Resource
    IEaiApiInfoService apiInfoService;
    @Resource
    IEaiEditApiService editApiService;
    @Resource
    ICommonStructureService structureService;
    @Resource
    EaiCommonStructureService iEaiCommonStructureService;
    @Resource
    IHttpAuthenticationService authenticationService;

    public List<EaiRelationResource> resourcesConstant(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        CommonConstant commonConstant = (CommonConstant)this.commonConstantService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)commonConstant)) {
            throw new HussarException("\u516c\u5171\u5e38\u91cf\u4e0d\u5b58\u5728\uff01\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(commonConstant.getId());
        return this.resourcesConstants(commonConstant.getApplicationCode(), ids);
    }

    public List<EaiRelationResource> resourcesStructStatus(String applicationCode, List<Long> ids) {
        List<StructurePullDownItems> commonStructures;
        LambdaQueryWrapper update;
        List apiInfos;
        List<Long> apiIds = this.apiIds(applicationCode, ids);
        ArrayList<EaiRelationResource> list = new ArrayList<EaiRelationResource>();
        if (HussarUtils.isNotEmpty(apiIds) && HussarUtils.isNotEmpty((Object)(apiInfos = this.apiInfoService.list((Wrapper)(update = (LambdaQueryWrapper)new LambdaQueryWrapper().in(ApiInfo::getId, apiIds)))))) {
            apiInfos.forEach(apiInfo -> {
                EaiRelationResource eaiRelationResource = new EaiRelationResource();
                eaiRelationResource.setType(EaiResourcesEnum.API.getType());
                eaiRelationResource.setName(apiInfo.getApiName());
                eaiRelationResource.setNameEn(apiInfo.getApiCode());
                list.add(eaiRelationResource);
            });
        }
        if (HussarUtils.isNotEmpty(commonStructures = this.findStructureScope(applicationCode, ids))) {
            commonStructures.forEach(commonStructure -> {
                EaiRelationResource eaiRelationResource = new EaiRelationResource();
                eaiRelationResource.setType(EaiResourcesEnum.STRUCTURE.getType());
                eaiRelationResource.setName(commonStructure.getStructureName());
                eaiRelationResource.setNameEn(commonStructure.getStructureCode());
                list.add(eaiRelationResource);
            });
        }
        return list;
    }

    private List<StructurePullDownItems> findStructureScope(String applicationCode, List<Long> ids) {
        StructurePullDownVo structurePullDownVo = this.iEaiCommonStructureService.getBaseAndStructure(applicationCode);
        List structureList = structurePullDownVo.getStructure();
        if (HussarUtils.isEmpty((Object)structureList)) {
            return Collections.emptyList();
        }
        structureList.forEach(v -> {
            if (HussarUtils.isNotEmpty((Object)v.getStructureValues())) {
                v.setStructureValuesStr(EaiResourceRelationBaseServiceImpl.toJSONString(v.getStructureValues()));
            }
        });
        ArrayList<StructurePullDownItems> result = new ArrayList<StructurePullDownItems>();
        List<String> sIds = ids.stream().map(String::valueOf).collect(Collectors.toList());
        sIds.forEach(id -> {
            for (StructurePullDownItems s : structureList) {
                if (HussarUtils.equals((Object)id, (Object)s.getId()) || HussarUtils.isEmpty((Object)s.getStructureValuesStr()) || !s.getStructureValuesStr().contains((CharSequence)id)) continue;
                result.add(s);
            }
        });
        return result;
    }

    private List<Long> apiIds(String applicationCode, Long id) {
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(id);
        return this.apiIds(applicationCode, ids);
    }

    private List<Long> apiIds(String applicationCode, List<Long> id) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)applicationCode)).and(a -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)a.like(ApiInfo::getInParams, (Object)String.format("%%%s%%", id))).or(b -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)b.like(ApiInfo::getOutParams, (Object)String.format("%%%s%%", id));
            });
        });
        List list = this.apiInfoService.list((Wrapper)queryWrapper);
        ArrayList change = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)list)) {
            list.forEach(editApi -> {
                List items = ParamsConvertUtil.toEaiParamsItems((String)editApi.getInParams());
                this.list(items, change, editApi.getId(), id);
                List items2 = ParamsConvertUtil.toEaiParamsItems((String)editApi.getOutParams());
                this.list(items2, change, editApi.getId(), id);
            });
        }
        return change.stream().distinct().collect(Collectors.toList());
    }

    private void list(List<EaiParamsItems> items, List<Long> change, Long apiId, List<Long> id) {
        if (HussarUtils.isEmpty(items)) {
            return;
        }
        for (EaiParamsItems item : items) {
            if (HussarUtils.isEmpty((Object)item)) continue;
            String qId = item.getQuoteStructureId();
            if (HussarUtils.isNotEmpty((Object)qId) && id.contains(Long.valueOf(qId))) {
                change.add(apiId);
                break;
            }
            if (!HussarUtils.isNotEmpty((Object)item.getItems())) continue;
            this.list(item.getItems(), change, apiId, id);
        }
    }

    public List<EaiRelationResource> resourcesConstants(String applicationCode, List<Long> ids) {
        EaiHttpParamsPackageVo eaiHttpParamsVo;
        ArrayList<EaiRelationResource> result = new ArrayList<EaiRelationResource>();
        ApiResponse response = this.authenticationService.httpAuthDetail(applicationCode);
        EaiHttpTemplateVo templateVo = (EaiHttpTemplateVo)response.getData();
        if (HussarUtils.isNotEmpty((Object)templateVo) && HussarUtils.isNotEmpty((Object)(eaiHttpParamsVo = templateVo.getEaiHttpParams()))) {
            EaiHttpParamsVo body;
            this.httpParams(eaiHttpParamsVo.getHttpQueryParam(), result);
            this.httpParams(eaiHttpParamsVo.getAuthParams(), result);
            this.httpParams(eaiHttpParamsVo.getHttpHeader(), result);
            if (HussarUtils.isNotEmpty((Object)eaiHttpParamsVo.getHttpBody()) && HussarUtils.isNotEmpty((Object)(body = this.checkedConstant(eaiHttpParamsVo.getHttpBody().getBodyParam())))) {
                EaiRelationResource eaiRelationResource = new EaiRelationResource();
                eaiRelationResource.setName(body.getParamsName());
                eaiRelationResource.setNameEn(body.getParamsNameEn());
                eaiRelationResource.setType(EaiResourcesEnum.AUTH.getType());
                result.add(eaiRelationResource);
            }
        }
        return result;
    }

    private void httpParams(List<EaiHttpParamsVo> httpQueryParam, List<EaiRelationResource> result) {
        EaiHttpParamsVo query;
        if (HussarUtils.isNotEmpty(httpQueryParam) && HussarUtils.isNotEmpty((Object)(query = this.checkedConstant(httpQueryParam)))) {
            EaiRelationResource eaiRelationResource = new EaiRelationResource();
            eaiRelationResource.setName(query.getParamsName());
            eaiRelationResource.setNameEn(query.getParamsNameEn());
            eaiRelationResource.setType(EaiResourcesEnum.AUTH.getType());
            result.add(eaiRelationResource);
        }
    }

    private EaiHttpParamsVo checkedConstant(List<EaiHttpParamsVo> queryParam) {
        if (HussarUtils.isNotEmpty(queryParam)) {
            for (EaiHttpParamsVo v : queryParam) {
                if ("0".equals(v.getParamsFrom())) {
                    // empty if block
                }
                if (!"1".equals(v.getParamsFrom())) continue;
                return v;
            }
        }
        return null;
    }

    public List<EaiRelationResource> resourcesStructState(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        CommonStructure commonStructure = (CommonStructure)this.commonStructureService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)commonStructure)) {
            throw new HussarException("\u6570\u636e\u7ed3\u6784\u4e0d\u5b58\u5728\uff01\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u8bd5");
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(commonStructure.getId());
        return this.resourcesStructStates(commonStructure.getApplicationCode(), ids);
    }

    public List<EaiRelationResource> resourcesStructStates(String applicationCode, List<Long> ids) {
        List<StructurePullDownItems> commonStructures;
        LambdaQueryWrapper update;
        List apiInfos;
        List<Long> apiIds = this.apiIds(applicationCode, ids);
        ArrayList<EaiRelationResource> list = new ArrayList<EaiRelationResource>();
        if (HussarUtils.isNotEmpty(apiIds) && HussarUtils.isNotEmpty((Object)(apiInfos = this.apiInfoService.list((Wrapper)(update = (LambdaQueryWrapper)new LambdaQueryWrapper().in(ApiInfo::getId, apiIds)))))) {
            apiInfos.forEach(apiInfo -> {
                EaiRelationResource eaiRelationResource = new EaiRelationResource();
                eaiRelationResource.setType(EaiResourcesEnum.API.getType());
                eaiRelationResource.setName(apiInfo.getApiName());
                eaiRelationResource.setNameEn(apiInfo.getApiCode());
                list.add(eaiRelationResource);
            });
        }
        if (HussarUtils.isNotEmpty(commonStructures = this.findStructureScope(applicationCode, ids))) {
            commonStructures.forEach(commonStructure -> {
                EaiRelationResource eaiRelationResource = new EaiRelationResource();
                eaiRelationResource.setType(EaiResourcesEnum.STRUCTURE.getType());
                eaiRelationResource.setName(commonStructure.getStructureName());
                eaiRelationResource.setNameEn(commonStructure.getStructureCode());
                list.add(eaiRelationResource);
            });
        }
        return list;
    }

    private static String toJSONString(Object t) {
        return JSON.toJSONString((Object)JSON.toJSON((Object)t));
    }
}

