/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.resourcerelation.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpTemplateService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpTemplateVo;
import com.jxdinfo.hussar.eai.atomicbase.api.resourcerelation.service.EaiAppStatusBaseService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.resourcerelation.service.impl.EaiAppStatusBaseServiceImpl")
public class EaiAppStatusBaseServiceImpl
implements EaiAppStatusBaseService {
    @Resource
    IEaiApiInfoService apiInfoService;
    @Resource
    IEaiEditApiService editApiService;
    @Resource
    IHttpAuthenticationService authenticationService;
    @Resource
    IEaiHttpTemplateService httpTemplateService;
    private static String REG = "\"%s\"";
    private static final String REGEXP_EAI_CONSTANT = "getEaiConstant(\\\"%s\\\")";

    @HussarTransactional(rollbackFor={Exception.class})
    public void resetStatus(String applicationCode) {
        LambdaUpdateWrapper update = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(ApiInfo::getApplicationCode, (Object)applicationCode)).set(ApiInfo::getTestState, (Object)"0");
        this.apiInfoService.update((Wrapper)update);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(EaiHttpTemplate::getTemplateType, (Object)"0")).eq(EaiHttpTemplate::getApplicationCode, (Object)applicationCode)).isNotNull(EaiHttpTemplate::getTemplateType);
        this.httpTemplateService.update((Wrapper)updateWrapper);
    }

    public void resetConstantStatus(String applicationCode, Long id) {
        boolean b = this.resetAuthConstantStatus(applicationCode, id);
        if (b) {
            return;
        }
    }

    private boolean resetAuthConstantStatus(String applicationCode, Long id) {
        ApiResponse response = this.authenticationService.httpAuthDetail(applicationCode);
        EaiHttpTemplateVo templateVo = (EaiHttpTemplateVo)response.getData();
        if (HussarUtils.isNotEmpty((Object)templateVo)) {
            String str;
            Pattern pattern = Pattern.compile(String.format(REG, id));
            Matcher matcher = pattern.matcher(str = JSON.toJSONString((Object)templateVo));
            if (matcher.find()) {
                this.resetStatus(applicationCode);
                return true;
            }
            Pattern regPattern = Pattern.compile(String.format(REGEXP_EAI_CONSTANT, id));
            Matcher regMatcher = regPattern.matcher(str);
            if (regMatcher.find()) {
                this.resetStatus(applicationCode);
                return true;
            }
        }
        return false;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void resetStructStatus(String applicationCode, Long id) {
        boolean b = this.restAuthStructure(applicationCode, id);
        if (b) {
            return;
        }
        List<Long> apiIds = this.apiIds(applicationCode, id);
        if (HussarUtils.isNotEmpty(apiIds)) {
            LambdaUpdateWrapper update = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(ApiInfo::getId, apiIds)).set(ApiInfo::getTestState, (Object)"0");
            this.apiInfoService.update((Wrapper)update);
        }
    }

    private boolean restAuthStructure(String applicationCode, Long id) {
        String str;
        Pattern pattern;
        Matcher matcher;
        ApiResponse response = this.authenticationService.httpAuthDetail(applicationCode);
        EaiHttpTemplateVo templateVo = (EaiHttpTemplateVo)response.getData();
        if (HussarUtils.isNotEmpty((Object)templateVo) && (matcher = (pattern = Pattern.compile(String.format(REG, id))).matcher(str = JSON.toJSONString((Object)templateVo))).find()) {
            this.resetStatus(applicationCode);
            return true;
        }
        return false;
    }

    private boolean restAuthStructure(String applicationCode, List<Long> ids) {
        ApiResponse response = this.authenticationService.httpAuthDetail(applicationCode);
        EaiHttpTemplateVo templateVo = (EaiHttpTemplateVo)response.getData();
        if (HussarUtils.isNotEmpty((Object)templateVo)) {
            for (Long id : ids) {
                String str;
                Pattern pattern = Pattern.compile(String.format(REG, id));
                Matcher matcher = pattern.matcher(str = JSON.toJSONString((Object)templateVo));
                if (!matcher.find()) continue;
                this.resetStatus(applicationCode);
                return true;
            }
        }
        return false;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void resetStructStatus(String applicationCode, List<Long> ids) {
        boolean b = this.restAuthStructure(applicationCode, ids);
        if (b) {
            return;
        }
        List<Long> apiIds = this.apiIds(applicationCode, ids);
        if (HussarUtils.isNotEmpty(apiIds)) {
            LambdaUpdateWrapper update = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().in(ApiInfo::getId, apiIds)).set(ApiInfo::getTestState, (Object)"0");
            this.apiInfoService.update((Wrapper)update);
        }
    }

    private List<Long> apiIds(String applicationCode, Long id) {
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(id);
        return this.apiIds(applicationCode, ids);
    }

    private List<Long> apiIds(String applicationCode, List<Long> id) {
        List ids;
        LambdaQueryWrapper editQueryWrapper;
        List editApis;
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)applicationCode);
        List list = this.apiInfoService.list((Wrapper)queryWrapper);
        ArrayList change = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)list) && HussarUtils.isNotEmpty((Object)(editApis = this.editApiService.list((Wrapper)(editQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EditApi::getApiId, ids = list.stream().map(ApiInfo::getId).collect(Collectors.toList()))))))) {
            editApis.forEach(editApi -> {
                List items = ParamsConvertUtil.toEaiParamsItems((String)editApi.getInParams());
                this.list(items, change, editApi.getApiId(), id);
                List items2 = ParamsConvertUtil.toEaiParamsItems((String)editApi.getOutParams());
                this.list(items2, change, editApi.getApiId(), id);
            });
        }
        return change.stream().distinct().collect(Collectors.toList());
    }

    private void list(List<EaiParamsItems> items, List<Long> change, Long apiId, List<Long> id) {
        if (HussarUtils.isEmpty(items)) {
            return;
        }
        for (EaiParamsItems item : items) {
            if (HussarUtils.isEmpty((Object)item)) continue;
            String qId = item.getQuoteStructureId();
            if (HussarUtils.isNotEmpty((Object)qId) && id.contains(Long.valueOf(qId))) {
                change.add(apiId);
                break;
            }
            if (!HussarUtils.isNotEmpty((Object)item.getItems())) continue;
            this.list(item.getItems(), change, apiId, id);
        }
    }
}

