/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.vo.EaiPublishTestListVo;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.CommonResourcesIdMap;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.EaiPublishApiInfo;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.EaiPublishApiInfos;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.EaiPublishEditApiInfo;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.PublishVariable;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.enums.EaiPublishEngineType;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.factory.IPublishAuthFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiChangeApiStateService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiChangeAppStateService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiChangeAuthStateService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiCheckPublishPermissionService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishApiInfoService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishApiRelationService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishApiStateService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishCanvasService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishCheckApply;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishEditApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishEngineApiClassifyMapService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishEngineApiClassifyService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishExtraService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishInitService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiRejectPublishService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiResourcePublishService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiToPublishApiService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.IEaiPublishConfigurationService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.PublishStepService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.PublishStepServiceImpl")
public class PublishStepServiceImpl
implements PublishStepService {
    @Resource
    private EaiPublishInitService eaiPublishInitService;
    @Resource
    private EaiPublishApiInfoService eaiPublishApiInfoService;
    @Resource
    private EaiPublishApiStateService eaiPublishApiStateService;
    @Resource
    private EaiPublishEditApiService eaiPublishEditApiService;
    @Resource
    private EaiPublishCanvasService eaiPublishCanvasService;
    @Resource
    private EaiResourcePublishService eaiResourcePublishService;
    @Resource
    private List<EaiPublishExtraService> eaiPublishExtraServices;
    @Resource
    private EaiRejectPublishService eaiRejectPublishService;
    @Resource
    private EaiChangeAppStateService eaiUnlockAppService;
    @Resource
    private EaiChangeApiStateService eaiChangeApiStateService;
    @Resource
    private EaiCheckPublishPermissionService eaiCheckPublishPermissionService;
    @Resource
    private List<EaiChangeAuthStateService> eaiUnlockAuthServices;
    @Resource
    private EaiPublishCheckApply eaiPublishCheckApply;
    @Resource
    private EaiToPublishApiService toPublishApiService;
    @Resource
    private EaiPublishEngineApiClassifyMapService eaiPublishEngineApiClassifyMapService;
    @Resource
    private EaiPublishApiRelationService eaiPublishApiRelationService;
    @Resource
    private EaiPublishApiCallSpecificationInfoService eaiPublishApiCallSpecificationInfoService;
    @Resource
    private IEaiPublishConfigurationService eaiPublishConfigurationService;
    private TransmittableThreadLocal<PublishVariable> publishVariable = new TransmittableThreadLocal();

    PublishStepServiceImpl() {
    }

    public void initPublish(String applicationCode) {
        this.publishVariable.set((Object)new PublishVariable(applicationCode));
    }

    public void checkAuth() {
        this.eaiCheckPublishPermissionService.check(((PublishVariable)this.publishVariable.get()).getApplicationCode());
    }

    public void checkApply() {
        this.eaiPublishCheckApply.checkApply(((PublishVariable)this.publishVariable.get()).getApplicationCode());
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void lockedApp() {
        this.eaiUnlockAppService.lockedApp(((PublishVariable)this.publishVariable.get()).getApplicationCode());
    }

    public void newAppVersion() {
        String appVersion = this.eaiPublishInitService.newAppVersion(((PublishVariable)this.publishVariable.get()).getApplicationCode());
        ((PublishVariable)this.publishVariable.get()).setAppVersion(appVersion);
    }

    public EaiPublishTestListVo toPublishApiInfo() {
        return this.toPublishApiService.getToPublishApiInfo(((PublishVariable)this.publishVariable.get()).getApplicationCode(), ((PublishVariable)this.publishVariable.get()).getAppVersion(), "eai_api_cache_key");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void appVersionAndUpdate() {
        String appVersion = this.eaiPublishInitService.initPublish(((PublishVariable)this.publishVariable.get()).getApplicationCode());
        ((PublishVariable)this.publishVariable.get()).setAppVersion(appVersion);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void lockedAuth() {
        for (EaiChangeAuthStateService eaiUnlockAuthService : this.eaiUnlockAuthServices) {
            eaiUnlockAuthService.lockAuth(((PublishVariable)this.publishVariable.get()).getApplicationCode());
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void lockedApi() {
        this.eaiPublishInitService.initPublish(((PublishVariable)this.publishVariable.get()).getApplicationCode());
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void publishAuth() {
        Set setStr = IPublishAuthFactory.getAllServiceType();
        if (HussarUtils.isNotEmpty((Object)setStr)) {
            ArrayList list = new ArrayList(setStr);
            CommonResourcesIdMap commonResourcesIdMap = ((PublishVariable)this.publishVariable.get()).getCommonResourcesIdMap();
            for (String s : list) {
                commonResourcesIdMap = IPublishAuthFactory.getService((String)s).publishAuthAndGetCommonResources(((PublishVariable)this.publishVariable.get()).getApplicationCode(), ((PublishVariable)this.publishVariable.get()).getAppVersion(), commonResourcesIdMap);
            }
            ((PublishVariable)this.publishVariable.get()).setCommonResourcesIdMap(commonResourcesIdMap);
        }
    }

    private void getPublishApiInfo() {
        List apiInfosUpdate;
        EaiPublishApiInfo eaiPublishApiInfo = this.eaiPublishApiInfoService.getPublishApiInfos(((PublishVariable)this.publishVariable.get()).getApplicationCode());
        ((PublishVariable)this.publishVariable.get()).setEaiPublishApiInfo(eaiPublishApiInfo);
        List apiInfos = eaiPublishApiInfo.getApiInfos();
        if (HussarUtils.isNotEmpty((Object)apiInfos)) {
            List onApiIds = apiInfos.stream().map(ApiInfo::getId).collect(Collectors.toList());
            ((PublishVariable)this.publishVariable.get()).setOnApiIds(onApiIds);
            this.eaiPublishApiStateService.changeApiStateToOnGround(onApiIds);
            if (HussarUtils.isNotEmpty(onApiIds)) {
                ((PublishVariable)this.publishVariable.get()).getAllApiIds().addAll(onApiIds);
            }
            EaiPublishEditApiInfo eaiPublishEditApiInfo = this.eaiPublishEditApiService.getEditApi(onApiIds);
            ((PublishVariable)this.publishVariable.get()).setEaiPublishEditApiInfo(eaiPublishEditApiInfo);
        }
        if (HussarUtils.isNotEmpty((Object)(apiInfosUpdate = eaiPublishApiInfo.getApiInfosUpdate()))) {
            List offApiIds = apiInfosUpdate.stream().map(ApiInfo::getId).collect(Collectors.toList());
            ((PublishVariable)this.publishVariable.get()).setOffApiIds(offApiIds);
            this.eaiPublishApiStateService.changeApiStateToOffGround(offApiIds);
            if (HussarUtils.isNotEmpty(offApiIds)) {
                ((PublishVariable)this.publishVariable.get()).getAllApiIds().addAll(offApiIds);
            }
        }
        ((PublishVariable)this.publishVariable.get()).setCacheKey(eaiPublishApiInfo.getKey());
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void publishCanvas() {
        EaiPublishEditApiInfo eaiPublishEditApiInfo = ((PublishVariable)this.publishVariable.get()).getEaiPublishEditApiInfo();
        if (HussarUtils.isNotEmpty((Object)eaiPublishEditApiInfo) && HussarUtils.isNotEmpty((Object)eaiPublishEditApiInfo.getEditApisWithCanvas())) {
            List editApis = eaiPublishEditApiInfo.getEditApisWithCanvas();
            Map<Long, Long> map = editApis.stream().collect(Collectors.toMap(EditApi::getId, EditApi::getCanvasId));
            CommonResourcesIdMap commonResourcesIdMap = ((PublishVariable)this.publishVariable.get()).getCommonResourcesIdMap();
            Map newMap = this.eaiPublishCanvasService.publishCanvas(commonResourcesIdMap, map, ((PublishVariable)this.publishVariable.get()).getAppVersion());
            ((PublishVariable)this.publishVariable.get()).setCommonResourcesIdMap(commonResourcesIdMap);
            if (HussarUtils.isNotEmpty((Object)editApis)) {
                for (EditApi editApi : editApis) {
                    editApi.setCanvasId((Long)newMap.get(editApi.getId()));
                }
            }
            eaiPublishEditApiInfo.setEditApisWithCanvas(editApis);
        }
        ((PublishVariable)this.publishVariable.get()).setEaiPublishEditApiInfo(eaiPublishEditApiInfo);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void publishApi() {
        this.getPublishApiInfo();
        List apiInfos = ((PublishVariable)this.publishVariable.get()).getEaiPublishApiInfo().getApiInfos();
        this.publishApi(apiInfos);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void publishApi(List<ApiInfo> apiInfos) {
        List eaiResourcesInfos = new ArrayList();
        if (HussarUtils.isNotEmpty(apiInfos)) {
            Map apiParamsMap = this.eaiPublishApiInfoService.apiInfoParams(apiInfos);
            CommonResourcesIdMap commonResourcesIdMap = ((PublishVariable)this.publishVariable.get()).getCommonResourcesIdMap();
            Map newApiParamsMap = this.eaiResourcePublishService.getCommonResourcesByApi(apiParamsMap, ((PublishVariable)this.publishVariable.get()).getApplicationCode(), ((PublishVariable)this.publishVariable.get()).getAppVersion(), commonResourcesIdMap);
            ((PublishVariable)this.publishVariable.get()).setCommonResourcesIdMap(commonResourcesIdMap);
            EaiPublishApiInfos eaiPublishApiInfos = this.eaiPublishApiInfoService.publishApi(apiInfos, ((PublishVariable)this.publishVariable.get()).getApplicationCode(), ((PublishVariable)this.publishVariable.get()).getAppVersion(), newApiParamsMap);
            ((PublishVariable)this.publishVariable.get()).setEaiPublishApiInfos(eaiPublishApiInfos);
            ((PublishVariable)this.publishVariable.get()).setApiIdMaps(eaiPublishApiInfos.getApiIds());
            eaiResourcesInfos = eaiPublishApiInfos.getEaiResourcesInfos();
        }
        List apiInfoUpdate = ((PublishVariable)this.publishVariable.get()).getEaiPublishApiInfo().getApiInfosUpdate();
        List resetIds = this.eaiPublishApiRelationService.publishResourcesInfo(eaiResourcesInfos, ((PublishVariable)this.publishVariable.get()).getOnApiIds(), apiInfoUpdate, ((PublishVariable)this.publishVariable.get()).getAppVersion());
        ((PublishVariable)this.publishVariable.get()).setResetApiIds(resetIds);
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void publishApiCallSpecification() {
        Map map;
        if (HussarUtils.isNotEmpty((Object)((PublishVariable)this.publishVariable.get()).getEaiPublishApiInfos()) && HussarUtils.isNotEmpty((Object)(map = ((PublishVariable)this.publishVariable.get()).getEaiPublishApiInfos().getApiIds()))) {
            this.eaiPublishApiCallSpecificationInfoService.publishApiCallSpecificationInfo(map);
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void publishEditApi() {
        ArrayList allEditApis = new ArrayList();
        List editApiWithCanvas = ((PublishVariable)this.publishVariable.get()).getEaiPublishEditApiInfo().getEditApisWithCanvas();
        List editApis = ((PublishVariable)this.publishVariable.get()).getEaiPublishEditApiInfo().getEditApis();
        if (HussarUtils.isNotEmpty((Object)editApiWithCanvas)) {
            allEditApis.addAll(editApiWithCanvas);
        }
        if (HussarUtils.isNotEmpty((Object)editApis)) {
            allEditApis.addAll(editApis);
        }
        this.eaiPublishEditApiService.publishEditApi(((PublishVariable)this.publishVariable.get()).getOnApiIds(), allEditApis, ((PublishVariable)this.publishVariable.get()).getEaiPublishApiInfos().getApiIds(), ((PublishVariable)this.publishVariable.get()).getEaiPublishApiInfos().getApiVersions());
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void publishExtra() {
        if (HussarUtils.isNotEmpty(this.eaiPublishExtraServices)) {
            CommonResourcesIdMap commonResourcesIdMap = ((PublishVariable)this.publishVariable.get()).getCommonResourcesIdMap();
            for (EaiPublishExtraService eaiPublishExtraService : this.eaiPublishExtraServices) {
                eaiPublishExtraService.publishExtra(((PublishVariable)this.publishVariable.get()).getOnApiIds(), ((PublishVariable)this.publishVariable.get()).getApiIdMaps(), ((PublishVariable)this.publishVariable.get()).getApplicationCode(), ((PublishVariable)this.publishVariable.get()).getAppVersion(), commonResourcesIdMap);
            }
            ((PublishVariable)this.publishVariable.get()).setCommonResourcesIdMap(commonResourcesIdMap);
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void rejectApply() {
        this.eaiRejectPublishService.reject(((PublishVariable)this.publishVariable.get()).getResetApiIds());
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void publishEngine() {
        List normalApiVersion = ((PublishVariable)this.publishVariable.get()).getEaiPublishApiInfos().getApiVersions();
        if (HussarUtils.isEmpty((Object)normalApiVersion)) {
            return;
        }
        Map map = this.eaiPublishEngineApiClassifyMapService.getAllEaiPublishEngineApiClassifyService();
        if (HussarUtils.isNotEmpty((Object)map)) {
            EaiPublishEditApiInfo eaiPublishEditApiInfo = ((PublishVariable)this.publishVariable.get()).getEaiPublishEditApiInfo();
            Set keys = map.keySet();
            CommonResourcesIdMap commonResourcesIdMap = ((PublishVariable)this.publishVariable.get()).getCommonResourcesIdMap();
            for (String str : keys) {
                if (EaiPublishEngineType.DEFAULT.getType().equals(str)) continue;
                normalApiVersion = ((EaiPublishEngineApiClassifyService)map.get(str)).publishEngine(eaiPublishEditApiInfo, normalApiVersion, ((PublishVariable)this.publishVariable.get()).getAppVersion(), commonResourcesIdMap);
            }
            if (HussarUtils.isNotEmpty((Object)normalApiVersion)) {
                ((EaiPublishEngineApiClassifyService)map.get(EaiPublishEngineType.DEFAULT.getType())).publishEngine(eaiPublishEditApiInfo, normalApiVersion, ((PublishVariable)this.publishVariable.get()).getAppVersion(), commonResourcesIdMap);
            }
            ((PublishVariable)this.publishVariable.get()).setCommonResourcesIdMap(commonResourcesIdMap);
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void unlockApp() {
        this.eaiUnlockAppService.unlockApp(((PublishVariable)this.publishVariable.get()).getApplicationCode(), ((PublishVariable)this.publishVariable.get()).getAllApiIds(), null, ((PublishVariable)this.publishVariable.get()).getCacheKey(), Boolean.valueOf(false));
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void unPublish() {
        if (HussarUtils.isNotEmpty((Object)((PublishVariable)this.publishVariable.get()).getApplicationCode())) {
            this.eaiUnlockAppService.unPublishing(((PublishVariable)this.publishVariable.get()).getAllApiIds(), null, ((PublishVariable)this.publishVariable.get()).getApplicationCode());
        }
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public void publishConfiguration() {
        this.eaiPublishConfigurationService.publishConfiguration(((PublishVariable)this.publishVariable.get()).getApplicationCode(), ((PublishVariable)this.publishVariable.get()).getAppVersion(), "jsonFormat");
    }
}

