/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiChangeApiStateService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiChangeAppStateService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiChangeAuthStateService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiUnlockAppServiceImpl")
public class EaiUnlockAppServiceImpl
implements EaiChangeAppStateService {
    @Resource
    private List<EaiChangeAuthStateService> eaiUnlockAuthServices;
    @Resource
    private ISysApplicationService applicationService;
    @Resource
    private EaiChangeApiStateService eaiUnlockedApiService;

    public void lockedApp(String applicationCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)applicationCode)).eq(SysApplication::getAppStatus, (Object)"1");
        SysApplication sysApplication = (SysApplication)this.applicationService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)sysApplication)) {
            throw new BaseException("\u53d1\u5e03\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u6216\u68c0\u67e5\u6743\u9650\u540e\u91cd\u8bd5");
        }
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysApplication::getAppCode, (Object)applicationCode)).set(SysApplication::getAppStatus, (Object)"2");
        this.applicationService.update((Wrapper)wrapper);
    }

    public boolean unPublishing(List<Long> apiIds, List<Long> eventIds, String applicationCode) {
        this.changeAppState(applicationCode, apiIds, eventIds, null, "1", null);
        return true;
    }

    public void unlockApp(String applicationCode, List<Long> allIds, List<Long> eventIds, String key, Boolean isDraft) {
        String authType = "1";
        if (isDraft.booleanValue()) {
            authType = "0";
        }
        this.changeAppState(applicationCode, allIds, eventIds, key, "1", authType);
    }

    public void unlockApp(String applicationCode) {
        this.changeAppState(applicationCode, null, null, null, "1", null);
    }

    public void changeAppState(String applicationCode, List<Long> allIds, List<Long> eventIds, String key, String publishType, String releaseType) {
        LambdaUpdateWrapper wrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysApplication::getAppCode, (Object)applicationCode)).set(SysApplication::getAppStatus, (Object)publishType);
        if (HussarUtils.isNotEmpty((Object)releaseType)) {
            wrapper.set(SysApplication::getReleaseStatus, (Object)releaseType);
        } else {
            releaseType = "0";
        }
        this.applicationService.update((Wrapper)wrapper);
        if (HussarUtils.isNotEmpty(this.eaiUnlockAuthServices)) {
            for (EaiChangeAuthStateService eaiUnlockAuthService : this.eaiUnlockAuthServices) {
                eaiUnlockAuthService.unlockAuth(applicationCode, releaseType);
            }
        }
        this.eaiUnlockedApiService.unlocked(allIds, eventIds, applicationCode);
        if (HussarUtils.isNotEmpty((Object)key)) {
            HussarCacheUtil.evict((String)"eai_api_cache_key", (Object)key);
        }
        try {
            HussarCacheUtil.evict((String)applicationCode, (Object)applicationCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

