/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApply;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.dto.EaiPublishDto;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.vo.EaiPublishTestListVo;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.vo.EaiPublishTestVo;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiChangeApiStateService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiChangeAppStateService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishApiInfoService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiToPublishApiService;
import com.jxdinfo.hussar.eai.logsinfo.api.model.EaiPublishLog;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiToPublishApiServiceImpl")
public class EaiToPublishApiServiceImpl
implements EaiToPublishApiService {
    @Resource
    private IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    private EaiChangeAppStateService eaiChangeAppStateService;
    @Resource
    private EaiPublishApiInfoService eaiPublishApiInfoService;
    @Resource
    private EaiChangeApiStateService changeApiStateService;

    @HussarTransactional
    public EaiPublishTestListVo getToPublishApiInfo(String applicationCode, String appVersion, String cacheKey) {
        Map apiInfosMap = this.eaiPublishApiInfoService.apiInfoList(applicationCode, false);
        StringBuffer sb = new StringBuffer(24);
        sb.append(cacheKey).append(":").append(applicationCode);
        String key = sb.toString();
        HussarCacheUtil.evict((String)cacheKey, (Object)key);
        HussarCacheUtil.put((String)cacheKey, (Object)key, (Object)apiInfosMap);
        ArrayList apiInfos = new ArrayList();
        if (HussarUtils.isNotEmpty(apiInfosMap.get("insert"))) {
            apiInfos.addAll((Collection)apiInfosMap.get("insert"));
        }
        if (HussarUtils.isNotEmpty(apiInfosMap.get("update"))) {
            apiInfos.addAll((Collection)apiInfosMap.get("update"));
        }
        List<Long> apiIds = apiInfos.stream().map(ApiInfo::getId).collect(Collectors.toList());
        List<Long> update = this.updateIds(apiIds, applicationCode);
        ArrayList error = new ArrayList();
        ArrayList info = new ArrayList();
        if (HussarUtils.isNotEmpty(apiInfos)) {
            apiInfos.forEach(apiInfo -> {
                if ("0".equals(apiInfo.getTestState()) && !"0".equals(apiInfo.getPublicState())) {
                    EaiPublishTestVo eaiPublishTestVo = new EaiPublishTestVo();
                    eaiPublishTestVo.setResourceName(this.formatTestInfo(apiInfo.getApiName(), apiInfo.getApiPath()));
                    eaiPublishTestVo.setResourceType("1");
                    eaiPublishTestVo.setPublishType(this.publishType((ApiInfo)apiInfo, update));
                    error.add(eaiPublishTestVo);
                } else {
                    EaiPublishTestVo eaiPublishTestVo = new EaiPublishTestVo();
                    eaiPublishTestVo.setResourceName(this.formatTestInfo(apiInfo.getApiName(), apiInfo.getApiPath()));
                    eaiPublishTestVo.setResourceType("1");
                    eaiPublishTestVo.setPublishType(this.publishType((ApiInfo)apiInfo, update));
                    info.add(eaiPublishTestVo);
                }
            });
        }
        EaiPublishTestListVo eaiPublishTestListVo = new EaiPublishTestListVo();
        eaiPublishTestListVo.setAccess("0");
        EaiPublishDto eaiPublishDto = new EaiPublishDto();
        if (HussarUtils.isEmpty(error) && HussarUtils.isNotEmpty(info)) {
            EaiApply eaiApply = new EaiApply();
            eaiApply.setApplyId(EngineUtil.getId());
            if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
                eaiApply.setCreator(BaseSecurityUtil.getUser().getUserId());
                eaiApply.setApplyBy(BaseSecurityUtil.getUser().getUserName());
            }
            eaiApply.setApplyCode(applicationCode);
            eaiApply.setApplyType("08");
            eaiPublishDto.setEaiApply(eaiApply);
            EaiPublishLog eaiPublishLog = new EaiPublishLog();
            eaiPublishLog.setLogName("\u5e94\u7528\u53d1\u5e03\u65e5\u5fd7");
            eaiPublishLog.setLogVersion(appVersion);
            eaiPublishLog.setRemark(JSON.toJSONString(info));
            eaiPublishDto.setEaiPublishLog(eaiPublishLog);
            eaiPublishTestListVo.setAccess("1");
        } else {
            this.eaiChangeAppStateService.unlockApp(applicationCode);
        }
        eaiPublishTestListVo.setError(error);
        eaiPublishTestListVo.setInfo(info);
        eaiPublishTestListVo.setEaiPublishDto(eaiPublishDto);
        return eaiPublishTestListVo;
    }

    private List<Long> updateIds(List<Long> apiIds, String applicationCode) {
        ArrayList<Long> update = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty(apiIds)) {
            this.changeApiStateService.locked(apiIds, null, applicationCode);
            LambdaQueryWrapper queryWrapper1 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getDeleteState, (Object)"0")).in(EaiResourcesInfo::getResourceRelationId, apiIds);
            List published = this.eaiResourcesInfoService.list((Wrapper)queryWrapper1);
            if (HussarUtils.isNotEmpty((Object)published)) {
                published.forEach(eaiResourcesInfo -> update.add(eaiResourcesInfo.getResourceRelationId()));
            }
        }
        return update;
    }

    private String publishType(ApiInfo apiInfo, List<Long> update) {
        if ("0".equals(apiInfo.getPublicState()) && "1".equals(apiInfo.getApiState())) {
            return "3";
        }
        if (HussarUtils.isNotEmpty(update) && update.contains(apiInfo.getId())) {
            return "2";
        }
        return "1";
    }

    private String formatTestInfo(String name, String nameEn) {
        if (!nameEn.startsWith("/")) {
            return String.format("%s(/%s)", name, nameEn);
        }
        return String.format("%s(%s)", name, nameEn);
    }
}

