/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.CommonResourcesIdMap;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.EaiPublishBaseResources;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.factory.IPublishResourceFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiCommonResourcesIdMapService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiResourcePublishService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiResourcePublishServiceImpl")
public class EaiResourcePublishServiceImpl
implements EaiResourcePublishService {
    @Resource
    private ICommonStructureService commonStructureService;
    @Resource
    private EaiCommonResourcesIdMapService eaiCommonResourcesIdMapService;
    @Resource
    ICommonStructureService eaiCommonStructureService;
    private static final String STRUCTURE_ERROR = "\u5f85\u53d1\u5e03\u7684\u6570\u636e\u7ed3\u6784\u914d\u7f6e\u4fe1\u606f\u5df2\u88ab\u5220\u9664\uff0c\u6570\u636e\u7ed3\u6784\u540d\u79f0:\u3010%s\u3011,\u6570\u636e\u7ed3\u6784\u6807\u8bc6\u3010%s\u3011";
    private static final String STRUCTURE_DELETED_ERROR = "\u5f85\u53d1\u5e03\u7684\u6570\u636e\u7ed3\u6784\u5df2\u88ab\u5220\u9664\uff0c\u6570\u636e\u7ed3\u6784id:\u3010%s\u3011";

    public Map<String, String> getCommonResourcesByApi(Map<String, String> apiInfos, String applicationCode, String appVersion, CommonResourcesIdMap commonResourcesIdMap) {
        EaiPublishBaseResources eaiPublishCommonResources = new EaiPublishBaseResources();
        HashMap<String, String> map = new HashMap<String, String>();
        if (HussarUtils.isEmpty(apiInfos)) {
            return apiInfos;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (Map.Entry<String, String> apiInfo : apiInfos.entrySet()) {
            String v2 = apiInfo.getValue();
            List eaiParamsItems = ParamsConvertUtil.toEaiParamsItems((String)v2);
            this.getIds(eaiParamsItems, ids);
        }
        if (HussarUtils.isNotEmpty(ids)) {
            Map newIds = commonResourcesIdMap.getStructureMap();
            ArrayList<Long> selectIds = new ArrayList<Long>();
            HashMap<Long, Long> hasIds = new HashMap<Long, Long>();
            this.idClassify(ids, newIds, hasIds, selectIds);
            List<StructureVersion> newStructureVersions = new ArrayList<StructureVersion>();
            if (HussarUtils.isNotEmpty(selectIds)) {
                List commonStructures = this.commonStructureService.listByIds(selectIds);
                for (CommonStructure commonStructure : commonStructures) {
                    StructureVersion structureVersion = this.commonStructureToVersion(commonStructure, appVersion);
                    newStructureVersions.add(structureVersion);
                }
                if (HussarUtils.isNotEmpty(newStructureVersions)) {
                    Map<Long, Long> versionIds = newStructureVersions.stream().collect(Collectors.toMap(StructureVersion::getStructureId, StructureVersion::getId));
                    if (HussarUtils.isNotEmpty(hasIds)) {
                        versionIds.putAll(hasIds);
                    }
                    this.commonMap(commonResourcesIdMap, versionIds);
                    apiInfos.forEach((k, v) -> {
                        List eaiParamsItems = ParamsConvertUtil.toEaiParamsItems((String)v);
                        this.resetIds(eaiParamsItems, versionIds);
                        map.put((String)k, ParamsConvertUtil.toJSONString((Object)eaiParamsItems));
                    });
                    eaiPublishCommonResources.setConvertParams(map);
                    newStructureVersions = this.resetNewStructureVersion(newStructureVersions, versionIds);
                    eaiPublishCommonResources.setInsertStructures(newStructureVersions);
                }
            }
        }
        IPublishResourceFactory.getService((String)"default").publishCommonResources(eaiPublishCommonResources, appVersion);
        this.eaiCommonResourcesIdMapService.toCommonResourcesIdMap(eaiPublishCommonResources, commonResourcesIdMap);
        return map;
    }

    private void idClassify(List<Long> ids, Map<Long, Long> newIds, Map<Long, Long> hasIds, List<Long> selectIds) {
        for (Long id : ids) {
            if (HussarUtils.isNotEmpty(newIds) && newIds.containsKey(id)) {
                hasIds.put(id, newIds.get(id));
                continue;
            }
            selectIds.add(id);
        }
    }

    private void commonMap(CommonResourcesIdMap commonResourcesIdMap, Map<Long, Long> versionIds) {
        if (HussarUtils.isNotEmpty((Object)commonResourcesIdMap.getStructureMap())) {
            commonResourcesIdMap.getStructureMap().putAll(versionIds);
        } else {
            commonResourcesIdMap.setStructureMap(versionIds);
        }
    }

    private List<StructureVersion> resetNewStructureVersion(List<StructureVersion> newStructureVersions, Map<Long, Long> versionIds) {
        for (StructureVersion structureVersion : newStructureVersions) {
            versionIds.forEach((k, v) -> {
                if (k.equals(structureVersion.getStructureId())) {
                    structureVersion.setStructureValues(this.cheangNewIds(String.valueOf(k), versionIds));
                }
            });
        }
        return newStructureVersions;
    }

    public Map<String, String> getCommonResourcesByApi(Map<String, String> apiInfos, String applicationCode, String appVersion) {
        return this.getCommonResourcesByApi(apiInfos, applicationCode, appVersion, new CommonResourcesIdMap());
    }

    private void getIds(List<EaiParamsItems> eaiParamsItems, List<Long> ids) {
        eaiParamsItems.forEach(eaiParamsItem -> {
            if (HussarUtils.isNotEmpty((Object)eaiParamsItem.getQuoteStructureId()) && !ids.contains(Long.valueOf(eaiParamsItem.getQuoteStructureId()))) {
                ids.add(Long.valueOf(eaiParamsItem.getQuoteStructureId()));
            }
            if (HussarUtils.isNotEmpty((Object)eaiParamsItem.getItems())) {
                this.getIds(eaiParamsItem.getItems(), ids);
            }
        });
    }

    private void resetIds(List<EaiParamsItems> eaiParamsItems, Map<Long, Long> ids) {
        eaiParamsItems.forEach(eaiParamsItem -> {
            String id = eaiParamsItem.getQuoteStructureId();
            if (HussarUtils.isNotEmpty((Object)id) && ids.containsKey(Long.valueOf(id))) {
                eaiParamsItem.setQuoteStructureId(String.valueOf(ids.get(Long.valueOf(id))));
            }
            if (HussarUtils.isNotEmpty((Object)eaiParamsItem.getItems())) {
                this.resetIds(eaiParamsItem.getItems(), ids);
            }
        });
    }

    private StructureVersion commonStructureToVersion(CommonStructure commonStructure, String appVersion) {
        StructureVersion structureVersion = (StructureVersion)BeanUtil.copy((Object)commonStructure, StructureVersion.class);
        if (HussarUtils.isNotEmpty((Object)structureVersion)) {
            structureVersion.setId(EngineUtil.getId());
            structureVersion.setStructureId(commonStructure.getId());
            structureVersion.setStructureVersion(appVersion);
            structureVersion.setCreateTime(null);
            structureVersion.setLastEditor(null);
        }
        return structureVersion;
    }

    private String cheangNewIds(String structureId, Map<Long, Long> versiionIds) {
        List list;
        CommonStructure commonStructureVo = (CommonStructure)this.eaiCommonStructureService.getById((Serializable)((Object)structureId));
        if (HussarUtils.isEmpty((Object)commonStructureVo)) {
            throw new BaseException(String.format(STRUCTURE_DELETED_ERROR, structureId));
        }
        String values = commonStructureVo.getStructureValues();
        if (values != null && HussarUtils.isNotEmpty((Object)(list = JSON.parseArray((String)values, StructureItems.class)))) {
            this.fillStructureItem(list, versiionIds);
            return JSON.toJSONString((Object)list);
        }
        throw new BaseException(String.format(STRUCTURE_ERROR, commonStructureVo.getStructureName(), commonStructureVo.getStructureCode()));
    }

    private void fillStructureItem(List<StructureItems> list, Map<Long, Long> versiionIds) {
        for (StructureItems item : list) {
            versiionIds.forEach((k, v) -> {
                if (String.valueOf(k).equals(item.getQuoteStructureId())) {
                    item.setQuoteStructureId(String.valueOf(v));
                }
            });
            if (!HussarUtils.isNotEmpty((Object)item.getItems())) continue;
            this.fillStructureItem(item.getItems(), versiionIds);
        }
    }
}

