/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.AuthHTTPBodyParams;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.CommonResourcesIdMap;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishParamsPossitionService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishResourceIdService;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.ExpressionRegUtil;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiPublishResourceIdServiceImpl")
public class EaiPublishResourceIdServiceImpl
implements EaiPublishResourceIdService {
    @Resource
    private EaiPublishParamsPossitionService eaiPublishParamsPossitionService;
    @Resource
    private ICommonConstantService commonConstantService;
    @Resource
    private ICommonStructureService commonStructureService;
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiPublishResourceIdServiceImpl.class);

    public String getConstantIdFromExp(String expStr, Map<Long, Long> constantMap) {
        return this.getConstantIdFromExp(expStr, constantMap, new HashMap<Long, Long>());
    }

    public String getConstantIdFromExp(String expStr, Map<Long, Long> constantMap, Map<Long, Long> newConstantMap) {
        List constantIdOlds = ExpressionRegUtil.findConstantIds((String)expStr);
        if (CollectionUtil.isNotEmpty((Collection)constantIdOlds)) {
            for (Long oldId : constantIdOlds) {
                if (!constantMap.containsKey(oldId)) {
                    Long id = EngineUtil.getId();
                    constantMap.put(oldId, id);
                    newConstantMap.put(oldId, id);
                    expStr = expStr.replace("\"" + oldId + "\"", "\"" + id + "\"");
                    continue;
                }
                expStr = expStr.replace("\"" + oldId + "\"", "\"" + constantMap.get(oldId) + "\"");
            }
        }
        return expStr;
    }

    public void addToList(List<EaiHttpParams> queryParam, Map<Long, Long> list) {
        this.addToList(queryParam, list, new HashMap<Long, Long>());
    }

    public void addToList(List<EaiHttpParams> queryParam, Map<Long, Long> list, Map<Long, Long> newList) {
        if (HussarUtils.isNotEmpty(queryParam)) {
            queryParam.forEach(v -> {
                if (HussarUtils.isNotEmpty((Object)v.getParamsValue()) && v.getParamsValue().startsWith("{")) {
                    if (HussarUtils.isEmpty((Object)v.getParamsFrom()) && "1".equals(v.getParamsPosition())) {
                        AuthHTTPBodyParams newStructParam = (AuthHTTPBodyParams)JSON.parseObject((String)v.getParamsValue(), AuthHTTPBodyParams.class);
                        this.getConstantIdFromRecursionStructure(newStructParam, list, newList);
                    }
                    AuthHTTPBodyParams authHTTPBodyParams = (AuthHTTPBodyParams)JSON.parseObject((String)v.getParamsValue(), AuthHTTPBodyParams.class);
                    this.children(authHTTPBodyParams, list, newList);
                    v.setParamsValue(JSON.toJSONString((Object)authHTTPBodyParams));
                } else {
                    if ("0".equals(v.getParamsFrom())) {
                        this.getConstantId(list, v.getParamsValue());
                    }
                    if ("1".equals(v.getParamsFrom())) {
                        Long oldId = Long.valueOf(v.getParamsValue());
                        if (!list.containsKey(oldId)) {
                            Long id = EngineUtil.getId();
                            list.put(oldId, id);
                            newList.put(oldId, id);
                            v.setParamsValue(String.valueOf(id));
                        } else {
                            v.setParamsValue(String.valueOf(list.get(oldId)));
                        }
                    }
                }
            });
        }
    }

    private void children(AuthHTTPBodyParams authHTTPBodyParams, Map<Long, Long> list, Map<Long, Long> newList) {
        List childs = authHTTPBodyParams.getItems();
        if (HussarUtils.isNotEmpty((Object)childs)) {
            for (AuthHTTPBodyParams child : childs) {
                this.children(child, list, newList);
            }
        }
        if ("0".equals(authHTTPBodyParams.getParamsFrom())) {
            String value = authHTTPBodyParams.getParamsValue();
            authHTTPBodyParams.setParamsValue(this.getConstantIdFromExp(value, list, newList));
        }
        if ("1".equals(authHTTPBodyParams.getParamsFrom())) {
            Long oldId = Long.valueOf(authHTTPBodyParams.getParamsValue());
            if (!list.containsKey(oldId)) {
                Long id = EngineUtil.getId();
                list.put(oldId, id);
                newList.put(oldId, id);
                authHTTPBodyParams.setParamsValue(String.valueOf(id));
            } else {
                authHTTPBodyParams.setParamsValue(String.valueOf(list.get(oldId)));
            }
        }
    }

    private void getConstantIdFromRecursionStructure(AuthHTTPBodyParams newStructParam, Map<Long, Long> list, Map<Long, Long> newList) {
        if (null != EaiDataType.getBaseModelType((Integer)newStructParam.getType())) {
            if ("0".equals(newStructParam.getParamsFrom())) {
                String value = newStructParam.getParamsValue();
                newStructParam.setParamsValue(this.getConstantIdFromExp(value, list, newList));
            }
        } else if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == newStructParam.getType().intValue()) {
            List paramItems = newStructParam.getItems();
            if (CollectionUtil.isNotEmpty((Collection)paramItems)) {
                for (AuthHTTPBodyParams params : paramItems) {
                    if (null != EaiDataType.getBaseModelType((Integer)params.getType())) {
                        if (!"0".equals(params.getParamsFrom())) continue;
                        String value = params.getParamsValue();
                        params.setParamsValue(this.getConstantIdFromExp(value, list));
                        continue;
                    }
                    if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == params.getType().intValue()) {
                        this.getConstantIdFromRecursionStructure(params, list, newList);
                        continue;
                    }
                    this.getConstantIdFromRecursionStructure((AuthHTTPBodyParams)params.getItems().get(0), list, newList);
                }
            }
        } else if (EaiDataType.DATA_TYPE_LIST.getType() == newStructParam.getType().intValue()) {
            this.getConstantIdFromRecursionStructure((AuthHTTPBodyParams)newStructParam.getItems().get(0), list, newList);
        }
    }

    private void getConstantId(Map<Long, Long> list, String paramsValue) {
        AuthHTTPBodyParams newStructParam = null;
        try {
            newStructParam = (AuthHTTPBodyParams)JSON.parseObject((String)paramsValue, AuthHTTPBodyParams.class);
        }
        catch (Exception e) {
            LOGGER.info("ParamsValue\u5b58\u7684\u662f\u65e7\u6570\u636e{}", (Object)paramsValue);
        }
        if (null != newStructParam) {
            String val = newStructParam.getParamsValue();
            newStructParam.setParamsValue(this.getConstantIdFromExp(val, list));
        }
    }

    public List<ConstantVersion> commonConstantsToVersion(String appVersion, Map<Long, Long> constantMap) {
        List commonConstants = this.commonConstantService.listByIds(new ArrayList<Long>(constantMap.keySet()));
        ArrayList<ConstantVersion> constantVersions = new ArrayList<ConstantVersion>();
        for (CommonConstant commonConstant : commonConstants) {
            ConstantVersion version = this.commonConstantsToVersion(commonConstant, appVersion, constantMap);
            constantVersions.add(version);
        }
        return constantVersions;
    }

    public List<StructureVersion> commonStructuresToVersion(String appVersion, Map<Long, Long> structureMap) {
        List commonStructures = this.commonStructureService.listByIds(new ArrayList<Long>(structureMap.keySet()));
        ArrayList<StructureVersion> structureVersions = new ArrayList<StructureVersion>();
        for (CommonStructure commonStructure : commonStructures) {
            StructureVersion version = this.commonStructuresToVersion(commonStructure, appVersion, structureMap);
            structureVersions.add(version);
        }
        return structureVersions;
    }

    public EaiHttpAuthDto authParamsCommonResources(EaiHttpAuthDto eaiHttpAuthDto, CommonResourcesIdMap commonResourcesIdMap, CommonResourcesIdMap newMap) {
        List eaiParamsPositions;
        HashMap<Long, Long> constantMap = commonResourcesIdMap.getConstantMap();
        HashMap<Long, Long> structureMap = commonResourcesIdMap.getStructureMap();
        HashMap<Long, Long> newConstantMap = new HashMap<Long, Long>(8);
        HashMap<Long, Long> newStructureMap = new HashMap<Long, Long>(8);
        List eaiHttpVerifyDtos = eaiHttpAuthDto.getEaiHttpVerifyDtos();
        if (HussarUtils.isEmpty((Object)constantMap)) {
            constantMap = newConstantMap;
        }
        if (HussarUtils.isEmpty((Object)structureMap)) {
            structureMap = newStructureMap;
        }
        if (HussarUtils.isNotEmpty((Object)eaiHttpVerifyDtos)) {
            for (EaiHttpVerifyDto eaiHttpVerifyDto : eaiHttpVerifyDtos) {
                if ("1".equals(eaiHttpVerifyDto.getHttpVerifyBase().getHttpUrlType())) {
                    String url = eaiHttpVerifyDto.getHttpVerifyBase().getHttpUrl();
                    eaiHttpVerifyDto.getHttpVerifyBase().setHttpUrl(this.getConstantIdFromExp(url, constantMap, newConstantMap));
                }
                List eaiHttpParams = eaiHttpVerifyDto.getHttpParams();
                this.addToList(eaiHttpParams, constantMap, newConstantMap);
                this.addStructure(eaiHttpParams, structureMap, newStructureMap);
                eaiHttpVerifyDto.setHttpParams(eaiHttpParams);
            }
        }
        if (HussarUtils.isNotEmpty((Object)(eaiParamsPositions = eaiHttpAuthDto.getEaiParamsPosition()))) {
            eaiParamsPositions = this.eaiPublishParamsPossitionService.changeResourceIds(eaiParamsPositions, constantMap);
            eaiHttpAuthDto.setEaiParamsPosition(eaiParamsPositions);
        }
        commonResourcesIdMap.setStructureMap(structureMap);
        commonResourcesIdMap.setConstantMap(constantMap);
        if (HussarUtils.isNotEmpty(newStructureMap)) {
            newMap.setStructureMap(newStructureMap);
        }
        if (HussarUtils.isNotEmpty(newConstantMap)) {
            newMap.setConstantMap(newConstantMap);
        }
        return eaiHttpAuthDto;
    }

    private void addStructure(List<EaiHttpParams> eaiHttpParams, Map<Long, Long> map, Map<Long, Long> newMap) {
        for (EaiHttpParams eaiHttpParam : eaiHttpParams) {
            if (!StringUtil.isNotEmpty((Object)eaiHttpParam.getParamsValue())) continue;
            try {
                AuthHTTPBodyParams newStructParam = (AuthHTTPBodyParams)JSON.parseObject((String)eaiHttpParam.getParamsValue(), AuthHTTPBodyParams.class);
                if (!map.containsKey(Long.valueOf(newStructParam.getQuoteStructureId()))) {
                    newStructParam = this.listAuthHTTPBodyParams(newStructParam, map, newMap);
                } else {
                    newStructParam.setQuoteStructureId(String.valueOf(map.get(newStructParam.getQuoteStructureId())));
                }
                eaiHttpParam.setParamsValue(JSON.toJSONString((Object)newStructParam));
            }
            catch (Exception exception) {}
        }
    }

    private AuthHTTPBodyParams listAuthHTTPBodyParams(AuthHTTPBodyParams newStructParam, Map<Long, Long> map, Map<Long, Long> newMap) {
        List items;
        if (HussarUtils.isNotEmpty((Object)newStructParam.getQuoteStructureId()) && !map.containsKey(Long.valueOf(newStructParam.getQuoteStructureId()))) {
            Long structureId = Long.valueOf(newStructParam.getQuoteStructureId());
            Long id = null;
            if (map.containsKey(structureId)) {
                id = map.get(structureId);
            } else {
                id = EngineUtil.getId();
                map.put(Long.valueOf(newStructParam.getQuoteStructureId()), id);
                newMap.put(Long.valueOf(newStructParam.getQuoteStructureId()), id);
            }
            this.getStructureIdFromRecursionStructure(newStructParam.getQuoteStructureId(), map, newMap);
            newStructParam.setQuoteStructureId(String.valueOf(id));
        }
        if (HussarUtils.isNotEmpty((Object)(items = newStructParam.getItems()))) {
            ArrayList<AuthHTTPBodyParams> newItems = new ArrayList<AuthHTTPBodyParams>();
            for (AuthHTTPBodyParams item : items) {
                newItems.add(this.listAuthHTTPBodyParams(item, map, newMap));
            }
            newStructParam.setItems(newItems);
        }
        return newStructParam;
    }

    private void getStructureIdFromRecursionStructure(String structureId, Map<Long, Long> map, Map<Long, Long> newMap) {
        CommonStructure commonStructure = (CommonStructure)this.commonStructureService.getById((Serializable)((Object)structureId));
        if (HussarUtils.isNotEmpty((Object)commonStructure)) {
            Long commonId = commonStructure.getId();
            Long newId = null;
            if (map.containsKey(commonId)) {
                newId = map.get(commonId);
            } else {
                newId = EngineUtil.getId();
                map.put(commonId, newId);
                newMap.put(commonId, newId);
            }
            String value = commonStructure.getStructureValues();
            if (HussarUtils.isNotEmpty((Object)value)) {
                List structureItems = JSON.parseArray((String)value, StructureItems.class);
                for (StructureItems structureItem : structureItems) {
                    Long qId;
                    if (HussarUtils.isNotEmpty((Object)structureItem.getQuoteStructureId()) && !map.containsKey(qId = Long.valueOf(structureItem.getQuoteStructureId()))) {
                        Long id = EngineUtil.getId();
                        map.put(qId, id);
                        newMap.put(commonId, newId);
                        this.getStructureIdFromRecursionStructure(structureItem.getQuoteStructureId(), map, newMap);
                        structureItem.setQuoteStructureId(String.valueOf(id));
                    }
                    if (!HussarUtils.isNotEmpty((Object)structureItem.getItems())) continue;
                    List items = structureItem.getItems();
                    for (StructureItems item : items) {
                        Long itemQId = Long.valueOf(item.getQuoteStructureId());
                        if (map.containsKey(itemQId)) continue;
                        Long id = EngineUtil.getId();
                        map.put(itemQId, id);
                        newMap.put(commonId, newId);
                        this.getStructureIdFromRecursionStructure(item.getQuoteStructureId(), map, newMap);
                        item.setQuoteStructureId(String.valueOf(id));
                    }
                    structureItem.setItems(items);
                }
                commonStructure.setStructureValues(JSON.toJSONString((Object)structureItems));
            }
        }
    }

    private StructureVersion commonStructuresToVersion(CommonStructure commonStructure, String appVersion, Map<Long, Long> list) {
        StructureVersion structureVersion = new StructureVersion();
        BeanUtil.copyProperties((Object)commonStructure, (Object)structureVersion);
        Long id = commonStructure.getId();
        list.forEach((k, v) -> {
            if (k.equals(id)) {
                structureVersion.setId(v);
            }
        });
        structureVersion.setStructureId(id);
        structureVersion.setStructureVersion(appVersion);
        return structureVersion;
    }

    private ConstantVersion commonConstantsToVersion(CommonConstant commonConstant, String appVersion, Map<Long, Long> list) {
        ConstantVersion constantVersion = new ConstantVersion();
        BeanUtil.copyProperties((Object)commonConstant, (Object)constantVersion);
        Long id = commonConstant.getId();
        list.forEach((k, v) -> {
            if (k.equals(id)) {
                constantVersion.setId(v);
            }
        });
        constantVersion.setConstantId(id);
        constantVersion.setConstantVersion(appVersion);
        return constantVersion;
    }
}

