/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishInitService;
import com.jxdinfo.hussar.eai.common.util.EaiVersionUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiPublishInitServiceImpl")
public class EaiPublishInitServiceImpl
implements EaiPublishInitService {
    @Resource
    protected ISysApplicationService applicationService;

    @HussarTransactional
    public String initPublish(String applicationCode) {
        String appVersion = this.newAppVersion(applicationCode);
        this.updateVersion(applicationCode, appVersion);
        return appVersion;
    }

    public String newAppVersion(String applicationCode) {
        AssertUtil.isNotEmpty((String)applicationCode, (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper versionQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)applicationCode);
        SysApplication sysApplication = (SysApplication)this.applicationService.getOne((Wrapper)versionQueryWrapper);
        return EaiVersionUtil.getInstance().getNewVersion(sysApplication.getAppVersion());
    }

    public void updateVersion(String applicationCode, String appVersion) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(SysApplication::getAppCode, (Object)applicationCode)).set(SysApplication::getAppVersion, (Object)appVersion);
        this.applicationService.update((Wrapper)updateWrapper);
    }
}

