/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.enums.EaiPublishEngineType;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.factory.IPublishEngineFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishEngineService;
import com.jxdinfo.hussar.eai.common.constant.logic.EaiLogicConstant;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.choreo.api.dto.ApiNamingDto;
import com.jxdinfo.hussar.support.choreo.api.entity.ApiPm;
import com.jxdinfo.hussar.support.choreo.api.model.PushBackCtx;
import com.jxdinfo.hussar.support.choreo.api.service.EngineBussnessdataConfigService;
import com.jxdinfo.hussar.support.engine.api.model.NodeBusiness;
import com.jxdinfo.hussar.support.engine.core.enums.NodeTypeEnum;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.rmi.sdk.enums.RequestTypeEnum;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiPublishEngineServiceImpl")
public class EaiPublishEngineServiceImpl
implements EaiPublishEngineService {
    @Resource
    protected EngineBussnessdataConfigService engineBussnessdataConfigService;

    public void pushEngine(List<EaiApiVersion> apiVersions, String appVersion) {
        if (HussarUtils.isEmpty(apiVersions)) {
            return;
        }
        this.pushEngine(apiVersions, appVersion, null);
    }

    public void pushEngine(List<EaiApiVersion> apiVersions, String appVersion, Map<Long, String> maps) {
        PushBackCtx pushBackCtx = new PushBackCtx();
        apiVersions.forEach(apiInfo -> {
            ApiNamingDto apiNamingDto = this.toApiNamingDto(appVersion, (EaiApiVersion)apiInfo);
            pushBackCtx.addApiNaming(apiNamingDto);
            NodeBusiness nodeBusiness = null;
            nodeBusiness = maps != null && maps.containsKey(apiInfo.getApiVersionId()) ? this.toNodeBusiness((EaiApiVersion)apiInfo, (String)maps.get(apiInfo.getApiVersionId())) : this.toNodeBusiness((EaiApiVersion)apiInfo);
            pushBackCtx.addNodeBusiness(nodeBusiness);
        });
        this.engineBussnessdataConfigService.pushApi(pushBackCtx);
    }

    public void pushEngine(List<Long> canvasIds, Map<Long, Long> map, List<EaiApiVersion> apiVersions, String appcode, String appVersion) {
        throw new BaseException("the method is not support in this implement");
    }

    public void afterPropertiesSet() throws Exception {
        IPublishEngineFactory.register((String)EaiPublishEngineType.DEFAULT.getType(), (EaiPublishEngineService)this);
    }

    protected ApiNamingDto toApiNamingDto(String appVersion, EaiApiVersion apiInfo) {
        ApiNamingDto apiNamingDto = new ApiNamingDto();
        ApiPm apiPm = new ApiPm();
        apiPm.setParameterId(EngineUtil.getId());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(RequestTypeEnum.POST.getType()).append(" ").append(apiInfo.getApiPath());
        apiPm.setBusinessId(stringBuilder.toString());
        apiPm.setHpeVersion(Integer.valueOf(Integer.parseInt(appVersion.substring(1))));
        apiPm.setCreateTime(apiInfo.getCreateTime());
        apiPm.setCreator(apiInfo.getCreator());
        apiPm.setLastEditor(apiInfo.getLastEditor());
        apiPm.setLastTime(apiInfo.getLastTime());
        apiNamingDto.setApiPm(apiPm);
        apiNamingDto.setBusinessName(apiInfo.getApiName());
        apiNamingDto.setId(EngineUtil.getId());
        apiNamingDto.setBusinessId(stringBuilder.toString());
        apiNamingDto.setNewVersion(appVersion);
        apiNamingDto.setServiceId(apiInfo.getApiVersionId());
        apiNamingDto.setBusinessType("HTTP");
        apiNamingDto.setServiceName(this.getServiceName(apiInfo));
        return apiNamingDto;
    }

    private NodeBusiness toNodeBusiness(EaiApiVersion apiInfo) {
        return this.toNodeBusiness(apiInfo, null);
    }

    private NodeBusiness toNodeBusiness(EaiApiVersion apiInfo, String parse) {
        NodeBusiness nodeBusiness = new NodeBusiness();
        nodeBusiness.setNodeType(NodeTypeEnum.API.getValue());
        nodeBusiness.setNodeName(this.getServiceName(apiInfo));
        nodeBusiness.setNodeClass("com.jxdinfo.hussar.eai.common.server.applicationrelease.applicationauth.service.impl.IEaiHttpTemplateAuthServiceImpl");
        nodeBusiness.setActionName("apiInvoke");
        nodeBusiness.setDataServiceActionName("com.jxdinfo.hussar.eai.server.enginegain.service.impl.EaiGainParamsChangeServiceImpl");
        nodeBusiness.setDataServiceCode(String.valueOf(apiInfo.getApiVersionId()));
        nodeBusiness.setNodeId(apiInfo.getApiVersionId());
        if (HussarUtils.isNotEmpty((Object)parse)) {
            nodeBusiness.setJsonParams(parse);
        }
        return nodeBusiness;
    }

    protected String getServiceName(EaiApiVersion apiInfo) {
        return String.format("%s_%s_%s", EaiLogicConstant.getReplaceCode((String)apiInfo.getApplicationCode()), apiInfo.getApiVersion(), EaiLogicConstant.getReplaceCode((String)apiInfo.getApiCode()));
    }
}

