/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.EaiPublishEditApiInfo;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishEditApiService;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiPublishEditApiServiceImpl")
public class EaiPublishEditApiServiceImpl
implements EaiPublishEditApiService {
    @Resource
    private IEaiEditApiService editApiService;

    public EaiPublishEditApiInfo getEditApi(List<Long> onApiIds) {
        EaiPublishEditApiInfo eaiPublishEditApiInfo = new EaiPublishEditApiInfo();
        ArrayList<EditApi> editApis = new ArrayList<EditApi>();
        ArrayList<EditApi> editApisWithCanvas = new ArrayList<EditApi>();
        for (Long aLong : onApiIds) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)aLong);
            EditApi editApi = (EditApi)this.editApiService.getOne((Wrapper)queryWrapper);
            if (HussarUtils.isNotEmpty((Object)editApi.getCanvasId())) {
                editApisWithCanvas.add(editApi);
                continue;
            }
            editApis.add(editApi);
        }
        eaiPublishEditApiInfo.setEditApis(editApis);
        eaiPublishEditApiInfo.setEditApisWithCanvas(editApisWithCanvas);
        return eaiPublishEditApiInfo;
    }

    public Map<Long, Long> publishEditApi(List<Long> apiIds, List<EditApi> allEditApis, Map<Long, Long> editIds, List<EaiApiVersion> apiVersions) {
        HashMap<Long, Long> map = new HashMap<Long, Long>();
        if (HussarUtils.isNotEmpty(apiIds)) {
            if (HussarUtils.isEmpty(allEditApis) || allEditApis.size() != apiIds.size() || editIds.size() != allEditApis.size()) {
                throw new BaseException("\u53d1\u5e03\u63a5\u53e3\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
            }
            for (EditApi editApi : allEditApis) {
                Long apiId = editIds.get(editApi.getApiId());
                editApi.setApiId(apiId);
                Long id = EngineUtil.getId();
                map.put(editApi.getId(), id);
                editApi.setId(id);
                EaiApiVersion apiVersion = apiVersions.stream().filter(v -> apiId.equals(v.getApiVersionId())).findFirst().orElseGet(EaiApiVersion::new);
                EaiParamsConvertDto in = ParamsConvertUtil.toEaiParamsConvertDto((String)apiVersion.getInParams());
                EaiParamsConvertDto out = ParamsConvertUtil.toEaiParamsConvertDto((String)apiVersion.getOutParams());
                if (HussarUtils.isNotEmpty((Object)in)) {
                    editApi.setInParams(JSON.toJSONString((Object)in));
                } else {
                    editApi.setInParams(null);
                }
                if (HussarUtils.isNotEmpty((Object)out)) {
                    editApi.setOutParams(JSON.toJSONString((Object)out));
                    continue;
                }
                editApi.setOutParams(null);
            }
            this.editApiService.saveBatch(allEditApis);
        }
        return map;
    }
}

