/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiApplicationExtendConfiguration;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiApplicationExtendConfigurationVersion;
import com.jxdinfo.hussar.eai.appinfo.api.plugin.AppExtendConfigDataPlugin;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiApplicationExtendConfigurationService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiApplicationExtendConfigurationVersionService;
import com.jxdinfo.hussar.eai.appinfo.server.plugins.AppExtendConfigDataPluginHolder;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.IEaiPublishConfigurationService;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiPublishConfigurationServiceImpl")
public class EaiPublishConfigurationServiceImpl
implements IEaiPublishConfigurationService {
    @Resource
    private IEaiApplicationExtendConfigurationVersionService eaiApplicationExtendConfigurationVersionService;
    @Resource
    private IEaiApplicationExtendConfigurationService eaiApplicationExtendConfigurationService;

    public void publishConfiguration(String appCode, String configVersion, String configType) {
        if (HussarUtils.isEmpty((Object)appCode)) {
            throw new BaseException("\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(EaiApplicationExtendConfiguration::getApplicationCode, (Object)appCode)).eq(EaiApplicationExtendConfiguration::getConfigType, (Object)configType);
        EaiApplicationExtendConfiguration commonConfiguration = (EaiApplicationExtendConfiguration)this.eaiApplicationExtendConfigurationService.getOne((Wrapper)queryWrapper);
        if (commonConfiguration == null) {
            AppExtendConfigDataPlugin plugin = AppExtendConfigDataPluginHolder.lookup((String)configType);
            Object configData = plugin.initConfigData();
            commonConfiguration = new EaiApplicationExtendConfiguration();
            commonConfiguration.setApplicationCode(appCode);
            commonConfiguration.setConfigType(configType);
            commonConfiguration.setConfigDataText(HussarIntegrationJsonUtils.toString((Object)configData));
            commonConfiguration.setCreateBy(HussarSecurityUtils.getLoginUserDetails().getUserName());
            commonConfiguration.setEditBy(HussarSecurityUtils.getLoginUserDetails().getUserName());
            this.eaiApplicationExtendConfigurationService.save((Object)commonConfiguration);
        }
        EaiApplicationExtendConfigurationVersion configurationVersion = new EaiApplicationExtendConfigurationVersion();
        HussarUtils.copy((Object)commonConfiguration, (Object)configurationVersion);
        configurationVersion.setConfigVersion(configVersion);
        configurationVersion.setCreateBy(HussarSecurityUtils.getLoginUserDetails().getUserName());
        configurationVersion.setEditBy(HussarSecurityUtils.getLoginUserDetails().getUserName());
        this.eaiApplicationExtendConfigurationVersionService.save((Object)configurationVersion);
    }
}

