/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.applyinfo.api.service.IEaiApplyRecordService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishApiRelationService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiRejectPublishService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiPublishApiRelationServiceImpl")
public class EaiPublishApiRelationServiceImpl
implements EaiPublishApiRelationService {
    @Resource
    private IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    private EaiRejectPublishService eaiRejectPublishService;
    @Resource
    private IEaiApplyRecordService applyRecordService;

    public List<Long> publishResourcesInfo(List<EaiResourcesInfo> eaiResourcesInfos, List<Long> apiIds, List<ApiInfo> apiInfosUpdate, String appVersion) {
        ArrayList<EaiResourcesInfo> update = new ArrayList<EaiResourcesInfo>();
        ArrayList<EaiResourcesInfo> insert = new ArrayList<EaiResourcesInfo>();
        if (HussarUtils.isNotEmpty(apiIds)) {
            LambdaQueryWrapper queryWrapper1 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getDeleteState, (Object)"0")).in(EaiResourcesInfo::getResourceRelationId, apiIds);
            List published = this.eaiResourcesInfoService.list((Wrapper)queryWrapper1);
            if (HussarUtils.isNotEmpty((Object)published)) {
                this.eaiResourcesInfoClassify(eaiResourcesInfos, published, appVersion, insert, update);
            } else {
                eaiResourcesInfos.forEach(eaiResourcesInfo -> {
                    eaiResourcesInfo.setApplicationVersion(appVersion);
                    eaiResourcesInfo.setDeleteState("0");
                });
                insert.addAll(eaiResourcesInfos);
            }
        }
        if (HussarUtils.isNotEmpty(insert)) {
            this.eaiResourcesInfoService.saveBatch(insert);
        }
        ArrayList<Long> restIds = new ArrayList<Long>();
        if (HussarUtils.isNotEmpty(apiInfosUpdate)) {
            ArrayList delIds = new ArrayList(apiInfosUpdate.size());
            apiInfosUpdate.forEach(apiInfo -> delIds.add(apiInfo.getId()));
            restIds.addAll(delIds);
            LambdaUpdateWrapper delWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(EaiResourcesInfo::getDeleteState, (Object)"0")).in(EaiResourcesInfo::getResourceRelationId, delIds)).set(EaiResourcesInfo::getDeleteState, (Object)"1");
            this.eaiResourcesInfoService.update((Wrapper)delWrapper);
        }
        if (HussarUtils.isNotEmpty(update)) {
            this.eaiResourcesInfoService.updateBatchById(update);
            restIds.addAll(update.stream().map(EaiResourcesInfo::getResourceRelationId).collect(Collectors.toList()));
        }
        return restIds;
    }

    private void eaiResourcesInfoClassify(List<EaiResourcesInfo> eaiResourcesInfos, List<EaiResourcesInfo> published, String appVersion, List<EaiResourcesInfo> insert, List<EaiResourcesInfo> update) {
        for (EaiResourcesInfo eaiResourcesInfo : eaiResourcesInfos) {
            boolean isInsert = true;
            for (EaiResourcesInfo publish : published) {
                if (!publish.getResourceRelationId().equals(eaiResourcesInfo.getResourceRelationId())) continue;
                eaiResourcesInfo.setResourceId(publish.getResourceId());
                eaiResourcesInfo.setApplicationVersion(appVersion);
                eaiResourcesInfo.setDeleteState("0");
                update.add(eaiResourcesInfo);
                isInsert = false;
                break;
            }
            if (!isInsert) continue;
            eaiResourcesInfo.setResourceId(EngineUtil.getId());
            eaiResourcesInfo.setApplicationVersion(appVersion);
            eaiResourcesInfo.setDeleteState("0");
            insert.add(eaiResourcesInfo);
        }
    }
}

