/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EaiApiClassification;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiClassificationService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiClassificationVersion;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IEaiApiClassificationVersionService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.EaiPublishApiInfo;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.EaiPublishApiInfos;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishApiInfoService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.IEaiApiResourceService;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiPublishApiInfoServiceImpl")
public class EaiPublishApiInfoServiceImpl
implements EaiPublishApiInfoService {
    @Resource
    private IEaiApiInfoService eaiApiInfoService;
    @Resource
    private IEaiApiClassificationService eaiApiClassificationService;
    @Resource
    private IEaiApiResourceService eaiApiResourceService;
    @Resource
    private IApiVersionService apiVersionService;
    private static final Long MAX_PAGE = 5000L;
    @Resource
    IEaiApiClassificationVersionService eaiApiClassificationVersionService;

    private String getCacheKey(String applicationCode) {
        StringBuffer sb = new StringBuffer(24);
        sb.append("eai_api_cache_key").append(":").append(applicationCode);
        return sb.toString();
    }

    public Map<String, String> apiInfoParams(List<ApiInfo> apiInfos) {
        HashMap<String, String> map = new HashMap<String, String>(apiInfos.size());
        this.listParams(apiInfos, map);
        return map;
    }

    private void listParams(List<ApiInfo> apiInfos, Map<String, String> map) {
        apiInfos.forEach(apiInfo -> {
            if (HussarUtils.isNotEmpty((Object)apiInfo.getInParams())) {
                map.put(this.getKeyIn(apiInfo.getId()), apiInfo.getInParams());
            }
            if (HussarUtils.isNotEmpty((Object)apiInfo.getOutParams())) {
                map.put(this.getKeyOut(apiInfo.getId()), apiInfo.getOutParams());
            }
        });
    }

    public EaiPublishApiInfos publishApi(List<ApiInfo> apiInfos, String applicationCode, String appVersion, Map<String, String> idMappings) {
        List apiClassifications;
        EaiPublishApiInfos publishApiInfos = new EaiPublishApiInfos();
        ArrayList<EaiApiVersion> apiVersions = new ArrayList<EaiApiVersion>(apiInfos.size());
        HashMap<Long, Long> apiIds = new HashMap<Long, Long>(apiInfos.size());
        ArrayList<EaiResourcesInfo> eaiResourcesInfos = new ArrayList<EaiResourcesInfo>(apiInfos.size());
        List classifyIds = apiInfos.stream().map(ApiInfo::getClassificId).collect(Collectors.toList());
        Map<Object, Object> map = new HashMap();
        if (HussarUtils.isNotEmpty(classifyIds) && HussarUtils.isNotEmpty((Object)(apiClassifications = this.eaiApiClassificationService.listByIds(classifyIds = classifyIds.stream().distinct().collect(Collectors.toList()))))) {
            map = this.publishEaiApiClassification(apiClassifications, appVersion);
        }
        for (ApiInfo apiInfo : apiInfos) {
            Long versionId = EngineUtil.getId();
            EaiApiVersion eaiApiVersion = this.toEaiApiVersion(versionId, applicationCode, appVersion, apiInfo, idMappings);
            Long classificId = apiInfo.getClassificId();
            if (HussarUtils.isNotEmpty(map) && map.containsKey(classificId)) {
                eaiApiVersion.setClassificId((Long)map.get(classificId));
            }
            apiVersions.add(eaiApiVersion);
            apiIds.put(apiInfo.getId(), versionId);
            EaiResourcesInfo eaiResourcesInfo = this.toEaiResourcesInfo(applicationCode, appVersion, eaiApiVersion);
            eaiResourcesInfo.setResourceId(EngineUtil.getId());
            eaiResourcesInfos.add(eaiResourcesInfo);
        }
        this.eaiApiResourceService.saveResourceFromApi(apiInfos, applicationCode);
        if (HussarUtils.isNotEmpty(apiVersions)) {
            this.apiVersionService.saveBatch(apiVersions);
        }
        publishApiInfos.setApiIds(apiIds);
        publishApiInfos.setEaiResourcesInfos(eaiResourcesInfos);
        publishApiInfos.setApiVersions(apiVersions);
        return publishApiInfos;
    }

    public EaiPublishApiInfo getPublishApiInfos(String applicationCode) {
        String key = this.getCacheKey(applicationCode);
        Map<String, List<ApiInfo>> apiInfosMap = HussarCacheUtil.containKey((String)"eai_api_cache_key", (Object)key) ? (Map<String, List<ApiInfo>>)HussarCacheUtil.get((String)"eai_api_cache_key", (Object)key) : this.apiInfoList(applicationCode, true);
        List<ApiInfo> apiInfos = apiInfosMap.get("insert");
        List<ApiInfo> apiInfosUpdate = apiInfosMap.get("update");
        EaiPublishApiInfo eaiPublishApiInfos = new EaiPublishApiInfo();
        eaiPublishApiInfos.setApiInfos(apiInfos);
        eaiPublishApiInfos.setApiInfosUpdate(apiInfosUpdate);
        eaiPublishApiInfos.setKey(key);
        return eaiPublishApiInfos;
    }

    public Map<String, List<ApiInfo>> apiInfoList(String applicationCode, boolean isAudit) {
        List list;
        HashMap<String, List<ApiInfo>> map = new HashMap<String, List<ApiInfo>>();
        LambdaQueryWrapper apiWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)applicationCode)).ne(ApiInfo::getDraftState, (Object)"1")).eq(ApiInfo::getPublicState, (Object)"1");
        if (isAudit) {
            apiWrapper.eq(ApiInfo::getApplyState, (Object)"1");
        }
        long i = this.eaiApiInfoService.count((Wrapper)apiWrapper);
        map.put("insert", new ArrayList(0));
        if (i > 0L) {
            int initialCapacity = i > MAX_PAGE ? 5000 : 64;
            List apiInfos = new ArrayList(initialCapacity);
            if (i <= MAX_PAGE) {
                apiInfos = this.eaiApiInfoService.list((Wrapper)apiWrapper);
            } else {
                long k = i / MAX_PAGE;
                if (i % MAX_PAGE > 0L) {
                    ++k;
                }
                int j = 0;
                while ((long)j < k) {
                    IPage list2 = this.eaiApiInfoService.page((IPage)new Page((long)j * MAX_PAGE, MAX_PAGE.longValue()), (Wrapper)apiWrapper);
                    apiInfos.addAll(list2.getRecords());
                    ++j;
                }
            }
            map.put("insert", apiInfos);
        }
        LambdaQueryWrapper apiWrapper2 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)apiWrapper2.eq(ApiInfo::getApplicationCode, (Object)applicationCode)).eq(ApiInfo::getApiState, (Object)"1")).eq(ApiInfo::getPublicState, (Object)"0");
        if (isAudit) {
            apiWrapper2.eq(ApiInfo::getApplyState, (Object)"1");
        }
        if (HussarUtils.isNotEmpty((Object)(list = this.eaiApiInfoService.list((Wrapper)apiWrapper2)))) {
            map.put("update", list);
        }
        return map;
    }

    protected EaiApiVersion toEaiApiVersion(Long versionId, String applicationCode, String appVersion, ApiInfo apiInfo, Map<String, String> map) {
        EaiApiVersion eaiApiVersion = (EaiApiVersion)BeanUtil.copyProperties((Object)apiInfo, EaiApiVersion.class);
        eaiApiVersion.setApiVersionId(versionId);
        eaiApiVersion.setApiId(apiInfo.getId());
        eaiApiVersion.setApiVersion(appVersion);
        String path = apiInfo.getApiPath();
        if (!path.startsWith("/")) {
            path = String.format("/%s", path);
        }
        eaiApiVersion.setApiPath(path);
        eaiApiVersion.setApplicationCode(applicationCode);
        String inKey = this.getKeyIn(apiInfo.getId());
        String outKey = this.getKeyOut(apiInfo.getId());
        if (HussarUtils.isNotEmpty(map) && map.containsKey(inKey)) {
            eaiApiVersion.setInParams(map.get(inKey));
        } else {
            eaiApiVersion.setInParams(apiInfo.getInParams());
        }
        if (HussarUtils.isNotEmpty(map) && map.containsKey(outKey)) {
            eaiApiVersion.setOutParams(map.get(outKey));
        } else {
            eaiApiVersion.setOutParams(apiInfo.getOutParams());
        }
        eaiApiVersion.setContentType(HussarUtils.isEmpty((Object)apiInfo.getContentType()) ? EaiContentType.APPLICATION_JSON.getTypeStr() : apiInfo.getContentType());
        eaiApiVersion.setApiType(HussarUtils.isEmpty((Object)apiInfo.getApiType()) ? "0" : apiInfo.getApiType());
        return eaiApiVersion;
    }

    private String getKeyIn(Long id) {
        return String.format("%s_%s", id, "I");
    }

    private String getKeyOut(Long id) {
        return String.format("%s_%s", id, "O");
    }

    private Map<Long, Long> publishEaiApiClassification(List<EaiApiClassification> apiClassifications, String version) {
        HashMap<Long, Long> map = new HashMap<Long, Long>(apiClassifications.size());
        ArrayList<EaiApiClassificationVersion> list = new ArrayList<EaiApiClassificationVersion>();
        for (EaiApiClassification apiClassification : apiClassifications) {
            Long id = EngineUtil.getId();
            EaiApiClassificationVersion apiClassificationVersion = new EaiApiClassificationVersion();
            BeanUtil.copyProperties((Object)apiClassification, (Object)apiClassificationVersion);
            apiClassificationVersion.setClassificId(apiClassification.getId());
            apiClassificationVersion.setClassificVersion(version);
            apiClassificationVersion.setId(id);
            list.add(apiClassificationVersion);
            map.put(apiClassification.getId(), id);
        }
        this.eaiApiClassificationVersionService.saveBatch(list);
        return map;
    }

    private EaiResourcesInfo toEaiResourcesInfo(String applicationCode, String appVersion, EaiApiVersion eaiApiVersion) {
        EaiResourcesInfo eaiResourcesInfo = new EaiResourcesInfo();
        eaiResourcesInfo.setApplicationCode(applicationCode);
        eaiResourcesInfo.setApplicationVersion(appVersion);
        eaiResourcesInfo.setResourceCode(eaiApiVersion.getApiCode());
        eaiResourcesInfo.setResourceRelationId(eaiApiVersion.getApiId());
        eaiResourcesInfo.setResourceVersionId(eaiApiVersion.getApiVersionId());
        eaiResourcesInfo.setResourceName(eaiApiVersion.getApiName());
        eaiResourcesInfo.setResourceType("1");
        eaiResourcesInfo.setCreator(eaiApiVersion.getCreator());
        eaiResourcesInfo.setCreateTime(eaiApiVersion.getCreateTime());
        eaiResourcesInfo.setLastEditor(eaiApiVersion.getLastEditor());
        eaiResourcesInfo.setLastTime(eaiApiVersion.getLastTime());
        return eaiResourcesInfo;
    }
}

