/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiCallSpecificationInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishApiCallInfoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiPublishApiCallInfoServiceImpl")
public class EaiPublishApiCallInfoServiceImpl
implements EaiPublishApiCallInfoService {
    @Resource
    IApiCallSpecificationInfoService callSpecificationInfoService;

    public List<EaiApiVersion> saveBaseCallInfo(List<EaiApiVersion> apiVersions) {
        if (HussarUtils.isEmpty(apiVersions)) {
            return apiVersions;
        }
        List apiIds = apiVersions.stream().map(EaiApiVersion::getApiId).collect(Collectors.toList());
        List callInfos = this.callSpecificationInfoService.selectCallInfoListByApiIds(apiIds);
        Map<Long, List<ApiCallSpecificationInfo>> callInfosMap = callInfos.stream().collect(Collectors.groupingBy(ApiCallSpecificationInfo::getApiId));
        Map apiVersionMap = apiVersions.stream().collect(Collectors.toMap(EaiApiVersion::getApiId, Function.identity()));
        ArrayList infoAll = Lists.newArrayListWithCapacity((int)10);
        HashMap apiCallMap = new HashMap();
        for (Map.Entry<Long, List<ApiCallSpecificationInfo>> entry : callInfosMap.entrySet()) {
            List<ApiCallSpecificationInfo> infoDtosT = entry.getValue();
            infoDtosT.forEach(info -> {
                Long apiId = ((EaiApiVersion)apiVersionMap.get(entry.getKey())).getApiVersionId();
                info.setApiId(apiId);
                Long id = IdWorker.getId((Object)new ApiCallSpecificationInfo());
                apiCallMap.put(apiId, id);
                info.setSpecificatId(id);
            });
            infoAll.addAll(infoDtosT);
        }
        this.callSpecificationInfoService.saveBatch((Collection)infoAll);
        for (EaiApiVersion apiVersion : apiVersions) {
            apiVersion.setClassificId((Long)apiCallMap.get(apiVersion.getApiVersionId()));
        }
        return apiVersions;
    }
}

