/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiChangeApiStateService;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishApiInfoService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiChangeApiStateServiceImpl")
public class EaiChangeApiStateServiceImpl
implements EaiChangeApiStateService {
    @Resource
    EaiPublishApiInfoService eaiPublishApiInfoService;
    @Resource
    IEaiApiInfoService eaiApiInfoService;

    public void locked(List<Long> allIds, List<Long> eventIds, String applicationCode) {
        this.changeState(allIds, eventIds, applicationCode, true);
    }

    public void unlocked(List<Long> apiIds, List<Long> eventIds, String applicationCode) {
        this.changeState(apiIds, eventIds, applicationCode, false);
    }

    public void changeState(List<Long> apiIds, List<Long> eventIds, String applicationCode, Boolean locked) {
        String apiState = "0";
        if (Boolean.TRUE.equals(locked)) {
            apiState = "1";
        }
        if (HussarUtils.isNotEmpty(apiIds)) {
            this.changeApiState(apiState, apiIds, applicationCode);
        } else if (HussarUtils.isNotEmpty((Object)applicationCode)) {
            this.changeAppState(apiState, applicationCode, locked);
        }
    }

    private void changeAppState(String apiState, String applicationCode, boolean locked) {
        List apiInfos;
        ArrayList<Long> apiIds = new ArrayList<Long>();
        StringBuilder sb = new StringBuilder(24);
        sb.append("eai_api_cache_key").append(":").append(applicationCode);
        String key = sb.toString();
        Map apiInfosMap = HussarCacheUtil.containKey((String)"eai_api_cache_key", (Object)key) ? (Map)HussarCacheUtil.get((String)"eai_api_cache_key", (Object)key) : this.eaiPublishApiInfoService.apiInfoList(applicationCode, !locked);
        if (HussarUtils.isNotEmpty(apiInfosMap.get("insert")) && HussarUtils.isNotEmpty((Object)(apiInfos = (List)apiInfosMap.get("insert")))) {
            apiIds.addAll(apiInfos.stream().map(ApiInfo::getId).collect(Collectors.toList()));
        }
        if (HussarUtils.isNotEmpty(apiInfosMap.get("update")) && HussarUtils.isNotEmpty((Object)(apiInfos = (List)apiInfosMap.get("update")))) {
            apiIds.addAll(apiInfos.stream().map(ApiInfo::getId).collect(Collectors.toList()));
        }
        if (HussarUtils.isNotEmpty(apiIds)) {
            this.changeApiState(apiState, apiIds, applicationCode);
        } else if (!locked && HussarUtils.isNotEmpty((Object)applicationCode)) {
            LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(ApiInfo::getApplyState, (Object)apiState)).eq(ApiInfo::getApplicationCode, (Object)applicationCode);
            this.eaiApiInfoService.update((Wrapper)updateWrapper);
        }
    }

    private void changeApiState(String apiState, List<Long> apiIds, String applicationCode) {
        LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(ApiInfo::getApplyState, (Object)apiState)).in(ApiInfo::getId, apiIds);
        this.eaiApiInfoService.update((Wrapper)updateWrapper);
        StringBuilder sb = new StringBuilder(24);
        sb.append("eai_api_cache_key").append(":").append(applicationCode);
        String key = sb.toString();
        HussarCacheUtil.evict((String)"eai_api_cache_key", (Object)key);
    }
}

