/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.authorization.permit.model.SysResources;
import com.jxdinfo.hussar.authorization.permit.service.ISysResourcesService;
import com.jxdinfo.hussar.common.utils.LambdaQueryUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.IEaiApiResourceService;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl.EaiApiResourceServiceImpl")
public class EaiApiResourceServiceImpl
implements IEaiApiResourceService {
    @Resource
    protected ISysResourcesService sysResourcesService;
    @Resource
    protected ISysApplicationService applicationService;

    public void saveResourceFromApi(List<ApiInfo> apiInfos, String applicationCode) {
        List<SysResources> addList;
        ArrayList<SysResources> sysResourcesList = new ArrayList<SysResources>(apiInfos.size());
        SysApplication sysApplication = (SysApplication)this.applicationService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)applicationCode));
        ArrayList<String> urlList = new ArrayList<String>();
        apiInfos.forEach(apiInfo -> {
            String path = apiInfo.getApiPath();
            if (!path.startsWith("/")) {
                path = String.format("/%s", path);
            }
            sysResourcesList.add(this.toSysResource((ApiInfo)apiInfo, path, sysApplication.getId()));
            urlList.add(path);
        });
        if (HussarUtils.isNotEmpty(sysResourcesList) && HussarUtils.isNotEmpty(addList = this.getAddResourcesList(sysResourcesList, urlList))) {
            this.sysResourcesService.saveBatch(addList);
        }
    }

    protected List<SysResources> getAddResourcesList(List<SysResources> sysResourcesList, List<String> urlList) {
        if (ToolUtil.isEmpty(urlList)) {
            return sysResourcesList;
        }
        List currentResourceList = this.sysResourcesService.list((Wrapper)LambdaQueryUtil.getMultiQueryWrapper(SysResources::getUrlNames, urlList));
        ArrayList<SysResources> addList = new ArrayList<SysResources>();
        for (SysResources resources : sysResourcesList) {
            boolean addFlag = true;
            String url = resources.getUrlNames();
            if (ToolUtil.isNotEmpty((Object)url)) {
                for (SysResources currentResource : currentResourceList) {
                    if (!url.equals(currentResource.getUrlNames())) continue;
                    addFlag = false;
                    break;
                }
            }
            if (!addFlag) continue;
            addList.add(resources);
        }
        return addList;
    }

    protected SysResources toSysResource(ApiInfo apiInfo, String path, Long appId) {
        SysResources sysResources = new SysResources();
        sysResources.setModuleId(Long.valueOf(1L));
        sysResources.setResourceName(apiInfo.getApiName());
        sysResources.setDeptRight("data_organ");
        sysResources.setIsAudit("0");
        sysResources.setIsRepeatAuthenticate("0");
        sysResources.setKeepAlive("0");
        sysResources.setResTypeId("res_open_interface");
        sysResources.setResourceAlias(apiInfo.getApiName());
        sysResources.setResourceCode("0");
        sysResources.setStrategy("0");
        sysResources.setUrlNames(path);
        sysResources.setUserRight("data_holder");
        sysResources.setApplicationId(appId);
        return sysResources;
    }
}

