/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.publish.service.impl;

import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.CommonResourcesIdMap;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.EaiPublishBaseResources;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.CommonResourcesIdMapService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.Map;
import java.util.stream.Collectors;

public class CommonResourcesIdMapServiceImpl<T extends EaiPublishBaseResources>
implements CommonResourcesIdMapService<T> {
    public void toCommonResourcesIdMap(T source, CommonResourcesIdMap target) {
        if (HussarUtils.isNotEmpty(source)) {
            if (HussarUtils.isNotEmpty((Object)source.getInsertStructures())) {
                Map<Long, Long> structureMap = source.getInsertStructures().stream().collect(Collectors.toMap(StructureVersion::getStructureId, StructureVersion::getId));
                if (HussarUtils.isNotEmpty((Object)target.getStructureMap())) {
                    target.getStructureMap().putAll(structureMap);
                } else {
                    target.setStructureMap(structureMap);
                }
            }
            if (HussarUtils.isNotEmpty((Object)source.getInsertConstants())) {
                Map<Long, Long> constantMap = source.getInsertConstants().stream().collect(Collectors.toMap(ConstantVersion::getConstantId, ConstantVersion::getId));
                if (HussarUtils.isNotEmpty((Object)target.getConstantMap())) {
                    target.getConstantMap().putAll(constantMap);
                } else {
                    target.setConstantMap(constantMap);
                }
            }
        }
    }
}

