/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.open.service.impl;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonStructureVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.StructureItemsVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.StructureVersionVo;
import com.jxdinfo.hussar.eai.atomicbase.api.commonstructure.vo.StructurePullDownItems;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonStructureService;
import com.jxdinfo.hussar.eai.atomicbase.api.open.service.EaiStructureVersionService;
import com.jxdinfo.hussar.eai.atomicbase.server.open.dao.EaiPublishStructureVersionMapper;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.StructureVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IStructureVersionService;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.open.service.impl.EaiStructureVersionServiceImpl")
public class EaiStructureVersionServiceImpl
implements EaiStructureVersionService {
    @Resource
    EaiPublishStructureVersionMapper eaiPublishStructureVersionMapper;
    @Resource
    private EaiCommonStructureService commonStructureService;
    @Resource
    private IStructureVersionService structureVersionService;

    public List<StructurePullDownItems> listByAppCodeAndVersion(String applicationCode, String appVersion) {
        return this.eaiPublishStructureVersionMapper.listByAppCodeAndVersion(applicationCode, appVersion);
    }

    public List<CommonStructureVo> selectAllReleasedStructures() {
        return this.eaiPublishStructureVersionMapper.selectAllReleasedStructures();
    }

    public StructureVersionVo getStructureVersionDetailById(String id) {
        StructureVersionVo vo = new StructureVersionVo();
        StructureVersion structureVersion = (StructureVersion)this.structureVersionService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)structureVersion)) {
            return vo;
        }
        BeanUtil.copyProperties((Object)structureVersion, (Object)vo, (String[])new String[]{"structureValues"});
        if (HussarUtils.isBlank((CharSequence)structureVersion.getStructureValues())) {
            return vo;
        }
        List value = this.commonStructureService.strToItemsList(structureVersion.getStructureValues(), structureVersion.getId().toString());
        ArrayList<String> preValues = new ArrayList<String>();
        HashMap<String, StructureVersion> map = new HashMap<String, StructureVersion>();
        this.fillStructureItems(value, map, preValues);
        vo.setStructureValueList(value);
        return vo;
    }

    public void fillStructureItems(List<StructureItemsVo> list, Map<String, StructureVersion> map, List<String> preValues) {
        String structureId = "";
        if (HussarUtils.isEmpty(list)) {
            return;
        }
        for (StructureItemsVo item : list) {
            if (HussarUtils.isNotEmpty((Object)item.getNowStructureId())) {
                preValues.add(item.getNowStructureId());
            }
            item.setValue(ToolUtil.isNotEmpty((Object)item.getType()) ? item.getType().toString() : null);
            if (HussarUtils.isNotBlank((CharSequence)item.getQuoteStructureId())) {
                StructureVersion valueStrVo = null;
                String id = item.getQuoteStructureId();
                if (map.containsKey(id)) {
                    valueStrVo = map.get(id);
                } else {
                    valueStrVo = (StructureVersion)this.structureVersionService.getById((Serializable)Long.valueOf(id));
                    map.put(id, valueStrVo);
                }
                if (HussarUtils.isEmpty((Object)valueStrVo)) {
                    CommonStructureVo structure = this.commonStructureService.getById(id);
                    if (HussarUtils.isEmpty((Object)structure)) continue;
                    valueStrVo = new StructureVersion();
                    BeanUtil.copyProperties((Object)structure, (Object)valueStrVo);
                }
                item.setValue(valueStrVo.getStructureCode());
                item.setQuoteName(valueStrVo.getStructureName());
                structureId = item.getQuoteStructureId();
                if (preValues.contains(structureId)) continue;
                preValues.add(structureId);
                List value = this.commonStructureService.strToItemsList(valueStrVo.getStructureValues(), String.valueOf(valueStrVo.getId()));
                if (HussarUtils.isNotEmpty((Object)item.getItems())) {
                    item.getItems().addAll(value);
                } else {
                    item.setItems(value);
                }
                this.fillStructureItems(item.getItems(), map, preValues);
            }
            if (HussarUtils.isBlank((CharSequence)item.getQuoteStructureId()) && HussarUtils.isNotEmpty((Object)item.getItems())) {
                this.fillStructureItems(item.getItems(), map, preValues);
            }
            if (!HussarUtils.isNotEmpty(preValues) || !HussarUtils.isNotEmpty((Object)structureId)) continue;
            String finalStructureId = structureId;
            preValues = preValues.stream().filter(f -> !f.equals(finalStructureId)).collect(Collectors.toList());
        }
    }
}

