/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.info.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.ApiTestDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.configuration.service.IEaiConfigurationBuildService;
import com.jxdinfo.hussar.eai.atomicbase.api.info.dto.ApiVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.ApiVerifyFactoryService;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiVerifyService;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.LogicVerifyFactoryService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.util.JsonParseToStringUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="com.jxdinfo.hussar.eai.adapter.apiinfo.server.service.impl.EaiVerifyServiceImpl")
public class EaiVerifyServiceImpl<T extends ApiVerifyDto>
implements EaiVerifyService<T> {
    private static final String PLACEHOLDER_PARAMETER = "#metadata";
    @Resource
    private ApiVerifyFactoryService apiVerifyFactoryService;
    @Resource
    private LogicVerifyFactoryService logicVerifyFactoryService;
    @Resource
    EaiApiProperties eaiApiProperties;
    @Resource
    private IEaiConfigurationBuildService eaiConfigurationBuildService;

    public ApiResponse verifyApi(T apiVerifyDto) {
        if (HussarUtils.isEmpty((Object)apiVerifyDto.getApiPattern())) {
            apiVerifyDto.setApiPattern(String.valueOf(this.eaiApiProperties.getLogicType()));
        }
        if (HussarUtils.isEmpty((Object)apiVerifyDto.getApiType())) {
            apiVerifyDto.setApiType("0");
        }
        this.eaiConfigurationBuildService.debugJsonConfiguration(apiVerifyDto.getApplicationCode());
        if (StringUtil.isNotEmpty((Object)apiVerifyDto.getApiId()) && (HussarUtils.isEmpty((Object)apiVerifyDto.getApiPattern()) || "0".equals(apiVerifyDto.getApiPattern()))) {
            return this.apiVerifyFactoryService.verifySavedApi(apiVerifyDto);
        }
        if (HussarUtils.isEmpty((Object)apiVerifyDto.getApiPattern()) || "0".equals(apiVerifyDto.getApiPattern())) {
            return this.apiVerifyFactoryService.verifyApi(apiVerifyDto);
        }
        if ("1".equals(apiVerifyDto.getApiPattern())) {
            return this.logicVerifyFactoryService.verifyApi(apiVerifyDto);
        }
        throw new BaseException(String.format("can not find the ApiPattern:[%s]", apiVerifyDto.getApiPattern()));
    }

    public void bodyMergeFile(ApiTestDto apiTestDto, MultipartHttpServletRequest request) {
        Map body = (Map)apiTestDto.getBody();
        if (HussarUtils.isNotEmpty((Object)apiTestDto.getInParams()) && CollectionUtil.isNotEmpty((Collection)apiTestDto.getInParams().getBody())) {
            this.getFileForBody(body, apiTestDto.getInParams().getBody(), request);
        }
        apiTestDto.setBody((Object)body);
    }

    public void getFileForBody(Map<String, Object> body, List<EaiParamsItems> bodyItems, MultipartHttpServletRequest request) {
        HashMap formFile = Maps.newHashMapWithExpectedSize((int)5);
        for (String name : Collections.list(request.getParameterNames())) {
            if (PLACEHOLDER_PARAMETER.equals(name)) continue;
            formFile.put(name, request.getParameter(name));
        }
        HashMap fileItemMap = Maps.newHashMapWithExpectedSize((int)5);
        for (EaiParamsItems items : bodyItems) {
            if (EaiDataType.DATA_TYPE_MULTIPARTFILE.getType() == items.getType().intValue()) {
                fileItemMap.put(items.getMappingName(), items);
                continue;
            }
            if (!HussarUtils.isNotEmpty((Object)items.getItemType()) || EaiDataType.DATA_TYPE_LIST.getType() != items.getType().intValue() || EaiDataType.DATA_TYPE_MULTIPARTFILE.getType() != items.getItemType().intValue()) continue;
            fileItemMap.put(items.getMappingName(), items);
        }
        for (Map.Entry file : request.getMultiFileMap().entrySet()) {
            String name = (String)file.getKey();
            if (PLACEHOLDER_PARAMETER.equals(name)) continue;
            List list = (List)file.getValue();
            EaiParamsItems itemsCurrent = (EaiParamsItems)fileItemMap.get(name);
            if (EaiDataType.DATA_TYPE_MULTIPARTFILE.getType() == itemsCurrent.getType().intValue()) {
                formFile.put(name, list.get(0));
                continue;
            }
            if (EaiDataType.DATA_TYPE_LIST.getType() != itemsCurrent.getType().intValue() || EaiDataType.DATA_TYPE_MULTIPARTFILE.getType() != itemsCurrent.getItemType().intValue()) continue;
            formFile.put(name, list);
        }
        if (HussarUtils.isNotEmpty((Object)formFile)) {
            body.putAll(formFile);
        }
    }

    public ApiResponse<EaiApiResponseVo> getFileBaseInfoByBodyFile(ApiResponse<EaiApiResponseVo> response) {
        if (HussarUtils.isNotEmpty((Object)response.getData()) && HussarUtils.isNotEmpty((Object)((EaiApiResponseVo)response.getData()).getOuturlRequestParams())) {
            Map outurlRequestParams = ((EaiApiResponseVo)response.getData()).getOuturlRequestParams();
            outurlRequestParams = (Map)JsonParseToStringUtil.INSTANCE.toObject((Object)outurlRequestParams);
            ((EaiApiResponseVo)response.getData()).setOuturlRequestParams(outurlRequestParams);
        }
        return response;
    }

    private List<byte[]> getByteList(List<MultipartFile> list) {
        ArrayList bytes = Lists.newArrayListWithCapacity((int)5);
        list.forEach(file -> bytes.add(this.convertByte((MultipartFile)file)));
        return bytes;
    }

    private byte[] convertByte(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        if (HussarUtils.isEmpty((Object)fileName)) {
            throw new BaseException("\u4e0a\u4f20\u6587\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        byte[] fileBytes = null;
        try {
            fileBytes = file.getBytes();
        }
        catch (IOException e) {
            throw new BaseException("\u6587\u4ef6\u5b57\u8282\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return fileBytes;
    }
}

