/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.info.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.appinfo.api.vo.ApplicationManageVo;
import com.jxdinfo.hussar.eai.appinfo.server.common.EaiAppEditManager;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddCommonStructureDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.StructureImportDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonStructureVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.StructureItemsVo;
import com.jxdinfo.hussar.eai.atomicbase.api.commonstructure.dto.CheckStructureCodeDto;
import com.jxdinfo.hussar.eai.atomicbase.api.commonstructure.dto.QueryCommonStructureDto;
import com.jxdinfo.hussar.eai.atomicbase.api.commonstructure.vo.StructurePullDownItems;
import com.jxdinfo.hussar.eai.atomicbase.api.commonstructure.vo.StructurePullDownVo;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonStructureService;
import com.jxdinfo.hussar.eai.atomicbase.api.open.service.EaiStructureVersionService;
import com.jxdinfo.hussar.eai.atomicbase.api.resourcerelation.service.EaiAppStatusBaseService;
import com.jxdinfo.hussar.eai.atomicbase.api.resourcerelation.service.EaiResourceRelationBaseService;
import com.jxdinfo.hussar.eai.atomicbase.server.info.dao.EaiCommonStructureMapper;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.entity.HussarEaiBaseEntity;
import com.jxdinfo.hussar.eai.common.enums.api.EaiCategoryEnum;
import com.jxdinfo.hussar.eai.common.util.StructureItems;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.info.service.impl.EaiCommonStructureImpl")
public class EaiCommonStructureImpl
implements EaiCommonStructureService {
    @Resource
    private EaiCommonStructureMapper structureMapper;
    @Resource
    private IApplicationManagementService iApplicationManagementService;
    @Resource
    private ICommonStructureService commonStructureService;
    @Resource
    private EaiAppStatusBaseService eaiAppStatusService;
    @Resource
    EaiResourceRelationBaseService eaiResourceRelationBaseService;
    @Resource
    private EaiStructureVersionService iEaiStructureVersionService;

    public Long saveStructure(AddCommonStructureDto addCommonStructureDto) {
        AssertUtil.isNotNull((Object)addCommonStructureDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)addCommonStructureDto.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAppStatus(addCommonStructureDto.getApplicationCode());
        CheckStructureCodeDto checkStructureCodeDto = new CheckStructureCodeDto();
        BeanUtil.copyProperties((Object)addCommonStructureDto, (Object)checkStructureCodeDto);
        if (ToolUtil.isNotEmpty((Object)addCommonStructureDto.getName())) {
            addCommonStructureDto.setStructureCode(addCommonStructureDto.getName());
        }
        if (ToolUtil.isNotEmpty((Object)addCommonStructureDto.getDesc())) {
            addCommonStructureDto.setStructureName(addCommonStructureDto.getDesc());
        }
        if (!this.checkStructureCode(checkStructureCodeDto).booleanValue()) {
            throw new HussarException("\u7ed3\u6784\u6807\u8bc6\u4e0d\u552f\u4e00");
        }
        EaiAppEditManager.getInstance().call(addCommonStructureDto.getApplicationCode());
        Long structureId = this.fillStructure(addCommonStructureDto);
        addCommonStructureDto.setId(String.valueOf(structureId));
        return structureId;
    }

    @HussarTransactional
    public Boolean saveBatchStructure(List<AddCommonStructureDto> list) {
        AssertUtil.isNotEmpty(list, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAppStatus(list.get(0).getApplicationCode());
        List<CommonStructure> commonStructures = this.fillStructureList(list);
        List ids = commonStructures.stream().map(CommonStructure::getId).collect(Collectors.toList());
        this.eaiAppStatusService.resetStructStatus(list.get(0).getApplicationCode(), ids);
        List appCodes = list.stream().map(HussarEaiBaseEntity::getApplicationCode).collect(Collectors.toList());
        List disappCodes = appCodes.stream().distinct().collect(Collectors.toList());
        EaiAppEditManager.getInstance().call(disappCodes);
        return this.commonStructureService.saveOrUpdateBatch(commonStructures);
    }

    public Boolean updateStructure(CommonStructure commonStructure) {
        AssertUtil.isNotNull((Object)commonStructure, (String)"\u6570\u636e\u7ed3\u6784\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)commonStructure.getId(), (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        if (ToolUtil.isNotEmpty((Object)commonStructure.getName())) {
            commonStructure.setStructureCode(commonStructure.getName());
        }
        if (ToolUtil.isNotEmpty((Object)commonStructure.getDesc())) {
            commonStructure.setStructureName(commonStructure.getDesc());
        }
        this.eaiAppStatusService.resetStructStatus(commonStructure.getApplicationCode(), commonStructure.getId());
        EaiAppEditManager.getInstance().call(commonStructure.getApplicationCode());
        return this.commonStructureService.updateById((Object)commonStructure);
    }

    public List<CommonStructureVo> saveBatchJsonStructure(List<AddCommonStructureDto> list) {
        AssertUtil.isNotEmpty(list, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        this.checkAppStatus(list.get(0).getApplicationCode());
        ArrayList<CommonStructure> commonStructures = new ArrayList<CommonStructure>();
        ArrayList<CommonStructureVo> result = new ArrayList<CommonStructureVo>();
        String userName = "";
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            userName = userDetails.getUserName();
        }
        for (AddCommonStructureDto dto : list) {
            CommonStructure commonStructure = new CommonStructure();
            CommonStructureVo vo = new CommonStructureVo();
            this.fill(commonStructure, dto);
            long thisId = IdWorker.getId((Object)commonStructure);
            commonStructure.setStructureCode(dto.getStructureCode() + Long.toString(thisId).substring(Long.toString(thisId).length() - 4));
            commonStructure.setCreateBy(userName);
            commonStructure.setId(Long.valueOf(thisId));
            commonStructures.add(commonStructure);
            dto.setId(String.valueOf(thisId));
            BeanUtil.copyProperties((Object)commonStructure, (Object)vo, (String[])new String[]{"structureValues"});
            result.add(vo);
        }
        this.commonStructureService.saveBatch(commonStructures);
        EaiAppEditManager.getInstance().call(((CommonStructure)commonStructures.get(0)).getApplicationCode());
        return result;
    }

    public Boolean checkDelete(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        CommonStructure commonStructure = (CommonStructure)this.commonStructureService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)commonStructure)) {
            throw new HussarException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u6216\u68c0\u67e5\u6743\u9650\u540e\u91cd\u8bd5");
        }
        this.checkAppStatus(commonStructure.getApplicationCode());
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(commonStructure.getId());
        List resourcesRelation = this.eaiResourceRelationBaseService.resourcesStructStatus(commonStructure.getApplicationCode(), ids);
        if (HussarUtils.isNotEmpty((Object)resourcesRelation)) {
            throw new HussarException("\u5220\u9664\u5931\u8d25\uff01\u6570\u636e\u7ed3\u6784\u201c" + commonStructure.getStructureName() + "\u201d\u5df2\u88ab\u5176\u4ed6\u8d44\u6e90\u4f7f\u7528\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u5f71\u54cd\u5206\u6790");
        }
        EaiAppEditManager.getInstance().call(commonStructure.getApplicationCode());
        return true;
    }

    @HussarTransactional
    public Boolean deleteById(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        CommonStructure commonStructure = (CommonStructure)this.commonStructureService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)commonStructure)) {
            throw new HussarException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u6216\u68c0\u67e5\u6743\u9650\u540e\u91cd\u8bd5");
        }
        this.eaiAppStatusService.resetStructStatus(commonStructure.getApplicationCode(), Long.valueOf(Long.parseLong(id)));
        EaiAppEditManager.getInstance().call(commonStructure.getApplicationCode());
        return this.commonStructureService.removeById((Serializable)((Object)id));
    }

    public CommonStructureVo getById(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        CommonStructure commonStructure = (CommonStructure)this.commonStructureService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)commonStructure)) {
            return new CommonStructureVo();
        }
        CommonStructureVo vo = new CommonStructureVo();
        BeanUtil.copyProperties((Object)commonStructure, (Object)vo, (String[])new String[]{"structureValues"});
        if (HussarUtils.isBlank((CharSequence)commonStructure.getStructureValues())) {
            return vo;
        }
        List<StructureItemsVo> value = this.strToItemsList(commonStructure.getStructureValues(), commonStructure.getId().toString());
        ArrayList<String> preValues = new ArrayList<String>();
        HashMap<String, CommonStructure> map = new HashMap<String, CommonStructure>();
        this.fillStructureItems(value, map, preValues);
        vo.setStructureValues(value);
        return vo;
    }

    public CommonStructureVo getByCommonStructureId(String id) {
        CommonStructure commonStructure = (CommonStructure)this.commonStructureService.getById((Serializable)((Object)id));
        CommonStructureVo vo = new CommonStructureVo();
        BeanUtil.copyProperties((Object)commonStructure, (Object)vo, (String[])new String[]{"structureValues"});
        if (HussarUtils.isNotEmpty((Object)commonStructure.getStructureValues())) {
            JSONArray array = JSON.parseArray((String)commonStructure.getStructureValues());
            ArrayList value = new ArrayList();
            array.forEach(arr -> {
                StructureItemsVo items = (StructureItemsVo)JSON.parseObject((String)JSONObject.toJSONString((Object)arr), StructureItemsVo.class);
                value.add(items);
            });
            vo.setStructureValues(value);
        }
        return vo;
    }

    public List<CommonStructureVo> listByAppCode(QueryCommonStructureDto queryCommonStructureDto) {
        return this.structureMapper.listByAppCode(queryCommonStructureDto);
    }

    public Boolean checkStructureCode(CheckStructureCodeDto checkStructureCodeDto) {
        AssertUtil.isNotNull((Object)checkStructureCodeDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)checkStructureCodeDto.getStructureCode(), (String)"\u6570\u636e\u7ed3\u6784\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)checkStructureCodeDto.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        return this.structureMapper.countByStructureCode(checkStructureCodeDto) == 0;
    }

    public StructurePullDownVo getBaseAndStructure(String applicationCode) {
        StructurePullDownVo result = new StructurePullDownVo();
        this.fillBaseDataStructure(result);
        this.fillExtendDataStructure(result);
        ArrayList<String> applicationCodes = new ArrayList<String>();
        applicationCodes.add(applicationCode);
        List<StructurePullDownItems> commonStructureList = this.structureMapper.listByApplicationCodes(applicationCodes);
        if (HussarUtils.isEmpty(commonStructureList)) {
            return result;
        }
        HashMap<String, StructurePullDownItems> map = new HashMap();
        if (HussarUtils.isNotEmpty(commonStructureList)) {
            map = commonStructureList.stream().collect(Collectors.toMap(StructurePullDownItems::getId, Function.identity()));
        }
        for (StructurePullDownItems vo : commonStructureList) {
            vo.setType(EaiDataType.DATA_TYPE_STRUCTURE.getTypeStr());
            vo.setValue(vo.getStructureCode());
            if (HussarUtils.isBlank((CharSequence)vo.getStructureValuesStr())) continue;
            List<StructureItemsVo> structureItems = this.strToItemsList(vo.getStructureValuesStr(), vo.getId());
            ArrayList<String> preValues = new ArrayList<String>();
            this.fillItems(structureItems, map, preValues);
            vo.setStructureValues(structureItems);
        }
        result.setStructure(commonStructureList);
        return result;
    }

    @HussarTransactional
    public Map<String, StructureImportDto> addNewStructure(JSONObject definitions, String appCode) {
        Map paramMap = (Map)JSONObject.toJavaObject((JSON)definitions, Map.class);
        ArrayList<CommonStructure> list = new ArrayList<CommonStructure>();
        this.fillJsonBaseInfo(paramMap, list, appCode);
        if (HussarUtils.isEmpty(list)) {
            return null;
        }
        ArrayList<StructureImportDto> structureImportList = new ArrayList<StructureImportDto>();
        this.fillJsonParamInfo(list, structureImportList, appCode);
        this.commonStructureService.saveBatch(list);
        return structureImportList.stream().collect(Collectors.toMap(StructureImportDto::getOriginStructureCode, Function.identity(), (k1, k2) -> k1));
    }

    private Long fillStructure(AddCommonStructureDto addCommonStructureDto) {
        CommonStructure commonStructure = new CommonStructure();
        if (ToolUtil.isNotEmpty((Object)addCommonStructureDto.getId())) {
            commonStructure.setId(Long.valueOf(addCommonStructureDto.getId()));
        }
        this.fill(commonStructure, addCommonStructureDto);
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            commonStructure.setCreateBy(userDetails.getUserName());
        }
        this.commonStructureService.saveOrUpdate((Object)commonStructure);
        return commonStructure.getId();
    }

    private List<CommonStructure> fillStructureList(List<AddCommonStructureDto> list) {
        ArrayList<CommonStructure> commonStructures = new ArrayList<CommonStructure>();
        String userName = "";
        UserDetails userDetails = HussarSecurityUtils.getLoginUserDetails();
        if (HussarUtils.isNotEmpty((Object)userDetails)) {
            userName = userDetails.getUserName();
        }
        for (AddCommonStructureDto dto : list) {
            CommonStructure commonStructure = new CommonStructure();
            this.fill(commonStructure, dto);
            if (HussarUtils.isNotBlank((CharSequence)dto.getId())) {
                commonStructure.setId(Long.valueOf(Long.parseLong(dto.getId())));
                commonStructure.setEditBy(userName);
            } else {
                Long id = IdWorker.getId((Object)commonStructure);
                commonStructure.setId(id);
                dto.setId(String.valueOf(id));
            }
            commonStructure.setCreateBy(userName);
            commonStructures.add(commonStructure);
        }
        return commonStructures;
    }

    private void fill(CommonStructure commonStructure, AddCommonStructureDto addCommonStructureDto) {
        commonStructure.setParamsType(EaiDataType.DATA_TYPE_STRUCTURE.getTypeStr());
        commonStructure.setApplicationCode(addCommonStructureDto.getApplicationCode());
        commonStructure.setStructureName(addCommonStructureDto.getStructureName());
        commonStructure.setStructureCode(addCommonStructureDto.getStructureCode());
        if (HussarUtils.isNotEmpty((Object)addCommonStructureDto.getStructureValues())) {
            this.resetItemsInQuoteStructureId(addCommonStructureDto.getStructureValues());
            this.fillNickName(addCommonStructureDto.getStructureValues());
            commonStructure.setStructureValues(EaiCommonStructureImpl.toJSONString(addCommonStructureDto.getStructureValues()));
        } else {
            commonStructure.setStructureValues("");
        }
        if (ToolUtil.isNotEmpty((Object)addCommonStructureDto.getName())) {
            commonStructure.setStructureCode(addCommonStructureDto.getName());
        }
        if (ToolUtil.isNotEmpty((Object)addCommonStructureDto.getDesc())) {
            commonStructure.setStructureName(addCommonStructureDto.getDesc());
        }
        commonStructure.setRemark(addCommonStructureDto.getRemark());
        commonStructure.setStructureClassify(EaiCategoryEnum.OPEN.getCode());
    }

    public static String toJSONString(Object t) {
        return JSONObject.toJSONString((Object)JSON.toJSON((Object)t));
    }

    public void fillStructureItems(List<StructureItemsVo> list, Map<String, CommonStructure> map, List<String> preValues) {
        if (HussarUtils.isEmpty(list)) {
            return;
        }
        for (StructureItemsVo item : list) {
            if (this.isNotStructureType(item.getType())) {
                item.setValue(String.valueOf(item.getType()));
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)item.getNowStructureId())) {
                preValues.add(item.getNowStructureId());
            }
            item.setValue(ToolUtil.isNotEmpty((Object)item.getType()) ? item.getType().toString() : null);
            if (HussarUtils.isNotBlank((CharSequence)item.getQuoteStructureId())) {
                CommonStructure valueStrVo = null;
                String id = item.getQuoteStructureId();
                if (map.containsKey(id)) {
                    valueStrVo = map.get(id);
                } else {
                    valueStrVo = (CommonStructure)this.commonStructureService.getById((Serializable)Long.valueOf(id));
                    map.put(id, valueStrVo);
                }
                if (HussarUtils.isEmpty((Object)valueStrVo)) continue;
                item.setValue(valueStrVo.getStructureCode());
                item.setQuoteName(valueStrVo.getStructureName());
                String structureId = item.getQuoteStructureId();
                if (preValues.contains(structureId)) continue;
                preValues.add(structureId);
                List<StructureItemsVo> value = this.strToItemsList(valueStrVo.getStructureValues(), String.valueOf(valueStrVo.getId()));
                item.setItems(this.valueItems(item, value));
                this.fillStructureItems(item.getItems(), map, preValues);
            }
            if (!HussarUtils.isBlank((CharSequence)item.getQuoteStructureId()) || !HussarUtils.isNotEmpty((Object)item.getItems())) continue;
            this.fillStructureItems(item.getItems(), map, preValues);
        }
    }

    public void fillItems(List<StructureItemsVo> list, Map<String, StructurePullDownItems> map, List<String> preValues) {
        if (HussarUtils.isEmpty(list)) {
            return;
        }
        for (StructureItemsVo item : list) {
            if (this.isNotStructureType(item.getType())) {
                item.setValue(String.valueOf(item.getType()));
                continue;
            }
            if (HussarUtils.isNotEmpty((Object)item.getNowStructureId())) {
                preValues.add(item.getNowStructureId());
            }
            item.setValue(ToolUtil.isNotEmpty((Object)item.getType()) ? item.getType().toString() : null);
            if (HussarUtils.isNotBlank((CharSequence)item.getQuoteStructureId())) {
                StructurePullDownItems valueStrVo = null;
                String id = item.getQuoteStructureId();
                if (!map.containsKey(id)) continue;
                valueStrVo = map.get(id);
                item.setValue(valueStrVo.getStructureCode());
                item.setQuoteName(valueStrVo.getStructureName());
                String structureId = item.getQuoteStructureId();
                if (preValues.contains(structureId)) continue;
                preValues.add(structureId);
                List<StructureItemsVo> value = this.strToItemsList(valueStrVo.getStructureValuesStr(), String.valueOf(valueStrVo.getId()));
                if (HussarUtils.isNotEmpty(value)) {
                    item.setItems(this.valueItems(item, value));
                }
                this.fillItems(item.getItems(), map, preValues);
            }
            if (!HussarUtils.isBlank((CharSequence)item.getQuoteStructureId()) || !HussarUtils.isNotEmpty((Object)item.getItems())) continue;
            this.fillItems(item.getItems(), map, preValues);
        }
    }

    private List<StructureItemsVo> valueItems(StructureItemsVo item, List<StructureItemsVo> value) {
        if (HussarUtils.isNotEmpty(value)) {
            if (HussarUtils.isNotEmpty((Object)item.getItems())) {
                List structureItemsVos = item.getItems();
                ArrayList<StructureItemsVo> itemsVos = new ArrayList<StructureItemsVo>(structureItemsVos.size());
                for (StructureItemsVo structureItemsVo : structureItemsVos) {
                    if (structureItemsVo == null) continue;
                    for (StructureItemsVo v : value) {
                        if (!structureItemsVo.getName().equals(v.getName())) continue;
                        itemsVos.add(v);
                    }
                }
                if (!itemsVos.isEmpty()) {
                    value.removeAll(itemsVos);
                }
            }
            return value;
        }
        return Collections.emptyList();
    }

    public List<StructureItemsVo> strToItemsList(String listStr, String nowStructureId) {
        List array = JSON.parseArray((String)listStr, StructureItemsVo.class);
        if (HussarUtils.isEmpty((Object)array)) {
            return Collections.emptyList();
        }
        for (StructureItemsVo items : array) {
            items.setNowStructureId(nowStructureId);
        }
        return array;
    }

    private void fillExtendDataStructure(StructurePullDownVo result) {
        ArrayList<StructurePullDownItems> list = new ArrayList<StructurePullDownItems>();
        list.add(this.initStructurePullDownItems(EaiDataType.DATA_TYPE_PAGE));
        list.add(this.initStructurePullDownItems(EaiDataType.DATA_TYPE_MULTIPARTFILE));
        result.setExtend(list);
    }

    private boolean isNotStructureType(Integer type) {
        return type != null && EaiDataType.DATA_TYPE_STRUCTURE.getType() != type.intValue() && EaiDataType.DATA_TYPE_LIST.getType() != type.intValue() && EaiDataType.DATA_TYPE_PAGE.getType() != type.intValue();
    }

    private StructurePullDownItems initStructurePullDownItems(EaiDataType eaiDataType) {
        StructurePullDownItems baseStructure = new StructurePullDownItems();
        baseStructure.setType(eaiDataType.getTypeStr());
        baseStructure.setValue(eaiDataType.getTypeStr());
        baseStructure.setStructureName(eaiDataType.getMsg());
        baseStructure.setStructureCode(eaiDataType.getCode());
        return baseStructure;
    }

    private void fillBaseDataStructure(StructurePullDownVo result) {
        ArrayList<StructurePullDownItems> base = new ArrayList<StructurePullDownItems>();
        ArrayList<StructurePullDownItems> list = new ArrayList<StructurePullDownItems>();
        for (EaiDataType dataType : EaiDataType.values()) {
            StructurePullDownItems baseStructure = new StructurePullDownItems();
            baseStructure.setType(dataType.getTypeStr());
            baseStructure.setValue(dataType.getTypeStr());
            baseStructure.setStructureName(dataType.getMsg());
            baseStructure.setStructureCode(dataType.getCode());
            if (EaiDataType.DATA_TYPE_LIST.equals((Object)dataType)) {
                list.add(baseStructure);
                continue;
            }
            if (EaiDataType.DATA_TYPE_STRUCTURE.equals((Object)dataType) || EaiDataType.DATA_TYPE_PAGE.equals((Object)dataType) || EaiDataType.DATA_TYPE_APIRESPONSE.equals((Object)dataType) || EaiDataType.DATA_TYPE_MULTIPARTFILE.equals((Object)dataType)) continue;
            base.add(baseStructure);
        }
        result.setBase(base);
        result.setList(list);
    }

    private void resetItemsInQuoteStructureId(List<StructureItems> list) {
        if (HussarUtils.isEmpty(list)) {
            return;
        }
        for (StructureItems items : list) {
            if (HussarUtils.isBlank((CharSequence)items.getQuoteStructureId())) {
                this.resetItemsInQuoteStructureId(items.getItems());
                continue;
            }
            items.setItems(Collections.emptyList());
        }
    }

    private void fillNickName(List<StructureItems> list) {
        if (HussarUtils.isEmpty(list)) {
            return;
        }
        for (StructureItems item : list) {
            if (HussarUtils.isEmpty((Object)item.getNickName())) {
                item.setNickName(item.getName());
            }
            this.fillNickName(item.getItems());
        }
    }

    private void fillJsonBaseInfo(Map<String, JSONObject> paramMap, List<CommonStructure> list, String appCode) {
        for (Map.Entry<String, JSONObject> entry : paramMap.entrySet()) {
            CommonStructure commonStructure = new CommonStructure();
            String structureCode = entry.getKey();
            JSONObject valueJson = entry.getValue();
            String structureName = String.valueOf(valueJson.get((Object)"title"));
            JSONObject propertiesJson = JSONObject.parseObject((String)String.valueOf(valueJson.get((Object)"properties")));
            String description = null;
            if (HussarUtils.isNotEmpty((Object)valueJson.get((Object)"description"))) {
                description = String.valueOf(valueJson.get((Object)"description"));
            }
            commonStructure.setId(Long.valueOf(IdWorker.getId((Object)new CommonStructure())));
            commonStructure.setStructureCode(structureCode);
            commonStructure.setParamsType(EaiDataType.DATA_TYPE_STRUCTURE.getTypeStr());
            commonStructure.setApplicationCode(appCode);
            commonStructure.setStructureName(structureName);
            commonStructure.setRemark(description);
            commonStructure.setStructureClassify(EaiCategoryEnum.OPEN.getCode());
            commonStructure.setStructureValues(EaiCommonStructureImpl.toJSONString(propertiesJson));
            list.add(commonStructure);
        }
    }

    private void fillJsonParamInfo(List<CommonStructure> list, List<StructureImportDto> structureImportList, String appCode) {
        Map<String, CommonStructure> codeMap = list.stream().collect(Collectors.toMap(CommonStructure::getStructureCode, Function.identity(), (k1, k2) -> k1));
        Map<String, CommonStructure> structureCodeMap = this.getStructureCodeMap(appCode);
        for (CommonStructure structure : list) {
            StructureImportDto structureImportDto = new StructureImportDto();
            structureImportDto.setOriginStructureCode(structure.getStructureCode());
            JSONObject propertiesJson = JSONObject.parseObject((String)structure.getStructureValues());
            List<StructureItems> structureItemsList = this.parsePropertiesToItems(codeMap, propertiesJson);
            structure.setStructureValues(EaiCommonStructureImpl.toJSONString(structureItemsList));
            Integer structIdSuffix = Integer.valueOf(String.valueOf(structure.getId()).substring(Long.toString(structure.getId()).length() - 4));
            String structCodeT = CollectionUtil.isNotEmpty(structureCodeMap) ? this.checkUniqueStructCode(structure.getStructureCode(), structIdSuffix, structureCodeMap) : structure.getStructureCode() + structIdSuffix;
            structure.setStructureCode(structCodeT);
            if (HussarUtils.isNotEmpty((Object)structure.getStructureName())) {
                structure.setStructureName(structCodeT);
            }
            BeanUtil.copyProperties((Object)structure, (Object)structureImportDto);
            structureImportList.add(structureImportDto);
        }
    }

    @NotNull
    private Map<String, CommonStructure> getStructureCodeMap(String appCode) {
        Map<Object, Object> structureCodeMap = Maps.newHashMapWithExpectedSize((int)5);
        List commonStrucures = this.commonStructureService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonStructure::getApplicationCode, (Object)appCode)).isNotNull(CommonStructure::getStructureName));
        if (CollectionUtil.isNotEmpty((Collection)commonStrucures)) {
            structureCodeMap = commonStrucures.stream().collect(Collectors.toMap(CommonStructure::getStructureCode, Function.identity()));
        }
        return structureCodeMap;
    }

    private String checkUniqueStructCode(String structCodePre, Integer structIdSuffix, Map<String, CommonStructure> structureCodeMap) {
        String structCode = structCodePre + structIdSuffix;
        if (structureCodeMap.containsKey(structCode)) {
            structIdSuffix = structIdSuffix + 1;
            return this.checkUniqueStructCode(structCodePre, structIdSuffix, structureCodeMap);
        }
        return structCode;
    }

    private List<StructureItems> parsePropertiesToItems(Map<String, CommonStructure> codeMap, JSONObject propertiesJson) {
        ArrayList<StructureItems> structureItemsList = new ArrayList<StructureItems>();
        if (HussarUtils.isEmpty((Object)propertiesJson)) {
            return structureItemsList;
        }
        for (Map.Entry entry : propertiesJson.entrySet()) {
            StructureItems structureItems = new StructureItems();
            String name = (String)entry.getKey();
            JSONObject valueJson = JSONObject.parseObject((String)String.valueOf(entry.getValue()));
            String description = valueJson.getString("description");
            String refPath = valueJson.getString("$ref");
            String ref = "";
            if (StringUtil.isNotBlank((CharSequence)refPath)) {
                ref = refPath.substring(refPath.lastIndexOf("/") + 1);
            }
            String type = valueJson.getString("type");
            String format = valueJson.getString("format");
            if (HussarUtils.isBlank((CharSequence)type)) {
                type = "object";
                if (StringUtil.isNotBlank((CharSequence)ref)) {
                    structureItems.setQuoteStructureId(codeMap.get(ref).getId().toString());
                }
                structureItems.setItems(Collections.emptyList());
            } else if (StringUtil.equals((CharSequence)"array", (CharSequence)type)) {
                this.parseArray(valueJson, codeMap, structureItems);
            } else {
                structureItems.setItemType(null);
                structureItems.setItems(Collections.emptyList());
                structureItems.setQuoteStructureId("");
            }
            structureItems.setName(name);
            structureItems.setNickName(name);
            structureItems.setType(this.setType(type, format));
            structureItems.setMark(description);
            structureItemsList.add(structureItems);
        }
        return structureItemsList;
    }

    private void parseArray(JSONObject valueJson, Map<String, CommonStructure> codeMap, StructureItems structureItems) {
        Object arr = valueJson.get((Object)"items");
        JSONObject property = JSONObject.parseObject((String)String.valueOf(arr));
        String arrType = (String)property.get((Object)"type");
        String arrFormat = (String)property.get((Object)"format");
        String arrRefPath = (String)property.get((Object)"$ref");
        String arrRef = "";
        if (StringUtil.isNotBlank((CharSequence)arrRefPath)) {
            arrRef = arrRefPath.substring(arrRefPath.lastIndexOf("/") + 1);
        }
        if (HussarUtils.isBlank((CharSequence)arrType)) {
            arrType = "object";
            StructureItems arrItems = new StructureItems();
            arrItems.setType(this.setType(arrType, arrFormat));
            arrItems.setName(codeMap.get(arrRef).getStructureCode());
            arrItems.setNickName(codeMap.get(arrRef).getStructureCode());
            arrItems.setMark(codeMap.get(arrRef).getRemark());
            arrItems.setQuoteStructureId(codeMap.get(arrRef).getId().toString());
            arrItems.setItemType(null);
            arrItems.setItems(Collections.emptyList());
            structureItems.setItemType(this.setType(arrType, arrFormat));
            structureItems.setQuoteStructureId("");
            structureItems.setItems(Collections.singletonList(arrItems));
        } else if (StringUtil.equals((CharSequence)"array", (CharSequence)arrType)) {
            structureItems.setItemType(this.setType(arrType, arrFormat));
            StructureItems arrItems = new StructureItems();
            arrItems.setType(this.setType(arrType, arrFormat));
            arrItems.setName("items");
            arrItems.setNickName("items");
            arrItems.setMark("items");
            this.parseArray(property, codeMap, arrItems);
            structureItems.setQuoteStructureId("");
            structureItems.setItems(Collections.singletonList(arrItems));
        } else {
            StructureItems arrItems = new StructureItems();
            arrItems.setType(this.setType(arrType, arrFormat));
            arrItems.setName("items");
            arrItems.setNickName("items");
            arrItems.setMark("items");
            arrItems.setQuoteStructureId("");
            arrItems.setItemType(null);
            arrItems.setItems(Collections.emptyList());
            structureItems.setQuoteStructureId("");
            structureItems.setItemType(this.setType(arrType, arrFormat));
            structureItems.setItems(Collections.singletonList(arrItems));
        }
    }

    private Integer setType(String type, String format) {
        if ("boolean".equals(type)) {
            return 0;
        }
        if ("integer".equals(type) && "int32".equals(format)) {
            return 1;
        }
        if ("integer".equals(type) && "int64".equals(format)) {
            return 2;
        }
        if ("integer".equals(type)) {
            return 1;
        }
        if ("long".equals(type)) {
            return 2;
        }
        if ("number".equals(type) && "double".equals(format)) {
            return 3;
        }
        if ("double".equals(type)) {
            return 3;
        }
        if ("string".equals(type) && "date-time".equals(format)) {
            return 5;
        }
        if ("string".equals(type)) {
            return 4;
        }
        if ("date".equals(type)) {
            return 5;
        }
        if ("array".equals(type)) {
            return 6;
        }
        if ("object".equals(type)) {
            return 7;
        }
        return null;
    }

    private void checkAppStatus(String appCode) {
        ApplicationManageVo applicationManageVo = this.iApplicationManagementService.getByAppCode(appCode);
        if (HussarUtils.isEmpty((Object)applicationManageVo)) {
            throw new HussarException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        if (StringUtil.equals((CharSequence)"2", (CharSequence)applicationManageVo.getAppStatus())) {
            throw new HussarException("\u5e94\u7528\u7533\u8bf7\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u6570\u636e\u7ed3\u6784");
        }
    }

    public Map<String, CommonStructureVo> getAllStructures() {
        List<CommonStructureVo> allStructures = this.structureMapper.selectAllStructures();
        if (HussarUtils.isEmpty(allStructures)) {
            return new HashMap<String, CommonStructureVo>();
        }
        return allStructures.stream().collect(Collectors.toMap(CommonStructureVo::getId, Function.identity(), (v1, v2) -> v1));
    }

    public StructurePullDownVo getBaseAndReleasedStructure(String applicationCode, String appVersion) {
        StructurePullDownVo result = new StructurePullDownVo();
        this.fillBaseDataStructure(result);
        this.fillExtendDataStructure(result);
        List commonStructureList = this.iEaiStructureVersionService.listByAppCodeAndVersion(applicationCode, appVersion);
        if (HussarUtils.isEmpty((Object)commonStructureList)) {
            return result;
        }
        for (StructurePullDownItems vo : commonStructureList) {
            vo.setType(EaiDataType.DATA_TYPE_STRUCTURE.getTypeStr());
            vo.setValue(vo.getStructureCode());
            if (HussarUtils.isBlank((CharSequence)vo.getStructureValuesStr())) continue;
            List<StructureItemsVo> structureItems = this.strToItemsList(vo.getStructureValuesStr(), vo.getId());
            ArrayList<String> preValues = new ArrayList<String>();
            Map<String, Object> map = new HashMap<String, StructurePullDownItems>();
            if (HussarUtils.isNotEmpty((Object)commonStructureList)) {
                map = commonStructureList.stream().collect(Collectors.toMap(StructurePullDownItems::getId, Function.identity()));
            }
            this.fillItems(structureItems, map, preValues);
            vo.setStructureValues(structureItems);
        }
        result.setStructure(commonStructureList);
        return result;
    }

    public List<CommonStructure> listByIdList(List<Long> ids) {
        if (HussarUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(CommonStructure::getId, ids);
        return this.commonStructureService.list((Wrapper)queryWrapper);
    }

    private Map<String, CommonStructureVo> getAllReleasedStructures() {
        List allStructures = this.iEaiStructureVersionService.selectAllReleasedStructures();
        if (HussarUtils.isEmpty((Object)allStructures)) {
            return new HashMap<String, CommonStructureVo>();
        }
        return allStructures.stream().collect(Collectors.toMap(CommonStructureVo::getId, Function.identity(), (v1, v2) -> v1));
    }

    public boolean deleteByAppCode(String appCode) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonStructure::getApplicationCode, (Object)appCode);
        return this.commonStructureService.remove((Wrapper)wrapper);
    }

    public Boolean checkStructureName(CheckStructureCodeDto checkStructureCodeDto) {
        AssertUtil.isNotNull((Object)checkStructureCodeDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)checkStructureCodeDto.getStructureName(), (String)"\u6570\u636e\u7ed3\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)checkStructureCodeDto.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        return this.structureMapper.countByStructureName(checkStructureCodeDto) == 0;
    }

    public Boolean saveOrUpdateBatch(List<CommonStructure> newCommonStructureList) {
        return this.commonStructureService.saveOrUpdateBatch(newCommonStructureList);
    }

    public Boolean checkStructureCodeAndName(CheckStructureCodeDto checkStructureCodeDto) {
        Boolean codeUniqueFlag = this.checkStructureCode(checkStructureCodeDto);
        if (!codeUniqueFlag.booleanValue()) {
            return codeUniqueFlag;
        }
        Boolean nameUniqueFlag = this.checkStructureName(checkStructureCodeDto);
        if (!nameUniqueFlag.booleanValue()) {
            return nameUniqueFlag;
        }
        return true;
    }
}

