/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.info.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.appinfo.api.vo.ApplicationManageVo;
import com.jxdinfo.hussar.eai.appinfo.server.common.EaiAppEditManager;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonConstantVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.commonconstant.dto.CommonConstantDto;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonConstantService;
import com.jxdinfo.hussar.eai.atomicbase.api.resourcerelation.service.EaiAppStatusBaseService;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.info.service.impl.EaiCommonConstantServiceImpl")
public class EaiCommonConstantServiceImpl
implements EaiCommonConstantService {
    @Resource
    private ICommonConstantService commonConstantService;
    @Resource
    private IApplicationManagementService iApplicationManagementService;
    @Resource
    private EaiAppStatusBaseService eaiAppStatusService;
    @Resource
    private IHttpAuthenticationService httpAuthenticationService;

    public ApiResponse<Boolean> nameEnUniqueVerification(String nameEn, String applicationCode, Long constantId) {
        List commonConstants = this.commonConstantService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonConstant::getConstantNameEn, (Object)nameEn)).eq(CommonConstant::getApplicationCode, (Object)applicationCode));
        if (null == constantId) {
            if (commonConstants.size() > 0) {
                return ApiResponse.success((Object)false);
            }
        } else {
            if (commonConstants.size() == 0) {
                return ApiResponse.success((Object)true);
            }
            if (commonConstants.size() == 1) {
                CommonConstant commonConstant = (CommonConstant)commonConstants.get(0);
                if (!constantId.equals(commonConstant.getId())) {
                    return ApiResponse.success((Object)false);
                }
            } else {
                return ApiResponse.success((Object)false);
            }
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Long> saveCommon(CommonConstantDto commonConstant) {
        this.checkAppStatus(commonConstant.getApplicationCode());
        commonConstant.setCreateBy(BaseSecurityUtil.getUser().getUserName());
        CommonConstant constant = new CommonConstant();
        BeanUtil.copy((Object)commonConstant, (Object)constant);
        if (ToolUtil.isNotEmpty((Object)commonConstant.getName())) {
            constant.setConstantNameEn(commonConstant.getName());
        }
        if (ToolUtil.isNotEmpty((Object)commonConstant.getDesc())) {
            constant.setConstantName(commonConstant.getDesc());
        }
        EaiAppEditManager.getInstance().call(commonConstant.getApplicationCode());
        if (this.commonConstantService.save((Object)constant)) {
            return ApiResponse.success((Object)constant.getId());
        }
        throw new HussarException("\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    public ApiResponse<Boolean> updateCommon(CommonConstantDto commonConstant) {
        this.checkAppStatus(commonConstant.getApplicationCode());
        commonConstant.setEditBy(BaseSecurityUtil.getUser().getUserName());
        CommonConstant constant = new CommonConstant();
        BeanUtil.copy((Object)commonConstant, (Object)constant);
        if (ToolUtil.isNotEmpty((Object)commonConstant.getName())) {
            constant.setConstantNameEn(commonConstant.getName());
        }
        if (ToolUtil.isNotEmpty((Object)commonConstant.getDesc())) {
            constant.setConstantName(commonConstant.getDesc());
        }
        this.eaiAppStatusService.resetConstantStatus(commonConstant.getApplicationCode(), commonConstant.getId());
        EaiAppEditManager.getInstance().call(commonConstant.getApplicationCode());
        return ApiResponse.status((boolean)this.commonConstantService.updateById((Object)constant));
    }

    public ApiResponse<Page<CommonConstant>> eaiListPage(Page<CommonConstant> pageInfo, CommonConstantDto commonConstant) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CommonConstant::getApplicationCode, (Object)commonConstant.getApplicationCode());
        if (StringUtils.isNotEmpty((CharSequence)commonConstant.getConstantName())) {
            queryWrapper.like(CommonConstant::getConstantName, (Object)commonConstant.getConstantName());
        }
        if (StringUtils.isNotEmpty((CharSequence)commonConstant.getConstantNameEn())) {
            queryWrapper.like(CommonConstant::getConstantNameEn, (Object)commonConstant.getConstantNameEn());
        }
        if (StringUtils.isNotEmpty((CharSequence)commonConstant.getParamstype())) {
            queryWrapper.eq(CommonConstant::getParamstype, (Object)commonConstant.getParamstype());
        }
        return ApiResponse.success((Object)this.commonConstantService.page(pageInfo, (Wrapper)queryWrapper));
    }

    public ApiResponse<String> commonDeleteCheck(Long constantId) {
        CommonConstant commonParams = (CommonConstant)this.commonConstantService.getById((Serializable)constantId);
        return this.httpAuthenticationService.verifyCommonParamsHasUse(commonParams, constantId);
    }

    public boolean deleteByAppCode(String appCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(CommonConstant::getApplicationCode, (Object)appCode);
        EaiAppEditManager.getInstance().call(appCode);
        return this.commonConstantService.remove((Wrapper)queryWrapper);
    }

    private void checkAppStatus(String appCode) {
        ApplicationManageVo applicationManageVo = this.iApplicationManagementService.getByAppCode(appCode);
        if (HussarUtils.isEmpty((Object)applicationManageVo)) {
            throw new HussarException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        if (StringUtil.equals((CharSequence)"2", (CharSequence)applicationManageVo.getAppStatus())) {
            throw new HussarException("\u5e94\u7528\u7533\u8bf7\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c\u516c\u5171\u5e38\u91cf");
        }
    }

    public boolean removeById(Serializable id) {
        CommonConstant commonConstant = (CommonConstant)this.commonConstantService.getById(id);
        if (HussarUtils.isNotEmpty((Object)commonConstant)) {
            EaiAppEditManager.getInstance().call(commonConstant.getApplicationCode());
            return this.commonConstantService.removeById(id);
        }
        return false;
    }

    public boolean removeByIds(Collection<? extends Serializable> id) {
        LambdaQueryWrapper queryWrapper;
        List commonConstant;
        if (HussarUtils.isNotEmpty(id) && HussarUtils.isNotEmpty((Object)(commonConstant = this.commonConstantService.list((Wrapper)(queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(CommonConstant::getId, id)))))) {
            List appNames = commonConstant.stream().map(CommonConstant::getApplicationCode).collect(Collectors.toList());
            List appCodes = appNames.stream().distinct().collect(Collectors.toList());
            EaiAppEditManager.getInstance().call(appCodes);
            this.commonConstantService.removeByIds(id);
        }
        return false;
    }

    public List<CommonConstant> constantList(String appCode) {
        return this.commonConstantService.list((Wrapper)new LambdaQueryWrapper().eq(CommonConstant::getApplicationCode, (Object)appCode));
    }

    public ApiResponse<CommonConstantVo> getConstantDetailById(String constantId) {
        AssertUtil.isNotEmpty((String)constantId, (String)"\u5e38\u91cfID\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
        CommonConstantVo commonConstantDto = new CommonConstantVo();
        CommonConstant commonConstant = (CommonConstant)this.commonConstantService.getById((Serializable)((Object)constantId));
        BeanUtil.copy((Object)commonConstant, (Object)commonConstantDto);
        return ApiResponse.success((Object)commonConstantDto);
    }
}

