/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.copyresources;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonStructureVo;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.dto.CodeDto;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.dto.CopyParams;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.factory.CopyResourceServiceFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.service.CopyNumService;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.service.CopyResourceService;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonStructureService;
import com.jxdinfo.hussar.eai.common.annotation.EaiAuthCheck;
import com.jxdinfo.hussar.eai.common.annotation.EaiAuthResourceType;
import com.jxdinfo.hussar.eai.common.enums.app.EaiResourcesEnum;
import com.jxdinfo.hussar.eai.common.util.EaiCounterUtil;
import com.jxdinfo.hussar.eai.common.util.ResourcesNumUtil;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.copyresources.CopyStructureServiceImpl")
public class CopyStructureServiceImpl
implements CopyResourceService<CommonStructureVo> {
    private static final String STRUCTURE_TO_STRUCTURE = "structure_default_structure";
    @Resource
    private EaiCommonStructureService commonStructureService;
    @Resource
    private ICommonStructureService iCommonStructureService;
    @Resource
    private CopyNumService copyNumService;

    @EaiAuthCheck(paramName="id", paramType="id", sourceType=EaiAuthResourceType.STRUCTURE)
    public ApiResponse<CommonStructureVo> copyResult(CopyParams copyParams) {
        CommonStructureVo commonStructureVo = this.commonStructureService.getById(copyParams.getId());
        String structureCode = commonStructureVo.getStructureCode();
        String structureName = commonStructureVo.getStructureName();
        String applicationCode = commonStructureVo.getApplicationCode();
        CodeDto codeDto = this.checkCode(structureCode, applicationCode, true);
        String newStructureCode = String.format("%s_%d", codeDto.getCode(), codeDto.getNum());
        CodeDto nameDto = this.checkCode(structureName, applicationCode, false);
        String newStructureName = String.format("%s_%d", nameDto.getCode(), nameDto.getNum());
        EaiCounterUtil.getInstanceReduceQueue((String)String.format("%s_%s", codeDto.getCode(), EaiResourcesEnum.STRUCTURE.getType()));
        EaiCounterUtil.getInstanceReduceQueue((String)String.format("%s_%s", nameDto.getCode(), EaiResourcesEnum.STRUCTURE.getType()));
        commonStructureVo.setStructureCode(newStructureCode);
        commonStructureVo.setStructureName(newStructureName);
        commonStructureVo.setId(null);
        return ApiResponse.success((Object)commonStructureVo);
    }

    private CodeDto checkCode(String structureCode, String applicationCode, boolean isCode) {
        String code = ResourcesNumUtil.getName((String)structureCode);
        CodeDto result = this.copyNumService.getNum(structureCode, this.getNumFromList(code, isCode), EaiResourcesEnum.STRUCTURE.getType());
        structureCode = result.getCode();
        long num = result.getNum();
        String newStructureCode = String.format("%s_%d", structureCode, num);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(CommonStructure::getApplicationCode, (Object)applicationCode);
        if (isCode) {
            queryWrapper.eq(CommonStructure::getStructureCode, (Object)newStructureCode);
        } else {
            queryWrapper.eq(CommonStructure::getStructureName, (Object)newStructureCode);
        }
        long count = this.iCommonStructureService.count((Wrapper)queryWrapper);
        boolean checkCode = count < 1L;
        result.setChecked(checkCode);
        while (!checkCode) {
            result = this.checkCode(structureCode, applicationCode, isCode);
            checkCode = result.getChecked();
        }
        return result;
    }

    private Long getNumFromList(String code, boolean isCode) {
        Long num = 0L;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (isCode) {
            queryWrapper.like(CommonStructure::getStructureCode, (Object)code);
        } else {
            queryWrapper.like(CommonStructure::getStructureName, (Object)code);
        }
        List commonStructures = this.iCommonStructureService.list((Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)commonStructures)) {
            List list = commonStructures.stream().map(CommonStructure::getStructureCode).collect(Collectors.toList());
            num = ResourcesNumUtil.getMaxNum(list);
        }
        return num;
    }

    public void afterPropertiesSet() throws Exception {
        CopyResourceServiceFactory.registerCopyResourceService((String)STRUCTURE_TO_STRUCTURE, (CopyResourceService)this);
    }
}

