/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.copyresources;

import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.dto.CodeDto;
import com.jxdinfo.hussar.eai.atomicbase.api.copyresources.service.CopyNumService;
import com.jxdinfo.hussar.eai.common.util.EaiCounterUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.copyresources.CopyNumServiceImpl")
public class CopyNumServiceImpl
implements CopyNumService {
    private Pattern pattern = Pattern.compile("_\\d{1,3}$");

    public CodeDto getNum(String code, Long initNum, String type) {
        return this.getNum(code, initNum, type, true);
    }

    public CodeDto getChangeNum(String code, Long initNum, String type) {
        return this.getNum(code, initNum, type, false);
    }

    private CodeDto getNum(String code, Long initNum, String type, Boolean init) {
        CodeDto codeDto = new CodeDto();
        codeDto.setCode(code);
        Matcher matcher = this.pattern.matcher(code);
        Long num = initNum;
        if (matcher.find()) {
            String numStr = matcher.group();
            Long number = Long.parseLong(numStr.substring(1));
            if (init.booleanValue() && number > num) {
                num = number;
            }
            code = code.substring(0, code.length() - numStr.length());
            codeDto.setCode(code);
        }
        num = EaiCounterUtil.getInstanceCounterNum((String)String.format("%s_%s", code, type), (long)num);
        codeDto.setNum(num.longValue());
        return codeDto;
    }
}

