/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.configuration.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.eai.appinfo.api.dto.EaiApplicationJsonConfigDto;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiApplicationExtendConfiguration;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiApplicationExtendConfigurationVersion;
import com.jxdinfo.hussar.eai.appinfo.api.plugin.AppExtendConfigDataPlugin;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiApplicationExtendConfigurationService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiApplicationExtendConfigurationVersionService;
import com.jxdinfo.hussar.eai.appinfo.server.plugins.AppExtendConfigDataPluginHolder;
import com.jxdinfo.hussar.eai.atomicbase.api.configuration.service.IEaiConfigurationBuildService;
import com.jxdinfo.hussar.integration.support.jackson.config.JsonConfiguration;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.configuration.service.impl.EaiConfigurationBuildServiceImpl")
public class EaiConfigurationBuildServiceImpl
implements IEaiConfigurationBuildService {
    @Resource
    private IEaiApplicationExtendConfigurationService eaiApplicationExtendConfigurationService;
    @Resource
    private IEaiApplicationExtendConfigurationVersionService eaiApplicationExtendConfigurationVersionService;

    public void debugJsonConfiguration(String appCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(EaiApplicationExtendConfiguration::getApplicationCode, (Object)appCode)).eq(EaiApplicationExtendConfiguration::getConfigType, (Object)"jsonFormat");
        EaiApplicationExtendConfiguration eaiCommonConfiguration = (EaiApplicationExtendConfiguration)this.eaiApplicationExtendConfigurationService.getOne((Wrapper)queryWrapper);
        String configData = null;
        if (eaiCommonConfiguration != null) {
            configData = eaiCommonConfiguration.getConfigDataText();
        }
        this.buildContextual(configData);
    }

    public void buildJsonConfiguration(String appCode, String configVersion) {
        EaiApplicationExtendConfigurationVersion eaiConfigurationVersion = this.getLatestVersion(appCode);
        this.buildContextual(eaiConfigurationVersion.getConfigDataText());
    }

    private EaiApplicationExtendConfigurationVersion getLatestVersion(String appCode) {
        PageInfo pageInfo = new PageInfo();
        pageInfo.setCurrent(1L);
        pageInfo.setSize(1L);
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(EaiApplicationExtendConfigurationVersion::getApplicationCode, (Object)appCode)).eq(EaiApplicationExtendConfigurationVersion::getConfigType, (Object)"jsonFormat")).orderByDesc(EaiApplicationExtendConfigurationVersion::getVersionNum);
        Page configurationVersions = (Page)this.eaiApplicationExtendConfigurationVersionService.page((IPage)page, (Wrapper)queryWrapper);
        if (HussarUtils.isNotEmpty((Object)configurationVersions) && HussarUtils.isNotEmpty((Object)configurationVersions.getRecords())) {
            return (EaiApplicationExtendConfigurationVersion)configurationVersions.getRecords().get(0);
        }
        return new EaiApplicationExtendConfigurationVersion();
    }

    private void buildContextual(String configData) {
        EaiApplicationJsonConfigDto jsonConfigDto;
        if (HussarUtils.isNotEmpty((Object)configData)) {
            jsonConfigDto = (EaiApplicationJsonConfigDto)HussarIntegrationJsonUtils.parse((String)configData, EaiApplicationJsonConfigDto.class);
        } else {
            AppExtendConfigDataPlugin plugin = AppExtendConfigDataPluginHolder.lookup((String)"jsonFormat");
            jsonConfigDto = (EaiApplicationJsonConfigDto)plugin.initConfigData();
        }
        String dateTimeFormat = jsonConfigDto.getDateTimeFormat();
        String dateFormat = jsonConfigDto.getDateFormat();
        String timeFormat = jsonConfigDto.getTimeFormat();
        Boolean ambiguousQuote = jsonConfigDto.getAmbiguousQuote();
        Boolean propertyIgnoreCase = jsonConfigDto.getPropertyIgnoreCase();
        JsonConfiguration configuration = JsonConfiguration.builder().dateTimeFormat(dateTimeFormat).dateFormat(dateFormat).timeFormat(timeFormat).ambiguousQuote(ambiguousQuote).propertyIgnoreCase(propertyIgnoreCase).build();
        HussarIntegrationJsonUtils.Contextual.setConfigure((JsonConfiguration)configuration);
    }
}

