/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.common.service.impl;

import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.common.dto.EaiGenHttpParams;
import com.jxdinfo.hussar.eai.atomicbase.api.common.service.IEaiParamsChangeService;
import com.jxdinfo.hussar.eai.atomicbase.server.common.service.impl.EaiParamsChangeCommonService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.ServletUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.common.service.impl.EaiParamsChangeServiceImpl")
public class EaiParamsChangeServiceImpl
extends EaiParamsChangeCommonService
implements IEaiParamsChangeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiParamsChangeServiceImpl.class);

    private Map<String, Object> initHeader(Object params, boolean test) {
        Map<String, Object> authHeader = !test ? this.getFromHeader() : null;
        return authHeader;
    }

    private EaiGenHttpParams initParams(Object params) {
        EaiGenHttpParams eaiGenHttpParams = new EaiGenHttpParams();
        eaiGenHttpParams.setAuthHeader(this.getFromHeader());
        eaiGenHttpParams.setParams(params);
        return eaiGenHttpParams;
    }

    public HttpAuthVerifyDto getApiTestDto(Object params, String apiCode, boolean test) {
        return super.getApiTestDto(this.initParams(params), apiCode, test);
    }

    public HttpAuthVerifyDto getApiTestDto(Object params, String apiCode) {
        return this.getApiTestDto(params, apiCode, false);
    }

    public EaiApiVersion getApiVersionInfo(String apiCode) {
        return (EaiApiVersion)this.apiVersionService.getById((Serializable)Long.valueOf(apiCode));
    }

    public Map<String, Object> getFromHeader() {
        Enumeration headers = ServletUtils.getRequest().getHeaderNames();
        HashMap<String, Object> authHeader = new HashMap<String, Object>();
        if (headers != null) {
            while (headers.hasMoreElements()) {
                String key = (String)headers.nextElement();
                authHeader.put(key, ServletUtils.getRequest().getHeader(key));
            }
        }
        return authHeader;
    }

    public Object getResponseResult(Object resp, String responseType) {
        EaiApiVersion eaiApiVersion = (EaiApiVersion)this.apiVersionService.getById((Serializable)Long.valueOf(responseType));
        if (HussarUtils.isNotEmpty((Object)eaiApiVersion) && HussarUtils.isNotEmpty((Object)eaiApiVersion.getOutParams())) {
            try {
                return ParamsConvertUtil.parseResult((Object)resp, (String)eaiApiVersion.getOutParams());
            }
            catch (Exception e) {
                LOGGER.error("\u8fd4\u56de\u503c\u8f6c\u6362\u5f02\u5e38 apiId={}, apiCode={}, apiName={}, appCode={}", new Object[]{eaiApiVersion.getApiId(), eaiApiVersion.getApiCode(), eaiApiVersion.getApiName(), eaiApiVersion.getApplicationCode(), e});
                EaiApiParams eaiApiParams = new EaiApiParams();
                eaiApiParams.setBody(resp);
                return eaiApiParams;
            }
        }
        return resp;
    }

    public EaiApiParams getEaiApiParams(Object params, String apiCode) {
        EaiApiVersion eaiApiVersion = this.getApiVersion(apiCode);
        EditApi editApi = this.getEditApi(eaiApiVersion);
        return this.getEaiApiParams(params, apiCode, eaiApiVersion, editApi);
    }

    public EaiApiParams getEaiApiParams(Object params, String apiCode, EaiApiVersion eaiApiVersion, EditApi editApi) {
        return this.getEaiApiParams(params, apiCode, eaiApiVersion, editApi, false);
    }

    public HttpAuthVerifyDto getFormDataAuthVerifyDtoBody(EaiGenHttpParams inParams, String apiCode) {
        AssertUtil.isNotEmpty((String)apiCode, (String)"\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a");
        return super.getAuthVerifyDtoBody(inParams, apiCode);
    }

    public HttpAuthVerifyDto getAuthVerifyDtoBody(Object inParams, String apiCode) {
        AssertUtil.isNotEmpty((String)apiCode, (String)"\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a");
        return super.getAuthVerifyDtoBody(this.initParams(inParams), apiCode);
    }
}

