/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.apirelease.api.srevice.IApiVersionService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IEaiResourcesInfoService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpBodyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.common.dto.EaiGenHttpParams;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiRequestTypeEnum;
import com.jxdinfo.hussar.eai.common.enums.sys.EaiCharsetEnum;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EaiParamsChangeCommonService {
    private static final Logger LOGGER = LoggerFactory.getLogger(EaiParamsChangeCommonService.class);
    protected static final String ERROR_MSG = "\u63a5\u53e3\u4e0d\u80fd\u4e3a\u7a7a";
    protected static final String ERROR_NOTFOUND_MSG = "\u8bf7\u6c42\u7684\u63a5\u53e3\u4e0d\u5b58\u5728";
    @Resource
    private IEaiApplicationAuthService applicationAuthService;
    @Resource
    private IEaiResourcesInfoService eaiResourcesInfoService;
    @Resource
    private IEaiEditApiService editApiService;
    @Resource
    private IApiCallSpecificationInfoService callSpecificationInfoService;
    @Resource
    protected IApiVersionService apiVersionService;

    protected EaiApiParams getEaiApiParams(Object params, String apiCode, EaiApiVersion eaiApiVersion, EditApi editApi, boolean test) {
        EaiApiParams obj = new EaiApiParams();
        String inParams = eaiApiVersion.getInParams();
        if (HussarUtils.isNotEmpty((Object)inParams)) {
            List list = ParamsConvertUtil.toEaiParamsItems((String)inParams);
            if (HussarUtils.isNotEmpty((Object)list) && list.size() == 1) {
                EaiParamsItems body = (EaiParamsItems)list.get(0);
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == body.getType().intValue() && "Object".equals(body.getValue())) {
                    inParams = JSON.toJSONString((Object)body.getItems());
                }
            }
            obj = test ? ParamsConvertUtil.oEaiParamsItems((Object)params, (String)inParams, (boolean)test) : ParamsConvertUtil.oEaiParamsItems((Object)params, (String)inParams);
        }
        if (!test) {
            obj.setUrl(editApi.getApiPath());
        }
        if (HussarUtils.isEmpty((Object)editApi.getContentType()) || test) {
            obj.setContentType(EaiContentType.APPLICATION_JSON);
        } else {
            obj.setContentType(EaiContentType.getByType((int)Integer.valueOf(editApi.getContentType())));
        }
        if (HussarUtils.isEmpty((Object)editApi.getEncodingType())) {
            obj.setCharset(EaiCharsetEnum.UTF8);
        } else {
            obj.setCharset(EaiCharsetEnum.getByCode((int)Integer.valueOf(editApi.getEncodingType())));
        }
        if (HussarUtils.isEmpty((Object)editApi.getHttpMethod())) {
            obj.setRequestType(EaiRequestTypeEnum.POST);
        } else {
            obj.setRequestType(EaiRequestTypeEnum.getByType((String)editApi.getHttpMethod()));
        }
        return obj;
    }

    public HttpAuthVerifyDto getApiTestDto(EaiGenHttpParams eaiGenHttpParams, String apiCode, boolean test) {
        AssertUtil.isNotEmpty((String)apiCode, (String)ERROR_MSG);
        EaiResourcesInfo eaiResourcesInfo = this.getEaiResourcesInfo(apiCode);
        this.checkApi(eaiResourcesInfo);
        Map authHeader = eaiGenHttpParams.getAuthHeader();
        Object params = eaiGenHttpParams.getParams();
        HttpAuthVerifyDto httpAuthVerifyDto = new HttpAuthVerifyDto();
        String applicationCode = eaiResourcesInfo.getApplicationCode();
        httpAuthVerifyDto.setTokenVerifys(this.headerList(authHeader, applicationCode));
        httpAuthVerifyDto.setApplicationCode(applicationCode);
        EaiApiVersion apiVersion = this.getApiVersion(apiCode);
        httpAuthVerifyDto.setOutMapping(ParamsConvertUtil.toEaiParamsItems((String)apiVersion.getOutParams()));
        EditApi editApi = this.getEditApi(apiVersion);
        EaiApiParams eaiApiParams = this.getEaiApiParams(params, apiCode, apiVersion, editApi, test);
        httpAuthVerifyDto.setHttpHeader(this.headerToEaiHttpParamsDto(eaiApiParams));
        httpAuthVerifyDto.setHttpQueryParam(this.queryToEaiHttpParamsDto(eaiApiParams));
        Object body = eaiApiParams.getBody();
        EaiHttpBodyDto bodyDto = new EaiHttpBodyDto();
        if (HussarUtils.isNotEmpty((Object)body)) {
            bodyDto.setBodyParam(this.bodyParams(body));
            bodyDto.setContentType(String.valueOf(eaiApiParams.getContentType().getType()));
            httpAuthVerifyDto.setHttpBody(bodyDto);
        } else {
            bodyDto.setContentType(String.valueOf(eaiApiParams.getContentType().getType()));
            httpAuthVerifyDto.setHttpBody(bodyDto);
        }
        httpAuthVerifyDto.setHttpUrl(eaiApiParams.getUrl());
        httpAuthVerifyDto.setHttpMethod(eaiApiParams.getRequestType().getType());
        httpAuthVerifyDto.setCallSpecificaList(this.callSpecificationInfoService.selectCallInfoListByApiId(Long.valueOf(apiCode)));
        return httpAuthVerifyDto;
    }

    protected List<EaiHttpParamsDto> headerList(Map<String, Object> authHeader, String applicationCode) {
        if (HussarUtils.isNotEmpty(authHeader)) {
            HashMap httpHeader = new HashMap();
            LambdaQueryWrapper authWrapper = new LambdaQueryWrapper();
            authWrapper.eq(EaiApplicationAuth::getApplicationCode, (Object)applicationCode);
            List eaiHttpParams = this.applicationAuthService.list((Wrapper)authWrapper);
            ArrayList list = new ArrayList();
            eaiHttpParams.forEach(eaiHttpParam -> {
                EaiHttpParamsDto eaiHttpParamsDto = new EaiHttpParamsDto();
                eaiHttpParamsDto.setParamsNameEn(eaiHttpParam.getParamsNameEn());
                eaiHttpParamsDto.setParamsId(eaiHttpParam.getParamsId());
                eaiHttpParamsDto.setParamsFrom("2");
                authHeader.forEach((k, v) -> {
                    if (k.equals(eaiHttpParam.getParamsNameEn())) {
                        eaiHttpParamsDto.setParamsValue(String.valueOf(v));
                        httpHeader.put(k, v);
                    }
                });
                TempHttpCode.setParams((Map)httpHeader);
                list.add(eaiHttpParamsDto);
            });
        }
        return Collections.emptyList();
    }

    protected void setHeader(Map<String, Object> authHeader, String applicationCode) {
        if (HussarUtils.isNotEmpty(authHeader)) {
            HashMap httpHeader = new HashMap();
            LambdaQueryWrapper authWrapper = new LambdaQueryWrapper();
            authWrapper.eq(EaiApplicationAuth::getApplicationCode, (Object)applicationCode);
            List eaiHttpParams = this.applicationAuthService.list((Wrapper)authWrapper);
            eaiHttpParams.forEach(eaiHttpParam -> authHeader.forEach((k, v) -> {
                if (null != eaiHttpParam.getParamsNameEn() && k.equals(eaiHttpParam.getParamsNameEn().toLowerCase())) {
                    httpHeader.put(eaiHttpParam.getParamsNameEn(), v);
                }
            }));
            TempHttpCode.setParams(httpHeader);
        }
    }

    protected EaiResourcesInfo getEaiResourcesInfo(String apiCode) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(EaiResourcesInfo::getResourceVersionId, (Object)Long.valueOf(apiCode));
        return (EaiResourcesInfo)this.eaiResourcesInfoService.getOne((Wrapper)queryWrapper);
    }

    protected void checkApi(EaiResourcesInfo eaiResourcesInfo) {
        if (ToolUtil.isEmpty((Object)eaiResourcesInfo)) {
            throw new BaseException(ERROR_NOTFOUND_MSG);
        }
        if ("1".equals(eaiResourcesInfo.getDeleteState())) {
            throw new BaseException("\u63a5\u53e3\u5df2\u4e0b\u67b6");
        }
    }

    protected EaiApiVersion getApiVersion(String apiCode) {
        AssertUtil.isNotEmpty((String)apiCode, (String)ERROR_MSG);
        EaiApiVersion eaiApiVersion = (EaiApiVersion)this.apiVersionService.getById((Serializable)Long.valueOf(apiCode));
        if (HussarUtils.isEmpty((Object)eaiApiVersion)) {
            throw new BaseException(ERROR_NOTFOUND_MSG);
        }
        return eaiApiVersion;
    }

    protected EditApi getEditApi(EaiApiVersion eaiApiVersion) {
        LambdaQueryWrapper lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, (Object)eaiApiVersion.getApiVersionId());
        return (EditApi)this.editApiService.getOne((Wrapper)lambdaQueryWrapper);
    }

    protected List<EaiHttpParamsDto> toEaiHttpParamsDto(Map<String, Object> map) {
        ArrayList<EaiHttpParamsDto> list = new ArrayList<EaiHttpParamsDto>();
        map.forEach((k, v) -> {
            EaiHttpParamsDto eaiHttpParamsDto = new EaiHttpParamsDto();
            eaiHttpParamsDto.setParamsNameEn(k);
            eaiHttpParamsDto.setKeyValue(v);
            list.add(eaiHttpParamsDto);
        });
        return list;
    }

    protected List<EaiHttpParamsDto> headerToEaiHttpParamsDto(EaiApiParams eaiApiParams) {
        Map header = eaiApiParams.getHeader();
        if (HussarUtils.isNotEmpty((Object)header)) {
            return this.toEaiHttpParamsDto(header);
        }
        return Collections.emptyList();
    }

    protected List<EaiHttpParamsDto> queryToEaiHttpParamsDto(EaiApiParams eaiApiParams) {
        Map header = eaiApiParams.getQuery();
        if (HussarUtils.isNotEmpty((Object)header)) {
            return this.toEaiHttpParamsDto(header);
        }
        return Collections.emptyList();
    }

    protected HttpAuthVerifyDto getAuthVerifyDtoBody(EaiGenHttpParams eaiGenHttpParams, String apiCode) {
        AssertUtil.isNotEmpty((String)apiCode, (String)ERROR_MSG);
        Map authHeader = eaiGenHttpParams.getAuthHeader();
        EaiResourcesInfo eaiResourcesInfo = this.getEaiResourcesInfo(apiCode);
        this.checkApi(eaiResourcesInfo);
        Object inParams = eaiGenHttpParams.getParams();
        HttpAuthVerifyDto httpAuthVerifyDto = new HttpAuthVerifyDto();
        this.setHeader(authHeader, eaiResourcesInfo.getApplicationCode());
        httpAuthVerifyDto.setApplicationCode(eaiResourcesInfo.getApplicationCode());
        EaiApiParams eaiApiParams = this.getEaiApiParamsBody(inParams, apiCode);
        Object body = eaiApiParams.getBody();
        EaiHttpBodyDto bodyDto = new EaiHttpBodyDto();
        if (HussarUtils.isNotEmpty((Object)body)) {
            if (body instanceof Map) {
                bodyDto.setBodyParam(this.multiBodyParams((Map)body));
            } else {
                bodyDto.setBodyParam(this.bodyParams(body));
            }
            httpAuthVerifyDto.setHttpBody(bodyDto);
        } else {
            httpAuthVerifyDto.setHttpBody(bodyDto);
        }
        return httpAuthVerifyDto;
    }

    private List<EaiHttpParamsDto> multiBodyParams(Map<String, Object> body) {
        return this.toEaiHttpParamsDto(body);
    }

    public List<EaiHttpParamsDto> bodyParams(Object body) {
        ArrayList<EaiHttpParamsDto> bodyParams = new ArrayList<EaiHttpParamsDto>();
        String jv = JSON.toJSONString((Object)body);
        if (jv.startsWith("{")) {
            Map objectMap = (Map)JSON.parseObject((String)jv, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
            bodyParams.addAll(this.toEaiHttpParamsDto(objectMap));
        } else {
            EaiHttpParamsDto eaiHttpParamsDto = new EaiHttpParamsDto();
            eaiHttpParamsDto.setParamsNameEn(null);
            eaiHttpParamsDto.setKeyValue(body);
            bodyParams.add(eaiHttpParamsDto);
        }
        return bodyParams;
    }

    private EaiApiParams getEaiApiParamsBody(Object params, String apiCode) {
        AssertUtil.isNotEmpty((String)apiCode, (String)ERROR_MSG);
        EaiApiVersion eaiApiVersion = (EaiApiVersion)this.apiVersionService.getById((Serializable)Long.valueOf(apiCode));
        if (HussarUtils.isEmpty((Object)eaiApiVersion)) {
            throw new BaseException(ERROR_NOTFOUND_MSG);
        }
        EaiApiParams obj = new EaiApiParams();
        obj.setBody(params);
        return obj;
    }
}

