/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.common.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jxdinfo.hussar.eai.atomicbase.api.common.service.EaiEncodingService;
import com.jxdinfo.hussar.eai.common.util.EaiCharSetUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.common.service.impl.EaiEncodingServiceImpl")
public class EaiEncodingServiceImpl
implements EaiEncodingService {
    private static final String ENCODING_EXCEPTION = "\u7f16\u7801\u683c\u5f0f\u8f6c\u6362\u5931\u8d25";
    private static final String DATA_TYPE_EXCEPTION = "\u4e0d\u652f\u6301\u7684\u6570\u636e\u683c\u5f0f";

    public String convertStringToOthers(String t, Charset charset) {
        try {
            return EaiCharSetUtil.convert((String)t, (Charset)charset, (Charset)charset);
        }
        catch (Exception e) {
            throw new HussarException(ENCODING_EXCEPTION, (Throwable)e);
        }
    }

    public String utf8toGBK(String t) {
        return this.convertStringToOthers(t, EaiCharSetUtil.CHARSET_GBK);
    }

    public String utf8toGB2312(String t) {
        return this.convertStringToOthers(t, EaiCharSetUtil.CHARSET_GB2312);
    }

    public String utf8toISO88591(String t) {
        return this.convertStringToOthers(t, EaiCharSetUtil.CHARSET_ISO_8859_1);
    }

    public String utf8toASCII(String t) {
        return this.convertStringToOthers(t, EaiCharSetUtil.CHARSET_ASCII);
    }

    public Map<String, Object> utf8toGBK(Map<String, Object> t) {
        return this.convertMapToOthers(t, EaiCharSetUtil.CHARSET_GBK);
    }

    public Map<String, Object> utf8toGB2312(Map<String, Object> t) {
        return this.convertMapToOthers(t, EaiCharSetUtil.CHARSET_GB2312);
    }

    public Map<String, Object> utf8toISO88591(Map<String, Object> t) {
        return this.convertMapToOthers(t, EaiCharSetUtil.CHARSET_ISO_8859_1);
    }

    public Map<String, Object> utf8toASCII(Map<String, Object> t) {
        return this.convertMapToOthers(t, EaiCharSetUtil.CHARSET_ASCII);
    }

    public <T> T convertStructureToOthers(Object obj, Charset charset, Class<T> clazz) {
        if (HussarUtils.isEmpty((Object)obj)) {
            return null;
        }
        if (obj instanceof CharSequence) {
            if (clazz.isInstance(CharSequence.class)) {
                return (T)JSONObject.parseObject((String)EaiCharSetUtil.convert((String)String.valueOf(obj), (Charset)charset, (Charset)charset), clazz);
            }
            throw new HussarException(DATA_TYPE_EXCEPTION);
        }
        try {
            String str = JSONObject.toJSONString((Object)JSON.toJSON((Object)obj), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            String va = this.convertStringToOthers(str, charset);
            return (T)JSONObject.parseObject((String)va, clazz);
        }
        catch (Exception e) {
            throw new HussarException(DATA_TYPE_EXCEPTION, (Throwable)e);
        }
    }

    public Object convertObjectToOthers(Object obj, Charset charset) {
        if (HussarUtils.isEmpty((Object)obj)) {
            return obj;
        }
        if (obj instanceof CharSequence) {
            return EaiCharSetUtil.convert((String)String.valueOf(obj), (Charset)charset, (Charset)charset);
        }
        return obj;
    }

    public Map<String, Object> convertMapToOthers(Map<String, Object> t, Charset charset) {
        if (t != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            t.forEach((k, v) -> {
                String newKey = this.convertStringToOthers((String)k, charset);
                Object newValue = null;
                newValue = v instanceof CharSequence ? this.convertStringToOthers(String.valueOf(v), charset) : v;
                map.put(newKey, newValue);
            });
            return map;
        }
        return null;
    }
}

