/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.common.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.common.service.EaiApiCommonService;
import com.jxdinfo.hussar.eai.atomicbase.api.common.service.EaiEncodingService;
import com.jxdinfo.hussar.eai.atomicbase.server.util.EaiRmiUtil;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.enums.sys.EaiCharsetEnum;
import com.jxdinfo.hussar.eai.common.util.EaiCharSetUtil;
import com.jxdinfo.hussar.eai.common.util.JsonParseToStringUtil;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationConvertUtils;
import com.jxdinfo.hussar.integration.support.utils.HussarIntegrationJsonUtils;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineMethod;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineService;
import com.jxdinfo.hussar.support.engine.core.enums.DataServiceType;
import com.jxdinfo.hussar.support.engine.plugin.rmi.sdk.dto.RmiRequestDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.sdk.enums.RequestTypeEnum;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiRequest;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;

@EngineService(value="com.jxdinfo.hussar.eai.server.common.service.impl.EaiApiCommonServiceImpl", type=DataServiceType.PERMANENT, des="\u63a5\u53e3\u8c03\u7528service")
public class EaiApiCommonServiceImpl
implements EaiApiCommonService {
    private static final Logger log = LoggerFactory.getLogger(EaiApiCommonServiceImpl.class);
    private static final String RESP = "[RmiApi] \u8fd4\u56de\u503c\uff1a{}";
    private static final String COMMON_RESP = "[\u7ed3\u679c] EaiApiResponse\uff1a{}";
    private static final String REQ = "[RmiApi] \u8bf7\u6c42body\u53c2\u6570\uff1a{}";
    @Autowired
    EaiEncodingService eaiEncodingService;
    private static String LOG_MSG_REQ_BODY = "\n body\u53c2\u6570\uff1a";
    private static String LOG_MSG_REQ_FILE = "\n \u6587\u4ef6\u53c2\u6570\uff1a";
    private static String LOG_MSG_REQ_HEADER = "\n header\u53c2\u6570\uff1a";
    private static String LOG_MSG_REQ_QUERY = "\n query\u53c2\u6570\uff1a";
    private static final String CONTENT_TYPE = "content-type";
    private static final String CHAR_SET = "charset";
    private static final String URL_ERROR = "\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String CONTENT_TYPE_ERROR = "ContentType\u4e0d\u80fd\u4e3a\u7a7a";
    private static final String URL_FORMAT_ERROR = "\u65e0\u6cd5\u89e3\u6790\u7684url";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static final String HOST = "host";
    private static final String PORT = "port";
    private static final String PATH = "path";
    private static final String DEFAULT_PORT = "80";
    private static final String DEFAULT_URI_PATH = "/";
    private static final String SPLIT_CODE = ":";
    private static final String SCHEMA_HTTP = "http";
    private static final String SCHEMA_HTTPS = "https";
    private static final String SCHEMA = "schema";

    @EngineMethod(des="\u4e0d\u8fdb\u884c\u7f16\u7801\u8f6c\u6362", paramDes={"EaiApiInvokeParams"}, returnDes="EaiApiResponse")
    public EaiApiResponse getResponse(EaiApiParams eaiApiParams) {
        return this.getResponse(eaiApiParams, null);
    }

    @EngineMethod(des="\u8fdb\u884c\u7f16\u7801\u8f6c\u6362", paramDes={"EaiApiInvokeParams"}, returnDes="EaiApiResponse")
    public EaiApiResponse getConvertResponse(EaiApiParams eaiApiParams) {
        return this.getConvertResponse(eaiApiParams, null);
    }

    @EngineMethod(des="\u8fdb\u884c\u7f16\u7801\u8f6c\u6362\uff0c\u6307\u5b9a\u8fd4\u56de\u503c\u7ed3\u6784", paramDes={"EaiApiInvokeParams\uff0cClass responseClass"}, returnDes="EaiApiResponse")
    public EaiApiResponse getConvertResponse(EaiApiParams eaiApiParams, Class responseClass) {
        Object resp;
        RmiRequestDto requestDto = this.formatConvertRmiRequestDto(eaiApiParams, false);
        if (responseClass != null) {
            requestDto.setReturnClassType(responseClass);
        }
        this.logRequestBody(requestDto);
        RmiApiRequest request = EaiRmiUtil.INSTANCE.getRequest(requestDto);
        EaiApiResponse response = new EaiApiResponse();
        request.onSuccess((v1, v2, v3) -> response.setHeader(v3.getHeaders())).onError((v1, v2, v3) -> {
            if (HussarUtils.isNotEmpty((Object)v3.getContent())) {
                response.setException(v3.getContent());
            } else if (HussarUtils.isNotEmpty((Object)v3.getException())) {
                response.setException(v3.getException().getMessage());
            }
        });
        if (responseClass != null) {
            resp = request.execute(responseClass);
            if (HussarUtils.isNotEmpty((Object)resp)) {
                Object result = this.eaiEncodingService.convertStructureToOthers(resp, EaiCharSetUtil.parse((String)eaiApiParams.getCharset().getName()), responseClass);
                response.setBody(result);
            } else {
                response.setBody(resp);
            }
        } else {
            resp = request.execute();
            if (HussarUtils.isNotEmpty((Object)resp)) {
                Object result = this.eaiEncodingService.convertObjectToOthers(resp, EaiCharSetUtil.parse((String)eaiApiParams.getCharset().getName()));
                response.setBody(result);
            } else {
                response.setBody(resp);
            }
        }
        this.logResp(resp, response);
        return response;
    }

    private void logRequestBody(RmiRequestDto requestDto) {
        StringBuilder reqStr = new StringBuilder(LOG_MSG_REQ_BODY);
        reqStr.append((String)HussarIntegrationConvertUtils.convert((Object)requestDto.getBody(), String.class));
        if (HussarUtils.isNotEmpty((Object)requestDto.getMultiFileMap())) {
            reqStr.append(LOG_MSG_REQ_FILE).append(JsonParseToStringUtil.INSTANCE.toString((Object)requestDto.getMultiFileMap()));
        }
        if (HussarUtils.isNotEmpty((Object)requestDto.getHeader())) {
            reqStr.append(LOG_MSG_REQ_HEADER).append((String)HussarIntegrationConvertUtils.convert((Object)requestDto.getHeader(), String.class));
        }
        if (HussarUtils.isNotEmpty((Object)requestDto.getQuery())) {
            reqStr.append(LOG_MSG_REQ_QUERY).append((String)HussarIntegrationConvertUtils.convert((Object)requestDto.getQuery(), String.class));
        }
        log.info(REQ, (Object)reqStr);
    }

    @EngineMethod(des="\u4e0d\u8fdb\u884c\u7f16\u7801\u8f6c\u6362\uff0c\u6307\u5b9a\u8fd4\u56de\u503c\u7ed3\u6784", paramDes={"EaiApiInvokeParams\uff0cClass responseClass"}, returnDes="EaiApiResponse")
    public EaiApiResponse getResponse(EaiApiParams eaiApiParams, Class responseClass) {
        RmiRequestDto requestDto = this.formatRmiRequestDto(eaiApiParams, false);
        requestDto.setReturnClassType(responseClass);
        this.logRequestBody(requestDto);
        RmiApiRequest request = EaiRmiUtil.INSTANCE.getRequest(requestDto);
        EaiApiResponse response = new EaiApiResponse();
        request.onSuccess((v1, v2, v3) -> response.setHeader(v3.getHeaders())).onError((v1, v2, v3) -> {
            if (HussarUtils.isNotEmpty((Object)v3.getContent())) {
                response.setException(v3.getContent());
            } else if (HussarUtils.isNotEmpty((Object)v3.getException())) {
                response.setException(v3.getException().getMessage());
            }
        });
        Object resp = responseClass != null ? request.execute(responseClass) : request.execute();
        response.setBody(resp);
        this.logResp(resp, response);
        return response;
    }

    private void logResp(Object resp, EaiApiResponse response) {
        try {
            log.info(RESP, (Object)HussarIntegrationJsonUtils.toString((Object)resp));
            log.info(COMMON_RESP, (Object)HussarIntegrationJsonUtils.toString((Object)response));
        }
        catch (Exception e) {
            log.info(RESP, HussarIntegrationConvertUtils.convert((Object)resp, String.class));
            log.info(COMMON_RESP, HussarIntegrationConvertUtils.convert((Object)response, String.class));
        }
    }

    private String contentType(Map<String, Object> header, String contentType, String charset) {
        String[] charsets = new String[1];
        String c = charset;
        if (HussarUtils.isNotEmpty(header)) {
            try {
                for (Map.Entry<String, Object> entry : header.entrySet()) {
                    String k = entry.getKey();
                    Object v = entry.getValue();
                    if (!CONTENT_TYPE.equals(k.toLowerCase())) continue;
                    String value = String.valueOf(v);
                    if (EaiContentType.NONE.getName().equals(value.toUpperCase())) continue;
                    if (HussarUtils.isNotEmpty((Object)value) && value.toLowerCase().contains(CHAR_SET)) {
                        if (HussarUtils.isNotEmpty((Object)c)) {
                            String type = value.substring(0, value.toLowerCase().indexOf(CHAR_SET));
                            charsets[0] = String.format("%s;charset=%s", type, c);
                        }
                        charsets[0] = String.valueOf(v);
                    } else {
                        charsets[0] = String.format("%s;charset=%s", value, c);
                    }
                    return charsets[0];
                }
            }
            catch (BaseException e) {
                log.error("contentType error:{}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (HussarUtils.isEmpty((Object)charset)) {
            charset = "UTF-8";
        }
        if (EaiContentType.NONE.getName().equals(contentType)) {
            return null;
        }
        return String.format("%s;charset=%s", contentType, charset);
    }

    private RmiRequestDto formatRmiRequestDto(EaiApiParams eaiApiParams, boolean b) {
        AssertUtil.isNotEmpty((String)eaiApiParams.getUrl(), (String)URL_ERROR);
        AssertUtil.isNotNull((Object)eaiApiParams.getContentType(), (String)CONTENT_TYPE_ERROR);
        RmiRequestDto requestDto = new RmiRequestDto();
        RequestTypeEnum requestTypeEnum = RequestTypeEnum.valueOf((String)eaiApiParams.getRequestType().getType());
        requestDto.setRequestType(requestTypeEnum);
        String url = eaiApiParams.getUrl();
        if (url == null) {
            throw new BaseException(URL_FORMAT_ERROR);
        }
        Map<String, String> path = this.getRequestUrL(url);
        requestDto.setUri(path.get(PATH));
        requestDto.setHost(path.get(HOST));
        requestDto.setPort(Integer.valueOf(path.get(PORT)));
        requestDto.setNeedAuth(b);
        requestDto.setContentType(this.contentType(eaiApiParams.getHeader(), eaiApiParams.getContentType().getName(), eaiApiParams.getCharset().getName()));
        requestDto.setHeader(eaiApiParams.getHeader());
        requestDto.setQuery(HussarUtils.isNotEmpty((Object)eaiApiParams.getQuery()) ? eaiApiParams.getQuery() : new HashMap());
        requestDto.setBody(eaiApiParams.getBody());
        return requestDto;
    }

    private Map<String, String> getRequestUrL(String url) {
        if (HussarUtils.isNotEmpty((Object)url)) {
            HashMap<String, String> map = new HashMap<String, String>();
            String ur = null;
            String schema = SCHEMA_HTTP;
            if (url.startsWith(HTTP)) {
                ur = url.substring(HTTP.length());
                schema = SCHEMA_HTTP;
            } else if (url.startsWith(HTTPS)) {
                ur = url.substring(HTTPS.length());
                schema = SCHEMA_HTTPS;
            }
            if (ur != null) {
                String port;
                String host;
                String uri;
                String path;
                if (ur.contains(DEFAULT_URI_PATH)) {
                    path = ur.substring(0, ur.indexOf(DEFAULT_URI_PATH));
                    uri = ur.substring(ur.indexOf(DEFAULT_URI_PATH), ur.length());
                } else {
                    path = ur;
                    uri = DEFAULT_URI_PATH;
                }
                if (path.contains(SPLIT_CODE)) {
                    host = path.substring(0, path.lastIndexOf(SPLIT_CODE));
                    port = path.substring(path.lastIndexOf(SPLIT_CODE) + 1, path.length());
                } else {
                    host = path;
                    port = DEFAULT_PORT;
                }
                if (HussarUtils.isNotEmpty((Object)host) && HussarUtils.isNotEmpty((Object)port)) {
                    map.put(HOST, host);
                    map.put(PORT, port);
                    map.put(PATH, uri);
                    map.put(SCHEMA, schema);
                    return map;
                }
            }
        }
        throw new BaseException(URL_FORMAT_ERROR);
    }

    private RmiRequestDto formatConvertRmiRequestDto(EaiApiParams eaiApiParams, boolean b) {
        AssertUtil.isNotEmpty((String)eaiApiParams.getUrl(), (String)URL_ERROR);
        AssertUtil.isNotNull((Object)eaiApiParams.getContentType(), (String)CONTENT_TYPE_ERROR);
        RmiRequestDto requestDto = new RmiRequestDto();
        EaiCharsetEnum charset = eaiApiParams.getCharset();
        RequestTypeEnum requestTypeEnum = RequestTypeEnum.valueOf((String)eaiApiParams.getRequestType().getType());
        requestDto.setRequestType(requestTypeEnum);
        Map<String, String> path = this.getRequestUrL(eaiApiParams.getUrl());
        AssertUtil.isNotEmpty(path, (String)URL_FORMAT_ERROR);
        requestDto.setSchema(path.get(SCHEMA));
        requestDto.setUri(path.get(PATH));
        requestDto.setHost(path.get(HOST));
        requestDto.setPort(Integer.valueOf(path.get(PORT)));
        requestDto.setNeedAuth(b);
        requestDto.setContentType(this.contentType(eaiApiParams.getHeader(), eaiApiParams.getContentType().getName(), eaiApiParams.getCharset().getName()));
        Map<String, Object> header = eaiApiParams.getHeader();
        if (HussarUtils.isNotEmpty((Object)header)) {
            header = this.newMap(header);
            Map<String, Object> convertHeader = this.changeCharset(charset, header);
            if (HussarUtils.isNotEmpty(header)) {
                requestDto.setHeader(convertHeader);
            } else {
                requestDto.setHeader(header);
            }
        } else {
            requestDto.setHeader(new HashMap());
        }
        Map<String, Object> query = eaiApiParams.getQuery();
        if (HussarUtils.isNotEmpty((Object)query)) {
            query = this.newMap(query);
            Map<String, Object> convertQuery = this.changeCharset(charset, query);
            if (HussarUtils.isNotEmpty(query)) {
                requestDto.setQuery(convertQuery);
            } else {
                requestDto.setQuery(query);
            }
        } else {
            requestDto.setQuery(new HashMap());
        }
        Object body = eaiApiParams.getBody();
        if (HussarUtils.isNotEmpty((Object)body)) {
            body = this.newBody(body);
            if (EaiContentType.FORM_DATA == eaiApiParams.getContentType() && body instanceof Map) {
                this.getKeyValueBody((Map)body, requestDto);
            } else if (EaiContentType.APPLICATION_JSON.equals((Object)eaiApiParams.getContentType()) && body instanceof String) {
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)body.toString());
                    requestDto.setBody((Object)jsonObject);
                }
                catch (Exception e) {
                    throw new HussarException("\u8f93\u5165\u7684\u5b57\u7b26\u4e32\u4e0d\u662f\u6709\u6548\u7684JSON\u5bf9\u8c61\uff0c\u8bf7\u786e\u4fdd\u8f93\u5165\u7684\u662f\u6b63\u786e\u7684JSON\u683c\u5f0f\u5b57\u7b26\u4e32\u3002", (Throwable)e);
                }
            } else {
                Object convertBody = this.changeCharset(charset, body);
                if (HussarUtils.isNotEmpty((Object)body)) {
                    requestDto.setBody(convertBody);
                } else {
                    requestDto.setBody(body);
                }
            }
        } else {
            requestDto.setBody(new Object());
        }
        return requestDto;
    }

    private void getKeyValueBody(Map<String, Object> body, RmiRequestDto requestDto) {
        LinkedMultiValueMap multiFileMap = new LinkedMultiValueMap();
        HashMap requestBodyMap = Maps.newHashMapWithExpectedSize((int)5);
        for (Map.Entry<String, Object> itMap : body.entrySet()) {
            String key = itMap.getKey();
            Object value = itMap.getValue();
            if (value instanceof List) {
                List valueList = (List)value;
                Iterator itList = valueList.iterator();
                Boolean containsFile = false;
                while (itList.hasNext()) {
                    Object itValue = itList.next();
                    if (!(itValue instanceof MultipartFile)) continue;
                    containsFile = true;
                    multiFileMap.add((Object)key, (Object)((MultipartFile)itValue));
                }
                if (containsFile.booleanValue()) continue;
                requestBodyMap.put(key, value);
                continue;
            }
            if (value instanceof MultipartFile) {
                multiFileMap.add((Object)key, (Object)((MultipartFile)value));
                continue;
            }
            requestBodyMap.put(key, value);
        }
        requestDto.setBody((Object)requestBodyMap);
        if (CollectionUtil.isNotEmpty((Map)multiFileMap)) {
            requestDto.setMultiFileMap((MultiValueMap)multiFileMap);
        }
    }

    private Map<String, Object> newMap(Map<String, Object> map) {
        map.forEach((k, v) -> {
            if (v == null || "null".equals(v)) {
                map.put((String)k, "");
            }
        });
        return map;
    }

    private Object newBody(Object obj) {
        if (HussarUtils.isNull((Object)obj)) {
            return "";
        }
        return obj;
    }

    private Object changeCharset(EaiCharsetEnum charset, Object eaiApiParams) {
        if (HussarUtils.isNotEmpty((Object)charset)) {
            try {
                return this.eaiEncodingService.convertObjectToOthers(eaiApiParams, EaiCharSetUtil.parse((String)charset.getName()));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return eaiApiParams;
            }
        }
        return eaiApiParams;
    }

    private Map<String, Object> changeCharset(EaiCharsetEnum charset, Map<String, Object> eaiApiParams) {
        return this.eaiEncodingService.convertMapToOthers(eaiApiParams, EaiCharSetUtil.charset((String)charset.getName()));
    }
}

