/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.clientpermission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysAppClient;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysAppClientService;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.atomicbase.api.clientpermission.service.IEaiClientPermissionService;
import com.jxdinfo.hussar.eai.common.enums.app.EaiAppResourcesEnum;
import com.jxdinfo.hussar.iam.client.dto.ClientPermissionDto;
import com.jxdinfo.hussar.iam.client.model.SysClientModel;
import com.jxdinfo.hussar.iam.client.model.SysClientPermission;
import com.jxdinfo.hussar.iam.client.service.IHussarIamClientPermissionService;
import com.jxdinfo.hussar.iam.client.service.ISysClientModelService;
import com.jxdinfo.hussar.iam.client.service.ISysClientPermissionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.clientpermission.service.impl.EaiClientPermissionServiceImpl")
public class EaiClientPermissionServiceImpl
implements IEaiClientPermissionService {
    @Resource
    private ISysApplicationService sysApplicationService;
    @Resource
    private ISysAppClientService sysAppClientService;
    @Resource
    private ISysClientPermissionService sysClientPermissionService;
    @Resource
    private ISysClientModelService sysClientModelService;
    @Resource
    private IHussarIamClientPermissionService iamClientPermissionService;

    @HussarTransactional
    public ApiResponse<Boolean> fillDefaultClientPermission() {
        List clientModelIds;
        List clientModelList;
        List appIds;
        List appClientList;
        List<Object> addList = new ArrayList();
        List applicationList = this.sysApplicationService.list((Wrapper)new LambdaQueryWrapper().eq(SysApplication::getAppType, (Object)"6"));
        if (ToolUtil.isNotEmpty((Object)applicationList) && ToolUtil.isNotEmpty((Object)(appClientList = this.sysAppClientService.list((Wrapper)new LambdaQueryWrapper().in(SysAppClient::getAppId, appIds = applicationList.stream().map(SysApplication::getId).collect(Collectors.toList()))))) && ToolUtil.isNotEmpty((Object)(clientModelList = this.sysClientModelService.list((Wrapper)new LambdaQueryWrapper().in(SysClientModel::getId, clientModelIds = appClientList.stream().map(SysAppClient::getClientModelId).collect(Collectors.toList())))))) {
            List<String> clientIds = clientModelList.stream().map(SysClientModel::getClientId).distinct().collect(Collectors.toList());
            addList = this.getAddPermissionList(clientIds);
        }
        if (ToolUtil.isNotEmpty(addList)) {
            return this.iamClientPermissionService.addOrDelClientPermission(addList, new ArrayList());
        }
        return ApiResponse.success();
    }

    private List<ClientPermissionDto> getAddPermissionList(List<String> clientIds) {
        ArrayList<ClientPermissionDto> addList = new ArrayList<ClientPermissionDto>();
        if (ToolUtil.isEmpty(clientIds)) {
            return addList;
        }
        List defaultPermissionIds = EaiAppResourcesEnum.getDefaultResourceIds();
        List currentPermissions = this.sysClientPermissionService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysClientPermission::getClientId, clientIds)).in(SysClientPermission::getPermissionId, (Collection)defaultPermissionIds));
        HashMap<String, ArrayList<Long>> permissionMap = new HashMap<String, ArrayList<Long>>();
        for (SysClientPermission currentPermission : currentPermissions) {
            String clientId = currentPermission.getClientId();
            ArrayList<Long> permissionIds = (ArrayList<Long>)permissionMap.get(clientId);
            if (ToolUtil.isEmpty((Object)permissionIds)) {
                permissionIds = new ArrayList<Long>();
            }
            permissionIds.add(currentPermission.getPermissionId());
            permissionMap.put(clientId, permissionIds);
        }
        for (String clientId : clientIds) {
            List permissionIds = (List)permissionMap.get(clientId);
            for (Long permissionId : defaultPermissionIds) {
                if (ToolUtil.isNotEmpty((Object)permissionIds) && permissionIds.contains(permissionId)) continue;
                ClientPermissionDto clientPermissionDto = new ClientPermissionDto();
                clientPermissionDto.setClientId(clientId);
                clientPermissionDto.setResourceId(permissionId);
                addList.add(clientPermissionDto);
            }
        }
        return addList;
    }
}

