/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.appauth.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.service.ExpressionEngineService;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.service.IHttpTokenAuthVerifyService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.TokenAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.common.service.EaiApiCommonService;
import com.jxdinfo.hussar.eai.atomicbase.api.configuration.service.IEaiConfigurationBuildService;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.service.impl.CommomHttpAuthServiceImpl;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.constant.app.LogLevelConstant;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.applicationrelease.applicationauth.service.impl.EaiHttpTokenAuthVerifyServiceImpl")
public class HttpTokenAuthVerifyServiceImpl
extends CommomHttpAuthServiceImpl
implements IHttpTokenAuthVerifyService {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpTokenAuthVerifyServiceImpl.class);
    @Resource
    private EaiApiCommonService eaiApiCommonService;
    @Resource
    private ExpressionEngineService expressionEngineService;
    @Resource
    private IEaiConfigurationBuildService eaiConfigurationBuildService;
    private static final String GET_TOKEN_STATUS = "GET_TOKEN_STATUS";
    private static final String TOKEN_GETING = "0";
    private static final Long GET_TOKEN_LOADING_TIME = 100L;
    private static final Integer GET_TOKEN_LOADING_MAX_COUNT = 10;
    private static final Object TOKEN_GETING_LOCKED = new Object();

    public ApiResponse<EaiApiResponseVo> tokenVerifyPre(TokenAuthVerifyDto tokenDto) {
        this.setParamsCurrentRequest(tokenDto.getTokenVerifys());
        this.eaiConfigurationBuildService.debugJsonConfiguration(tokenDto.getApplicationCode());
        Map<Long, EaiHttpParamsDto> tokenVerifyMap = this.getAuthParamsMap(tokenDto.getTokenVerifys());
        if (CollectionUtils.isNotEmpty((Collection)tokenDto.getHttpHeaderForStruct())) {
            List<EaiHttpParamsDto> realHttpParamsHeader = this.analysisHttpRequestParamsForStruct(tokenDto.getServiceId(), tokenDto.getHttpHeaderForStruct(), tokenVerifyMap, false);
            tokenDto.setHttpHeader(realHttpParamsHeader);
            this.pushMsg(tokenDto.getServiceId(), "TOKEN\u9274\u6743\u9a8c\u8bc1\uff1aHTTP\u8bf7\u6c42\u5934\u89e3\u6790\u5b8c\u6210", false);
        }
        if (CollectionUtils.isNotEmpty((Collection)tokenDto.getHttpQueryParamForStruct())) {
            List<EaiHttpParamsDto> realHttpParamsQuery = this.analysisHttpRequestParamsForStruct(tokenDto.getServiceId(), tokenDto.getHttpQueryParamForStruct(), tokenVerifyMap, false);
            tokenDto.setHttpQueryParam(realHttpParamsQuery);
            this.pushMsg(tokenDto.getServiceId(), "TOKEN\u9274\u6743\u9a8c\u8bc1\uff1aURL\u67e5\u8be2\u53c2\u6570\u89e3\u6790\u5b8c\u6210", false);
        }
        if (null != tokenDto.getHttpBody() && CollectionUtils.isNotEmpty((Collection)tokenDto.getHttpBody().getAuthHTTPBodyParams())) {
            List<EaiHttpParamsDto> realHttpParamsBody = this.analysisHttpRequestParamsForStruct(tokenDto.getServiceId(), tokenDto.getHttpBody().getAuthHTTPBodyParams(), tokenVerifyMap, false);
            tokenDto.getHttpBody().setBodyParam(realHttpParamsBody);
            this.pushMsg(tokenDto.getServiceId(), "TOKEN\u9274\u6743\u9a8c\u8bc1\uff1aHTTP\u8bf7\u6c42\u4f53\u89e3\u6790\u5b8c\u6210", false);
        }
        return this.tokenVerify(tokenDto, false);
    }

    public ApiResponse<EaiApiResponseVo> tokenVerify(TokenAuthVerifyDto tokenDto, boolean isPublished) {
        EaiApiResponse response;
        EaiApiParams requestParam = this.structureEaiApiParams(tokenDto.getServiceId(), tokenDto.getHttpVerifyBase().getHttpUrl(), tokenDto.getHttpVerifyBase().getHttpUrlType(), tokenDto.getHttpVerifyBase().getHttpMethod(), tokenDto.getHttpBody(), tokenDto.getHttpHeader(), tokenDto.getHttpQueryParam(), isPublished);
        if (tokenDto.isHasCache()) {
            String cacheKey = StringUtil.isNotEmpty((Object)tokenDto.getDebugCacheKey()) ? tokenDto.getDebugCacheKey() : tokenDto.getApplicationCode();
            response = this.sendRequstForToken(cacheKey, tokenDto, isPublished, requestParam);
        } else {
            response = this.sendHttp(requestParam, tokenDto.getServiceId(), isPublished);
        }
        List<Object> eaiParamsItems = Lists.newArrayListWithCapacity((int)10);
        if (null != response) {
            if (null == response.getBody()) {
                return this.tokenRreponseDataPackage(requestParam, response, eaiParamsItems, false);
            }
        } else {
            this.pushMsg(tokenDto.getServiceId(), "TOKEN\u9274\u6743\u9a8c\u8bc1\uff1a\u63a5\u53e3\u54cd\u5e94\u53c2\u6570\u662f\u7a7a", isPublished);
            return this.tokenRreponseDataPackage(requestParam, response, eaiParamsItems, false);
        }
        eaiParamsItems = this.analysisBody(response.getBody());
        return this.checkTokenValue(tokenDto, requestParam, response, eaiParamsItems, isPublished);
    }

    private EaiApiResponse sendRequstForToken(String cacheKey, TokenAuthVerifyDto tokenDto, boolean isPublished, EaiApiParams requestParam) {
        EaiApiResponse response = (EaiApiResponse)HussarCacheUtil.get((String)cacheKey, (Object)cacheKey);
        if (null == response) {
            LOGGER.info("TOKEN\u9274\u6743\u9a8c\u8bc1\uff1a\u4ece\u7f13\u5b58{}-{}\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230TOKEN,\u91cd\u65b0\u53d1\u8d77token\u8bf7\u6c42", (Object)tokenDto.getApplicationCode(), (Object)tokenDto.getApplicationCode());
            this.pushMsg(tokenDto.getServiceId(), "TOKEN\u9274\u6743\u9a8c\u8bc1\uff1a\u4ece\u7f13\u5b58\u4e2d\u6ca1\u6709\u83b7\u53d6\u5230TOKEN\uff0c\u91cd\u65b0\u53d1\u8d77token\u8bf7\u6c42", LogLevelConstant.LOG_LEVEL_INFO, null, isPublished);
            if (StringUtil.isNotEmpty((Object)HussarCacheUtil.get((String)tokenDto.getApplicationCode(), (Object)GET_TOKEN_STATUS)) && TOKEN_GETING.equals(HussarCacheUtil.get((String)tokenDto.getApplicationCode(), (Object)GET_TOKEN_STATUS))) {
                int count = 0;
                while (TOKEN_GETING.equals(HussarCacheUtil.get((String)tokenDto.getApplicationCode(), (Object)GET_TOKEN_STATUS))) {
                    LOGGER.info("TOKEN\u9274\u6743\u9a8c\u8bc1:{}-{},\u5f53\u524dtoken\u72b6\u6001\u4f4d\uff1a{}-\u6b63\u5728\u83b7\u53d6\uff0c\u7b2c{}\u6b21loading", new Object[]{tokenDto.getApplicationCode(), tokenDto.getApplicationCode(), HussarCacheUtil.get((String)tokenDto.getApplicationCode(), (Object)GET_TOKEN_STATUS), count + 1});
                    try {
                        if (count < GET_TOKEN_LOADING_MAX_COUNT) {
                            ++count;
                            Thread.sleep(GET_TOKEN_LOADING_TIME);
                            continue;
                        }
                        LOGGER.info("TOKEN\u9274\u6743\u9a8c\u8bc1:loading\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650{}\u6b21,\u6e05\u7a7a\u7f13\u5b58{}-{}", new Object[]{GET_TOKEN_LOADING_MAX_COUNT, tokenDto.getApplicationCode(), tokenDto.getApplicationCode()});
                        HussarCacheUtil.evict((String)cacheKey, (Object)cacheKey);
                        this.sendTokenHttp(cacheKey, tokenDto, isPublished, requestParam);
                        break;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                response = (EaiApiResponse)HussarCacheUtil.get((String)cacheKey, (Object)cacheKey);
            } else {
                response = this.sendTokenHttp(cacheKey, tokenDto, isPublished, requestParam);
            }
        } else {
            LOGGER.info("TOKEN\u9274\u6743\u9a8c\u8bc1\uff1a\u4ece\u7f13\u5b58{}-{}\u4e2d\u83b7\u53d6\u5230TOKEN", (Object)tokenDto.getApplicationCode(), (Object)tokenDto.getApplicationCode());
        }
        return response;
    }

    @Override
    public Object getRequestBody(List<EaiHttpParamsDto> paramsDtos) {
        if (HussarUtils.isNotEmpty(paramsDtos)) {
            if (paramsDtos.size() == 1) {
                return paramsDtos.get(0).getKeyValue();
            }
            return this.getRequestParamMap(paramsDtos);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EaiApiResponse sendTokenHttp(String cacheKey, TokenAuthVerifyDto tokenDto, boolean isPublished, EaiApiParams requestParam) {
        Object object = TOKEN_GETING_LOCKED;
        synchronized (object) {
            HussarCacheUtil.put((String)cacheKey, (Object)GET_TOKEN_STATUS, (Object)TOKEN_GETING);
            LOGGER.info("TOKEN\u9274\u6743\u9a8c\u8bc1\uff1a{}-{},\u8bbe\u7f6etoken\u72b6\u6001\u4f4d\u4e3a:{}-\u6b63\u5728\u83b7\u53d6\u4e2d...", new Object[]{cacheKey, cacheKey, TOKEN_GETING});
        }
        EaiApiResponse response = this.sendHttp(requestParam, tokenDto.getServiceId(), isPublished);
        HussarCacheUtil.put((String)cacheKey, (Object)cacheKey, (Object)response);
        HussarCacheUtil.evict((String)cacheKey, (Object)GET_TOKEN_STATUS);
        LOGGER.info("TOKEN\u9274\u6743\u9a8c\u8bc1\uff1a{}-{},token\u83b7\u53d6\u5b8c\u6bd5", (Object)cacheKey, (Object)cacheKey);
        return response;
    }

    private ApiResponse<EaiApiResponseVo> checkTokenValue(TokenAuthVerifyDto tokenDto, EaiApiParams requestParam, EaiApiResponse response, List<EaiParamsItems> eaiParamsItems, boolean isPublished) {
        if (tokenDto.isHasCheckTokenValue()) {
            List<EaiParamsPosition> eaiParamsPositions = this.queryAuthParamsPosition(tokenDto.getTemplateId(), "3");
            if (HussarUtils.isEmpty(eaiParamsPositions)) {
                return this.tokenRreponseDataPackage(requestParam, response, eaiParamsItems, false);
            }
            ArrayList expressionParams = Lists.newArrayListWithCapacity((int)10);
            eaiParamsPositions.forEach(position -> {
                List httpParams = JSON.parseArray((String)position.getEffective(), EaiHttpParams.class);
                if (HussarUtils.isNotEmpty((Object)httpParams)) {
                    httpParams = httpParams.stream().filter(p -> TOKEN_GETING.equals(p.getParamsFrom()) && p.getParamsValue().contains("$BODY.")).collect(Collectors.toList());
                    expressionParams.addAll(httpParams);
                }
            });
            Boolean tokenValueIsNull = true;
            if (HussarUtils.isNotEmpty((Object)expressionParams)) {
                for (EaiHttpParams expressionParam : expressionParams) {
                    Map<String, Object> valueMap = this.getValueMap(expressionParam.getParamsValue(), response);
                    Object tokenValue = this.expressionEngineService.executeExpression(expressionParam.getParamsValue(), valueMap, isPublished);
                    if (null != tokenValue) continue;
                    this.pushMsg(tokenDto.getServiceId(), "TOKEN\u9274\u6743\u9a8c\u8bc1,\u89e3\u6790\u9274\u6743\u53c2\u6570\u5931\u8d25\uff1a" + expressionParam.getParamsValue() + "\u89e3\u6790\u503c\u4e3a\u7a7a", isPublished);
                    tokenValueIsNull = false;
                    break;
                }
            }
            if (!tokenValueIsNull.booleanValue()) {
                return this.tokenRreponseDataPackage(requestParam, response, eaiParamsItems, false);
            }
        }
        return this.tokenRreponseDataPackage(requestParam, response, eaiParamsItems, true);
    }

    private EaiApiResponse sendHttp(EaiApiParams requestParam, String serviceId, boolean isPublished) {
        EaiApiResponse response = null;
        LOGGER.info("TOKEN\u9274\u6743\u9a8c\u8bc1\uff1a\u5f00\u59cb\u53d1\u9001HTTP\u8bf7\u6c42...");
        this.pushMsg(serviceId, "TOKEN\u9274\u6743\u9a8c\u8bc1\uff1a\u5f00\u59cb\u53d1\u9001HTTP\u8bf7\u6c42...", isPublished);
        try {
            response = this.eaiApiCommonService.getConvertResponse(requestParam);
            if (null != response.getException()) {
                LOGGER.error("TOKEN\u9274\u6743\u9a8c\u8bc1:" + response.getException());
                this.pushMsg(serviceId, "TOKEN\u9274\u6743\u9a8c\u8bc1\uff1aHTTP\u8bf7\u6c42\u5904\u7406\u5f02\u5e38" + response.getException(), LogLevelConstant.LOG_LEVEL_ERROR, null, isPublished);
                return response;
            }
        }
        catch (Exception e) {
            LOGGER.error("TOKEN\u9274\u6743\u9a8c\u8bc1\u5f02\u5e38", (Throwable)e);
            this.pushMsg(serviceId, "TOKEN\u9274\u6743\u9a8c\u8bc1\uff1aHTTP\u8bf7\u6c42\u5904\u7406\u5f02\u5e38", LogLevelConstant.LOG_LEVEL_ERROR, null, isPublished);
            return null;
        }
        this.pushMsg(serviceId, "TOKEN\u9274\u6743\u9a8c\u8bc1\uff1aHTTP\u8bf7\u6c42\u5b8c\u6210", isPublished);
        return response;
    }

    public ApiResponse<EaiApiResponseVo> tokenVerifyResultParams(TokenAuthVerifyDto tokenDto, boolean isPublished) {
        ApiResponse<EaiApiResponseVo> tokenVerifyApiResponse = this.tokenVerify(tokenDto, isPublished);
        if (!tokenVerifyApiResponse.isSuccess()) {
            this.pushMsg(tokenDto.getServiceId(), "\u83b7\u53d6TOKEN\u5931\u8d25", LogLevelConstant.LOG_LEVEL_WARN, null, isPublished);
            return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)tokenVerifyApiResponse.getData(), (String)"\u83b7\u53d6TOKEN\u5931\u8d25");
        }
        EaiApiResponse response = ((EaiApiResponseVo)tokenVerifyApiResponse.getData()).getTokenResponse();
        List items = ((EaiApiResponseVo)tokenVerifyApiResponse.getData()).getTokenHttpResult();
        EaiApiResponseVo responseVo = (EaiApiResponseVo)tokenVerifyApiResponse.getData();
        responseVo.setTokenResponse(response);
        responseVo.setTokenHttpResult(items);
        return ApiResponse.success((Object)responseVo);
    }

    public ApiResponse<EaiApiResponseVo> tokenRreponseDataPackage(EaiApiParams requestParam, EaiApiResponse response, List<EaiParamsItems> eaiParamsItems, Boolean tokenVerfiy) {
        EaiApiResponseVo responseVo = new EaiApiResponseVo();
        Map<String, Object> tokenRequestMap = this.requestParamsPackage(requestParam);
        responseVo.setTokenRequestParams(tokenRequestMap);
        responseVo.setTokenResponse(response);
        responseVo.setTokenHttpResult(eaiParamsItems);
        if (tokenVerfiy.booleanValue()) {
            return ApiResponse.success((Object)responseVo);
        }
        return ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)responseVo, (String)"\u83b7\u53d6TOKEN\u5931\u8d25\uff01");
    }

    private List<EaiParamsItems> analysisBody(Object body) {
        ArrayList templates = Lists.newArrayListWithCapacity((int)10);
        if (null != body && body instanceof JSONObject) {
            HttpTokenAuthVerifyServiceImpl.analysisJsonObject((JSONObject)body, templates);
        }
        return templates;
    }

    public static void analysisJsonObject(JSONObject jsonObject, List<EaiParamsItems> templates) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            EaiParamsItems t = new EaiParamsItems();
            t.setName((String)entry.getKey());
            if (entry.getValue() instanceof JSONArray) {
                Object obT = ((JSONArray)entry.getValue()).get(0);
                t.setType(Integer.valueOf(EaiDataType.DATA_TYPE_LIST.getType()));
                if (obT instanceof JSONObject) {
                    ArrayList tt = Lists.newArrayListWithCapacity((int)10);
                    HttpTokenAuthVerifyServiceImpl.analysisJsonObject((JSONObject)obT, tt);
                    t.setItems((List)tt);
                } else {
                    t.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRING.getType()));
                }
            } else if (entry.getValue() instanceof JSONObject) {
                t.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                ArrayList tt = Lists.newArrayListWithCapacity((int)10);
                HttpTokenAuthVerifyServiceImpl.analysisJsonObject((JSONObject)entry.getValue(), tt);
            } else {
                t.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRING.getType()));
            }
            templates.add(t);
        }
    }
}

