/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.appauth.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiCallSpecificationInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpVerifyBase;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpExtendService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpParamsService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpTemplateService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpVerifyBaseService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiParamsPositionService;
import com.jxdinfo.hussar.eai.appinfo.server.common.EaiAppEditManager;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.AuthHTTPBodyParams;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpTemplateDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.TokenAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.factory.EaiHttpAuthenticationFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpParamsPackageVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpTemplateVo;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonStructureService;
import com.jxdinfo.hussar.eai.atomicbase.api.resourcerelation.service.EaiAppStatusBaseService;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.LogMsgConstant;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.service.impl.CommomHttpAuthServiceImpl;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.constant.app.LogLevelConstant;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.enums.app.HttpAuthTypeEnum;
import com.jxdinfo.hussar.eai.common.util.ExpressionRegUtil;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineMethod;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineService;
import com.jxdinfo.hussar.support.engine.core.enums.DataServiceType;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;

@EngineService(value="com.jxdinfo.hussar.eai.common.server.applicationrelease.applicationauth.service.impl.IEaiHttpTemplateAuthServiceImpl", type=DataServiceType.PERMANENT, des="\u63a5\u53e3\u8c03\u7528service")
public class HttpAuthServiceImpl<T extends EaiHttpAuthDto>
extends CommomHttpAuthServiceImpl
implements IHttpAuthenticationService<T> {
    @Resource
    private IEaiHttpParamsService httpParamsService;
    @Resource
    private EaiAppStatusBaseService eaiAppStatusService;
    @Resource
    private IApiCallSpecificationInfoService apiCallSpecificationInfoService;
    @Resource
    protected IEaiHttpExtendService httpExtendService;
    @Resource
    private IEaiHttpTemplateService templateService;
    @Resource
    private IEaiHttpVerifyBaseService httpVerifyBaseService;
    @Resource
    protected EaiCommonStructureService eaiCommonStructureService;
    @Resource
    protected IEaiApplicationAuthService eaiApplicationAuthService;
    @Resource
    private IEaiParamsPositionService eaiParamsPositionService;

    @HussarTransactional
    public ApiResponse<Long> httpAuthSave(HttpAuthDto tokenDto) {
        JSONObject first = (JSONObject)tokenDto.getHttpAuth().get(0);
        EaiHttpTemplateDto templateDto = (EaiHttpTemplateDto)JSONObject.parseObject((String)first.toJSONString(), EaiHttpTemplateDto.class);
        EaiHttpTemplate eaiHttpTemplateOld = this.getEaiHttpTemplate(templateDto.getApplicationCode());
        if (null != eaiHttpTemplateOld) {
            EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplateOld.getHttpType()).getAuthKey()).httpAuthEdit(tokenDto, eaiHttpTemplateOld, templateDto);
            this.eaiAppStatusService.resetStatus(eaiHttpTemplateOld.getApplicationCode());
        }
        EaiAppEditManager.getInstance().call(templateDto.getApplicationCode());
        return EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)templateDto.getHttpType()).getAuthKey()).httpAuthInfoSave(tokenDto);
    }

    @EngineMethod(des="\u63a5\u53e3\u8c03\u7528", paramDes={"HttpAuthVerifyDto"}, returnDes="ApiResponse<EaiApiResponseVo>")
    public ApiResponse<EaiApiResponseVo> apiInvoke(HttpAuthVerifyDto authVerifyDto) {
        authVerifyDto.setHasCache(true);
        EaiHttpTemplate eaiHttpTemplate = this.getPublishEaiHttpTemplate(authVerifyDto.getApplicationCode());
        if (null == eaiHttpTemplate) {
            return EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.HTTPTYPE_NOAUTH.getAuthKey()).httpAuthVerify(authVerifyDto, true, 0);
        }
        authVerifyDto.setEaiHttpTemplate(eaiHttpTemplate);
        return EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getHttpType()).getAuthKey()).httpAuthVerify(authVerifyDto, true, 0);
    }

    public ApiResponse<EaiApiResponseVo> httpAuthVerifyPre(HttpAuthVerifyDto authVerifyDto, boolean isPublished) {
        this.setParamsCurrentRequest(authVerifyDto.getTokenVerifys());
        Map<Long, EaiHttpParamsDto> tokenVerifyMap = this.getAuthParamsMap(authVerifyDto.getTokenVerifys());
        if (CollectionUtils.isNotEmpty((Collection)authVerifyDto.getHttpHeaderForStruct())) {
            List<EaiHttpParamsDto> realHttpParamsHeader = this.analysisHttpRequestParamsForStruct(authVerifyDto.getServiceId(), authVerifyDto.getHttpHeaderForStruct(), tokenVerifyMap, isPublished);
            authVerifyDto.setHttpHeader(realHttpParamsHeader);
            this.pushMsg(authVerifyDto.getServiceId(), "HTTP\u9274\u6743\u9a8c\u8bc1\uff1aHTTP\u8bf7\u6c42\u5934\u89e3\u6790\u5b8c\u6210", isPublished);
        }
        if (CollectionUtils.isNotEmpty((Collection)authVerifyDto.getHttpQueryParamForStruct())) {
            List<EaiHttpParamsDto> realHttpParamsQuery = this.analysisHttpRequestParamsForStruct(authVerifyDto.getServiceId(), authVerifyDto.getHttpQueryParamForStruct(), tokenVerifyMap, isPublished);
            authVerifyDto.setHttpQueryParam(realHttpParamsQuery);
            this.pushMsg(authVerifyDto.getServiceId(), "HTTP\u9274\u6743\u9a8c\u8bc1\uff1aURL\u67e5\u8be2\u53c2\u6570\u89e3\u6790\u5b8c\u6210", isPublished);
        }
        if (null != authVerifyDto.getHttpBody() && CollectionUtils.isNotEmpty((Collection)authVerifyDto.getHttpBody().getAuthHTTPBodyParams())) {
            List<EaiHttpParamsDto> bodyParamT = this.analysisHttpRequestParamsForStruct(authVerifyDto.getServiceId(), authVerifyDto.getHttpBody().getAuthHTTPBodyParams(), tokenVerifyMap, isPublished);
            if (EaiContentType.FORM_DATA.getType() == Integer.valueOf(authVerifyDto.getHttpBody().getContentType()).intValue()) {
                authVerifyDto.getHttpBody().setBodyParam(bodyParamT);
            } else if (EaiContentType.APPLICATION_JSON.getType() == Integer.valueOf(authVerifyDto.getHttpBody().getContentType()).intValue() && bodyParamT.size() == 1 && bodyParamT.get(0).getKeyValue() instanceof HashMap) {
                ArrayList bodyParamRealList = Lists.newArrayListWithCapacity((int)5);
                Map keyValueMap = (Map)bodyParamT.get(0).getKeyValue();
                keyValueMap.forEach((k, v) -> {
                    EaiHttpParamsDto bodyParamReal = new EaiHttpParamsDto();
                    bodyParamReal.setParamsNameEn(k);
                    bodyParamReal.setKeyValue(v);
                    bodyParamRealList.add(bodyParamReal);
                });
                authVerifyDto.getHttpBody().setBodyParam((List)bodyParamRealList);
            }
            this.pushMsg(authVerifyDto.getServiceId(), "HTTP\u9274\u6743\u9a8c\u8bc1\uff1aBODY\u53c2\u6570\u89e3\u6790\u5b8c\u6210", isPublished);
        }
        return this.httpAuthVerify(authVerifyDto, isPublished);
    }

    public ApiResponse authParamsUniquenessValidationForStruct(TokenAuthVerifyDto authVerifyDto) {
        List bodyParam;
        List httpHeader = authVerifyDto.getHttpHeaderForStruct();
        this.authParamsCheckForStruct(httpHeader, "HTTP\u8bf7\u6c42\u5934");
        List httpQueryParam = authVerifyDto.getHttpQueryParamForStruct();
        this.authParamsCheckForStruct(httpQueryParam, "URL\u67e5\u8be2\u53c2\u6570");
        if (null != authVerifyDto.getHttpBody() && CollectionUtil.isNotEmpty((Collection)(bodyParam = authVerifyDto.getHttpBody().getAuthHTTPBodyParams()))) {
            List itemsParams = ((AuthHTTPBodyParams)bodyParam.get(0)).getItems();
            this.authParamsCheckForBody(itemsParams, "HTTP\u8bf7\u6c42\u4f53");
        }
        return ApiResponse.success();
    }

    @EngineMethod(des="http\u9274\u6743\u9a8c\u8bc1", paramDes={"HttpAuthVerifyDto"}, returnDes="ApiResponse<EaiApiResponseVo>")
    public ApiResponse<EaiApiResponseVo> httpAuthVerify(HttpAuthVerifyDto authVerifyDto, boolean isPublished) {
        this.pushMsg(authVerifyDto.getServiceId(), "\u5f00\u59cb\u8fdb\u884c\u63a5\u53e3\u9a8c\u8bc1", LogLevelConstant.LOG_LEVEL_INFO, null, isPublished);
        EaiHttpTemplate eaiHttpTemplate = this.getEaiHttpTemplateByPublishFlag(authVerifyDto.getApplicationCode(), isPublished);
        if (null == eaiHttpTemplate) {
            this.pushMsg(authVerifyDto.getServiceId(), "\u83b7\u53d6\u9274\u6743\u6a21\u677f:\u3010\u65e0\u9274\u6743\u3011", LogLevelConstant.LOG_LEVEL_INFO, null, isPublished);
            return EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.HTTPTYPE_NOAUTH.getAuthKey()).httpAuthVerify(authVerifyDto, isPublished, 0);
        }
        authVerifyDto.setEaiHttpTemplate(eaiHttpTemplate);
        this.pushMsg(authVerifyDto.getServiceId(), "\u83b7\u53d6\u9274\u6743\u6a21\u677f:\u3010" + LogMsgConstant.getType(eaiHttpTemplate.getHttpType()) + "\u3011", LogLevelConstant.LOG_LEVEL_INFO, null, isPublished);
        return EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getHttpType()).getAuthKey()).httpAuthVerify(authVerifyDto, isPublished, 0);
    }

    public ApiResponse<EaiHttpTemplateVo> httpAuthDetail(String applicationCode) {
        EaiHttpTemplate eaiHttpTemplate = this.getEaiHttpTemplateContainDisable(applicationCode);
        if (null == eaiHttpTemplate) {
            return ApiResponse.success();
        }
        EaiHttpTemplateVo templateVo = new EaiHttpTemplateVo();
        BeanUtil.copy((Object)eaiHttpTemplate, (Object)templateVo);
        return EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getHttpType()).getAuthKey()).httpAuthDetail(templateVo);
    }

    public ApiResponse<EaiHttpTemplateVo> httpAuthVerfiyDetail(String applicationCode, Boolean publish) {
        EaiHttpTemplate eaiHttpTemplate = this.getEaiHttpTemplateByPublishFlag(applicationCode, publish);
        if (null == eaiHttpTemplate) {
            return ApiResponse.success();
        }
        EaiHttpExtend finalStep = this.getFinalStep(eaiHttpTemplate);
        if (null == finalStep) {
            return ApiResponse.success();
        }
        EaiHttpVerifyBase httpVerifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)finalStep.getExtendId()));
        if (null == httpVerifyBase) {
            return ApiResponse.success();
        }
        List params = this.httpParamsService.list((Wrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)httpVerifyBase.getHttpBaseId()));
        List<EaiHttpParams> header = params.stream().filter(p -> "0".equals(p.getParamsPosition())).collect(Collectors.toList());
        List<EaiHttpParams> body = params.stream().filter(p -> "1".equals(p.getParamsPosition())).collect(Collectors.toList());
        List<EaiHttpParams> query = params.stream().filter(p -> "2".equals(p.getParamsPosition())).collect(Collectors.toList());
        List<EaiHttpParams> authParams = params.stream().filter(p -> "3".equals(p.getParamsPosition())).collect(Collectors.toList());
        Map<Long, CommonConstant> commonConstantsMap = this.getCommonConstantsMap(eaiHttpTemplate.getApplicationCode(), publish);
        Map<Long, EaiApplicationAuth> applicationAuthMap = this.getEaiApplicationAuthMap(eaiHttpTemplate.getApplicationCode());
        EaiHttpParamsPackageVo paramsVo = this.getEaiHttpParams(header, body, query, commonConstantsMap, applicationAuthMap, authParams, httpVerifyBase.getContentType());
        EaiHttpTemplateVo templateVo = new EaiHttpTemplateVo();
        if (StringUtil.isEmpty((Object)httpVerifyBase.getHttpUrlType())) {
            httpVerifyBase.setHttpUrlType("0");
        }
        templateVo.setAuthVerify(httpVerifyBase);
        templateVo.setEaiHttpParams(paramsVo);
        templateVo.setApplicationCode(applicationCode);
        List specificationInfoDtos = this.apiCallSpecificationInfoService.selectCallInfoListByApiId(eaiHttpTemplate.getTemplateId());
        templateVo.setCallSpecificaList(specificationInfoDtos);
        return ApiResponse.success((Object)templateVo);
    }

    private EaiHttpExtend getFinalStep(EaiHttpTemplate eaiHttpTemplate) {
        EaiHttpExtend finalStep = this.getCertainStepByTemplateId(eaiHttpTemplate.getTemplateId(), "9");
        return finalStep;
    }

    @HussarTransactional
    public ApiResponse<Boolean> httpAuthVerifySave(HttpAuthVerifyDto authVerifyDto) {
        if (HussarUtils.isNotEmpty((Object)authVerifyDto.getAddCommonStructureList())) {
            boolean flag;
            List addCommonStructureList = authVerifyDto.getAddCommonStructureList();
            List cacheStruct = addCommonStructureList.stream().filter(c -> true == c.isCacheFlag()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(cacheStruct) && cacheStruct.size() > 1) {
                throw new BaseException("\u4fdd\u5b58\u7684\u6570\u636e\u7ed3\u6784\u9519\u8bef\uff01");
            }
            if (CollectionUtil.isNotEmpty(cacheStruct) && cacheStruct.size() == 1) {
                addCommonStructureList.forEach(a -> {
                    if (a.isCacheFlag()) {
                        String outBodyStructId = String.valueOf(EngineUtil.getId());
                        a.setId(outBodyStructId);
                        ((AuthHTTPBodyParams)authVerifyDto.getHttpBody().getAuthHTTPBodyParams().get(0)).setQuoteStructureId(outBodyStructId);
                        this.eaiCommonStructureService.saveStructure(a);
                    }
                });
            }
            if (!(flag = this.eaiCommonStructureService.saveBatchStructure(addCommonStructureList).booleanValue())) {
                throw new HussarException("\u65b0\u589e\u5931\u8d25");
            }
        }
        EaiHttpTemplate eaiHttpTemplate = this.getEaiHttpTemplate(authVerifyDto.getApplicationCode());
        String stepCodeCurrent = "9";
        this.deleteInfo(authVerifyDto.getApplicationCode(), stepCodeCurrent);
        EaiHttpExtend extend = new EaiHttpExtend();
        extend.setExtendId(Long.valueOf(IdWorker.getId((Object)new EaiHttpExtend())));
        extend.setStepCode(stepCodeCurrent);
        extend.setRemark("http\u9274\u6743\u9a8c\u8bc1\u4fdd\u5b58");
        extend.setTemplateId(eaiHttpTemplate.getTemplateId());
        this.httpExtendService.save((Object)extend);
        EaiHttpVerifyBase httpVerifyBase = this.insertHttpVerify(authVerifyDto.getHttpUrl(), authVerifyDto.getHttpUrlType(), authVerifyDto.getHttpBody(), extend.getExtendId(), authVerifyDto.getHttpMethod());
        ArrayList httpParams = Lists.newArrayListWithCapacity((int)10);
        this.getHttpParamsForStruct(httpParams, authVerifyDto.getHttpHeaderForStruct(), "0", httpVerifyBase);
        this.getHttpParamsForStruct(httpParams, authVerifyDto.getHttpQueryParamForStruct(), "2", httpVerifyBase);
        if (null != authVerifyDto.getHttpBody()) {
            this.getHttpParamsForStruct(httpParams, authVerifyDto.getHttpBody().getAuthHTTPBodyParams(), "1", httpVerifyBase);
        }
        this.getHttpParams(httpParams, authVerifyDto.getTokenVerifys(), "3", httpVerifyBase);
        this.httpParamsService.saveBatch((Collection)httpParams);
        this.saveCallInfo(authVerifyDto, eaiHttpTemplate);
        if (HussarUtils.isNotEmpty((Object)authVerifyDto.getCallSpecificaList())) {
            EaiHttpTemplate templateUpdate = new EaiHttpTemplate();
            templateUpdate.setTemplateId(eaiHttpTemplate.getTemplateId());
            templateUpdate.setTemplateType("0");
            this.templateService.updateById((Object)templateUpdate);
        }
        EaiAppEditManager.getInstance().call(authVerifyDto.getApplicationCode());
        return ApiResponse.success();
    }

    protected void saveCallInfo(HttpAuthVerifyDto authVerifyDto, EaiHttpTemplate eaiHttpTemplate) {
        this.apiCallSpecificationInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(ApiCallSpecificationInfo::getApiId, (Object)eaiHttpTemplate.getTemplateId()));
        List specificaList = authVerifyDto.getCallSpecificaList();
        if (HussarUtils.isNotEmpty((Object)specificaList)) {
            ArrayList infoList = Lists.newArrayListWithExpectedSize((int)10);
            specificaList.forEach(s -> {
                s.setApiId(eaiHttpTemplate.getTemplateId());
                s.setSpecificatId(Long.valueOf(IdWorker.getId((Object)new ApiCallSpecificationInfo())));
                ApiCallSpecificationInfo callSpecificationInfo = new ApiCallSpecificationInfo();
                BeanUtil.copy((Object)s, (Object)callSpecificationInfo);
                infoList.add(callSpecificationInfo);
            });
            this.apiCallSpecificationInfoService.saveBatch((Collection)infoList);
        }
    }

    private void deleteInfo(String applicationCode, String stepCodeCurrent) {
        EaiHttpExtend eaiHttpExtend;
        EaiHttpTemplate eaiHttpTemplateOld = this.getEaiHttpTemplate(applicationCode);
        if (null != eaiHttpTemplateOld && null != (eaiHttpExtend = (EaiHttpExtend)this.httpExtendService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)eaiHttpTemplateOld.getTemplateId())).eq(EaiHttpExtend::getStepCode, (Object)stepCodeCurrent)))) {
            EaiHttpVerifyBase httpVerifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)eaiHttpExtend.getExtendId()));
            this.httpParamsService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)httpVerifyBase.getHttpBaseId()));
            this.httpVerifyBaseService.removeById((Serializable)httpVerifyBase.getExtendId());
            this.httpExtendService.removeById((Serializable)eaiHttpExtend.getExtendId());
        }
    }

    public ApiResponse authParamsUniquenessValidation(TokenAuthVerifyDto authVerifyDto) {
        List httpHeader = authVerifyDto.getHttpHeader();
        this.authParamsCheck(httpHeader, "HTTP\u8bf7\u6c42\u5934");
        List httpQueryParam = authVerifyDto.getHttpQueryParam();
        this.authParamsCheck(httpQueryParam, "URL\u67e5\u8be2\u53c2\u6570");
        if (null != authVerifyDto.getHttpBody()) {
            List bodyParam = authVerifyDto.getHttpBody().getBodyParam();
            this.authParamsCheck(bodyParam, "HTTP\u8bf7\u6c42\u5934");
        }
        return ApiResponse.success();
    }

    public ApiResponse<T> selectHttpTemplateInfos(String applicationCode, boolean published) {
        EaiHttpTemplate eaiHttpTemplate = this.getNotNullEaiHttpTemplate(applicationCode);
        if (eaiHttpTemplate == null) {
            return ApiResponse.success();
        }
        return EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getHttpType()).getAuthKey()).selectHttpTemplateInfos(applicationCode, published);
    }

    public ApiResponse<T> selectHttpTemplateInfosWithNewIds(String applicationCode) {
        EaiHttpTemplate eaiHttpTemplate = this.getNotNullEaiHttpTemplate(applicationCode);
        if (eaiHttpTemplate == null) {
            return ApiResponse.success();
        }
        return EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getHttpType()).getAuthKey()).selectHttpTemplateInfosWithNewIds(applicationCode, Boolean.valueOf(false));
    }

    public ApiResponse<T> selectHttpTemplateInfosPublishingWithNewIds(String applicationCode) {
        EaiHttpTemplate eaiHttpTemplate = this.getEaiHttpTemplatePublishing(applicationCode);
        return EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getHttpType()).getAuthKey()).selectHttpTemplateInfosWithNewIds(applicationCode, Boolean.valueOf(true));
    }

    public ApiResponse<Boolean> saveHttpTemplateInfos(T eaiHttpAuthDto) {
        return EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpAuthDto.getEaiHttpTemplate().getHttpType()).getAuthKey()).saveHttpTemplateInfos(eaiHttpAuthDto);
    }

    public ApiResponse<Boolean> updateHttpTemplateInfos(T eaiHttpAuthDto) {
        return EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpAuthDto.getEaiHttpTemplate().getHttpType()).getAuthKey()).updateHttpTemplateInfos(eaiHttpAuthDto);
    }

    public boolean authParamsValueClean(EaiApplicationAuth authParams, Long authParamId) {
        EaiHttpTemplate eaiHttpTemplate = this.getEaiHttpTemplate(authParams.getApplicationCode());
        if (null != eaiHttpTemplate) {
            EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getHttpType()).getAuthKey()).authParamsValueCleanImpl(eaiHttpTemplate, authParamId);
        }
        return false;
    }

    public ApiResponse<String> verifyAuthParamHasUse(EaiApplicationAuth authParams, Long authParamsId) {
        EaiHttpTemplate eaiHttpTemplate = this.getEaiHttpTemplate(authParams.getApplicationCode());
        if (null != eaiHttpTemplate) {
            try {
                boolean flag = EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getHttpType()).getAuthKey()).verifyAuthParamHasUse(eaiHttpTemplate, authParamsId, "2");
                if (flag) {
                    return ApiResponse.success((Object)"\u6b64\u53c2\u6570\u5df2\u5728\u5e94\u7528\u9274\u6743\u4e2d\u4f7f\u7528\uff0c\u8bf7\u5c3d\u5feb\u4fee\u6539!", (String)"");
                }
                return ApiResponse.success();
            }
            catch (Exception e) {
                return ApiResponse.success((Object)"\u6b64\u53c2\u6570\u5df2\u5728\u5e94\u7528\u9274\u6743\u4e2d\u4f7f\u7528\uff0c\u8bf7\u5c3d\u5feb\u4fee\u6539!", (String)"");
            }
        }
        return ApiResponse.success();
    }

    public ApiResponse<String> verifyCommonParamsHasUse(CommonConstant commonParams, Long commonParamId) {
        EaiHttpTemplate eaiHttpTemplate = this.getEaiHttpTemplate(commonParams.getApplicationCode());
        if (null != eaiHttpTemplate) {
            try {
                boolean flag = EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getHttpType()).getAuthKey()).verifyAuthParamHasUse(eaiHttpTemplate, commonParamId, "1");
                if (flag) {
                    return ApiResponse.success((Object)("\u5220\u9664\u5931\u8d25\uff01\u5e38\u91cf\u201c" + commonParams.getConstantName() + "\u201d\u5df2\u5728\u5e94\u7528\u9274\u6743\u4e2d\u4f7f\u7528"), (String)"");
                }
                return ApiResponse.success();
            }
            catch (Exception e) {
                return ApiResponse.success((Object)("\u5220\u9664\u5931\u8d25\uff01\u5e38\u91cf\u201c" + commonParams.getConstantName() + "\u201d\u5df2\u5728\u5e94\u7528\u9274\u6743\u4e2d\u4f7f\u7528"), (String)"");
            }
        }
        return ApiResponse.success();
    }

    @HussarTransactional
    public ApiResponse<Boolean> deleteAuthParamsByAppcode(String appCode) {
        EaiHttpTemplate eaiHttpTemplatePublish;
        EaiHttpTemplate eaiHttpTemplate = this.getEaiHttpTemplate(appCode);
        if (null != eaiHttpTemplate) {
            EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplate.getHttpType()).getAuthKey()).httpAuthEdit(null, eaiHttpTemplate, null);
        }
        if (null != (eaiHttpTemplatePublish = this.getPublishEaiHttpTemplate(appCode))) {
            EaiHttpAuthenticationFactory.getInvokeAuth((String)HttpAuthTypeEnum.getHttpAuthTypeEnum((String)eaiHttpTemplatePublish.getHttpType()).getAuthKey()).httpAuthEdit(null, eaiHttpTemplatePublish, null);
        }
        return ApiResponse.success();
    }

    public void authParamsCheckForStruct(List<AuthHTTPBodyParams> paramsDtos, String tip) {
        if (HussarUtils.isNotEmpty(paramsDtos)) {
            List paramsName = paramsDtos.stream().map(AuthHTTPBodyParams::getName).collect(Collectors.toList());
            HashSet paramsNameSet = Sets.newHashSetWithExpectedSize((int)10);
            for (String paramName : paramsName) {
                if (paramsNameSet.contains(paramName)) {
                    throw new BaseException(tip + "\u4e2d\uff0c\u53c2\u6570\u540d\u79f0 " + paramName + " \u91cd\u590d");
                }
                paramsNameSet.add(paramName);
            }
        }
    }

    public void authParamsCheck(List<EaiHttpParamsDto> paramsDtos, String tip) {
        if (HussarUtils.isNotEmpty(paramsDtos)) {
            List paramsName = paramsDtos.stream().map(EaiHttpParamsDto::getParamsNameEn).collect(Collectors.toList());
            HashSet paramsNameSet = Sets.newHashSetWithExpectedSize((int)10);
            for (String paramName : paramsName) {
                if (paramsNameSet.contains(paramName)) {
                    throw new BaseException(tip + "\u4e2d\uff0c\u53c2\u6570\u540d\u79f0 " + paramName + " \u91cd\u590d");
                }
                paramsNameSet.add(paramName);
            }
        }
    }

    public void authParamsCheckForStructName(List<AuthHTTPBodyParams> paramsDtos, String tip) {
        if (HussarUtils.isNotEmpty(paramsDtos)) {
            List paramsName = paramsDtos.stream().map(AuthHTTPBodyParams::getName).collect(Collectors.toList());
            HashSet paramsNameSet = Sets.newHashSetWithExpectedSize((int)10);
            for (String paramName : paramsName) {
                if (paramsNameSet.contains(paramName)) {
                    throw new BaseException(tip + "\u4e2d\uff0c\u53c2\u6570\u540d\u79f0 " + paramName + " \u91cd\u590d");
                }
                paramsNameSet.add(paramName);
            }
        }
    }

    public void authParamsCheckForBody(List<AuthHTTPBodyParams> paramsDtos, String tip) {
        if (HussarUtils.isNotEmpty(paramsDtos)) {
            this.authParamsCheckForStructName(paramsDtos, tip);
            for (AuthHTTPBodyParams param : paramsDtos) {
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == param.getType().intValue()) {
                    this.authParamsCheckForBody(param.getItems(), tip);
                    continue;
                }
                if (EaiDataType.DATA_TYPE_LIST.getType() != param.getType().intValue()) continue;
                AuthHTTPBodyParams paramItem = (AuthHTTPBodyParams)param.getItems().get(0);
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() != paramItem.getType().intValue()) continue;
                this.authParamsCheckForBody(paramItem.getItems(), tip);
            }
        }
    }

    public ApiResponse<Boolean> expCompatibleOldData() {
        LambdaQueryWrapper httpTemplateQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiHttpTemplate::getHttpType, Arrays.asList("1", "3"));
        List httpTemplateList = this.templateService.list((Wrapper)httpTemplateQueryWrapper);
        if (CollectionUtil.isEmpty((Collection)httpTemplateList)) {
            return ApiResponse.success((Object)true);
        }
        for (EaiHttpTemplate httpTemplate : httpTemplateList) {
            EaiHttpExtend finalHttpExtends;
            List extendList = this.httpExtendService.list((Wrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)httpTemplate.getTemplateId()));
            Map<String, EaiHttpExtend> extendMap = extendList.stream().collect(Collectors.toMap(EaiHttpExtend::getStepCode, Function.identity()));
            if ("1".equals(httpTemplate.getHttpType())) {
                EaiHttpVerifyBase eaiHttpVerifyBaseOld = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)((EaiHttpExtend)extendMap.get("2")).getExtendId())).isNull(EaiHttpVerifyBase::getHttpUrlType));
                if (null != eaiHttpVerifyBaseOld) {
                    this.httpInfoHandle(eaiHttpVerifyBaseOld);
                    this.changeParamsValuePosition(extendMap, "3");
                }
            } else if ("3".equals(httpTemplate.getHttpType())) {
                this.changeParamsValuePosition(extendMap, "2");
            }
            if (null == (finalHttpExtends = (EaiHttpExtend)extendMap.get("9"))) continue;
            EaiHttpVerifyBase eaiHttpVerifyBaseOld = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)finalHttpExtends.getExtendId())).isNull(EaiHttpVerifyBase::getHttpUrlType));
            this.httpInfoHandle(eaiHttpVerifyBaseOld);
        }
        return ApiResponse.success((Object)true);
    }

    public ApiResponse<Boolean> httpAuthVerfiyConfigFlag(String applicationCode, Boolean publish) {
        EaiHttpTemplate eaiHttpTemplate = this.getEaiHttpTemplateByPublishFlag(applicationCode, publish);
        if (null == eaiHttpTemplate) {
            return ApiResponse.success((Object)false);
        }
        EaiHttpExtend finalStep = this.getFinalStep(eaiHttpTemplate);
        if (null == finalStep) {
            return ApiResponse.success((Object)false);
        }
        return ApiResponse.success((Object)true);
    }

    private void httpInfoHandle(EaiHttpVerifyBase eaiHttpVerifyBaseOld) {
        if (null == eaiHttpVerifyBaseOld) {
            return;
        }
        eaiHttpVerifyBaseOld.setHttpUrlType("0");
        this.httpVerifyBaseService.updateById((Object)eaiHttpVerifyBaseOld);
        List httpParamList = this.httpParamsService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)eaiHttpVerifyBaseOld.getHttpBaseId())).in(EaiHttpParams::getParamsFrom, Arrays.asList("0", null, "")));
        if (CollectionUtil.isNotEmpty((Collection)httpParamList)) {
            for (EaiHttpParams httpParams : httpParamList) {
                AuthHTTPBodyParams newParam = null;
                try {
                    newParam = (AuthHTTPBodyParams)JSON.parseObject((String)httpParams.getParamsValue(), AuthHTTPBodyParams.class);
                    if (StringUtil.isNotEmpty((Object)httpParams.getParamsFrom())) {
                        newParam.setParamsValue("\"" + newParam.getParamsValue() + "\"");
                    } else {
                        this.recursionChangeParamsValue(newParam);
                    }
                    httpParams.setParamsValue(JSON.toJSONString((Object)newParam));
                    this.httpParamsService.updateById((Object)httpParams);
                }
                catch (Exception e) {
                    httpParams.setParamsValue("\"" + httpParams.getParamsValue() + "\"");
                    this.httpParamsService.updateById((Object)httpParams);
                }
            }
        }
    }

    private void changeParamsValuePosition(Map<String, EaiHttpExtend> extendMap, String stepcod) {
        List positionList = this.eaiParamsPositionService.list((Wrapper)new LambdaQueryWrapper().eq(EaiParamsPosition::getExtendId, (Object)extendMap.get(stepcod).getExtendId()));
        for (EaiParamsPosition position : positionList) {
            List params = JSON.parseArray((String)position.getEffective(), EaiHttpParams.class);
            for (EaiHttpParams param : params) {
                if (!"0".equals(param.getParamsFrom())) continue;
                if (param.getParamsValue().startsWith("$BODY.") || param.getParamsValue().startsWith("$HEADER.")) {
                    param.setParamsValue(ExpressionRegUtil.analysiSpecialExp((String)param.getParamsValue()));
                    continue;
                }
                if (param.getParamsValue().contains("/*#META{") || param.getParamsValue().startsWith("\"")) continue;
                param.setParamsValue("\"" + param.getParamsValue() + "\"");
            }
            position.setEffective(JSON.toJSONString((Object)params));
            this.eaiParamsPositionService.updateById((Object)position);
        }
    }

    private void recursionChangeParamsValue(AuthHTTPBodyParams newParam) {
        if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == newParam.getType().intValue()) {
            List paramItems = newParam.getItems();
            for (AuthHTTPBodyParams param : paramItems) {
                if (null != EaiDataType.getBaseModelType((Integer)param.getType())) {
                    if (!"0".equals(param.getParamsFrom())) continue;
                    param.setParamsValue("\"" + param.getParamsValue() + "\"");
                    continue;
                }
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == param.getType().intValue()) {
                    this.recursionChangeParamsValue(param);
                    continue;
                }
                if (EaiDataType.DATA_TYPE_LIST.getType() != param.getType().intValue()) continue;
                AuthHTTPBodyParams paramsT = (AuthHTTPBodyParams)param.getItems().get(0);
                this.recursionChangeParamsValue(paramsT);
            }
        } else if (EaiDataType.DATA_TYPE_LIST.getType() == newParam.getType().intValue()) {
            AuthHTTPBodyParams paramsT = (AuthHTTPBodyParams)newParam.getItems().get(0);
            this.recursionChangeParamsValue(paramsT);
        }
    }

    public ApiResponse<Boolean> expCompatibleOldDataNew() {
        List positionList = this.eaiParamsPositionService.list();
        for (EaiParamsPosition position : positionList) {
            List params = JSON.parseArray((String)position.getEffective(), EaiHttpParams.class);
            for (EaiHttpParams param : params) {
                if (!"0".equals(param.getParamsFrom()) || !param.getParamsValue().startsWith("$BODY.") && !param.getParamsValue().startsWith("$HEADER.")) continue;
                param.setParamsValue(ExpressionRegUtil.analysiSpecialExp((String)param.getParamsValue()));
            }
            position.setEffective(JSON.toJSONString((Object)params));
            this.eaiParamsPositionService.updateById((Object)position);
        }
        return ApiResponse.success();
    }
}

