/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.appauth.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.service.ExpressionEngineService;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.util.ES5ExpressionEngineUtil;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IConstantVersionService;
import com.jxdinfo.hussar.integration.support.expression.builder.HussarExpressionEvaluator;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.appauth.service.impl.ExpressionEngineServiceImpl")
public class ExpressionEngineServiceImpl
implements ExpressionEngineService {
    public static final String HTTP_HEADER = "$HEADER";
    public static final String HTTP_BODY = "$BODY";
    public static final String EAICONSTANT_FUNCTION = "getEaiConstant";
    public static final String EAIAUTHPARAM_FUNCTION = "getEaiAuthParam";
    @Autowired
    private IConstantVersionService constantVersionService;
    @Autowired
    private ICommonConstantService commonConstantService;
    @Autowired
    protected IEaiApplicationAuthService eaiApplicationAuthService;

    public Object executeExpression(String expressionStr, Map<String, Object> valueMap, boolean publish) {
        HussarExpressionEvaluator expressionEvaluator = ES5ExpressionEngineUtil.getExpressionEngine();
        expressionEvaluator.function(EAICONSTANT_FUNCTION, this.createGetEaiConstantFunction(publish));
        expressionEvaluator.function(EAIAUTHPARAM_FUNCTION, this.createGetEaiAuthParamFunction());
        if (CollectionUtil.isNotEmpty(valueMap)) {
            if (valueMap.containsKey(HTTP_HEADER)) {
                expressionEvaluator.variable(HTTP_HEADER, valueMap.get(HTTP_HEADER));
            }
            if (valueMap.containsKey(HTTP_BODY)) {
                expressionEvaluator.variable(HTTP_BODY, valueMap.get(HTTP_BODY));
            }
        }
        return expressionEvaluator.evaluate(expressionStr);
    }

    public Object getEaiConstantById(Object id, boolean publish) {
        String constantType;
        String constantValue;
        long constantId;
        if (id == null) {
            return null;
        }
        if (id instanceof Number) {
            constantId = ((Number)id).longValue();
        } else if (id instanceof String) {
            try {
                constantId = Long.parseLong((String)id);
            }
            catch (NumberFormatException ignore) {
                return null;
            }
        } else {
            return null;
        }
        if (publish) {
            ConstantVersion versionServiceById = (ConstantVersion)this.constantVersionService.getById((Serializable)Long.valueOf(constantId));
            if (null == versionServiceById) {
                throw new BaseException("\u6ca1\u6709\u67e5\u8be2\u5230\u53d1\u5e03\u540e\u7684\u5e38\u91cf" + constantId + "\uff01");
            }
            constantValue = versionServiceById.getConstantValue();
            constantType = versionServiceById.getParamstype();
        } else {
            CommonConstant commonConstant = (CommonConstant)this.commonConstantService.getById((Serializable)Long.valueOf(constantId));
            constantValue = commonConstant.getConstantValue();
            constantType = commonConstant.getParamstype();
        }
        return ParamsConvertUtil.parseConstant((String)constantValue, (String)constantType);
    }

    public Object getEaiAuthParamByIdFromCache(Object id) {
        long authParamsId;
        if (id == null) {
            return null;
        }
        if (id instanceof Number) {
            authParamsId = ((Number)id).longValue();
        } else if (id instanceof String) {
            try {
                authParamsId = Long.parseLong((String)id);
            }
            catch (NumberFormatException ignore) {
                return null;
            }
        } else {
            return null;
        }
        EaiApplicationAuth authParam = (EaiApplicationAuth)this.eaiApplicationAuthService.getById((Serializable)Long.valueOf(authParamsId));
        Map allParams = TempHttpCode.getAllParams();
        Object authParamValue = null;
        if (CollectionUtil.isNotEmpty((Map)allParams) && allParams.containsKey(authParam.getParamsNameEn())) {
            authParamValue = allParams.get(authParam.getParamsNameEn());
        }
        if (StringUtil.isNotEmpty(authParamValue)) {
            String authParamsValueStr = authParamValue.toString();
            String authParamsType = authParam.getParamsType();
            return ParamsConvertUtil.parseConstant((String)authParamsValueStr, (String)authParamsType);
        }
        return null;
    }

    public Function<Object, Object> createGetEaiConstantFunction(boolean publish) {
        return id -> this.getEaiConstantById(id, publish);
    }

    public Function<Object, Object> createGetEaiAuthParamFunction() {
        return id -> this.getEaiAuthParamByIdFromCache(id);
    }
}

