/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.appauth.service.impl;

import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.appinfo.server.common.EaiAppEditManager;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.dto.EaiApplicationAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.service.EaiApplicationAuthService;
import com.jxdinfo.hussar.eai.atomicbase.api.resourcerelation.service.EaiAppStatusBaseService;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.service.impl.HttpAuthServiceImpl;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.atomicbase.server.appauth.service.impl.EaiApplicationAuthServiceImpl")
public class EaiApplicationAuthServiceImpl
implements EaiApplicationAuthService {
    @Resource
    IEaiApplicationAuthService eaiApplicationAuthService;
    @Resource
    EaiAppStatusBaseService eaiAppStatusBaseService;
    @Resource
    private HttpAuthServiceImpl httpAuthService;

    @HussarTransactional
    public ApiResponse<Boolean> updateEaiAppAuth(EaiApplicationAuthDto eaiApplicationAuthDto) {
        EaiApplicationAuth applicationAuth = new EaiApplicationAuth();
        BeanUtil.copy((Object)eaiApplicationAuthDto, (Object)applicationAuth);
        EaiApplicationAuth authParams = (EaiApplicationAuth)this.eaiApplicationAuthService.getById((Serializable)eaiApplicationAuthDto.getParamsId());
        ApiResponse<String> checkApiResponse = this.authDeleteCheck(authParams.getParamsId());
        if (HussarUtils.isNotEmpty((Object)checkApiResponse.getData())) {
            this.eaiAppStatusBaseService.resetStatus(authParams.getApplicationCode());
        }
        EaiAppEditManager.getInstance().call(authParams.getApplicationCode());
        return ApiResponse.status((boolean)this.eaiApplicationAuthService.updateById((Object)applicationAuth));
    }

    @HussarTransactional
    public ApiResponse<Boolean> authSave(EaiApplicationAuthDto eaiApplicationAuthDto) {
        EaiApplicationAuth authSave = new EaiApplicationAuth();
        BeanUtil.copy((Object)eaiApplicationAuthDto, (Object)authSave);
        EaiAppEditManager.getInstance().call(authSave.getApplicationCode());
        return ApiResponse.status((boolean)this.eaiApplicationAuthService.save((Object)authSave));
    }

    @HussarTransactional
    public ApiResponse<Boolean> authDeleteById(Long authParamsId) {
        EaiApplicationAuth authParams = (EaiApplicationAuth)this.eaiApplicationAuthService.getById((Serializable)authParamsId);
        ApiResponse<String> checkApiResponse = this.authDeleteCheck(authParams.getParamsId());
        if (HussarUtils.isNotEmpty((Object)checkApiResponse.getData())) {
            this.eaiAppStatusBaseService.resetStatus(authParams.getApplicationCode());
        }
        this.httpAuthService.authParamsValueClean(authParams, authParamsId);
        EaiAppEditManager.getInstance().call(authParams.getApplicationCode());
        return ApiResponse.status((boolean)this.eaiApplicationAuthService.removeById((Serializable)authParamsId));
    }

    public ApiResponse<String> authDeleteCheck(Long authParamsId) {
        EaiApplicationAuth authParams = (EaiApplicationAuth)this.eaiApplicationAuthService.getById((Serializable)authParamsId);
        return this.httpAuthService.verifyAuthParamHasUse(authParams, authParamsId);
    }

    public ApiResponse<Boolean> authNameUniqueCheck(String applicationCode, String authName, Long paramsId) {
        return this.eaiApplicationAuthService.authNameUniqueCheck(applicationCode, authName, paramsId);
    }

    public ApiResponse<Boolean> authEnNameUniqueCheck(String applicationCode, String authEnName, Long paramsId) {
        return this.eaiApplicationAuthService.authEnNameUniqueCheck(applicationCode, authEnName, paramsId);
    }
}

