/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.appauth.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiCallSpecificationInfo;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpVerifyBase;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiApplicationAuthService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpExtendService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpTemplateService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpVerifyBaseService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiParamsPositionService;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.service.ExpressionEngineService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.AuthHTTPBodyParams;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpBodyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpBodyVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpParamsPackageVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpParamsVo;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.LogMsgConstant;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.constant.app.LogLevelConstant;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiRequestTypeEnum;
import com.jxdinfo.hussar.eai.common.enums.sys.EaiCharsetEnum;
import com.jxdinfo.hussar.eai.common.util.ApplicationAuthMapUtils;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.eai.common.util.WebSocketUtil;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.model.ConstantVersion;
import com.jxdinfo.hussar.eai.resourcebaseopen.api.serevice.IConstantVersionService;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommomHttpAuthServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommomHttpAuthServiceImpl.class);
    private static final String PARAMSFROM_EXPRESSION_BODY = "$BODY.";
    private static final String PARAMSFROM_EXPRESSION_HEADER = "$HEADER.";
    public static final String HTTP_HEADER = "$HEADER";
    public static final String HTTP_BODY = "$BODY";
    private static final String BOOLEAN_TRUE_CONDITIONVALUE = "1";
    @Resource
    protected IEaiHttpExtendService httpExtendService;
    @Resource
    protected IEaiParamsPositionService paramsPositionService;
    @Resource
    private ICommonConstantService commonConstantService;
    @Resource
    private IEaiApplicationAuthService applicationAuthService;
    @Resource
    private IEaiHttpTemplateService templateService;
    @Resource
    private IEaiHttpVerifyBaseService httpVerifyBaseService;
    @Resource
    private ExpressionEngineService expressionEngineService;
    @Resource
    IConstantVersionService constantVersionService;
    private static final String PATTERN_REG = "^\\[*\\],\\[*\\]";

    public EaiHttpTemplate getEaiHttpTemplate(String applicationCode) {
        EaiHttpTemplate eaiHttpTemplate = (EaiHttpTemplate)this.templateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)applicationCode)).in(EaiHttpTemplate::getTemplateType, Arrays.asList("0", BOOLEAN_TRUE_CONDITIONVALUE)));
        return eaiHttpTemplate;
    }

    public EaiHttpTemplate getEaiHttpTemplateContainDisable(String applicationCode) {
        EaiHttpTemplate eaiHttpTemplateT = this.getEaiHttpTemplate(applicationCode);
        if (null == eaiHttpTemplateT) {
            eaiHttpTemplateT = (EaiHttpTemplate)this.templateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)applicationCode)).in(EaiHttpTemplate::getTemplateType, Arrays.asList("2")));
        }
        return eaiHttpTemplateT;
    }

    public EaiHttpTemplate getNotNullEaiHttpTemplate(String applicationCode) {
        EaiHttpTemplate eaiHttpTemplate = (EaiHttpTemplate)this.templateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)applicationCode)).isNotNull(EaiHttpTemplate::getTemplateType));
        return eaiHttpTemplate;
    }

    public EaiHttpTemplate getEaiHttpTemplatePublishing(String applicationCode) {
        EaiHttpTemplate eaiHttpTemplate = (EaiHttpTemplate)this.templateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)applicationCode)).eq(EaiHttpTemplate::getTemplateType, (Object)"2"));
        return eaiHttpTemplate;
    }

    public EaiHttpTemplate getPublishEaiHttpTemplate(String applicationCode) {
        EaiHttpTemplate eaiHttpTemplate = (EaiHttpTemplate)this.templateService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)applicationCode)).isNull(EaiHttpTemplate::getTemplateType));
        return eaiHttpTemplate;
    }

    public EaiHttpTemplate getEaiHttpTemplateByPublishFlag(String applicationCode, Boolean publish) {
        if (publish.booleanValue()) {
            return this.getPublishEaiHttpTemplate(applicationCode);
        }
        return this.getEaiHttpTemplate(applicationCode);
    }

    public Map<Long, CommonConstant> getCommonConstantsMap(String applicationCode, Boolean isPublished) {
        if (isPublished.booleanValue()) {
            List constantVersionList = this.constantVersionService.list((Wrapper)new LambdaQueryWrapper().eq(ConstantVersion::getApplicationCode, (Object)applicationCode));
            if (CollectionUtil.isNotEmpty((Collection)constantVersionList)) {
                ArrayList constants = new ArrayList(constantVersionList.size());
                constantVersionList.forEach(constantVersion -> {
                    CommonConstant constant = new CommonConstant();
                    constant.setApplicationCode(constantVersion.getApplicationCode());
                    constant.setConstantClassify(constantVersion.getConstantClassify());
                    constant.setConstantName(constantVersion.getConstantName());
                    constant.setConstantNameEn(constantVersion.getConstantNameEn());
                    constant.setConstantValue(constantVersion.getConstantValue());
                    constant.setId(constantVersion.getId());
                    constant.setParamstype(constantVersion.getParamstype());
                    constant.setRemark(constantVersion.getRemark());
                    constant.setCreateBy(constantVersion.getCreateBy());
                    constant.setEditBy(constantVersion.getEditBy());
                    constant.setCreateTime(constantVersion.getCreateTime());
                    constant.setCreator(constantVersion.getCreator());
                    constant.setLastEditor(constantVersion.getLastEditor());
                    constant.setLastTime(constantVersion.getLastTime());
                    constants.add(constant);
                });
                return constants.stream().collect(Collectors.toMap(CommonConstant::getId, Function.identity()));
            }
            return null;
        }
        List commonConstants = this.commonConstantService.list((Wrapper)new LambdaQueryWrapper().eq(CommonConstant::getApplicationCode, (Object)applicationCode));
        return commonConstants.stream().collect(Collectors.toMap(CommonConstant::getId, Function.identity()));
    }

    public Map<Long, EaiApplicationAuth> getEaiApplicationAuthMap(String applicationCode) {
        List applicationAuths = this.applicationAuthService.list((Wrapper)new LambdaQueryWrapper().eq(EaiApplicationAuth::getApplicationCode, (Object)applicationCode));
        return applicationAuths.stream().collect(Collectors.toMap(EaiApplicationAuth::getParamsId, Function.identity()));
    }

    public List<EaiHttpParamsDto> analysisHttpRequestParams(String serviceId, List<EaiHttpParamsDto> httpParamsDtos, boolean isPublished) {
        return this.analysisHttpRequestParams(serviceId, httpParamsDtos, null, null, isPublished);
    }

    protected EaiApiParams getEaiApiParams(Long templateId, EaiApiResponse apiResponseVo, HttpAuthVerifyDto authVerifyDto, Map<Long, EaiHttpParamsDto> tokenVerifyMap, String step, boolean isPublished) {
        Map<String, EaiParamsPosition> paramsPosissionsMap = this.queryAuthParamsPositionMap(templateId, step);
        List paramsHeaderToken = Lists.newArrayListWithCapacity((int)10);
        List paramsQueryToken = Lists.newArrayListWithCapacity((int)10);
        List paramsBodyToken = Lists.newArrayListWithCapacity((int)10);
        for (Map.Entry<String, EaiParamsPosition> entry : paramsPosissionsMap.entrySet()) {
            if ("0".equals(entry.getKey())) {
                paramsHeaderToken = JSON.parseArray((String)entry.getValue().getEffective(), EaiHttpParamsDto.class);
                continue;
            }
            if ("2".equals(entry.getKey())) {
                paramsQueryToken = JSON.parseArray((String)entry.getValue().getEffective(), EaiHttpParamsDto.class);
                continue;
            }
            if (BOOLEAN_TRUE_CONDITIONVALUE.equals(entry.getKey())) {
                paramsBodyToken = JSON.parseArray((String)entry.getValue().getEffective(), EaiHttpParamsDto.class);
                continue;
            }
            throw new BaseException("\u4e0d\u652f\u6301\u6b64\u4f4d\u7f6e\u7684\u7c7b\u578b");
        }
        Map<Object, Object> paramsHeaderTokenMap = Maps.newHashMapWithExpectedSize((int)10);
        Map<Object, Object> paramsQueryTokenMap = Maps.newHashMapWithExpectedSize((int)10);
        Map<Object, Object> paramsBodyTokenMap = Maps.newHashMapWithExpectedSize((int)10);
        if (CollectionUtil.isNotEmpty((Collection)paramsHeaderToken)) {
            paramsHeaderTokenMap = paramsHeaderToken.stream().collect(Collectors.toMap(EaiHttpParamsDto::getParamsNameEn, Function.identity()));
        }
        if (CollectionUtil.isNotEmpty((Collection)paramsQueryToken)) {
            paramsQueryTokenMap = paramsQueryToken.stream().collect(Collectors.toMap(EaiHttpParamsDto::getParamsNameEn, Function.identity()));
        }
        if (CollectionUtil.isNotEmpty((Collection)paramsBodyToken)) {
            paramsBodyTokenMap = paramsBodyToken.stream().collect(Collectors.toMap(EaiHttpParamsDto::getParamsNameEn, Function.identity()));
        }
        Map<Object, Object> paramsHeaderUriMap = Maps.newHashMapWithExpectedSize((int)10);
        Map<Object, Object> paramsQueryUrinMap = Maps.newHashMapWithExpectedSize((int)10);
        Map<Object, Object> paramsBodyUrinMap = Maps.newHashMapWithExpectedSize((int)10);
        if (CollectionUtil.isNotEmpty((Collection)authVerifyDto.getHttpHeader())) {
            paramsHeaderUriMap = authVerifyDto.getHttpHeader().stream().collect(Collectors.toMap(EaiHttpParamsDto::getParamsNameEn, Function.identity()));
        }
        if (CollectionUtil.isNotEmpty((Collection)authVerifyDto.getHttpQueryParam())) {
            paramsQueryUrinMap = authVerifyDto.getHttpQueryParam().stream().collect(Collectors.toMap(EaiHttpParamsDto::getParamsNameEn, Function.identity()));
        }
        if (null != authVerifyDto.getHttpBody() && CollectionUtil.isNotEmpty((Collection)authVerifyDto.getHttpBody().getBodyParam())) {
            paramsBodyUrinMap = authVerifyDto.getHttpBody().getBodyParam().stream().collect(Collectors.toMap(EaiHttpParamsDto::getParamsNameEn, Function.identity()));
        }
        Map paramsHeaderMergeMap = ApplicationAuthMapUtils.mergeMaps((Map)paramsHeaderTokenMap, (Map)paramsHeaderUriMap);
        Map paramsQueryMergeMap = ApplicationAuthMapUtils.mergeMaps((Map)paramsQueryTokenMap, (Map)paramsQueryUrinMap);
        Map paramsBodyMergeMap = ApplicationAuthMapUtils.mergeMaps((Map)paramsBodyTokenMap, (Map)paramsBodyUrinMap);
        return this.resetParams(apiResponseVo, new ArrayList<EaiHttpParamsDto>(paramsHeaderMergeMap.values()), new ArrayList<EaiHttpParamsDto>(paramsBodyMergeMap.values()), new ArrayList<EaiHttpParamsDto>(paramsQueryMergeMap.values()), tokenVerifyMap, authVerifyDto, isPublished);
    }

    protected EaiApiParams resetParams(EaiApiResponse apiResponseVo, List<EaiHttpParamsDto> headers, List<EaiHttpParamsDto> bodys, List<EaiHttpParamsDto> querys, Map<Long, EaiHttpParamsDto> tokenVerifyMap, HttpAuthVerifyDto authVerifyDto, boolean isPublished) {
        String serviceId = authVerifyDto.getServiceId();
        List<Object> header = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty(headers)) {
            header = this.analysisHttpRequestParams(serviceId, headers, tokenVerifyMap, apiResponseVo, isPublished);
            this.pushMsg(authVerifyDto.getServiceId(), "\u5b8c\u6210header\u53c2\u6570\u89e3\u6790", isPublished);
        } else {
            this.pushMsg(authVerifyDto.getServiceId(), "\u65e0header\u53c2\u6570", isPublished);
        }
        this.pushMsg(authVerifyDto.getServiceId(), "\u5f00\u59cb\u89e3\u6790query\u53c2\u6570...", isPublished);
        List<Object> query = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty(querys)) {
            query = this.analysisHttpRequestParams(serviceId, querys, tokenVerifyMap, apiResponseVo, isPublished);
            this.pushMsg(authVerifyDto.getServiceId(), "\u5b8c\u6210query\u53c2\u6570\u89e3\u6790", isPublished);
        } else {
            this.pushMsg(authVerifyDto.getServiceId(), "\u65e0query\u53c2\u6570", isPublished);
        }
        this.pushMsg(authVerifyDto.getServiceId(), "\u5f00\u59cb\u89e3\u6790body\u53c2\u6570...", isPublished);
        List<Object> body = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty(bodys)) {
            body = this.analysisHttpRequestParams(serviceId, bodys, tokenVerifyMap, apiResponseVo, isPublished);
            this.pushMsg(authVerifyDto.getServiceId(), "\u5b8c\u6210body\u53c2\u6570\u89e3\u6790", isPublished);
        } else {
            this.pushMsg(authVerifyDto.getServiceId(), "\u65e0body\u53c2\u6570", isPublished);
        }
        EaiHttpBodyDto requestBody = new EaiHttpBodyDto();
        if (null != authVerifyDto.getHttpBody()) {
            BeanUtil.copy((Object)authVerifyDto.getHttpBody(), (Object)requestBody);
            requestBody.setBodyParam((List)body);
        }
        return this.structureEaiApiParams(authVerifyDto.getServiceId(), authVerifyDto.getHttpUrl(), authVerifyDto.getHttpUrlType(), authVerifyDto.getHttpMethod(), requestBody, header, query, isPublished);
    }

    public void pushMsg(String serviceId, String msg, String type, Throwable exception, boolean isPublished) {
        if (!isPublished) {
            WebSocketUtil.senMsg((String)serviceId, (String)msg, (String)type, (Throwable)exception);
        }
    }

    public void pushMsg(String serviceId, String msg, boolean isPublished) {
        this.pushMsg(serviceId, msg, LogLevelConstant.LOG_LEVEL_INFO, null, isPublished);
    }

    public List<EaiHttpParamsDto> analysisHttpRequestParams(String serviceId, List<EaiHttpParamsDto> httpParamsDtos, Map<Long, EaiHttpParamsDto> tokenVerifyMap, boolean isPublished) {
        return this.analysisHttpRequestParams(serviceId, httpParamsDtos, tokenVerifyMap, null, isPublished);
    }

    public Map<Long, EaiHttpParamsDto> getAuthParamsMap(List<EaiHttpParamsDto> tokenVerifys) {
        Map<Object, Object> tokenVerifyMap = Maps.newHashMapWithExpectedSize((int)10);
        if (HussarUtils.isNotEmpty(tokenVerifys)) {
            tokenVerifyMap = tokenVerifys.stream().collect(Collectors.toMap(EaiHttpParamsDto::getParamsId, Function.identity()));
        }
        return tokenVerifyMap;
    }

    public List<EaiHttpParamsDto> analysisHttpRequestParamsForStruct(String serviceId, List<AuthHTTPBodyParams> authHTTPBodyParamsList, Map<Long, EaiHttpParamsDto> tokenVerifyMap, boolean isPublished) {
        ArrayList realHttpParamsList = Lists.newArrayListWithCapacity((int)5);
        if (CollectionUtil.isNotEmpty(authHTTPBodyParamsList)) {
            HashSet constantIdSet = Sets.newHashSetWithExpectedSize((int)5);
            for (AuthHTTPBodyParams authBody : authHTTPBodyParamsList) {
                this.analysisForConstant(constantIdSet, authBody);
            }
            Map<Object, Object> commonConstantsMap = Maps.newHashMapWithExpectedSize((int)5);
            if (CollectionUtil.isNotEmpty((Collection)constantIdSet)) {
                commonConstantsMap = this.getLongCommonConstantMap(serviceId, isPublished, constantIdSet);
            }
            for (AuthHTTPBodyParams authHTTPBodyParam : authHTTPBodyParamsList) {
                EaiHttpParamsDto realHttpParam = new EaiHttpParamsDto();
                String name = authHTTPBodyParam.getName();
                realHttpParam.setParamsNameEn(name);
                Object value = authHTTPBodyParam.getParamsValue();
                if (StringUtil.isNotEmpty((Object)EaiDataType.getBaseModelType((Integer)authHTTPBodyParam.getType()))) {
                    if ("0".equals(authHTTPBodyParam.getParamsFrom())) {
                        value = this.expressionEngineService.executeExpression(authHTTPBodyParam.getParamsValue(), null, isPublished);
                        this.pushMsg(serviceId, LogMsgConstant.getParamsFunc(name, value), isPublished);
                    } else if (BOOLEAN_TRUE_CONDITIONVALUE.equals(authHTTPBodyParam.getParamsFrom())) {
                        if (commonConstantsMap.containsKey(Long.valueOf(authHTTPBodyParam.getParamsValue()))) {
                            value = ((CommonConstant)commonConstantsMap.get(Long.valueOf(authHTTPBodyParam.getParamsValue()))).getConstantValue();
                            this.pushMsg(serviceId, LogMsgConstant.getConstantValue(name, value), isPublished);
                        }
                    } else if ("2".equals(authHTTPBodyParam.getParamsFrom()) && CollectionUtil.isNotEmpty(tokenVerifyMap)) {
                        value = tokenVerifyMap.get(Long.parseLong(authHTTPBodyParam.getParamsValue())).getParamsValue();
                        this.pushMsg(serviceId, LogMsgConstant.getParamsAuthValue(name, value), isPublished);
                    }
                } else if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == authHTTPBodyParam.getType().intValue()) {
                    value = this.assembleRealParamValue(tokenVerifyMap, (Map<Long, CommonConstant>)commonConstantsMap, authHTTPBodyParam, isPublished);
                }
                realHttpParam.setKeyValue(value);
                realHttpParamsList.add(realHttpParam);
            }
        }
        return realHttpParamsList;
    }

    @NotNull
    private Object assembleRealParamValue(Map<Long, EaiHttpParamsDto> tokenVerifyMap, Map<Long, CommonConstant> commonConstantsMap, AuthHTTPBodyParams authHTTPBodyParam, boolean isPublished) {
        HashMap valueMap = Maps.newHashMapWithExpectedSize((int)5);
        for (AuthHTTPBodyParams paramsItems : authHTTPBodyParam.getItems()) {
            String nameItem = paramsItems.getName();
            Object valueItem = paramsItems.getParamsValue();
            if (StringUtil.isNotEmpty((Object)EaiDataType.getBaseModelType((Integer)paramsItems.getType()))) {
                valueItem = this.getObjectValue(tokenVerifyMap, commonConstantsMap, paramsItems, isPublished);
            } else if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getType().intValue()) {
                valueItem = this.assembleRealParamValue(tokenVerifyMap, commonConstantsMap, paramsItems, isPublished);
            } else {
                ArrayList values = Lists.newArrayListWithCapacity((int)5);
                List itemsChild = paramsItems.getItems();
                if (StringUtil.isNotEmpty((Object)EaiDataType.getBaseModelType((Integer)paramsItems.getItemType()))) {
                    for (AuthHTTPBodyParams c : itemsChild) {
                        values.add(this.getObjectValue(tokenVerifyMap, commonConstantsMap, c, isPublished));
                    }
                    valueItem = values;
                } else if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == paramsItems.getItemType().intValue()) {
                    for (AuthHTTPBodyParams c : itemsChild) {
                        values.add(this.assembleRealParamValue(tokenVerifyMap, commonConstantsMap, c, isPublished));
                    }
                    valueItem = values;
                }
            }
            valueMap.put(nameItem, valueItem);
        }
        return valueMap;
    }

    private Object getObjectValue(Map<Long, EaiHttpParamsDto> tokenVerifyMap, Map<Long, CommonConstant> commonConstantsMap, AuthHTTPBodyParams paramsItems, boolean isPublished) {
        Object result = null;
        if ("0".equals(paramsItems.getParamsFrom())) {
            result = this.expressionEngineService.executeExpression(paramsItems.getParamsValue(), null, isPublished);
        } else if (BOOLEAN_TRUE_CONDITIONVALUE.equals(paramsItems.getParamsFrom())) {
            if (commonConstantsMap.containsKey(Long.valueOf(paramsItems.getParamsValue()))) {
                result = commonConstantsMap.get(Long.valueOf(paramsItems.getParamsValue())).getConstantValue();
            }
        } else if ("2".equals(paramsItems.getParamsFrom())) {
            if (CollectionUtil.isNotEmpty(tokenVerifyMap)) {
                result = tokenVerifyMap.get(Long.parseLong(paramsItems.getParamsValue())).getParamsValue();
            }
        } else {
            throw new BaseException("\u4e0d\u652f\u6301\u7c7b\u578b\u7684\u53c2\u6570\u503c\uff01");
        }
        if (HussarUtils.isNotEmpty((Object)result)) {
            return ParamsConvertUtil.parseDataType((Object)result, (Integer)paramsItems.getType(), (boolean)true);
        }
        return null;
    }

    @NotNull
    Map<Long, CommonConstant> getLongCommonConstantMap(String serviceId, boolean isPublished, Set<String> constantIdSet) {
        Map<Object, Object> commonConstantsMap = Maps.newHashMapWithExpectedSize((int)10);
        if (CollectionUtil.isNotEmpty(constantIdSet)) {
            if (isPublished) {
                List commonConstants = this.constantVersionService.listByIds(constantIdSet);
                if (HussarUtils.isNotEmpty((Object)commonConstants)) {
                    ArrayList constants = new ArrayList(commonConstants.size());
                    commonConstants.forEach(constantVersion -> {
                        CommonConstant constant = new CommonConstant();
                        constant.setApplicationCode(constantVersion.getApplicationCode());
                        constant.setConstantClassify(constantVersion.getConstantClassify());
                        constant.setConstantName(constantVersion.getConstantName());
                        constant.setConstantNameEn(constantVersion.getConstantNameEn());
                        constant.setConstantValue(constantVersion.getConstantValue());
                        constant.setId(constantVersion.getId());
                        constant.setParamstype(constantVersion.getParamstype());
                        constant.setRemark(constantVersion.getRemark());
                        constant.setCreateBy(constantVersion.getCreateBy());
                        constant.setEditBy(constantVersion.getEditBy());
                        constant.setCreateTime(constantVersion.getCreateTime());
                        constant.setCreator(constantVersion.getCreator());
                        constant.setLastEditor(constantVersion.getLastEditor());
                        constant.setLastTime(constantVersion.getLastTime());
                        constants.add(constant);
                    });
                    commonConstantsMap = constants.stream().collect(Collectors.toMap(CommonConstant::getId, Function.identity()));
                }
            } else {
                List commonConstants = this.commonConstantService.listByIds(constantIdSet);
                this.pushMsg(serviceId, LogMsgConstant.getParamsCommonConstant(commonConstants.size()), isPublished);
                commonConstantsMap = commonConstants.stream().collect(Collectors.toMap(CommonConstant::getId, Function.identity()));
            }
        }
        return commonConstantsMap;
    }

    private void analysisForConstant(Set<String> constantIdSet, AuthHTTPBodyParams authBody) {
        if (StringUtil.isNotEmpty((Object)EaiDataType.getBaseModelType((Integer)authBody.getType())) && BOOLEAN_TRUE_CONDITIONVALUE.equals(authBody.getParamsFrom())) {
            constantIdSet.add(authBody.getParamsValue());
            return;
        }
        if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == authBody.getType().intValue()) {
            for (AuthHTTPBodyParams bodyParam : authBody.getItems()) {
                this.analysisForConstant(constantIdSet, bodyParam);
            }
            return;
        }
        if (CollectionUtil.isNotEmpty((Collection)authBody.getItems())) {
            AuthHTTPBodyParams bodyParams = (AuthHTTPBodyParams)authBody.getItems().get(0);
            this.analysisForConstant(constantIdSet, bodyParams);
            return;
        }
    }

    public List<EaiHttpParamsDto> analysisHttpRequestParams(String serviceId, List<EaiHttpParamsDto> httpParamsDtos, Map<Long, EaiHttpParamsDto> tokenVerifyMap, EaiApiResponse apiResponseVo, boolean isPublished) {
        if (CollectionUtil.isNotEmpty(httpParamsDtos)) {
            Map<Object, Object> commonConstantsMap = Maps.newHashMapWithExpectedSize((int)10);
            List httpParamsConstant = httpParamsDtos.stream().filter(p -> BOOLEAN_TRUE_CONDITIONVALUE.equals(p.getParamsFrom())).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(httpParamsConstant)) {
                Set<String> constantId = httpParamsConstant.stream().map(EaiHttpParamsDto::getParamsValue).collect(Collectors.toSet());
                commonConstantsMap = this.getLongCommonConstantMap(serviceId, isPublished, constantId);
            }
            for (EaiHttpParamsDto paramsDto : httpParamsDtos) {
                String name = paramsDto.getParamsNameEn();
                Object value = paramsDto.getParamsValue();
                if ("0".equals(paramsDto.getParamsFrom())) {
                    Map<String, Object> valueMap = this.getValueMap(paramsDto.getParamsValue(), apiResponseVo);
                    value = this.expressionEngineService.executeExpression(paramsDto.getParamsValue(), valueMap, isPublished);
                    this.pushMsg(serviceId, LogMsgConstant.getParamsFunc(name, value), isPublished);
                } else if (BOOLEAN_TRUE_CONDITIONVALUE.equals(paramsDto.getParamsFrom())) {
                    if (commonConstantsMap.containsKey(Long.valueOf(paramsDto.getParamsValue()))) {
                        value = ((CommonConstant)commonConstantsMap.get(Long.valueOf(paramsDto.getParamsValue()))).getConstantValue();
                        this.pushMsg(serviceId, LogMsgConstant.getConstantValue(name, value), isPublished);
                    }
                } else if ("2".equals(paramsDto.getParamsFrom())) {
                    if (CollectionUtil.isNotEmpty(tokenVerifyMap)) {
                        value = tokenVerifyMap.get(Long.parseLong(paramsDto.getParamsValue())).getParamsValue();
                        this.pushMsg(serviceId, LogMsgConstant.getParamsAuthValue(name, value), isPublished);
                    }
                } else {
                    value = paramsDto.getKeyValue();
                    this.pushMsg(serviceId, LogMsgConstant.getParamsApiValue(name, value), isPublished);
                }
                paramsDto.setKeyValue(value);
            }
        }
        return httpParamsDtos;
    }

    public Map<String, Object> getValueMap(String paramsDto, EaiApiResponse apiResponseVo) {
        HashMap valueMap = Maps.newHashMapWithExpectedSize((int)5);
        if (HussarUtils.isNotEmpty((Object)apiResponseVo)) {
            if (paramsDto.contains(PARAMSFROM_EXPRESSION_BODY)) {
                valueMap.put(HTTP_BODY, apiResponseVo.getBody());
            } else if (paramsDto.contains(PARAMSFROM_EXPRESSION_HEADER)) {
                valueMap.put(HTTP_HEADER, apiResponseVo.getHeader());
            }
        }
        return valueMap;
    }

    public EaiApiParams structureEaiApiParams(String serviceId, String uri, String uriType, String httpMethod, EaiHttpBodyDto httpBodyDto, List<EaiHttpParamsDto> header, List<EaiHttpParamsDto> query, boolean isPublished) {
        EaiApiParams param = new EaiApiParams();
        if (BOOLEAN_TRUE_CONDITIONVALUE.equals(uriType)) {
            Object objectUrl = this.expressionEngineService.executeExpression(uri, null, isPublished);
            uri = objectUrl.toString();
        }
        param.setUrl(uri.trim());
        param.setRequestType(EaiRequestTypeEnum.getByType((String)httpMethod));
        if (null != httpBodyDto) {
            try {
                param.setContentType(EaiContentType.getByType((int)Integer.parseInt(httpBodyDto.getContentType())));
            }
            catch (Exception e) {
                param.setContentType(EaiContentType.getByName((String)httpBodyDto.getContentType()));
            }
            param.setBody(this.getRequestBody(httpBodyDto.getBodyParam()));
        }
        param.setHeader(this.getRequestParamMap(header));
        param.setQuery(this.getRequestParamMap(query));
        param.setCharset(EaiCharsetEnum.getByName((String)"UTF-8"));
        return param;
    }

    public Object getRequestBody(List<EaiHttpParamsDto> paramsDtos) {
        if (HussarUtils.isNotEmpty(paramsDtos)) {
            if (paramsDtos.size() == 1 && HussarUtils.isEmpty((Object)paramsDtos.get(0).getParamsNameEn())) {
                return paramsDtos.get(0).getKeyValue();
            }
            return this.getRequestParamMap(paramsDtos);
        }
        return null;
    }

    public HashMap<String, Object> getRequestParamMap(List<EaiHttpParamsDto> paramsDtos) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(paramsDtos)) {
            for (EaiHttpParamsDto httpParamsDto : paramsDtos) {
                map.put(httpParamsDto.getParamsNameEn(), httpParamsDto.getKeyValue());
            }
        }
        return map;
    }

    public void getHttpParams(List<EaiHttpParams> httpParams, List<EaiHttpParamsDto> httpParamsDtos, String paramsPosition, EaiHttpVerifyBase httpVerifyBase) {
        if (CollectionUtil.isNotEmpty(httpParamsDtos)) {
            for (EaiHttpParamsDto p : httpParamsDtos) {
                EaiHttpParams params = new EaiHttpParams();
                BeanUtil.copy((Object)p, (Object)params);
                params.setParamsId(Long.valueOf(IdWorker.getId((Object)new EaiHttpParams())));
                params.setHttpId(httpVerifyBase.getHttpBaseId());
                params.setParamsPosition(paramsPosition);
                httpParams.add(params);
            }
        }
    }

    public void getHttpParamsForStruct(List<EaiHttpParams> httpParams, List<AuthHTTPBodyParams> authHTTPBodyParams, String paramsPosition, EaiHttpVerifyBase httpVerifyBase) {
        if (CollectionUtil.isNotEmpty(authHTTPBodyParams)) {
            for (AuthHTTPBodyParams p : authHTTPBodyParams) {
                EaiHttpParams params = new EaiHttpParams();
                params.setParamsId(Long.valueOf(IdWorker.getId((Object)new EaiHttpParams())));
                params.setHttpId(httpVerifyBase.getHttpBaseId());
                params.setParamsPosition(paramsPosition);
                params.setParamsName(p.getName());
                params.setParamsNameEn(params.getParamsName());
                params.setParamsFrom(p.getParamsFrom());
                params.setParamsValue(JSON.toJSONString((Object)p));
                params.setRemark(p.getRemark());
                httpParams.add(params);
            }
        }
    }

    public ApiResponse<EaiApiResponseVo> outUriRreponseDataPackage(String serviceId, EaiApiParams requestParam, EaiApiResponse response, EaiApiResponseVo eaiApiResponseVo, List<EaiParamsItems> outMapping, List<ApiCallSpecificationInfo> callSpecificationInfoDtos, boolean isSuccess, boolean isPublished) {
        Object body;
        Map<String, Object> outurlRequestMap = this.requestParamsPackage(requestParam);
        eaiApiResponseVo.setOuturlRequestParams(outurlRequestMap);
        eaiApiResponseVo.setOuturlResponse(response);
        if (HussarUtils.isNotEmpty((Object)response) && HussarUtils.isNotEmpty((Object)response.getException())) {
            eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)response.getBody(), (String)response.getException()));
            return ApiResponse.success((Object)eaiApiResponseVo);
        }
        Map<String, Object> judgeResultMap = this.judgeApiCall(callSpecificationInfoDtos, response, isPublished);
        boolean apiCallResult = (Boolean)judgeResultMap.get("apiCallResult");
        String failMsg = (String)judgeResultMap.get("failMsg");
        if (HussarUtils.isNotEmpty((Object)response) && HussarUtils.isNotEmpty(outMapping)) {
            try {
                body = HussarUtils.isNotEmpty((Object)response.getBody()) ? ParamsConvertUtil.parseResult((Object)response.getBody(), (String)JSON.toJSONString(outMapping)) : response.getBody();
                if (apiCallResult) {
                    eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.success((Object)body));
                } else {
                    eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)body, (String)("\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38:" + failMsg)));
                }
            }
            catch (Exception e) {
                eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)response.getBody(), (String)(HussarUtils.isEmpty((Object)e.getMessage()) ? "\u51fa\u53c2\u7ed3\u6784\u8f6c\u6362\u5931\u8d25,\u8bf7\u68c0\u67e5\u51fa\u53c2\u914d\u7f6e" : e.getMessage())));
                return ApiResponse.success((Object)eaiApiResponseVo);
            }
        }
        if (isSuccess) {
            if (apiCallResult) {
                this.pushMsg(serviceId, "\u63a5\u53e3\u9a8c\u8bc1\u6210\u529f", isPublished);
                return ApiResponse.success((Object)eaiApiResponseVo);
            }
            this.pushMsg(serviceId, "\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38" + failMsg, LogLevelConstant.LOG_LEVEL_WARN, null, isPublished);
            eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)response.getBody(), (String)("\u63a5\u53e3\u9a8c\u8bc1\u5931\u8d25:" + failMsg)));
        } else {
            this.pushMsg(serviceId, "\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38", LogLevelConstant.LOG_LEVEL_ERROR, null, isPublished);
            body = null;
            if (HussarUtils.isNotEmpty((Object)response)) {
                body = response.getBody();
            }
            eaiApiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), (Object)body, (String)"\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38"));
        }
        return ApiResponse.success((Object)eaiApiResponseVo);
    }

    protected Map<Long, EaiHttpParamsDto> authParams(String serviceId, List<EaiHttpParamsDto> tokenVerifys, boolean isPublished) {
        this.pushMsg(serviceId, "\u5f00\u59cb\u89e3\u6790\u9274\u6743\u53c2\u6570...", isPublished);
        Map<Object, Object> tokenVerifyMap = Maps.newHashMapWithExpectedSize((int)10);
        if (CollectionUtil.isNotEmpty(tokenVerifys)) {
            tokenVerifys = this.analysisHttpRequestParams(serviceId, tokenVerifys, isPublished);
            tokenVerifyMap = tokenVerifys.stream().collect(Collectors.toMap(EaiHttpParamsDto::getParamsId, Function.identity()));
        }
        this.pushMsg(serviceId, "\u89e3\u6790\u9274\u6743\u53c2\u6570\uff1a\u5b8c\u6210", isPublished);
        this.pushMsg(serviceId, LogMsgConstant.getSplit(2), isPublished);
        return tokenVerifyMap;
    }

    private Map<String, Object> judgeApiCall(List<ApiCallSpecificationInfo> callSpecificationInfoDtos, EaiApiResponse apiResponse, boolean isPublished) {
        HashMap judgeResultMap = Maps.newHashMapWithExpectedSize((int)2);
        boolean apiCallResult = true;
        String failMsg = null;
        if (CollectionUtil.isNotEmpty(callSpecificationInfoDtos)) {
            if (null == apiResponse) {
                apiCallResult = false;
            } else {
                for (ApiCallSpecificationInfo p : callSpecificationInfoDtos) {
                    Map<String, Object> valueMap = this.getValueMap(p.getParamName(), apiResponse);
                    Object o = this.expressionEngineService.executeExpression(p.getParamName(), valueMap, isPublished);
                    if ("00".equals(p.getJudgeCondition())) {
                        if (null == o) {
                            apiCallResult = false;
                            failMsg = String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1anull", p.getShowParamName());
                            break;
                        }
                        if (EaiDataType.DATA_TYPE_BOOLEAN.getType() == Integer.valueOf(p.getParamType()).intValue()) {
                            boolean conditionValueValue = false;
                            if (BOOLEAN_TRUE_CONDITIONVALUE.equals(p.getConditionValue())) {
                                conditionValueValue = true;
                            }
                            if ((Boolean)o == false != conditionValueValue) continue;
                            apiCallResult = false;
                            failMsg = this.getEqMsg(p.getShowParamName(), o, String.valueOf(conditionValueValue));
                            break;
                        }
                        if (this.isEqualsCondition(p.getParamType(), o, p.getConditionValue())) continue;
                        apiCallResult = false;
                        failMsg = this.getEqMsg(p.getShowParamName(), o, p.getConditionValue());
                        break;
                    }
                    if ("01".equals(p.getJudgeCondition())) {
                        if (null == o) continue;
                        if (EaiDataType.DATA_TYPE_BOOLEAN.getType() == Integer.valueOf(p.getParamType()).intValue()) {
                            boolean conditionValueValue = false;
                            if (BOOLEAN_TRUE_CONDITIONVALUE.equals(p.getConditionValue())) {
                                conditionValueValue = true;
                            }
                            if ((Boolean)o != conditionValueValue) continue;
                            apiCallResult = false;
                            failMsg = this.getNotEqMsg(p.getShowParamName(), o, String.valueOf(conditionValueValue));
                            break;
                        }
                        if (!this.isEqualsCondition(p.getParamType(), o, p.getConditionValue())) continue;
                        apiCallResult = false;
                        failMsg = this.getNotEqMsg(p.getShowParamName(), o, p.getConditionValue());
                        break;
                    }
                    if (!"02".equals(p.getJudgeCondition())) continue;
                    if (null == o) {
                        apiCallResult = false;
                        failMsg = String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1anull", p.getShowParamName());
                        break;
                    }
                    if (EaiDataType.DATA_TYPE_BOOLEAN.getType() == Integer.valueOf(p.getParamType()).intValue()) {
                        boolean conditionValueValue = false;
                        if (BOOLEAN_TRUE_CONDITIONVALUE.equals(p.getConditionValue())) {
                            conditionValueValue = true;
                        }
                        if ((Boolean)o == false != conditionValueValue) continue;
                        apiCallResult = false;
                        failMsg = this.getEqInMsg(p.getShowParamName(), o, String.valueOf(conditionValueValue));
                        break;
                    }
                    if (HussarUtils.isNotEmpty((Object)p.getConditionValue())) {
                        List values = Stream.of(p.getConditionValue().split(",")).collect(Collectors.toList());
                        if (values.size() == 1) {
                            if (this.isEqualsCondition(p.getParamType(), values.get(0), p.getConditionValue())) continue;
                            apiCallResult = false;
                            failMsg = this.getEqInMsg(p.getShowParamName(), o, p.getConditionValue());
                            break;
                        }
                        if (values.contains(o.toString())) continue;
                        apiCallResult = false;
                        failMsg = this.getEqInMsg(p.getShowParamName(), o, p.getConditionValue());
                        break;
                    }
                    apiCallResult = false;
                    failMsg = this.getEqInMsg(p.getShowParamName(), o, p.getConditionValue());
                    break;
                }
            }
        }
        if (HussarUtils.isNotEmpty((Object)apiResponse) && HussarUtils.isNotEmpty((Object)apiResponse.getException())) {
            apiCallResult = false;
            if (HussarUtils.isNotEmpty((Object)apiResponse.getException())) {
                failMsg = apiResponse.getException();
            }
        }
        judgeResultMap.put("apiCallResult", apiCallResult);
        judgeResultMap.put("failMsg", failMsg);
        return judgeResultMap;
    }

    private boolean isEqualsCondition(String type, Object currentValue, String conditionValue) {
        Object parseValue = ParamsConvertUtil.parseDataType((Object)currentValue, (Integer)Integer.valueOf(type), (boolean)true);
        Object parseConditionValue = ParamsConvertUtil.parseDataType((Object)conditionValue, (Integer)Integer.valueOf(type), (boolean)true);
        return HussarUtils.equals((Object)parseValue, (Object)parseConditionValue);
    }

    private String getEqInMsg(String showParamName, Object o, String conditionValueValue) {
        return String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1a%s,\u9884\u671f\u5728(%s)\u4e4b\u5185", showParamName, o, conditionValueValue);
    }

    private String getNotEqMsg(String showParamName, Object o, String conditionValueValue) {
        return String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1a%s,\u9884\u671f\u4e0d\u7b49\u4e8e%s", showParamName, o, conditionValueValue);
    }

    private String getEqMsg(String showParamName, Object o, String conditionValueValue) {
        return String.format("\u54cd\u5e94\u4f53%s\u5f53\u524d\u503c\uff1a%s,\u9884\u671f\u7b49\u4e8e%s", showParamName, o, conditionValueValue);
    }

    public EaiHttpParamsPackageVo getEaiHttpParams(List<EaiHttpParams> header, List<EaiHttpParams> body, List<EaiHttpParams> query, Map<Long, CommonConstant> commonConstantsMap, Map<Long, EaiApplicationAuth> applicationAuthMap, List<EaiHttpParams> authParams, String contentType) {
        EaiHttpParamsPackageVo paramsVo = new EaiHttpParamsPackageVo();
        paramsVo.setHttpHeaderForStruct(this.getSourceNameForStruct(header, commonConstantsMap, applicationAuthMap, paramsVo));
        paramsVo.setHttpQueryParamForStruct(this.getSourceNameForStruct(query, commonConstantsMap, applicationAuthMap, paramsVo));
        paramsVo.setAuthParams(this.getSourceName(authParams, commonConstantsMap, applicationAuthMap));
        EaiHttpBodyVo httpBody = new EaiHttpBodyVo();
        httpBody.setContentType(contentType);
        httpBody.setBodyParamForStruct(this.getSourceNameForStruct(body, commonConstantsMap, applicationAuthMap, paramsVo));
        paramsVo.setHttpBody(httpBody);
        return paramsVo;
    }

    public Map<String, Object> requestParamsPackage(EaiApiParams requestParam) {
        TreeMap requestMap = Maps.newTreeMap();
        requestMap.put("url", requestParam.getUrl());
        requestMap.put("method", requestParam.getRequestType().getType());
        if (HussarUtils.isNotEmpty((Object)requestParam.getContentType())) {
            requestMap.put("contentType", requestParam.getContentType().getName());
        }
        requestMap.put("header", this.getRealType(requestParam.getHeader()));
        requestMap.put("query", this.getRealType(requestParam.getQuery()));
        requestMap.put("body", requestParam.getBody());
        return requestMap;
    }

    private Map<String, Object> getRealType(Map<String, Object> map) {
        if (CollectionUtil.isNotEmpty(map)) {
            map.forEach((k, v) -> {
                if (HussarUtils.isNotEmpty((Object)v) && v instanceof BigDecimal) {
                    v = v.toString().contains(".") ? (Number)Double.parseDouble(v.toString()) : (Number)Long.parseLong(v.toString());
                }
                map.put((String)k, v);
            });
        }
        return map;
    }

    public EaiHttpVerifyBase insertHttpVerify(String httpUrl, String httpUrlType, EaiHttpBodyDto bodyDto, Long extendId, String httpMethod) {
        EaiHttpVerifyBase httpVerifyBase = new EaiHttpVerifyBase();
        String analysisUrl = httpUrl.trim();
        httpVerifyBase.setHttpUrl(analysisUrl.toString());
        httpVerifyBase.setHttpUrlType(httpUrlType);
        httpVerifyBase.setHttpMethod(httpMethod);
        httpVerifyBase.setHttpBaseId(Long.valueOf(IdWorker.getId((Object)new EaiHttpVerifyBase())));
        httpVerifyBase.setExtendId(extendId);
        if (null != bodyDto) {
            httpVerifyBase.setContentType(bodyDto.getContentType());
        }
        this.httpVerifyBaseService.save((Object)httpVerifyBase);
        return httpVerifyBase;
    }

    public List<EaiHttpParamsVo> getSourceName(List<EaiHttpParams> params, Map<Long, CommonConstant> commonConstantsMap, Map<Long, EaiApplicationAuth> applicationAuthMap) {
        ArrayList paramsVos = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty(params)) {
            for (EaiHttpParams p : params) {
                EaiHttpParamsVo pVo = new EaiHttpParamsVo();
                BeanUtil.copy((Object)p, (Object)pVo);
                if (BOOLEAN_TRUE_CONDITIONVALUE.equals(pVo.getParamsFrom())) {
                    String paramsValueInheader = this.getParamsValue(pVo);
                    pVo.setSourceName(commonConstantsMap.get(Long.valueOf(paramsValueInheader)).getConstantNameEn());
                } else if ("2".equals(pVo.getParamsFrom())) {
                    String paramsValueInQuery = this.getParamsValue(pVo);
                    pVo.setSourceName(applicationAuthMap.get(Long.valueOf(paramsValueInQuery)).getParamsNameEn());
                } else if ("0".equals(pVo.getParamsFrom())) {
                    pVo.setSourceName(p.getParamsValue());
                } else if (StringUtil.isEmpty((Object)pVo.getParamsFrom())) {
                    AuthHTTPBodyParams authHTTPBodyParam = (AuthHTTPBodyParams)JSON.parseObject((String)p.getParamsValue(), AuthHTTPBodyParams.class);
                    this.getDetailInfo(commonConstantsMap, applicationAuthMap, authHTTPBodyParam);
                    pVo.setAuthHTTPBodyParams(Arrays.asList(authHTTPBodyParam));
                }
                paramsVos.add(pVo);
            }
        }
        return paramsVos;
    }

    public List<AuthHTTPBodyParams> getSourceNameForStruct(List<EaiHttpParams> params, Map<Long, CommonConstant> commonConstantsMap, Map<Long, EaiApplicationAuth> applicationAuthMap, EaiHttpParamsPackageVo paramsVo) {
        ArrayList paramsVos = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtil.isNotEmpty(params)) {
            for (EaiHttpParams p : params) {
                AuthHTTPBodyParams pVo = new AuthHTTPBodyParams();
                boolean newDataFlag = true;
                AuthHTTPBodyParams newParam = null;
                try {
                    newParam = (AuthHTTPBodyParams)JSON.parseObject((String)p.getParamsValue(), AuthHTTPBodyParams.class);
                    if (!paramsVo.getNewDataFlag()) {
                        paramsVo.setNewDataFlag(true);
                    }
                }
                catch (Exception e) {
                    LOGGER.info("ParamsValue\u5b58\u7684\u662f\u65e7\u6570\u636e{}", (Object)p.getParamsValue());
                    newDataFlag = false;
                }
                if (newDataFlag) {
                    BeanUtil.copy((Object)newParam, (Object)pVo);
                } else {
                    pVo.setName(p.getParamsNameEn());
                    pVo.setParamsValue(p.getParamsValue());
                    pVo.setParamsFrom(p.getParamsFrom());
                    pVo.setRemark(p.getRemark());
                }
                if (BOOLEAN_TRUE_CONDITIONVALUE.equals(pVo.getParamsFrom())) {
                    pVo.setSourceName(commonConstantsMap.get(Long.valueOf(pVo.getParamsValue())).getConstantNameEn());
                    if (!newDataFlag) {
                        pVo.setType(Integer.valueOf(Integer.parseInt(commonConstantsMap.get(Long.valueOf(pVo.getParamsValue())).getParamstype() != null ? commonConstantsMap.get(Long.valueOf(pVo.getParamsValue())).getParamstype() : "4")));
                        pVo.setValue(String.valueOf(pVo.getType()));
                    }
                } else if ("2".equals(pVo.getParamsFrom())) {
                    pVo.setSourceName(applicationAuthMap.get(Long.valueOf(pVo.getParamsValue())).getParamsNameEn());
                    if (!newDataFlag) {
                        pVo.setType(Integer.valueOf(Integer.parseInt(applicationAuthMap.get(Long.valueOf(pVo.getParamsValue())).getParamsType())));
                        pVo.setValue(String.valueOf(pVo.getType()));
                    }
                } else if ("0".equals(pVo.getParamsFrom())) {
                    if (newDataFlag) {
                        pVo.setSourceName(newParam.getParamsValue());
                    } else {
                        pVo.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRING.getType()));
                        pVo.setValue(String.valueOf(pVo.getType()));
                        pVo.setSourceName(p.getParamsValue());
                    }
                } else if (StringUtil.isEmpty((Object)pVo.getParamsFrom())) {
                    this.getDetailInfo(commonConstantsMap, applicationAuthMap, newParam);
                }
                paramsVos.add(pVo);
            }
        }
        return paramsVos;
    }

    private String getParamsValue(EaiHttpParamsVo pVo) {
        String paramsValue = pVo.getParamsValue();
        if (pVo.getParamsValue().startsWith("{")) {
            AuthHTTPBodyParams authParams = (AuthHTTPBodyParams)JSON.parseObject((String)pVo.getParamsValue(), AuthHTTPBodyParams.class);
            paramsValue = authParams.getParamsValue();
        }
        return paramsValue;
    }

    private void getDetailInfo(Map<Long, CommonConstant> commonConstantsMap, Map<Long, EaiApplicationAuth> applicationAuthMap, AuthHTTPBodyParams authHTTPBodyParam) {
        List items;
        if (HussarUtils.isEmpty((Object)authHTTPBodyParam)) {
            return;
        }
        if (StringUtil.isNotEmpty((Object)EaiDataType.getBaseModelType((Integer)authHTTPBodyParam.getType()))) {
            authHTTPBodyParam.setSourceName(authHTTPBodyParam.getParamsValue());
        }
        if (CollectionUtil.isNotEmpty((Collection)(items = authHTTPBodyParam.getItems()))) {
            for (AuthHTTPBodyParams bodyParam : items) {
                if (StringUtil.isNotEmpty((Object)EaiDataType.getBaseModelType((Integer)bodyParam.getType()))) {
                    String sourceName = null;
                    switch (bodyParam.getParamsFrom()) {
                        case "1": {
                            sourceName = commonConstantsMap.get(Long.valueOf(bodyParam.getParamsValue())).getConstantValue();
                            break;
                        }
                        case "2": {
                            sourceName = applicationAuthMap.get(Long.valueOf(bodyParam.getParamsValue())).getParamsName();
                            break;
                        }
                        case "0": {
                            sourceName = bodyParam.getParamsValue();
                            break;
                        }
                    }
                    bodyParam.setSourceName(sourceName);
                    continue;
                }
                if (EaiDataType.DATA_TYPE_STRUCTURE.getType() == bodyParam.getType().intValue()) {
                    this.getDetailInfo(commonConstantsMap, applicationAuthMap, bodyParam);
                    continue;
                }
                this.getDetailInfo(commonConstantsMap, applicationAuthMap, (AuthHTTPBodyParams)bodyParam.getItems().get(0));
            }
        }
    }

    public EaiHttpExtend getCertainStepByTemplateId(Long templateId, String stepcod) {
        return (EaiHttpExtend)this.httpExtendService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)templateId)).eq(EaiHttpExtend::getStepCode, (Object)stepcod));
    }

    public Map<String, EaiParamsPosition> queryAuthParamsPositionMap(Long templateId, String stepCode) {
        EaiHttpExtend extendThird = this.getCertainStepByTemplateId(templateId, stepCode);
        List eaiParamsPositions = this.paramsPositionService.list((Wrapper)new LambdaQueryWrapper().eq(EaiParamsPosition::getExtendId, (Object)extendThird.getExtendId()));
        return eaiParamsPositions.stream().collect(Collectors.toMap(EaiParamsPosition::getParamsPosition, Function.identity()));
    }

    public List<EaiParamsPosition> queryAuthParamsPosition(Long templateId, String stepCode) {
        EaiHttpExtend extendThird = this.getCertainStepByTemplateId(templateId, stepCode);
        return this.paramsPositionService.list((Wrapper)new LambdaQueryWrapper().eq(EaiParamsPosition::getExtendId, (Object)extendThird.getExtendId()));
    }

    public void setParamsCurrentRequest(List<EaiHttpParamsDto> eaiHttpParamsDtos) {
        if (CollectionUtil.isNotEmpty(eaiHttpParamsDtos)) {
            HashMap authParamsMap = Maps.newHashMapWithExpectedSize((int)5);
            for (EaiHttpParamsDto eaiHttpParamsDto : eaiHttpParamsDtos) {
                authParamsMap.put(eaiHttpParamsDto.getParamsNameEn(), eaiHttpParamsDto.getParamsValue());
            }
            TempHttpCode.setParams((Map)authParamsMap);
        }
    }
}

