/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpVerifyBase;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiTokenInvali;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpParamsService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpTemplateService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpVerifyBaseService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiTokenInvaliService;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.service.ExpressionEngineService;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.service.IHttpTokenAuthVerifyService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.AuthHTTPBodyParams;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpBodyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpTemplateDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.TokenAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.factory.EaiHttpAuthenticationFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IEaiHttpAuthenticationManagerExtendService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpParamsPackageVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpTemplateVo;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonStructureService;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.CommomApplicationAuthWayManager;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.LogMsgConstant;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.app.HttpAuthTypeEnum;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.base.apiresult.ResultCode;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.applicationrelease.applicationauth.manager.impl.HttpAuthenticationTokenManagerServiceImpl")
public class HttpAuthenticationTokenManagerServiceImpl
extends CommomApplicationAuthWayManager
implements IEaiHttpAuthenticationManagerExtendService<EaiHttpAuthDto> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpAuthenticationTokenManagerServiceImpl.class);
    private static final String GET_TOKEN_STATUS = "GET_TOKEN_STATUS";
    private static final String TOKEN_GETING = "0";
    private static final String TOKEN_GOT = "1";
    private static final Long GET_TOKEN_LOADING_TIME = 100L;
    private static final Integer GET_TOKEN_LOADING_MAX_COUNT = 10;
    @Resource
    private IEaiHttpParamsService httpParamsService;
    @Resource
    private IEaiHttpTemplateService templateService;
    @Resource
    private IEaiHttpVerifyBaseService httpVerifyBaseService;
    @Resource
    private IEaiTokenInvaliService tokenInvaliService;
    @Resource
    private IHttpTokenAuthVerifyService tokenAuthVerifyService;
    @Resource
    protected EaiCommonStructureService eaiCommonStructureService;
    @Resource
    private ExpressionEngineService expressionEngineService;

    public ApiResponse<Long> httpAuthInfoSave(HttpAuthDto tokenDto) {
        EaiHttpTemplateDto templateDto = this.saveFirstStep(tokenDto);
        JSONObject second = (JSONObject)tokenDto.getHttpAuth().get(1);
        EaiHttpExtend extendsecond = new EaiHttpExtend();
        extendsecond.setExtendId(Long.valueOf(IdWorker.getId((Object)new EaiHttpExtend())));
        extendsecond.setStepCode("2");
        extendsecond.setRemark("http\u9274\u6743\u7b2c\u4e8c\u6b65\uff1a\u83b7\u53d6token");
        extendsecond.setTemplateId(templateDto.getTemplateId());
        this.httpExtendService.save((Object)extendsecond);
        TokenAuthVerifyDto eaiTokenDto = (TokenAuthVerifyDto)JSON.parseObject((String)second.toString(), TokenAuthVerifyDto.class);
        EaiHttpVerifyBase httpVerifyBase = this.insertHttpVerify(eaiTokenDto.getHttpVerifyBase().getHttpUrl(), eaiTokenDto.getHttpVerifyBase().getHttpUrlType(), eaiTokenDto.getHttpBody(), extendsecond.getExtendId(), eaiTokenDto.getHttpVerifyBase().getHttpMethod());
        List<EaiHttpParams> httpParams = this.paddingHttpParamsInfo(eaiTokenDto, httpVerifyBase);
        this.httpParamsService.saveBatch(httpParams);
        List tokenInvalis = eaiTokenDto.getTokenInvalis();
        for (EaiTokenInvali v : tokenInvalis) {
            v.setExtendId(extendsecond.getExtendId());
        }
        this.tokenInvaliService.saveBatch((Collection)tokenInvalis);
        this.saveHttpParamsPosition(tokenDto, templateDto, "3", 2);
        if (HussarUtils.isNotEmpty((Object)eaiTokenDto.getAddCommonStructureList())) {
            boolean flag;
            List addCommonStructureList = eaiTokenDto.getAddCommonStructureList();
            List cacheStruct = addCommonStructureList.stream().filter(c -> true == c.isCacheFlag()).collect(Collectors.toList());
            if (CollectionUtil.isNotEmpty(cacheStruct) && cacheStruct.size() > 1) {
                throw new BaseException("\u4fdd\u5b58\u7684\u6570\u636e\u7ed3\u6784\u9519\u8bef\uff01");
            }
            if (CollectionUtil.isNotEmpty(cacheStruct) && cacheStruct.size() == 1) {
                addCommonStructureList.forEach(a -> {
                    if (a.isCacheFlag()) {
                        String outBodyStructId = String.valueOf(EngineUtil.getId());
                        a.setId(outBodyStructId);
                        ((AuthHTTPBodyParams)eaiTokenDto.getHttpBody().getAuthHTTPBodyParams().get(0)).setQuoteStructureId(outBodyStructId);
                        this.eaiCommonStructureService.saveStructure(a);
                    }
                });
            }
            if (!(flag = this.eaiCommonStructureService.saveBatchStructure(addCommonStructureList).booleanValue())) {
                throw new HussarException("\u65b0\u589e\u5931\u8d25");
            }
        }
        return ApiResponse.success((Object)templateDto.getTemplateId());
    }

    public ApiResponse<Boolean> httpAuthEdit(HttpAuthDto tokenDto, EaiHttpTemplate eaiHttpTemplateOld, EaiHttpTemplateDto currentTemp) {
        EaiHttpExtend extendSecond;
        EaiHttpExtend extendThird = this.getCertainStepByTemplateId(eaiHttpTemplateOld.getTemplateId(), "3");
        if (null != extendThird) {
            this.paramsPositionService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiParamsPosition::getExtendId, (Object)extendThird.getExtendId()));
            this.httpExtendService.removeById((Serializable)extendThird.getExtendId());
        }
        if (null != (extendSecond = this.getCertainStepByTemplateId(eaiHttpTemplateOld.getTemplateId(), "2"))) {
            EaiHttpVerifyBase httpVerifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)extendSecond.getExtendId()));
            this.tokenInvaliService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiTokenInvali::getExtendId, (Object)extendSecond.getExtendId()));
            this.httpVerifyBaseService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)extendSecond.getExtendId()));
            if (null != httpVerifyBase) {
                this.httpParamsService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)httpVerifyBase.getHttpBaseId()));
            }
            this.httpExtendService.removeById((Serializable)extendSecond.getExtendId());
        }
        this.templateService.removeById((Serializable)eaiHttpTemplateOld.getTemplateId());
        this.httpExtendService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)eaiHttpTemplateOld.getTemplateId())).eq(EaiHttpExtend::getStepCode, (Object)TOKEN_GOT));
        if (null != tokenDto) {
            this.deleteFinalStep(tokenDto, eaiHttpTemplateOld, currentTemp);
        }
        return ApiResponse.success();
    }

    public ApiResponse<EaiApiResponseVo> httpAuthVerify(HttpAuthVerifyDto authVerifyDto, boolean isPublished, int repeatCount) {
        boolean tokenInvali;
        this.initHttpAuthVerify(authVerifyDto.getServiceId(), "TOKEN\u9274\u6743", isPublished);
        EaiHttpTemplate eaiHttpTemplate = authVerifyDto.getEaiHttpTemplate();
        TokenAuthVerifyDto tokenDto = this.packageEaiTokenDto(eaiHttpTemplate, authVerifyDto, isPublished);
        ApiResponse tokenVerifyApiResponse = this.tokenAuthVerifyService.tokenVerifyResultParams(tokenDto, isPublished);
        String cacheKey = this.getCacheKey(authVerifyDto);
        if (!tokenVerifyApiResponse.isSuccess()) {
            if (authVerifyDto.isHasCache()) {
                LOGGER.info("\u83b7\u53d6token\u5931\u8d25\uff0c\u6e05\u7a7a\u7f13\u5b58{}-{}", (Object)cacheKey, (Object)cacheKey);
                HussarCacheUtil.evict((String)cacheKey, (Object)cacheKey);
            }
            return tokenVerifyApiResponse;
        }
        ApiResponse<EaiApiResponseVo> eaiApiResponseVo = this.httpAuth(eaiHttpTemplate.getTemplateId(), authVerifyDto, (ApiResponse<EaiApiResponseVo>)tokenVerifyApiResponse, isPublished);
        EaiHttpExtend extendSecond = this.getCertainStepByTemplateId(eaiHttpTemplate.getTemplateId(), "2");
        List eaiTokenInvalis = this.tokenInvaliService.list((Wrapper)new LambdaQueryWrapper().eq(EaiTokenInvali::getExtendId, (Object)extendSecond.getExtendId()));
        if (HussarUtils.isEmpty((Object)eaiApiResponseVo.getData())) {
            return eaiApiResponseVo;
        }
        EaiApiResponse outurlResponse = ((EaiApiResponseVo)eaiApiResponseVo.getData()).getOuturlResponse();
        if (HussarUtils.isEmpty((Object)outurlResponse) || HussarUtils.isEmpty((Object)outurlResponse.getBody())) {
            return eaiApiResponseVo;
        }
        if (CollectionUtil.isEmpty((Collection)eaiTokenInvalis)) {
            if (!eaiApiResponseVo.isSuccess() && authVerifyDto.isHasCache()) {
                LOGGER.info("\u6e05\u7a7a\u7f13\u5b58{}-{}", (Object)cacheKey, (Object)cacheKey);
                HussarCacheUtil.evict((String)cacheKey, (Object)cacheKey);
            }
            return eaiApiResponseVo;
        }
        try {
            tokenInvali = this.judgeInvali(outurlResponse, eaiTokenInvalis, isPublished);
        }
        catch (Exception e) {
            String msg = ToolUtil.isNotEmpty((Object)e.getMessage()) ? e.getMessage() : (ToolUtil.isNotEmpty((Object)e.getCause()) ? e.getCause().getMessage() : "");
            LOGGER.error("\u9274\u6743\u53c2\u6570\u5931\u6548\u5224\u65ad\u5931\u8d25:" + msg);
            return this.getFailResponse(eaiApiResponseVo, msg);
        }
        if (tokenInvali) {
            if (authVerifyDto.isHasCache()) {
                this.cleanToken(cacheKey);
            }
            if (repeatCount < 2) {
                this.pushMsg(authVerifyDto.getServiceId(), LogMsgConstant.getTestSendRe(++repeatCount), isPublished);
                return this.httpAuthVerify(authVerifyDto, isPublished, repeatCount);
            }
            return this.getFailResponse(eaiApiResponseVo, "token\u5931\u6548,\u53d1\u9001\u591a\u6b21token\u8bf7\u6c42,\u4ecd\u7136\u5931\u6548!");
        }
        return eaiApiResponseVo;
    }

    private ApiResponse<EaiApiResponseVo> getFailResponse(ApiResponse<EaiApiResponseVo> eaiApiResponseVo, String msg) {
        eaiApiResponseVo.setCode(ResultCode.FAILURE.getCode());
        eaiApiResponseVo.setSuccess(false);
        eaiApiResponseVo.setMsg(msg);
        EaiApiResponseVo apiResponseVo = (EaiApiResponseVo)eaiApiResponseVo.getData();
        apiResponseVo.setEscapeResponse((Object)ApiResponse.fail((int)ResultCode.FAILURE.getCode(), null, (String)msg));
        return eaiApiResponseVo;
    }

    private String getCacheKey(HttpAuthVerifyDto authVerifyDto) {
        String cacheKey = null;
        if (authVerifyDto.isHasCache()) {
            cacheKey = StringUtil.isNotEmpty((Object)authVerifyDto.getDebugCacheKey()) ? authVerifyDto.getDebugCacheKey() : authVerifyDto.getApplicationCode();
        }
        return cacheKey;
    }

    private void cleanToken(String cacheKey) {
        LOGGER.info("token\u5df2\u5931\u6548:{}-{}", (Object)cacheKey, (Object)cacheKey);
        if (StringUtil.isNotEmpty((Object)HussarCacheUtil.get((String)cacheKey, (Object)GET_TOKEN_STATUS)) && TOKEN_GETING.equals(HussarCacheUtil.get((String)cacheKey, (Object)GET_TOKEN_STATUS))) {
            int count = 0;
            while (TOKEN_GETING.equals(HussarCacheUtil.get((String)cacheKey, (Object)GET_TOKEN_STATUS))) {
                LOGGER.info("token\u5df2\u5931\u6548:{}-{},\u5f53\u524dtoken\u72b6\u6001\u4f4d\uff1a{}-\u6b63\u5728\u83b7\u53d6\uff0c\u7b2c{}\u6b21loading", new Object[]{cacheKey, cacheKey, HussarCacheUtil.get((String)cacheKey, (Object)GET_TOKEN_STATUS), count + 1});
                try {
                    if (count < GET_TOKEN_LOADING_MAX_COUNT) {
                        ++count;
                        Thread.sleep(GET_TOKEN_LOADING_TIME);
                        continue;
                    }
                    LOGGER.info("token\u5df2\u5931\u6548,loading\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650{}\u6b21,\u6e05\u7a7a\u7f13\u5b58{}-{}", new Object[]{GET_TOKEN_LOADING_MAX_COUNT, cacheKey, cacheKey});
                    HussarCacheUtil.evict((String)cacheKey, (Object)cacheKey);
                    break;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        } else {
            LOGGER.info("token\u5df2\u5931\u6548,\u6e05\u7a7a\u7f13\u5b58{}-{}", (Object)cacheKey, (Object)cacheKey);
            HussarCacheUtil.evict((String)cacheKey, (Object)cacheKey);
        }
    }

    private boolean judgeInvali(EaiApiResponse outurlResponse, List<EaiTokenInvali> eaiTokenInvalis, boolean isPublished) {
        boolean tokenInvali = false;
        for (EaiTokenInvali p : eaiTokenInvalis) {
            List values;
            Set valueSet;
            Map<String, Object> valueMap = this.getValueMap(p.getParamName(), outurlResponse);
            Object o = this.expressionEngineService.executeExpression(p.getParamName(), valueMap, isPublished);
            if (null == o && p.getConditionValue() != null) continue;
            if (null == o) break;
            if ("00".equals(p.getJudgeCondition())) {
                if (!o.toString().equals(p.getConditionValue())) continue;
                tokenInvali = true;
                break;
            }
            if ("01".equals(p.getJudgeCondition())) {
                if (o.toString().equals(p.getConditionValue())) continue;
                tokenInvali = true;
                break;
            }
            if (!"02".equals(p.getJudgeCondition()) || !HussarUtils.isNotEmpty((Object)p.getConditionValue()) || !(valueSet = (values = Stream.of(p.getConditionValue().split(",")).collect(Collectors.toList())).stream().collect(Collectors.toSet())).contains(o.toString())) continue;
            tokenInvali = true;
            break;
        }
        return tokenInvali;
    }

    public ApiResponse<EaiHttpTemplateVo> httpAuthDetail(EaiHttpTemplateVo eaiHttpTemplate) {
        Map<Long, CommonConstant> commonConstantsMap = this.getCommonConstantsMap(eaiHttpTemplate.getApplicationCode(), false);
        Map<Long, EaiApplicationAuth> applicationAuthMap = this.getEaiApplicationAuthMap(eaiHttpTemplate.getApplicationCode());
        EaiHttpExtend extend = this.getCertainStepByTemplateId(eaiHttpTemplate.getTemplateId(), "2");
        EaiHttpVerifyBase verifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)extend.getExtendId()));
        List params = this.httpParamsService.list((Wrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)verifyBase.getHttpBaseId()));
        List<EaiHttpParams> header = params.stream().filter(p -> TOKEN_GETING.equals(p.getParamsPosition())).collect(Collectors.toList());
        List<EaiHttpParams> query = params.stream().filter(p -> "2".equals(p.getParamsPosition())).collect(Collectors.toList());
        List<EaiHttpParams> body = params.stream().filter(p -> TOKEN_GOT.equals(p.getParamsPosition())).collect(Collectors.toList());
        List<EaiHttpParams> authParams = params.stream().filter(p -> "3".equals(p.getParamsPosition())).collect(Collectors.toList());
        EaiHttpParamsPackageVo tokenParams = this.getEaiHttpParams(header, body, query, commonConstantsMap, applicationAuthMap, authParams, verifyBase.getContentType());
        tokenParams.setAuthParams(this.getSourceName(authParams, commonConstantsMap, applicationAuthMap));
        if (StringUtil.isEmpty((Object)verifyBase.getHttpUrlType())) {
            verifyBase.setHttpUrlType(TOKEN_GETING);
        }
        eaiHttpTemplate.setAuthVerify(verifyBase);
        eaiHttpTemplate.setEaiHttpParams(tokenParams);
        List invalis = this.tokenInvaliService.list((Wrapper)new LambdaQueryWrapper().eq(EaiTokenInvali::getExtendId, (Object)extend.getExtendId()));
        eaiHttpTemplate.setTokenInvalis(invalis);
        Map<String, EaiParamsPosition> paramsPosissionMap = this.queryAuthParamsPositionMap(eaiHttpTemplate.getTemplateId(), "3");
        this.getHttpAuthPosissionParams(eaiHttpTemplate, commonConstantsMap, applicationAuthMap, paramsPosissionMap);
        return ApiResponse.success((Object)eaiHttpTemplate);
    }

    private TokenAuthVerifyDto packageEaiTokenDto(EaiHttpTemplate eaiHttpTemplate, HttpAuthVerifyDto authVerifyDto, boolean isPublished) {
        List<EaiHttpParams> httpParamsQuery;
        TokenAuthVerifyDto eaiTokenDto = new TokenAuthVerifyDto();
        EaiHttpExtend extendSencod = this.getCertainStepByTemplateId(eaiHttpTemplate.getTemplateId(), "2");
        EaiHttpVerifyBase httpVerifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)extendSencod.getExtendId()));
        eaiTokenDto.setHttpVerifyBase(httpVerifyBase);
        List eaiHttpParams = this.httpParamsService.list((Wrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)httpVerifyBase.getHttpBaseId()));
        Map<Long, EaiHttpParamsDto> tokenVerifyMap = this.getAuthParamsMap(authVerifyDto.getTokenVerifys());
        List<EaiHttpParams> httpParamsHeader = eaiHttpParams.stream().filter(p -> TOKEN_GETING.equals(p.getParamsPosition())).collect(Collectors.toList());
        if (CollectionUtil.isNotEmpty(httpParamsHeader)) {
            List<AuthHTTPBodyParams> authHTTPHeaderParams = this.getAuthHTTPBodyParams(httpParamsHeader);
            List<EaiHttpParamsDto> realHttpParamsHeader = this.analysisHttpRequestParamsForStruct(authVerifyDto.getServiceId(), authHTTPHeaderParams, tokenVerifyMap, isPublished);
            eaiTokenDto.setHttpHeader(realHttpParamsHeader);
            this.pushMsg(authVerifyDto.getServiceId(), "\u7ec4\u88c5TOKEN\u9274\u6743\u9a8c\u8bc1\u53c2\u6570\uff1aHTTP\u8bf7\u6c42\u5934\u89e3\u6790\u5b8c\u6210", isPublished);
        }
        if (CollectionUtil.isNotEmpty(httpParamsQuery = eaiHttpParams.stream().filter(p -> "2".equals(p.getParamsPosition())).collect(Collectors.toList()))) {
            List<AuthHTTPBodyParams> authHTTPQueryParams = this.getAuthHTTPBodyParams(httpParamsQuery);
            List<EaiHttpParamsDto> realHttpParamsQuery = this.analysisHttpRequestParamsForStruct(authVerifyDto.getServiceId(), authHTTPQueryParams, tokenVerifyMap, isPublished);
            eaiTokenDto.setHttpQueryParam(realHttpParamsQuery);
            this.pushMsg(authVerifyDto.getServiceId(), "\u7ec4\u88c5TOKEN\u9274\u6743\u9a8c\u8bc1\u53c2\u6570\uff1aURL\u67e5\u8be2\u53c2\u6570\u89e3\u6790\u5b8c\u6210", isPublished);
        }
        if (HussarUtils.isNotEmpty((Object)httpVerifyBase.getContentType())) {
            List<EaiHttpParams> httpParamsBody = eaiHttpParams.stream().filter(p -> TOKEN_GOT.equals(p.getParamsPosition())).collect(Collectors.toList());
            EaiHttpBodyDto httpBody = new EaiHttpBodyDto();
            httpBody.setContentType(httpVerifyBase.getContentType());
            List<AuthHTTPBodyParams> authHTTPBodyParams = this.getAuthHTTPBodyParams(httpParamsBody);
            List<EaiHttpParamsDto> realHttpParamsBody = this.analysisHttpRequestParamsForStruct(authVerifyDto.getServiceId(), authHTTPBodyParams, tokenVerifyMap, isPublished);
            httpBody.setBodyParam(realHttpParamsBody);
            eaiTokenDto.setHttpBody(httpBody);
        }
        eaiTokenDto.setTokenVerifys(authVerifyDto.getTokenVerifys());
        eaiTokenDto.setTemplateId(eaiHttpTemplate.getTemplateId());
        eaiTokenDto.setConnectId(authVerifyDto.getConnectId());
        eaiTokenDto.setHasCache(authVerifyDto.isHasCache());
        eaiTokenDto.setApplicationCode(authVerifyDto.getApplicationCode());
        eaiTokenDto.setDebugCacheKey(authVerifyDto.getDebugCacheKey());
        eaiTokenDto.setHasCheckTokenValue(true);
        return eaiTokenDto;
    }

    private List<AuthHTTPBodyParams> getAuthHTTPBodyParams(List<EaiHttpParams> httpParams) {
        ArrayList bodyParams = Lists.newArrayListWithCapacity((int)5);
        if (CollectionUtil.isNotEmpty(httpParams)) {
            for (EaiHttpParams p : httpParams) {
                AuthHTTPBodyParams pVo = new AuthHTTPBodyParams();
                boolean newDataFlag = true;
                AuthHTTPBodyParams newParam = null;
                try {
                    newParam = (AuthHTTPBodyParams)JSON.parseObject((String)p.getParamsValue(), AuthHTTPBodyParams.class);
                }
                catch (Exception e) {
                    LOGGER.info("ParamsValue\u5b58\u7684\u662f\u65e7\u6570\u636e{}", (Object)p.getParamsValue());
                    newDataFlag = false;
                }
                if (newDataFlag) {
                    BeanUtil.copy((Object)newParam, (Object)pVo);
                } else {
                    pVo.setName(p.getParamsNameEn());
                    pVo.setParamsValue(p.getParamsValue());
                    pVo.setParamsFrom(p.getParamsFrom());
                    pVo.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRING.getType()));
                    pVo.setRemark(p.getRemark());
                }
                bodyParams.add(pVo);
            }
        }
        return bodyParams;
    }

    public void afterPropertiesSet() throws BaseException {
        EaiHttpAuthenticationFactory.registerAuth((String)HttpAuthTypeEnum.HTTPTYPE_TOKEN.getAuthKey(), (IEaiHttpAuthenticationManagerExtendService)this);
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(IEaiTokenInvaliService.class.getName());
        HashMap mapperDomain = Maps.newHashMapWithExpectedSize((int)1);
        mapperDomain.put(IEaiTokenInvaliService.class.getName(), EaiTokenInvali.class.getName());
        EaiHttpAuthenticationFactory.registerExtra((String)HttpAuthTypeEnum.HTTPTYPE_TOKEN.getAuthKey(), list);
        EaiHttpAuthenticationFactory.registerExtraDomain((String)HttpAuthTypeEnum.HTTPTYPE_TOKEN.getAuthKey(), (Map)mapperDomain);
    }

    public ApiResponse<EaiHttpAuthDto> selectHttpTemplateInfos(String applicationCode, boolean published) {
        EaiHttpAuthDto dto = this.commonSelect(applicationCode, published);
        HashMap map = new HashMap();
        List eaiHttpExtends = dto.getHttpExtend();
        if (HussarUtils.isNotEmpty((Object)eaiHttpExtends)) {
            List<Long> ids = eaiHttpExtends.stream().map(EaiHttpExtend::getExtendId).collect(Collectors.toList());
            ArrayList extendDtos = new ArrayList();
            ids.forEach(id -> {
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiTokenInvali::getExtendId, id);
                List list1 = this.tokenInvaliService.list((Wrapper)queryWrapper);
                if (HussarUtils.isNotEmpty((Object)list1)) {
                    extendDtos.addAll(list1);
                }
            });
            String mapperFullPath = this.getKey();
            map.put(mapperFullPath, extendDtos);
            HashMap mapperDomain = Maps.newHashMapWithExpectedSize((int)1);
            mapperDomain.put(mapperFullPath, this.getDomain().get(mapperFullPath));
            dto.setMapperDomain((Map)mapperDomain);
            dto.setExtendDto(map);
        }
        return ApiResponse.success((Object)dto);
    }

    public ApiResponse<EaiHttpAuthDto> selectHttpTemplateInfosWithNewIds(String applicationCode, Boolean publishing) {
        EaiHttpAuthDto dto = this.commonSelectNew(applicationCode, publishing);
        HashMap map = new HashMap();
        List eaiHttpExtends = dto.getHttpExtend();
        if (HussarUtils.isNotEmpty((Object)eaiHttpExtends)) {
            Long extendIdSecondNew = ((EaiHttpExtend)eaiHttpExtends.get(1)).getExtendId();
            ArrayList extendDtos = new ArrayList();
            Map cmaps = dto.getIdMaps();
            if (cmaps.containsValue(extendIdSecondNew)) {
                Long[] fid = new Long[]{extendIdSecondNew};
                cmaps.forEach((k, v) -> {
                    if (v.equals(fid[0])) {
                        fid[0] = k;
                    }
                });
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiTokenInvali::getExtendId, (Object)fid[0]);
                List list1 = this.tokenInvaliService.list((Wrapper)queryWrapper);
                if (HussarUtils.isNotEmpty((Object)list1)) {
                    list1.forEach(eaiTokenInvali -> {
                        eaiTokenInvali.setExtendId((Long)dto.getIdMaps().get(eaiTokenInvali.getExtendId()));
                        eaiTokenInvali.setInvalidationId(EngineUtil.getId());
                        extendDtos.add(eaiTokenInvali);
                    });
                }
            }
            map.put(this.getKey(), extendDtos);
            dto.setExtendDto(map);
        }
        return ApiResponse.success((Object)dto);
    }

    private String getKey() {
        return (String)EaiHttpAuthenticationFactory.getRegisterExtra((String)HttpAuthTypeEnum.HTTPTYPE_TOKEN.getAuthKey()).get(0);
    }

    private Map<String, String> getDomain() {
        return EaiHttpAuthenticationFactory.getRegisterExtraDomain((String)HttpAuthTypeEnum.HTTPTYPE_TOKEN.getAuthKey());
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> saveHttpTemplateInfos(EaiHttpAuthDto eaiHttpAuthDto) {
        boolean common = this.commonSaveOrUpdateById(eaiHttpAuthDto, true);
        Map map = eaiHttpAuthDto.getExtendDto();
        boolean extra = true;
        List list = ((List)map.get(this.getKey())).stream().map(o -> (EaiTokenInvali)o).collect(Collectors.toList());
        if (HussarUtils.isNotEmpty(list)) {
            extra = this.tokenInvaliService.saveBatch(list);
        }
        if (common && extra) {
            return ApiResponse.success((Object)true);
        }
        throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<Boolean> updateHttpTemplateInfos(EaiHttpAuthDto eaiHttpAuthDto) {
        Map map = eaiHttpAuthDto.getExtendDto();
        boolean common = this.commonSaveOrUpdateById(eaiHttpAuthDto, false);
        boolean extra = true;
        List list = JSON.parseArray((String)JSON.toJSONString(map.get(this.getKey())), EaiTokenInvali.class);
        if (HussarUtils.isNotEmpty((Object)list)) {
            LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiTokenInvali::getExtendId, (Collection)eaiHttpAuthDto.getExtendIds());
            this.tokenInvaliService.remove((Wrapper)queryWrapper);
            extra = this.tokenInvaliService.saveBatch((Collection)list);
        }
        if (common && extra) {
            return ApiResponse.success((Object)true);
        }
        throw new BaseException("\u4fdd\u5b58\u5931\u8d25");
    }

    public void authParamsValueCleanImpl(EaiHttpTemplate eaiHttpTemplate, Long authParamId) {
        this.updateParamsValue(authParamId, eaiHttpTemplate, "2");
        this.positionUpdateParamsValue(eaiHttpTemplate, authParamId, "3");
        this.updateParamsValue(authParamId, eaiHttpTemplate, "9");
    }

    public boolean verifyAuthParamHasUse(EaiHttpTemplate eaiHttpTemplate, Long paramId, String paramsPosition) {
        this.verifyHasUseInStep(paramId, eaiHttpTemplate, "2", paramsPosition);
        this.verifyPositionHasUserposition(eaiHttpTemplate, paramId, "3", paramsPosition);
        this.verifyHasUseInStep(paramId, eaiHttpTemplate, "9", paramsPosition);
        return false;
    }
}

