/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpTemplateDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.factory.EaiHttpAuthenticationFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IEaiHttpAuthenticationManagerExtendService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpTemplateVo;
import com.jxdinfo.hussar.eai.atomicbase.api.common.service.EaiApiCommonService;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.CommomApplicationAuthWayManager;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.enums.app.HttpAuthTypeEnum;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.applicationrelease.applicationauth.manager.impl.HttpAuthenticationBasicAuthManagerServiceImpl")
public class HttpAuthenticationBasicAuthManagerServiceImpl
extends CommomApplicationAuthWayManager
implements IEaiHttpAuthenticationManagerExtendService<EaiHttpAuthDto> {
    @Resource
    private EaiApiCommonService eaiApiCommonService;

    public ApiResponse<Long> httpAuthInfoSave(HttpAuthDto tokenDto) {
        EaiHttpTemplateDto templateDto = this.saveFirstStep(tokenDto);
        this.saveHttpParamsPosition(tokenDto, templateDto, "2", 1);
        return ApiResponse.success((Object)templateDto.getTemplateId());
    }

    public ApiResponse<Boolean> httpAuthEdit(HttpAuthDto tokenDto, EaiHttpTemplate eaiHttpTemplateOld, EaiHttpTemplateDto currentTemp) {
        EaiHttpExtend extendThird = this.getCertainStepByTemplateId(eaiHttpTemplateOld.getTemplateId(), "2");
        if (null != extendThird) {
            this.paramsPositionService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiParamsPosition::getExtendId, (Object)extendThird.getExtendId()));
            this.httpExtendService.removeById((Serializable)extendThird.getExtendId());
        }
        this.httpTemplateService.removeById((Serializable)eaiHttpTemplateOld.getTemplateId());
        this.httpExtendService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)eaiHttpTemplateOld.getTemplateId())).eq(EaiHttpExtend::getStepCode, (Object)"1"));
        if (null != tokenDto) {
            this.deleteFinalStep(tokenDto, eaiHttpTemplateOld, currentTemp);
        }
        return ApiResponse.success();
    }

    public ApiResponse<EaiApiResponseVo> httpAuthVerify(HttpAuthVerifyDto authVerifyDto, boolean isPublished, int repeatCount) {
        String serviceId = authVerifyDto.getServiceId();
        this.initHttpAuthVerify(serviceId, "BASIC AUHT\u9274\u6743", isPublished);
        EaiHttpTemplate eaiHttpTemplate = authVerifyDto.getEaiHttpTemplate();
        Map<Long, EaiHttpParamsDto> tokenVerifyMap = this.authParams(serviceId, authVerifyDto.getTokenVerifys(), isPublished);
        this.pushMsg(serviceId, "\u89e3\u6790\u9274\u6743\u53c2\u6570\uff1a\u5b8c\u6210", isPublished);
        EaiApiParams requestParam = this.getEaiApiParams(eaiHttpTemplate.getTemplateId(), null, authVerifyDto, tokenVerifyMap, "2", isPublished);
        this.stepThree(authVerifyDto.getServiceId(), requestParam, isPublished);
        EaiApiResponse outUriresponse = this.eaiApiCommonService.getConvertResponse(requestParam);
        this.pushMsg(serviceId, "\u8bf7\u6c42\u7ed3\u675f\uff0c\u5f00\u59cb\u7ec4\u88c5\u8fd4\u56de\u503c...", isPublished);
        return this.outUriRreponseDataPackage(authVerifyDto.getServiceId(), requestParam, outUriresponse, new EaiApiResponseVo(), authVerifyDto.getOutMapping(), authVerifyDto.getCallSpecificaList(), true, isPublished);
    }

    public ApiResponse<EaiHttpTemplateVo> httpAuthDetail(EaiHttpTemplateVo eaiHttpTemplate) {
        Map<Long, CommonConstant> commonConstantsMap = this.getCommonConstantsMap(eaiHttpTemplate.getApplicationCode(), false);
        Map<Long, EaiApplicationAuth> applicationAuthMap = this.getEaiApplicationAuthMap(eaiHttpTemplate.getApplicationCode());
        EaiHttpExtend extendSecond = this.getCertainStepByTemplateId(eaiHttpTemplate.getTemplateId(), "2");
        List paramsPosissions = this.paramsPositionService.list((Wrapper)new LambdaQueryWrapper().eq(EaiParamsPosition::getExtendId, (Object)extendSecond.getExtendId()));
        Map<String, EaiParamsPosition> paramsPosissionMap = paramsPosissions.stream().collect(Collectors.toMap(EaiParamsPosition::getParamsPosition, Function.identity()));
        this.getHttpAuthPosissionParams(eaiHttpTemplate, commonConstantsMap, applicationAuthMap, paramsPosissionMap);
        return ApiResponse.success((Object)eaiHttpTemplate);
    }

    public void afterPropertiesSet() throws BaseException {
        EaiHttpAuthenticationFactory.registerAuth((String)HttpAuthTypeEnum.HTTPTYPE_BASIC_AUTH.getAuthKey(), (IEaiHttpAuthenticationManagerExtendService)this);
    }

    public ApiResponse<EaiHttpAuthDto> selectHttpTemplateInfos(String applicationCode, boolean published) {
        return ApiResponse.success((Object)this.commonSelect(applicationCode, published));
    }

    public ApiResponse<EaiHttpAuthDto> selectHttpTemplateInfosWithNewIds(String applicationCode, Boolean publishing) {
        return ApiResponse.success((Object)this.commonSelectNew(applicationCode, publishing));
    }

    public ApiResponse<Boolean> saveHttpTemplateInfos(EaiHttpAuthDto eaiHttpAuthDto) {
        return ApiResponse.success((Object)this.commonSaveOrUpdateById(eaiHttpAuthDto, true));
    }

    public ApiResponse<Boolean> updateHttpTemplateInfos(EaiHttpAuthDto eaiHttpAuthDto) {
        return ApiResponse.success((Object)this.commonSaveOrUpdateById(eaiHttpAuthDto, false));
    }

    public void authParamsValueCleanImpl(EaiHttpTemplate eaiHttpTemplate, Long authParamId) {
        this.positionUpdateParamsValue(eaiHttpTemplate, authParamId, "2");
        this.updateParamsValue(authParamId, eaiHttpTemplate, "9");
    }

    public boolean verifyAuthParamHasUse(EaiHttpTemplate eaiHttpTemplate, Long authParamId, String paramsPosition) {
        this.verifyPositionHasUserposition(eaiHttpTemplate, authParamId, "2", paramsPosition);
        this.verifyHasUseInStep(authParamId, eaiHttpTemplate, "9", paramsPosition);
        return false;
    }
}

