/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiCallSpecificationInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiApplicationAuth;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpExtend;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpParams;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpTemplate;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiHttpVerifyBase;
import com.jxdinfo.hussar.eai.appauth.api.model.EaiParamsPosition;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpExtendService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpParamsService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpTemplateService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiHttpVerifyBaseService;
import com.jxdinfo.hussar.eai.appauth.api.service.IEaiParamsPositionService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiApiResponse;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpTemplateDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.TokenAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpBodyVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpParamsPackageVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiHttpTemplateVo;
import com.jxdinfo.hussar.eai.atomicbase.api.common.service.EaiApiCommonService;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.manager.LogMsgConstant;
import com.jxdinfo.hussar.eai.atomicbase.server.appauth.service.impl.CommomHttpAuthServiceImpl;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommomApplicationAuthWayManager
extends CommomHttpAuthServiceImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommomApplicationAuthWayManager.class);
    private static final String EXTENDID_EMPTY = "extendId is empty";
    private static final String EXTENDID_HTTPID = "httpId is empty";
    @Resource
    protected IEaiHttpTemplateService httpTemplateService;
    @Resource
    protected IEaiHttpExtendService httpExtendService;
    @Resource
    protected IEaiParamsPositionService paramsPositionService;
    @Resource
    private EaiApiCommonService eaiApiCommonService;
    @Resource
    private IEaiHttpVerifyBaseService httpVerifyBaseService;
    @Resource
    private IEaiHttpParamsService httpParamsService;
    @Resource
    private IEaiParamsPositionService paramsPosissionService;
    @Resource
    private IApiCallSpecificationInfoService callSpecificationInfoService;

    public void initHttpAuthVerify(String serviceId, String type, boolean isPublished) {
        if (!isPublished) {
            this.pushMsg(serviceId, LogMsgConstant.getType(type), isPublished);
            this.pushMsg(serviceId, LogMsgConstant.getSplit(1), isPublished);
            this.pushMsg(serviceId, "\u5f00\u59cb\u89e3\u6790\u9274\u6743\u53c2\u6570...", isPublished);
        }
    }

    public void stepThree(String serviceId, EaiApiParams requestParam, boolean isPublished) {
        if (!isPublished) {
            this.pushMsg(serviceId, LogMsgConstant.getMergeParams(requestParam), isPublished);
            this.pushMsg(serviceId, LogMsgConstant.getSplit(3), isPublished);
            this.pushMsg(serviceId, "\u53d1\u8d77http\u8bf7\u6c42...", isPublished);
        }
    }

    public EaiHttpTemplateDto saveFirstStep(HttpAuthDto tokenDto) {
        JSONObject first = (JSONObject)tokenDto.getHttpAuth().get(0);
        EaiHttpTemplateDto templateDto = (EaiHttpTemplateDto)JSONObject.parseObject((String)first.toJSONString(), EaiHttpTemplateDto.class);
        Long templateIdExist = templateDto.getTemplateId();
        if (HussarUtils.isEmpty((Object)templateIdExist)) {
            templateIdExist = IdWorker.getId((Object)new EaiHttpTemplateDto());
        }
        templateDto.setTemplateId(templateIdExist);
        templateDto.setTemplateType("0");
        EaiHttpExtend extendFirst = new EaiHttpExtend();
        extendFirst.setStepCode("1");
        extendFirst.setTemplateId(templateDto.getTemplateId());
        EaiHttpTemplate template = new EaiHttpTemplate();
        BeanUtil.copy((Object)templateDto, (Object)template);
        this.httpTemplateService.save((Object)template);
        this.httpExtendService.save((Object)extendFirst);
        return templateDto;
    }

    public void saveHttpParamsPosition(HttpAuthDto tokenDto, EaiHttpTemplateDto templateDto, String stepCode, int index) {
        JSONObject jsonObject = (JSONObject)tokenDto.getHttpAuth().get(index);
        EaiHttpExtend httpExtend = new EaiHttpExtend();
        httpExtend.setExtendId(Long.valueOf(IdWorker.getId((Object)new EaiHttpExtend())));
        httpExtend.setStepCode(stepCode);
        httpExtend.setTemplateId(templateDto.getTemplateId());
        this.httpExtendService.save((Object)httpExtend);
        TokenAuthVerifyDto eaiTokenPositionDto = (TokenAuthVerifyDto)JSONObject.parseObject((String)jsonObject.toString(), TokenAuthVerifyDto.class);
        ArrayList EaiParamsPositions = Lists.newArrayListWithCapacity((int)3);
        this.getParamsPosission(httpExtend, eaiTokenPositionDto.getHttpHeader(), "0", EaiParamsPositions);
        this.getParamsPosission(httpExtend, eaiTokenPositionDto.getHttpQueryParam(), "2", EaiParamsPositions);
        if (null != eaiTokenPositionDto.getHttpBody()) {
            this.getParamsPosission(httpExtend, eaiTokenPositionDto.getHttpBody().getBodyParam(), "1", EaiParamsPositions);
        }
        this.paramsPosissionService.saveBatch((Collection)EaiParamsPositions);
    }

    public List<EaiHttpParams> paddingHttpParamsInfo(TokenAuthVerifyDto eaiTokenDto, EaiHttpVerifyBase httpVerifyBase) {
        ArrayList httpParams = Lists.newArrayListWithCapacity((int)10);
        this.getHttpParamsForStruct(httpParams, eaiTokenDto.getHttpHeaderForStruct(), "0", httpVerifyBase);
        this.getHttpParamsForStruct(httpParams, eaiTokenDto.getHttpQueryParamForStruct(), "2", httpVerifyBase);
        if (null != eaiTokenDto.getHttpBody() && CollectionUtil.isNotEmpty((Collection)eaiTokenDto.getHttpBody().getAuthHTTPBodyParams())) {
            this.getHttpParamsForStruct(httpParams, eaiTokenDto.getHttpBody().getAuthHTTPBodyParams(), "1", httpVerifyBase);
        }
        this.getHttpParams(httpParams, eaiTokenDto.getTokenVerifys(), "3", httpVerifyBase);
        return httpParams;
    }

    public void getParamsPosission(EaiHttpExtend extendthird, List<EaiHttpParamsDto> httpParamsPosition, String paramsPosition, List<EaiParamsPosition> EaiParamsPositions) {
        ArrayList effectiveHeadList = Lists.newArrayListWithExpectedSize((int)3);
        if (HussarUtils.isNotEmpty(httpParamsPosition)) {
            for (EaiHttpParamsDto head : httpParamsPosition) {
                HashMap effectiveMap = Maps.newHashMapWithExpectedSize((int)5);
                effectiveMap.put("paramsName", head.getParamsName());
                effectiveMap.put("paramsNameEn", head.getParamsNameEn());
                effectiveMap.put("paramsFrom", head.getParamsFrom());
                effectiveMap.put("paramsValue", head.getParamsValue());
                effectiveMap.put("remark", head.getRemark());
                effectiveHeadList.add(effectiveMap);
            }
            String effectiveJson = JSON.toJSONString((Object)effectiveHeadList);
            EaiParamsPosition header = new EaiParamsPosition();
            header.setEffective(effectiveJson);
            header.setParamsPosition(paramsPosition);
            header.setExtendId(extendthird.getExtendId());
            EaiParamsPositions.add(header);
        }
    }

    public void deleteFinalStep(HttpAuthDto tokenDto, EaiHttpTemplate eaiHttpTemplateOld, EaiHttpTemplateDto currentTemp) {
        EaiHttpExtend finalExtend;
        if (!eaiHttpTemplateOld.getHttpType().equals(currentTemp.getHttpType()) && null != (finalExtend = this.getCertainStepByTemplateId(eaiHttpTemplateOld.getTemplateId(), "9"))) {
            EaiHttpVerifyBase httpVerifyBaseFinal = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)finalExtend.getExtendId()));
            this.httpVerifyBaseService.removeById((Serializable)httpVerifyBaseFinal.getHttpBaseId());
            this.httpParamsService.remove((Wrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)httpVerifyBaseFinal.getHttpBaseId()));
            this.httpExtendService.removeById((Serializable)finalExtend.getExtendId());
        }
        JSONObject first = (JSONObject)tokenDto.getHttpAuth().get(0);
        EaiHttpTemplateDto templateDto = (EaiHttpTemplateDto)JSONObject.parseObject((String)first.toJSONString(), EaiHttpTemplateDto.class);
        templateDto.setTemplateId(eaiHttpTemplateOld.getTemplateId());
        tokenDto.getHttpAuth().set(0, (JSONObject)JSONObject.toJSON((Object)templateDto));
    }

    public ApiResponse<EaiApiResponseVo> httpAuth(Long templateId, HttpAuthVerifyDto authVerifyDto, ApiResponse<EaiApiResponseVo> tokenVerifyApiResponse, boolean isPublished) {
        String serviceId = authVerifyDto.getServiceId();
        Map<Long, EaiHttpParamsDto> tokenVerifyMap = this.authParams(serviceId, authVerifyDto.getTokenVerifys(), isPublished);
        EaiApiResponse apiResponse = null;
        if (null != tokenVerifyApiResponse.getData()) {
            apiResponse = ((EaiApiResponseVo)tokenVerifyApiResponse.getData()).getTokenResponse();
        }
        EaiApiParams requestParam = this.getEaiApiParams(templateId, apiResponse, authVerifyDto, tokenVerifyMap, "3", isPublished);
        this.stepThree(authVerifyDto.getServiceId(), requestParam, isPublished);
        EaiApiResponse outUriresponse = null;
        try {
            outUriresponse = this.eaiApiCommonService.getConvertResponse(requestParam);
        }
        catch (Exception e) {
            LOGGER.error("\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38\uff1a", (Throwable)e);
            this.pushMsg(serviceId, "\u8bf7\u6c42\u7ed3\u675f\uff0c\u5f00\u59cb\u7ec4\u88c5\u8fd4\u56de\u503c...", isPublished);
            if (null == outUriresponse) {
                outUriresponse = new EaiApiResponse();
                outUriresponse.setException("\u63a5\u53e3\u9a8c\u8bc1\u5f02\u5e38\uff1a" + e.getMessage());
            }
            return this.outUriRreponseDataPackage(serviceId, requestParam, outUriresponse, (EaiApiResponseVo)tokenVerifyApiResponse.getData(), authVerifyDto.getOutMapping(), authVerifyDto.getCallSpecificaList(), false, isPublished);
        }
        this.pushMsg(serviceId, "\u8bf7\u6c42\u7ed3\u675f\uff0c\u5f00\u59cb\u7ec4\u88c5\u8fd4\u56de\u503c...", isPublished);
        return this.outUriRreponseDataPackage(serviceId, requestParam, outUriresponse, (EaiApiResponseVo)tokenVerifyApiResponse.getData(), authVerifyDto.getOutMapping(), authVerifyDto.getCallSpecificaList(), true, isPublished);
    }

    protected EaiHttpAuthDto commonSelectNew(String applicationCode, boolean publishing) {
        EaiHttpAuthDto eaiHttpAuthDto = this.commonSelect(applicationCode, !publishing);
        String query = null;
        if (publishing) {
            query = "2";
        }
        if (HussarUtils.isNotEmpty((Object)eaiHttpAuthDto)) {
            eaiHttpAuthDto.getEaiHttpTemplate().setTemplateType(query);
            Long tempId = EngineUtil.getId();
            eaiHttpAuthDto.getEaiHttpTemplate().setTemplateId(tempId);
            List eaiHttpExtends = eaiHttpAuthDto.getHttpExtend();
            if (HussarUtils.isNotEmpty((Object)eaiHttpExtends)) {
                List eaiHttpVerifyDtos;
                HashMap map = new HashMap(eaiHttpExtends.size());
                eaiHttpExtends.forEach(eaiHttpExtend -> {
                    eaiHttpExtend.setTemplateId(tempId);
                    Long extendId = EngineUtil.getId();
                    Long oId = eaiHttpExtend.getExtendId();
                    map.put(oId, extendId);
                    eaiHttpExtend.setExtendId(extendId);
                });
                List paramsPositions = eaiHttpAuthDto.getEaiParamsPosition();
                if (HussarUtils.isNotEmpty((Object)paramsPositions)) {
                    paramsPositions.forEach(p -> {
                        p.setExtendId((Long)map.get(p.getExtendId()));
                        p.setPositionId(EngineUtil.getId());
                    });
                }
                if (HussarUtils.isNotEmpty((Object)(eaiHttpVerifyDtos = eaiHttpAuthDto.getEaiHttpVerifyDtos()))) {
                    eaiHttpVerifyDtos.forEach(eaiHttpVerifyDto -> {
                        eaiHttpVerifyDto.getHttpVerifyBase().setExtendId((Long)map.get(eaiHttpVerifyDto.getHttpVerifyBase().getExtendId()));
                        Long httpBaseId = EngineUtil.getId();
                        eaiHttpVerifyDto.getHttpVerifyBase().setHttpBaseId(httpBaseId);
                        List eaiHttpParams = eaiHttpVerifyDto.getHttpParams();
                        if (HussarUtils.isNotEmpty((Object)eaiHttpParams)) {
                            eaiHttpParams.forEach(eaiHttpParam -> {
                                eaiHttpParam.setParamsId(EngineUtil.getId());
                                eaiHttpParam.setHttpId(httpBaseId);
                            });
                            eaiHttpVerifyDto.setHttpParams(eaiHttpParams);
                        }
                    });
                }
                eaiHttpAuthDto.setIdMaps(map);
            }
            if (HussarUtils.isNotEmpty((Object)eaiHttpAuthDto.getCallSpecificaList())) {
                eaiHttpAuthDto.getCallSpecificaList().forEach(call -> {
                    call.setApiId(tempId);
                    call.setSpecificatId(Long.valueOf(IdWorker.getId((Object)new ApiCallSpecificationInfo())));
                });
            }
        }
        return eaiHttpAuthDto;
    }

    protected EaiHttpAuthDto commonSelect(String applicationCode, boolean published) {
        EaiHttpAuthDto eaiHttpAuthDto = new EaiHttpAuthDto();
        eaiHttpAuthDto.setApplicationCode(applicationCode);
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)applicationCode);
        if (!published) {
            queryWrapper.isNotNull(EaiHttpTemplate::getTemplateType);
        } else {
            queryWrapper.isNull(EaiHttpTemplate::getTemplateType);
        }
        EaiHttpTemplate eaiHttpTemplate = (EaiHttpTemplate)this.httpTemplateService.getOne((Wrapper)queryWrapper);
        eaiHttpAuthDto.setEaiHttpTemplate(eaiHttpTemplate);
        List eaiHttpExtend = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)eaiHttpTemplate)) {
            LambdaQueryWrapper extendWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, (Object)eaiHttpTemplate.getTemplateId())).orderByAsc(EaiHttpExtend::getStepCode);
            eaiHttpExtend = this.httpExtendService.list((Wrapper)extendWrapper);
            List apiCallSpecifiList = this.callSpecificationInfoService.selectCallInfoListByApiId(eaiHttpTemplate.getTemplateId());
            eaiHttpAuthDto.setCallSpecificaList(apiCallSpecifiList);
        }
        eaiHttpAuthDto.setHttpExtend(eaiHttpExtend);
        if (HussarUtils.isNotEmpty(eaiHttpExtend)) {
            List<Long> ids = eaiHttpExtend.stream().map(EaiHttpExtend::getExtendId).collect(Collectors.toList());
            LambdaQueryWrapper paramsWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiParamsPosition::getExtendId, ids);
            List eaiParamsPosition = this.paramsPositionService.list((Wrapper)paramsWrapper);
            eaiHttpAuthDto.setEaiParamsPosition(eaiParamsPosition);
            ArrayList eaiHttpVerifyDtos = new ArrayList();
            ids.forEach(id -> {
                LambdaQueryWrapper httpWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, id);
                EaiHttpVerifyBase eaiHttpVerifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)httpWrapper);
                if (HussarUtils.isNotEmpty((Object)eaiHttpVerifyBase) && eaiHttpVerifyBase.getHttpBaseId() > 0L) {
                    EaiHttpVerifyDto eaiHttpVerifyDto = new EaiHttpVerifyDto();
                    LambdaQueryWrapper httpParamsWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)eaiHttpVerifyBase.getHttpBaseId());
                    List list = this.httpParamsService.list((Wrapper)httpParamsWrapper);
                    eaiHttpVerifyDto.setHttpVerifyBase(eaiHttpVerifyBase);
                    eaiHttpVerifyDto.setHttpParams(list);
                    eaiHttpVerifyDtos.add(eaiHttpVerifyDto);
                }
            });
            eaiHttpAuthDto.setEaiHttpVerifyDtos(eaiHttpVerifyDtos);
        }
        return eaiHttpAuthDto;
    }

    @HussarTransactional(rollbackFor={Exception.class})
    protected boolean commonSaveOrUpdateById(EaiHttpAuthDto eaiHttpAuthDto, boolean save) {
        LambdaQueryWrapper lambdaQueryWrapper;
        List httpVerifyBases;
        List paramsPositions;
        List oldIds;
        LambdaQueryWrapper lambdaQueryWrapper2;
        List oldparams;
        List eaiHttpExtends;
        LambdaQueryWrapper queryWrapper;
        List eaiHttpExtends2;
        LambdaQueryWrapper queryWrapper2;
        EaiHttpTemplate oldTemplate;
        EaiHttpTemplate eaiHttpTemplate = eaiHttpAuthDto.getEaiHttpTemplate();
        AssertUtil.isNotNull((Object)eaiHttpTemplate, (String)"\u9274\u6743\u4fe1\u606f\u4e3a\u7a7a");
        if (!save) {
            AssertUtil.isNotNull((Object)eaiHttpTemplate.getTemplateId(), (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        Long oldTid = null;
        if (!save && HussarUtils.isNotEmpty((Object)(oldTemplate = (EaiHttpTemplate)this.httpTemplateService.getOne((Wrapper)(queryWrapper2 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpTemplate::getApplicationCode, (Object)eaiHttpTemplate.getApplicationCode())).isNull(EaiHttpTemplate::getTemplateType)))))) {
            oldTid = oldTemplate.getTemplateId();
            this.httpTemplateService.removeById((Serializable)oldTid);
            this.callSpecificationInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(ApiCallSpecificationInfo::getApiId, (Object)oldTid));
        }
        this.httpTemplateService.save((Object)eaiHttpAuthDto.getEaiHttpTemplate());
        if (!save) {
            this.callSpecificationInfoService.saveBatchCallSpecificInfoDto(eaiHttpAuthDto.getCallSpecificaList());
        }
        List<Object> extendIds = new ArrayList();
        if (!save && HussarUtils.isNotEmpty((Object)(eaiHttpExtends2 = this.httpExtendService.list((Wrapper)(queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiHttpExtend::getTemplateId, oldTid)))))) {
            extendIds = eaiHttpExtends2.stream().map(EaiHttpExtend::getExtendId).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(extendIds)) {
                this.httpExtendService.removeByIds(extendIds);
            }
            eaiHttpAuthDto.setExtendIds(extendIds);
        }
        if (HussarUtils.isNotEmpty((Object)(eaiHttpExtends = eaiHttpAuthDto.getHttpExtend()))) {
            eaiHttpExtends.forEach(eaiHttpExtend -> {
                if (HussarUtils.isEmpty((Object)eaiHttpExtend.getExtendId())) {
                    throw new BaseException(EXTENDID_EMPTY);
                }
                this.httpExtendService.save(eaiHttpExtend);
            });
        }
        if (!save && HussarUtils.isNotEmpty((Object)(oldparams = this.paramsPositionService.list((Wrapper)(lambdaQueryWrapper2 = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiParamsPosition::getExtendId, extendIds))))) && HussarUtils.isNotEmpty(oldIds = oldparams.stream().map(EaiParamsPosition::getPositionId).collect(Collectors.toList()))) {
            this.paramsPositionService.removeByIds(oldIds);
        }
        if (HussarUtils.isNotEmpty((Object)(paramsPositions = eaiHttpAuthDto.getEaiParamsPosition()))) {
            paramsPositions.forEach(paramsPosition -> {
                if (HussarUtils.isEmpty((Object)paramsPosition.getExtendId())) {
                    throw new BaseException(EXTENDID_EMPTY);
                }
                this.paramsPositionService.save(paramsPosition);
            });
        }
        if (!save && HussarUtils.isNotEmpty((Object)(httpVerifyBases = this.httpVerifyBaseService.list((Wrapper)(lambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiHttpVerifyBase::getExtendId, extendIds)))))) {
            LambdaQueryWrapper paramsWrapper;
            List eaiHttpParams;
            List oldParamsIds;
            List oldIds2 = httpVerifyBases.stream().map(EaiHttpVerifyBase::getHttpBaseId).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(oldIds2)) {
                this.httpVerifyBaseService.removeByIds(oldIds2);
            }
            if (HussarUtils.isNotEmpty(oldParamsIds = (eaiHttpParams = this.httpParamsService.list((Wrapper)(paramsWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EaiHttpParams::getHttpId, extendIds)))).stream().map(EaiHttpParams::getParamsId).collect(Collectors.toList()))) {
                this.httpParamsService.removeByIds(oldParamsIds);
            }
        }
        List eaiHttpVerifyDtos = eaiHttpAuthDto.getEaiHttpVerifyDtos();
        eaiHttpVerifyDtos.forEach(eaiHttpVerifyDto -> {
            this.httpVerifyBaseService.save((Object)eaiHttpVerifyDto.getHttpVerifyBase());
            List eaiHttpParams = eaiHttpVerifyDto.getHttpParams();
            if (HussarUtils.isNotEmpty((Object)eaiHttpParams)) {
                eaiHttpParams.forEach(eaiHttpParam -> {
                    if (HussarUtils.isEmpty((Object)eaiHttpParam.getHttpId())) {
                        throw new BaseException(EXTENDID_HTTPID);
                    }
                    this.httpParamsService.save(eaiHttpParam);
                });
            }
        });
        return true;
    }

    public void getHttpAuthPosissionParams(EaiHttpTemplateVo eaiHttpTemplate, Map<Long, CommonConstant> commonConstantsMap, Map<Long, EaiApplicationAuth> applicationAuthMap, Map<String, EaiParamsPosition> paramsPosissionMap) {
        EaiHttpParamsPackageVo tokenPosissionParams = new EaiHttpParamsPackageVo();
        for (Map.Entry<String, EaiParamsPosition> entry : paramsPosissionMap.entrySet()) {
            if ("0".equals(entry.getKey())) {
                List headerT = JSON.parseArray((String)entry.getValue().getEffective(), EaiHttpParams.class);
                tokenPosissionParams.setHttpHeader(this.getSourceName(headerT, commonConstantsMap, applicationAuthMap));
                continue;
            }
            if ("2".equals(entry.getKey())) {
                List queryT = JSON.parseArray((String)entry.getValue().getEffective(), EaiHttpParams.class);
                tokenPosissionParams.setHttpQueryParam(this.getSourceName(queryT, commonConstantsMap, applicationAuthMap));
                continue;
            }
            if (!"1".equals(entry.getKey())) continue;
            EaiHttpBodyVo bodyDtoT = new EaiHttpBodyVo();
            List bodyParam = JSON.parseArray((String)entry.getValue().getEffective(), EaiHttpParams.class);
            bodyDtoT.setBodyParam(this.getSourceName(bodyParam, commonConstantsMap, applicationAuthMap));
            tokenPosissionParams.setHttpBody(bodyDtoT);
        }
        eaiHttpTemplate.setAuthosissionParams(tokenPosissionParams);
    }

    public void positionUpdateParamsValue(EaiHttpTemplate eaiHttpTemplate, Long authParamId, String stepcode) {
        EaiHttpExtend extend = this.getCertainStepByTemplateId(eaiHttpTemplate.getTemplateId(), stepcode);
        List eaiParamsPositions = this.paramsPositionService.list((Wrapper)new LambdaQueryWrapper().eq(EaiParamsPosition::getExtendId, (Object)extend.getExtendId()));
        if (HussarUtils.isNotEmpty((Object)eaiParamsPositions)) {
            for (EaiParamsPosition p : eaiParamsPositions) {
                List paramsList;
                List authParamsList;
                if (!HussarUtils.isNotEmpty((Object)p.getEffective()) || !HussarUtils.isNotEmpty(authParamsList = (paramsList = JSON.parseArray((String)p.getEffective(), EaiHttpParams.class)).stream().filter(pT -> "2".equals(pT.getParamsFrom())).collect(Collectors.toList()))) continue;
                for (EaiHttpParams param : paramsList) {
                    if (!"2".equals(param.getParamsFrom()) || !String.valueOf(authParamId).equals(param.getParamsValue())) continue;
                    param.setParamsValue(null);
                }
                String effectiveStr = JSON.toJSONString((Object)paramsList);
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)updateWrapper.set(EaiParamsPosition::getEffective, (Object)effectiveStr)).eq(EaiParamsPosition::getPositionId, (Object)p.getPositionId());
                this.paramsPositionService.update((Object)new EaiParamsPosition(), (Wrapper)updateWrapper);
            }
        }
    }

    public void updateParamsValue(Long authParamId, EaiHttpTemplate eaiHttpTemplate, String stepcode) {
        EaiHttpExtend extend = this.getCertainStepByTemplateId(eaiHttpTemplate.getTemplateId(), stepcode);
        if (null != extend) {
            EaiHttpVerifyBase httpVerifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)extend.getExtendId()));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(EaiHttpParams::getParamsValue, null)).eq(EaiHttpParams::getHttpId, (Object)httpVerifyBase.getHttpBaseId())).eq(EaiHttpParams::getParamsFrom, (Object)"2")).eq(EaiHttpParams::getParamsValue, (Object)authParamId.toString());
            this.httpParamsService.update((Object)new EaiHttpParams(), (Wrapper)updateWrapper);
        }
    }

    public boolean verifyPositionHasUserposition(EaiHttpTemplate eaiHttpTemplate, Long authParamId, String stepCode, String paramsPosition) {
        EaiHttpExtend extendThrid = this.getCertainStepByTemplateId(eaiHttpTemplate.getTemplateId(), stepCode);
        List eaiParamsPositions = this.paramsPositionService.list((Wrapper)new LambdaQueryWrapper().eq(EaiParamsPosition::getExtendId, (Object)extendThrid.getExtendId()));
        if (HussarUtils.isNotEmpty((Object)eaiParamsPositions)) {
            for (EaiParamsPosition p : eaiParamsPositions) {
                Set authParamIdSets;
                List paramsList;
                List authParamsList;
                if (!HussarUtils.isNotEmpty((Object)p.getEffective()) || !HussarUtils.isNotEmpty(authParamsList = (paramsList = JSON.parseArray((String)p.getEffective(), EaiHttpParams.class)).stream().filter(pT -> paramsPosition.equals(pT.getParamsFrom())).collect(Collectors.toList())) || !(authParamIdSets = authParamsList.stream().map(EaiHttpParams::getParamsValue).collect(Collectors.toSet())).contains(authParamId.toString())) continue;
                throw new BaseException("http\u9274\u6743\u4e2d\u4f7f\u7528\u4e86\u6b64\u53c2\u6570\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
        }
        return false;
    }

    public void verifyHasUseInStep(Long authParamId, EaiHttpTemplate eaiHttpTemplate, String stepCode, String paramsPosition) {
        List authParams;
        Set authParamIds;
        EaiHttpVerifyBase httpVerifyBase;
        List params;
        EaiHttpExtend extend = this.getCertainStepByTemplateId(eaiHttpTemplate.getTemplateId(), stepCode);
        if (null != extend && HussarUtils.isNotEmpty((Object)(params = this.httpParamsService.list((Wrapper)new LambdaQueryWrapper().eq(EaiHttpParams::getHttpId, (Object)(httpVerifyBase = (EaiHttpVerifyBase)this.httpVerifyBaseService.getOne((Wrapper)new LambdaQueryWrapper().eq(EaiHttpVerifyBase::getExtendId, (Object)extend.getExtendId()))).getHttpBaseId())))) && (authParamIds = (authParams = params.stream().filter(p -> paramsPosition.equals(p.getParamsFrom())).collect(Collectors.toList())).stream().map(EaiHttpParams::getParamsValue).collect(Collectors.toSet())).contains(authParamId.toString())) {
            throw new BaseException("http\u9274\u6743\u4e2d\u4f7f\u7528\u4e86\u6b64\u53c2\u6570\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
    }
}

