/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.adapter.apppublishwithlogic.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.eai.adapter.apppublish.api.dto.EaiPublishApiInfos;
import com.jxdinfo.hussar.eai.adapter.apppublish.api.dto.EaiPublishCommonResources;
import com.jxdinfo.hussar.eai.adapter.apppublish.api.service.IEaiPublishBaseService;
import com.jxdinfo.hussar.eai.adapter.apppublishcommon.server.publishresource.service.IEaiPublishApplicationService;
import com.jxdinfo.hussar.eai.adapter.apppublishwithlogic.server.manager.EaiPublishWithLogicManager;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.appinfo.api.model.EaiResourcesInfo;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.applyinfo.api.model.EaiApply;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.dto.EaiPublishDto;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.vo.EaiPublishTestListVo;
import com.jxdinfo.hussar.eai.atomicbase.api.appauth.vo.EaiPublishTestVo;
import com.jxdinfo.hussar.eai.common.util.EaiVersionUtil;
import com.jxdinfo.hussar.eai.logsinfo.api.model.EaiPublishLog;
import com.jxdinfo.hussar.eai.resourceenhancements.api.model.CanvasInfo;
import com.jxdinfo.hussar.eai.resourceenhancements.api.service.ICanvasInfoService;
import com.jxdinfo.hussar.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarCacheUtil;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.server.applicationrelease.publish.service.impl.EaiLogicPublishServiceImpl")
public class EaiLogicPublishServiceImpl
extends EaiPublishWithLogicManager
implements IEaiPublishBaseService {
    @Resource
    private ICanvasInfoService canvasInfoService;
    @Resource
    private IEaiEditApiService editApiService;
    @Resource
    IApplicationManagementService applicationManagementService;
    @Resource
    IEaiPublishApplicationService eaiPublishApplicationService;

    public boolean publishApp(String applicationCode, List<ApiInfo> apiInfo, Boolean isPublish) {
        throw new BaseException("the method has not defined for this version");
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public ApiResponse<EaiPublishTestListVo> publishApply(String applicationCode) {
        LambdaQueryWrapper queryWrapper1;
        List published;
        AssertUtil.isNotEmpty((String)applicationCode, (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        List applicationManageVos = this.applicationManagementService.getByCurrentUser("");
        if (HussarUtils.isEmpty((Object)applicationManageVos) || applicationManageVos.stream().noneMatch(v -> v.getAppCode().equals(applicationCode))) {
            throw new BaseException("\u53d1\u5e03\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u6216\u68c0\u67e5\u6743\u9650\u540e\u91cd\u8bd5");
        }
        this.checkApply(applicationCode);
        SysApplication sysApplication = this.lockApp(applicationCode);
        String version = EaiVersionUtil.getInstance().getNewVersion(sysApplication.getAppVersion());
        Map apiInfosMap = this.eaiResourcePublishService.apiInfoList(applicationCode, false);
        StringBuffer sb = new StringBuffer(24);
        sb.append("eai_api_cache_key").append(":").append(applicationCode);
        String key = sb.toString();
        HussarCacheUtil.evict((String)"eai_api_cache_key", (Object)key);
        HussarCacheUtil.put((String)"eai_api_cache_key", (Object)key, (Object)apiInfosMap);
        ArrayList apiInfos = new ArrayList();
        if (HussarUtils.isNotEmpty(apiInfosMap.get("insert"))) {
            apiInfos.addAll((Collection)apiInfosMap.get("insert"));
        }
        if (HussarUtils.isNotEmpty(apiInfosMap.get("update"))) {
            apiInfos.addAll((Collection)apiInfosMap.get("update"));
        }
        List apiIds = apiInfos.stream().map(ApiInfo::getId).collect(Collectors.toList());
        this.eaiResourcePublishService.locked(apiIds, null, applicationCode);
        ArrayList update = new ArrayList();
        if (HussarUtils.isNotEmpty(apiIds) && HussarUtils.isNotEmpty((Object)(published = this.eaiResourcesInfoService.list((Wrapper)(queryWrapper1 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiResourcesInfo::getDeleteState, (Object)"0")).in(EaiResourcesInfo::getResourceRelationId, apiIds)))))) {
            published.forEach(eaiResourcesInfo -> update.add(eaiResourcesInfo.getResourceRelationId()));
        }
        ArrayList error = new ArrayList();
        ArrayList info = new ArrayList();
        if (HussarUtils.isNotEmpty(apiInfos)) {
            apiInfos.forEach(apiInfo -> {
                if ("0".equals(apiInfo.getTestState()) && !"0".equals(apiInfo.getPublicState())) {
                    EaiPublishTestVo eaiPublishTestVo = new EaiPublishTestVo();
                    eaiPublishTestVo.setResourceName(this.formatTestInfo(apiInfo.getApiName(), apiInfo.getApiPath()));
                    eaiPublishTestVo.setResourceType("1");
                    eaiPublishTestVo.setPublishType(this.publishType((ApiInfo)apiInfo, update));
                    error.add(eaiPublishTestVo);
                } else {
                    EaiPublishTestVo eaiPublishTestVo = new EaiPublishTestVo();
                    eaiPublishTestVo.setResourceName(this.formatTestInfo(apiInfo.getApiName(), apiInfo.getApiPath()));
                    eaiPublishTestVo.setResourceType("1");
                    eaiPublishTestVo.setPublishType(this.publishType((ApiInfo)apiInfo, update));
                    info.add(eaiPublishTestVo);
                }
            });
        }
        EaiPublishTestListVo eaiPublishTestListVo = new EaiPublishTestListVo();
        eaiPublishTestListVo.setAccess("0");
        EaiPublishDto eaiPublishDto = new EaiPublishDto();
        if (HussarUtils.isEmpty(error) && HussarUtils.isNotEmpty(info)) {
            EaiApply eaiApply = new EaiApply();
            eaiApply.setApplyId(IdGenerateUtils.getId());
            if (HussarUtils.isNotEmpty((Object)BaseSecurityUtil.getUser())) {
                eaiApply.setCreator(BaseSecurityUtil.getUser().getUserId());
                eaiApply.setApplyBy(BaseSecurityUtil.getUser().getUserName());
            }
            eaiApply.setApplyCode(applicationCode);
            eaiApply.setApplyType("08");
            eaiPublishDto.setEaiApply(eaiApply);
            EaiPublishLog eaiPublishLog = new EaiPublishLog();
            eaiPublishLog.setLogName("\u5e94\u7528\u53d1\u5e03\u65e5\u5fd7");
            eaiPublishLog.setLogVersion(version);
            eaiPublishLog.setRemark(JSON.toJSONString(info));
            eaiPublishDto.setEaiPublishLog(eaiPublishLog);
            eaiPublishTestListVo.setAccess("1");
        } else {
            this.unlockApp(applicationCode, true);
        }
        eaiPublishTestListVo.setError(error);
        eaiPublishTestListVo.setInfo(info);
        eaiPublishTestListVo.setEaiPublishDto(eaiPublishDto);
        return ApiResponse.success((Object)eaiPublishTestListVo);
    }

    public ApiResponse<Boolean> unpublishing(String applicationCode) {
        List applicationManageVos = this.applicationManagementService.getByCurrentUser("");
        if (HussarUtils.isEmpty((Object)applicationManageVos) || applicationManageVos.stream().noneMatch(v -> v.getAppCode().equals(applicationCode))) {
            throw new BaseException("\u53d1\u5e03\u5931\u8d25\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u6216\u68c0\u67e5\u6743\u9650\u540e\u91cd\u8bd5");
        }
        try {
            return ApiResponse.success((Object)this.eaiResourcePublishService.unlocked(null, null, applicationCode));
        }
        catch (Exception e) {
            throw new BaseException("\u53d6\u6d88\u53d1\u5e03\u5931\u8d25");
        }
    }

    public boolean savePublishInfo(EaiPublishDto eaiPublishDto) {
        try {
            eaiPublishDto.getEaiApply().setResourceStatus("0");
            eaiPublishDto.getEaiApply().setApplyType("08");
            this.eaiPublishApplicationService.savePublishInfo(eaiPublishDto);
        }
        catch (Exception e) {
            if (HussarUtils.isNotEmpty((Object)eaiPublishDto) && HussarUtils.isNotEmpty((Object)eaiPublishDto.getEaiApply())) {
                this.unlockApp(eaiPublishDto.getEaiApply().getApplyCode(), true);
            }
            throw e;
        }
        return true;
    }

    public boolean publishApp(String applicationCode) {
        String appVersion = this.initPublish(applicationCode);
        List authCheck = this.authCheck(applicationCode);
        boolean withAuth = (Boolean)authCheck.get(0);
        boolean updateAuth = (Boolean)authCheck.get(1);
        boolean isLogic = (Boolean)authCheck.get(2);
        EaiPublishCommonResources commonResources = null;
        commonResources = !isLogic ? this.authWithTemplete(applicationCode, withAuth, updateAuth, appVersion) : this.authWithLogic(applicationCode, withAuth, updateAuth, appVersion);
        EaiPublishApiInfos eaiPublishApiInfos = this.publishApiInfos(applicationCode);
        List apiInfos = eaiPublishApiInfos.getApiInfos();
        List apiInfosUpdate = eaiPublishApiInfos.getApiInfosUpdate();
        String key = eaiPublishApiInfos.getKey();
        ArrayList<Long> allIds = new ArrayList<Long>();
        List<Long> apiIds = null;
        ArrayList allEditApis = new ArrayList();
        ArrayList editApis = new ArrayList();
        ArrayList editApisWithCanvas = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)apiInfos)) {
            apiIds = apiInfos.stream().map(ApiInfo::getId).collect(Collectors.toList());
            allIds.addAll(apiIds);
            this.changeApiStateToOnGround(apiIds);
            apiIds.forEach(aLong -> {
                LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EditApi::getApiId, aLong);
                EditApi editApi = (EditApi)this.editApiService.getOne((Wrapper)queryWrapper);
                if (HussarUtils.isNotEmpty((Object)editApi.getCanvasId())) {
                    editApisWithCanvas.add(editApi);
                } else {
                    editApis.add(editApi);
                }
            });
        }
        if (HussarUtils.isNotEmpty(editApisWithCanvas)) {
            allEditApis.addAll(editApisWithCanvas);
        }
        if (HussarUtils.isNotEmpty(editApis)) {
            allEditApis.addAll(editApis);
        }
        if (HussarUtils.isNotEmpty((Object)apiInfosUpdate)) {
            List updateIds = apiInfosUpdate.stream().map(ApiInfo::getId).collect(Collectors.toList());
            allIds.addAll(updateIds);
            this.changeApiStateToOffGround(updateIds);
        }
        HashMap map = new HashMap(apiInfos.size());
        this.listParams(apiInfos, map);
        EaiPublishCommonResources apiResources = this.eaiResourcePublishService.getCommonResourcesByApi(map, applicationCode, appVersion);
        if (HussarUtils.isNotEmpty((Object)commonResources)) {
            this.addResources(commonResources, apiResources);
        } else {
            commonResources = apiResources;
        }
        ArrayList<CanvasInfo> canvas = null;
        if (HussarUtils.isNotEmpty(editApisWithCanvas)) {
            canvas = new ArrayList<CanvasInfo>(editApisWithCanvas.size());
            for (EditApi editApi2 : editApisWithCanvas) {
                Map resourceMap;
                EaiPublishCommonResources resourcesByCanvas;
                CanvasInfo canvasInfo = (CanvasInfo)this.canvasInfoService.getById((Serializable)editApi2.getCanvasId());
                String resources = canvasInfo.getCanvasResources();
                if (!HussarUtils.isNotEmpty((Object)resources) || !HussarUtils.isNotEmpty((Object)(resourcesByCanvas = this.canvasConvertService.getCommonResourcesByCanvas(canvasInfo, resourceMap = (Map)JSONObject.parseObject((String)resources, (TypeReference)new TypeReference<Map<String, Integer>>(){}, (Feature[])new Feature[0]), appVersion)))) continue;
                if (commonResources == null) {
                    commonResources = resourcesByCanvas;
                    continue;
                }
                this.addResources(commonResources, resourcesByCanvas);
            }
            this.canvasInfoService.saveBatch(canvas);
        }
        EaiPublishApiInfos publishApi = this.publishApi(apiInfos, applicationCode, appVersion, commonResources.getConvertParams());
        List eaiResourcesInfos = publishApi.getEaiResourcesInfos();
        Map editIds = publishApi.getEditIds();
        List apiVersions = publishApi.getApiVersions();
        if (HussarUtils.isNotEmpty(apiIds)) {
            if (HussarUtils.isEmpty(allEditApis) || allEditApis.size() != apiIds.size() || editIds.size() != allEditApis.size()) {
                throw new BaseException("\u53d1\u5e03\u63a5\u53e3\u914d\u7f6e\u4fe1\u606f\u5931\u8d25");
            }
            allEditApis.forEach(editApi -> {
                editApi.setApiId((Long)editIds.get(editApi.getApiId()));
                editApi.setId(IdGenerateUtils.getId());
            });
            this.editApiService.saveBatch(allEditApis);
        }
        if (HussarUtils.isNotEmpty(canvas)) {
            Map<Long, Long> canvasMap = editApisWithCanvas.stream().collect(Collectors.toMap(EditApi::getApiId, EditApi::getCanvasId));
            this.pushEngine(canvas, apiVersions, canvasMap, applicationCode, appVersion);
        } else {
            this.pushEngine(apiVersions, appVersion);
        }
        this.changeAppState(applicationCode, allIds, key, withAuth);
        return true;
    }

    private void addResources(EaiPublishCommonResources commonResources, EaiPublishCommonResources resourcesByCanvas) {
        if (HussarUtils.isNotEmpty((Object)resourcesByCanvas.getInsertStructures())) {
            if (HussarUtils.isNotEmpty((Object)commonResources.getInsertStructures())) {
                commonResources.getInsertStructures().addAll(resourcesByCanvas.getInsertStructures());
            } else {
                commonResources.setInsertStructures(resourcesByCanvas.getInsertStructures());
            }
        }
        if (HussarUtils.isNotEmpty((Object)resourcesByCanvas.getInsertConstants())) {
            if (HussarUtils.isNotEmpty((Object)commonResources.getInsertConstants())) {
                commonResources.getInsertConstants().addAll(resourcesByCanvas.getInsertConstants());
            } else {
                commonResources.setInsertConstants(resourcesByCanvas.getInsertConstants());
            }
        }
    }
}

