/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.adapter.apppublishencommon.server.publish.service.impl;

import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apirelease.api.model.EaiApiVersion;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.CommonResourcesIdMap;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.dto.EaiPublishEditApiInfo;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.enums.EaiPublishEngineType;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.factory.IPublishEngineFactory;
import com.jxdinfo.hussar.eai.atomicbase.api.publish.service.EaiPublishEngineApiClassifyService;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="com.jxdinfo.hussar.eai.adapter.apppublishencommon.server.publish.service.impl.EaiPublishEngineApiClassifyCanvasServiceImpl")
public class EaiPublishEngineApiClassifyCanvasServiceImpl
implements EaiPublishEngineApiClassifyService {
    @Autowired
    private EaiApiProperties eaiApiProperties;

    public List<EaiApiVersion> publishEngine(EaiPublishEditApiInfo eaiPublishEditApiInfo, List<EaiApiVersion> apiVersions, String appVersion, CommonResourcesIdMap commonResourcesIdMap) {
        Map<Long, Long> map;
        if (HussarUtils.isEmpty(apiVersions)) {
            return apiVersions;
        }
        ArrayList<EaiApiVersion> normalApiVersion = new ArrayList<EaiApiVersion>(apiVersions);
        ArrayList canvasIds = new ArrayList();
        ArrayList ids = null;
        if (HussarUtils.isNotEmpty((Object)commonResourcesIdMap) && HussarUtils.isNotEmpty((Object)(map = commonResourcesIdMap.getCanvasMap()))) {
            ids = new ArrayList(map.values());
        }
        if (HussarUtils.isNotEmpty(ids)) {
            canvasIds.addAll(ids);
        }
        map = new HashMap<Long, Long>();
        if (HussarUtils.isNotEmpty((Object)eaiPublishEditApiInfo) && HussarUtils.isNotEmpty((Object)eaiPublishEditApiInfo.getEditApisWithCanvas())) {
            map = eaiPublishEditApiInfo.getEditApisWithCanvas().stream().collect(Collectors.toMap(EditApi::getApiId, EditApi::getCanvasId));
        }
        ArrayList<EaiApiVersion> logicApiVersion = new ArrayList<EaiApiVersion>();
        if (1 == this.eaiApiProperties.getLogicType()) {
            this.apiVersionLogicClassify(map, apiVersions, logicApiVersion, normalApiVersion);
        }
        if (HussarUtils.isNotEmpty(logicApiVersion)) {
            String applicationCode = ((EaiApiVersion)logicApiVersion.get(0)).getApplicationCode();
            IPublishEngineFactory.getService((String)EaiPublishEngineType.LOGIC.getType()).pushEngine(canvasIds, map, logicApiVersion, applicationCode, appVersion);
        }
        return normalApiVersion;
    }

    private void apiVersionLogicClassify(Map<Long, Long> map, List<EaiApiVersion> apiVersions, List<EaiApiVersion> logicApiVersion, List<EaiApiVersion> normalApiVersion) {
        if (HussarUtils.isNotEmpty(map)) {
            for (EaiApiVersion apiVersion : apiVersions) {
                if (!map.containsKey(apiVersion.getApiVersionId())) continue;
                logicApiVersion.add(apiVersion);
                this.apiVersionNormalClassify(apiVersion, normalApiVersion);
            }
        }
    }

    private void apiVersionNormalClassify(EaiApiVersion apiVersion, List<EaiApiVersion> normalApiVersion) {
        if (normalApiVersion.contains(apiVersion)) {
            normalApiVersion.remove(apiVersion);
        }
    }

    public String getType() {
        return EaiPublishEngineType.LOGIC.getType();
    }
}

