/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.eai.adapter.apiinfo.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.application.model.SysApplication;
import com.jxdinfo.hussar.application.service.ISysApplicationService;
import com.jxdinfo.hussar.common.base.HussarBaseEntity;
import com.jxdinfo.hussar.common.base.PageInfo;
import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.common.utils.AssertUtil;
import com.jxdinfo.hussar.common.utils.HussarPageUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.eai.adapter.apiinfo.api.service.IReleaseApiService;
import com.jxdinfo.hussar.eai.adapter.apiinfo.server.dao.EaiReleaseApiMapper;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiCallSpecificationInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.ApiInfo;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EaiApiClassification;
import com.jxdinfo.hussar.eai.apiinfo.api.model.EditApi;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IApiCallSpecificationInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiClassificationService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiApiInfoService;
import com.jxdinfo.hussar.eai.apiinfo.api.service.IEaiEditApiService;
import com.jxdinfo.hussar.eai.appinfo.api.service.IApplicationManagementService;
import com.jxdinfo.hussar.eai.appinfo.api.vo.ApplicationManageVo;
import com.jxdinfo.hussar.eai.appinfo.server.common.EaiAppEditManager;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.AddApiInfoDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.ApiParamItem;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.ApiTestDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.CheckApiCodeDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.QueryApiInfoDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.StructureImportDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.dto.UpdateApiInfoDto;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.ApiInfoEditVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.ApiInfoVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonConstantVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.CommonStructureVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.EaiApiClassificationVo;
import com.jxdinfo.hussar.eai.atomicbase.api.apirelease.vo.EaiResourceVo;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpBodyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.EaiHttpParamsDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.dto.HttpAuthVerifyDto;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.service.IHttpAuthenticationService;
import com.jxdinfo.hussar.eai.atomicbase.api.auth.vo.EaiApiResponseVo;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiApiClassificationService;
import com.jxdinfo.hussar.eai.atomicbase.api.info.service.EaiCommonStructureService;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiApiParams;
import com.jxdinfo.hussar.eai.common.api.common.dto.EaiParamsItems;
import com.jxdinfo.hussar.eai.common.config.EaiApiProperties;
import com.jxdinfo.hussar.eai.common.constant.EaiDataType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiApiParamMappingEnum;
import com.jxdinfo.hussar.eai.common.enums.api.EaiContentType;
import com.jxdinfo.hussar.eai.common.enums.api.EaiDataCategoryEnum;
import com.jxdinfo.hussar.eai.common.enums.api.EaiRequestTypeEnum;
import com.jxdinfo.hussar.eai.common.enums.sys.EaiCharsetEnum;
import com.jxdinfo.hussar.eai.common.service.EaiConvertService;
import com.jxdinfo.hussar.eai.common.util.EaiOutParamDto;
import com.jxdinfo.hussar.eai.common.util.EaiParamsConvertDto;
import com.jxdinfo.hussar.eai.common.util.EaiVersionUtil;
import com.jxdinfo.hussar.eai.common.util.ParamsConvertUtil;
import com.jxdinfo.hussar.eai.common.util.TempHttpCode;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonConstant;
import com.jxdinfo.hussar.eai.resourcebase.api.model.CommonStructure;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonConstantService;
import com.jxdinfo.hussar.eai.resourcebase.api.service.ICommonStructureService;
import com.jxdinfo.hussar.engine.metadata.util.IdGenerateUtils;
import com.jxdinfo.hussar.engine.metadata.util.StringUtils;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.support.service.dto.UserDetails;
import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.CollectionUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.security.integration.authentication.support.utils.HussarSecurityUtils;
import com.jxdinfo.hussar.support.transaction.core.annotation.HussarTransactional;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ApiCommonManager
implements IReleaseApiService {
    private static Logger logger = LoggerFactory.getLogger(ApiCommonManager.class);
    @Autowired
    private EaiReleaseApiMapper eaiReleaseApiMapper;
    @Resource
    protected IEaiApiInfoService apiInfoService;
    @Resource
    protected IEaiEditApiService iEaiEditApiService;
    @Resource
    protected EaiConvertService eaiConvertService;
    @Resource
    protected ICommonStructureService commonStructureService;
    @Resource
    protected EaiCommonStructureService eaiCommonStructureService;
    @Resource
    protected IHttpAuthenticationService eaiHttpTemplateAuthService;
    @Resource
    protected IApplicationManagementService iApplicationManagementService;
    @Resource
    protected IApiCallSpecificationInfoService apiCallSpecificationInfoService;
    @Resource
    protected IEaiApiClassificationService apiClassificationService;
    @Resource
    protected EaiApiClassificationService eaiApiClassificationService;
    @Resource
    protected ICommonConstantService commonConstantService;
    @Resource
    protected EaiApiProperties eaiApiProperties;
    @Resource
    ISysApplicationService applicationService;

    @HussarTransactional
    public Boolean saveApiInfo(AddApiInfoDto addApiInfoDto) {
        boolean flag;
        AssertUtil.isNotNull((Object)addApiInfoDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull((Object)addApiInfoDto.getId(), (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        CheckApiCodeDto checkApiCodeDto = new CheckApiCodeDto();
        BeanUtil.copyProperties((Object)addApiInfoDto, (Object)checkApiCodeDto);
        if (!this.checkApiCode(checkApiCodeDto).booleanValue()) {
            throw new HussarException("\u63a5\u53e3\u6807\u8bc6\u4e0d\u552f\u4e00");
        }
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getAddCommonStructureList()) && !(flag = this.eaiCommonStructureService.saveBatchStructure(addApiInfoDto.getAddCommonStructureList()).booleanValue())) {
            throw new HussarException("\u65b0\u589e\u5931\u8d25");
        }
        if (String.valueOf(EaiContentType.NONE.getType()).equals(addApiInfoDto.getContentType())) {
            EaiParamsConvertDto dto = addApiInfoDto.getInParams();
            dto.setBody(null);
            addApiInfoDto.setInParams(dto);
        }
        ApiInfo apiInfo = new ApiInfo();
        this.fillApiInfo(addApiInfoDto, apiInfo);
        return this.saveCallInfo(addApiInfoDto, apiInfo);
    }

    protected boolean saveCallInfo(AddApiInfoDto addApiInfoDto, ApiInfo apiInfo) {
        this.apiCallSpecificationInfoService.remove((Wrapper)new LambdaQueryWrapper().eq(ApiCallSpecificationInfo::getApiId, (Object)apiInfo.getId()));
        List specificaList = addApiInfoDto.getCallSpecificaList();
        if (CollectionUtil.isNotEmpty((Collection)specificaList)) {
            ArrayList infoList = Lists.newArrayListWithExpectedSize((int)10);
            specificaList.forEach(s -> {
                s.setApiId(apiInfo.getId());
                s.setSpecificatId(Long.valueOf(IdWorker.getId((Object)new ApiCallSpecificationInfo())));
                ApiCallSpecificationInfo callSpecificationInfo = new ApiCallSpecificationInfo();
                BeanUtil.copy((Object)s, (Object)callSpecificationInfo);
                infoList.add(callSpecificationInfo);
            });
            return this.apiCallSpecificationInfoService.saveBatch((Collection)infoList);
        }
        return true;
    }

    public List<EaiParamsItems> fillBaseOutInfo(List<EaiParamsItems> outParam) {
        ArrayList<EaiParamsItems> result = new ArrayList<EaiParamsItems>();
        EaiParamsItems code = new EaiParamsItems();
        EaiParamsItems data = new EaiParamsItems();
        EaiParamsItems msg = new EaiParamsItems();
        EaiParamsItems success = new EaiParamsItems();
        code.setName("code");
        code.setType(Integer.valueOf(1));
        code.setItemType(null);
        code.setMark("code");
        code.setMapping(Integer.valueOf(1));
        code.setMappingName("code");
        code.setQuoteStructureId("");
        code.setValue("1");
        code.setItems(Collections.emptyList());
        data.setName("data");
        data.setMappingName("data");
        if (HussarUtils.isEmpty(outParam)) {
            data.setType(Integer.valueOf(7));
            data.setItemType(null);
            data.setMark("data");
            data.setMapping(Integer.valueOf(1));
            data.setQuoteStructureId("");
            data.setValue("7");
            data.setItems(Collections.emptyList());
        } else {
            EaiParamsItems paramsItem = outParam.get(0);
            data.setType(paramsItem.getType());
            data.setItemType(paramsItem.getItemType());
            data.setMark(paramsItem.getMark());
            data.setMapping(paramsItem.getMapping());
            data.setQuoteStructureId(paramsItem.getQuoteStructureId());
            data.setValue(paramsItem.getValue());
            data.setItems(paramsItem.getItems());
        }
        msg.setName("msg");
        msg.setType(Integer.valueOf(4));
        msg.setItemType(null);
        msg.setMark("msg");
        msg.setMapping(Integer.valueOf(1));
        msg.setMappingName("msg");
        msg.setQuoteStructureId("");
        msg.setValue("4");
        msg.setItems(Collections.emptyList());
        success.setName("success");
        success.setType(Integer.valueOf(0));
        success.setItemType(null);
        success.setMark("success");
        success.setMapping(Integer.valueOf(1));
        success.setMappingName("success");
        success.setQuoteStructureId("");
        success.setValue("0");
        success.setItems(Collections.emptyList());
        result.add(code);
        result.add(data);
        result.add(msg);
        result.add(success);
        return result;
    }

    @HussarTransactional
    public Boolean deleteById(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)((Object)id));
        if (HussarUtils.isEmpty((Object)apiInfo)) {
            throw new HussarException("\u63a5\u53e3\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (HussarUtils.equals((Object)apiInfo.getApiState(), (Object)"1")) {
            throw new HussarException("\u5df2\u4e0a\u67b6\u63a5\u53e3\u4e0d\u80fd\u5220\u9664");
        }
        this.apiInfoService.removeById((Serializable)((Object)id));
        return true;
    }

    public Boolean updateById(UpdateApiInfoDto updateApiInfoDto) {
        AssertUtil.isNotNull((Object)updateApiInfoDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)updateApiInfoDto.getId(), (String)"\u63a5\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
        ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)((Object)updateApiInfoDto.getId()));
        if (HussarUtils.isEmpty((Object)apiInfo)) {
            throw new HussarException("\u63a5\u53e3\u6570\u636e\u4e0d\u5b58\u5728");
        }
        if (StringUtil.equals((CharSequence)"1", (CharSequence)apiInfo.getApplyState())) {
            throw new HussarException("\u63a5\u53e3\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        CheckApiCodeDto checkApiCodeDto = new CheckApiCodeDto();
        checkApiCodeDto.setId(apiInfo.getId());
        if (ToolUtil.isNotEmpty((Object)updateApiInfoDto.getName())) {
            checkApiCodeDto.setApiCode(updateApiInfoDto.getName());
        } else {
            checkApiCodeDto.setApiCode(updateApiInfoDto.getApiCode());
        }
        checkApiCodeDto.setApplicationCode(apiInfo.getApplicationCode());
        if (!this.checkApiCode(checkApiCodeDto).booleanValue()) {
            throw new HussarException("\u63a5\u53e3\u6807\u8bc6\u4e0d\u552f\u4e00");
        }
        if (ToolUtil.isNotEmpty((Object)updateApiInfoDto.getDesc())) {
            apiInfo.setApiName(updateApiInfoDto.getDesc());
        } else {
            apiInfo.setApiName(updateApiInfoDto.getApiName());
        }
        apiInfo.setRemark(updateApiInfoDto.getRemark());
        apiInfo.setPublicState(updateApiInfoDto.getPublicState());
        apiInfo.setDraftState("0");
        apiInfo.setClassificId(updateApiInfoDto.getClassificId());
        boolean b = this.apiInfoService.updateById((Object)apiInfo);
        if (b) {
            EaiAppEditManager.getInstance().call(apiInfo.getApplicationCode());
        }
        return b;
    }

    public Boolean updatePublic(UpdateApiInfoDto updateApiInfoDto) {
        AssertUtil.isNotNull((Object)updateApiInfoDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)updateApiInfoDto.getId(), (String)"\u63a5\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)updateApiInfoDto.getPublicState(), (String)"\u516c\u5f00\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)((Object)updateApiInfoDto.getId()));
        if (HussarUtils.isEmpty((Object)apiInfo)) {
            throw new HussarException("\u63a5\u53e3\u6570\u636e\u4e0d\u5b58\u5728");
        }
        ApplicationManageVo applicationManageVo = this.iApplicationManagementService.getByAppCode(apiInfo.getApplicationCode());
        if (HussarUtils.isEmpty((Object)applicationManageVo)) {
            throw new HussarException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        if (StringUtil.equals((CharSequence)"2", (CharSequence)applicationManageVo.getAppStatus())) {
            throw new HussarException("\u5e94\u7528\u5ba1\u6838\u4e2d\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        apiInfo.setPublicState(updateApiInfoDto.getPublicState());
        apiInfo.setDraftState("0");
        boolean b = this.apiInfoService.updateById((Object)apiInfo);
        if (b) {
            EaiAppEditManager.getInstance().call(apiInfo.getApplicationCode());
        }
        return b;
    }

    public Boolean updateTestState(UpdateApiInfoDto updateApiInfoDto) {
        AssertUtil.isNotNull((Object)updateApiInfoDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)updateApiInfoDto.getId(), (String)"\u63a5\u53e3id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)updateApiInfoDto.getTestState(), (String)"\u6d4b\u8bd5\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        ApiInfo apiInfo = (ApiInfo)this.apiInfoService.getById((Serializable)Long.valueOf(Long.parseLong(updateApiInfoDto.getId())));
        if (HussarUtils.isEmpty((Object)apiInfo)) {
            throw new HussarException("\u63a5\u53e3\u6570\u636e\u4e0d\u5b58\u5728");
        }
        apiInfo.setTestState(updateApiInfoDto.getTestState());
        apiInfo.setDraftState("0");
        boolean b = this.apiInfoService.updateById((Object)apiInfo);
        if (b) {
            EaiAppEditManager.getInstance().call(apiInfo.getApplicationCode());
        }
        return b;
    }

    public ApiInfoEditVo getById(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ApiInfoEditVo apiInfoEditVo = this.eaiReleaseApiMapper.getById(Long.parseLong(id));
        if (HussarUtils.isEmpty((Object)apiInfoEditVo)) {
            return new ApiInfoEditVo();
        }
        ApplicationManageVo applicationManageVo = this.iApplicationManagementService.getByAppCode(apiInfoEditVo.getApplicationCode());
        if (HussarUtils.isEmpty((Object)applicationManageVo)) {
            throw new HussarException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        if (StringUtil.equals((CharSequence)"0", (CharSequence)applicationManageVo.getAppStatus())) {
            apiInfoEditVo.setApiState("0");
        }
        if (HussarUtils.isNotBlank((CharSequence)apiInfoEditVo.getInParamsStr())) {
            List eaiParamsItems = this.eaiConvertService.toEaiParamsItems(apiInfoEditVo.getInParamsStr());
            List inParams = eaiParamsItems.stream().filter(v -> HussarUtils.isNotBlank((CharSequence)v.getName())).collect(Collectors.toList());
            apiInfoEditVo.setInParams(inParams);
        }
        if (HussarUtils.isNotBlank((CharSequence)apiInfoEditVo.getOutParamsStr())) {
            List outParam = this.eaiConvertService.toEaiParamsItems(apiInfoEditVo.getOutParamsStr());
            apiInfoEditVo.setOutParams(this.fillBaseOutInfo(outParam));
            apiInfoEditVo.setCallSpecificaList(this.apiCallSpecificationInfoService.selectCallInfoListByApiId(Long.valueOf(id)));
        }
        if (HussarUtils.isNotBlank((CharSequence)apiInfoEditVo.getInParamsEditStr())) {
            apiInfoEditVo.setInParamsEdit(this.eaiConvertService.toEaiParamsConvertDto(apiInfoEditVo.getInParamsEditStr()));
        }
        if (HussarUtils.isNotBlank((CharSequence)apiInfoEditVo.getOutParamsEditStr())) {
            EaiOutParamDto eaiOutParamDto = this.eaiConvertService.toEaiOutParamDtoDto(apiInfoEditVo.getOutParamsEditStr());
            apiInfoEditVo.setOutParamsEdit(eaiOutParamDto);
        }
        this.fillParamValue(apiInfoEditVo);
        apiInfoEditVo.setCallSpecificaList(this.apiCallSpecificationInfoService.selectCallInfoListByApiId(Long.valueOf(id)));
        return apiInfoEditVo;
    }

    public ApiInfoEditVo getBaseInfoById(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ApiInfoEditVo apiInfoEditVo = this.eaiReleaseApiMapper.getById(Long.parseLong(id));
        if (HussarUtils.isEmpty((Object)apiInfoEditVo)) {
            return new ApiInfoEditVo();
        }
        ApplicationManageVo applicationManageVo = this.iApplicationManagementService.getByAppCode(apiInfoEditVo.getApplicationCode());
        if (HussarUtils.isEmpty((Object)applicationManageVo)) {
            throw new HussarException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        if (StringUtil.equals((CharSequence)"0", (CharSequence)applicationManageVo.getAppStatus())) {
            apiInfoEditVo.setApiState("0");
        }
        if (HussarUtils.isNotBlank((CharSequence)apiInfoEditVo.getInParamsStr())) {
            List eaiParamsItems = this.eaiConvertService.toEaiParamsItems(apiInfoEditVo.getInParamsStr());
            List inParams = eaiParamsItems.stream().filter(v -> HussarUtils.isNotBlank((CharSequence)v.getName())).collect(Collectors.toList());
            apiInfoEditVo.setInParams(inParams);
        }
        if (HussarUtils.isNotBlank((CharSequence)apiInfoEditVo.getOutParamsStr())) {
            apiInfoEditVo.setOutParams(this.eaiConvertService.toEaiParamsItems(apiInfoEditVo.getOutParamsStr()));
        }
        if (HussarUtils.isNotBlank((CharSequence)apiInfoEditVo.getInParamsEditStr())) {
            apiInfoEditVo.setInParamsEdit(this.eaiConvertService.toEaiParamsConvertDto(apiInfoEditVo.getInParamsEditStr()));
        }
        if (HussarUtils.isNotBlank((CharSequence)apiInfoEditVo.getOutParamsEditStr())) {
            EaiOutParamDto eaiOutParamDto = this.eaiConvertService.toEaiOutParamDtoDto(apiInfoEditVo.getOutParamsEditStr());
            apiInfoEditVo.setOutParamsEdit(eaiOutParamDto);
        }
        this.fillParamValue(apiInfoEditVo);
        apiInfoEditVo.setCallSpecificaList(this.apiCallSpecificationInfoService.selectCallInfoListByApiId(Long.valueOf(Long.parseLong(id))));
        return apiInfoEditVo;
    }

    public List<ApiInfoVo> apiInfosByAppCode(String appCode) {
        ArrayList apiInfoVos = Lists.newArrayListWithCapacity((int)10);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.orderByDesc(HussarBaseEntity::getCreateTime);
        List apiInfos = this.apiInfoService.list((Wrapper)queryWrapper.eq(ApiInfo::getApplicationCode, (Object)appCode));
        apiInfos.forEach(apiInfo -> {
            ApiInfoVo apiInfoVo = new ApiInfoVo();
            BeanUtil.copy((Object)apiInfo, (Object)apiInfoVo);
            apiInfoVos.add(apiInfoVo);
        });
        return apiInfoVos;
    }

    public Long saveApiBaseInfo(AddApiInfoDto addApiInfoDto) {
        AssertUtil.isNotNull((Object)addApiInfoDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        if (HussarUtils.isEmpty((Object)addApiInfoDto.getId())) {
            addApiInfoDto.setId(String.valueOf(IdGenerateUtils.getId()));
        }
        addApiInfoDto.setApiCode(addApiInfoDto.getName());
        addApiInfoDto.setApiName(addApiInfoDto.getDesc());
        CheckApiCodeDto checkApiCodeDto = new CheckApiCodeDto();
        BeanUtil.copyProperties((Object)addApiInfoDto, (Object)checkApiCodeDto);
        if (!this.checkApiCode(checkApiCodeDto).booleanValue()) {
            throw new HussarException("\u63a5\u53e3\u6807\u8bc6\u4e0d\u552f\u4e00");
        }
        ApiInfo apiInfo = new ApiInfo();
        this.fillApiInfo(addApiInfoDto, apiInfo);
        addApiInfoDto.setCreateCanvasFlag(false);
        EditApi editApi = this.fillEditApi(addApiInfoDto);
        this.iEaiEditApiService.save((Object)editApi);
        return apiInfo.getId();
    }

    public Boolean checkUniqueClassifyName(String applicationCode, String classifyName, Long classifyId) {
        return this.apiClassificationService.checkUniqueClassifyName(applicationCode, classifyName, classifyId);
    }

    public Page<ApiInfoVo> listPageByAppCode(PageInfo pageInfo, QueryApiInfoDto queryApiInfoDto) {
        ApplicationManageVo applicationManageVo = this.iApplicationManagementService.getByAppCode(queryApiInfoDto.getApplicationCode());
        if (HussarUtils.isEmpty((Object)applicationManageVo)) {
            throw new HussarException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        Page page = HussarPageUtils.convert((PageInfo)pageInfo);
        Page<ApiInfoVo> result = this.eaiReleaseApiMapper.listPageByAppCode((Page<ApiInfoVo>)page, queryApiInfoDto);
        List list = result.getRecords();
        if (HussarUtils.isEmpty((Object)list)) {
            return result;
        }
        result.getRecords().forEach(apiInfoVo -> {
            if (StringUtil.isEmpty((Object)apiInfoVo.getClassificId())) {
                apiInfoVo.setClassificId(Long.valueOf(0L));
                apiInfoVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
            } else if (0L == apiInfoVo.getClassificId()) {
                apiInfoVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
            }
        });
        if (StringUtil.equals((CharSequence)"0", (CharSequence)applicationManageVo.getAppStatus())) {
            list.forEach(v -> v.setApiState("0"));
            result.setRecords(list);
        }
        return result;
    }

    public Boolean checkApiCode(CheckApiCodeDto checkApiCodeDto) {
        AssertUtil.isNotNull((Object)checkApiCodeDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)checkApiCodeDto.getApiCode(), (String)"\u63a5\u53e3\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)checkApiCodeDto.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        return this.eaiReleaseApiMapper.countByApiCode(checkApiCodeDto) == 0;
    }

    public ApiResponse<EaiApiResponseVo> verifyApi(ApiTestDto apiTestDto) {
        AssertUtil.isNotNull((Object)apiTestDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)apiTestDto.getContentType(), (String)"\u5185\u5bb9\u683c\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)apiTestDto.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)apiTestDto.getHttpUrl(), (String)"\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)apiTestDto.getHttpMethod(), (String)"\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        HttpAuthVerifyDto authVerifyDto = this.fillAuthVerify(apiTestDto);
        return this.eaiHttpTemplateAuthService.httpAuthVerify(authVerifyDto);
    }

    @HussarTransactional
    public Boolean importSwagger(byte[] content, String appCode) {
        String data = this.deserialize(content);
        List<AddApiInfoDto> addApiInfos = this.dealInfo(data, appCode);
        if (HussarUtils.isEmpty(addApiInfos)) {
            throw new HussarException("json\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
        }
        return this.saveBatchApiInfo(addApiInfos);
    }

    protected boolean fillApiInfo(AddApiInfoDto addApiInfoDto, ApiInfo apiInfo) {
        BeanUtil.copyProperties((Object)addApiInfoDto, (Object)apiInfo);
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getId())) {
            apiInfo.setId(Long.valueOf(addApiInfoDto.getId()));
        }
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getInParams())) {
            apiInfo.setInParams(this.eaiConvertService.toStringDefault(addApiInfoDto.getInParams()));
        }
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getOutParams())) {
            EaiParamsConvertDto eaiOutParamDto = addApiInfoDto.getOutParams();
            apiInfo.setOutParams(this.eaiConvertService.toStringDefault(eaiOutParamDto));
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getDataFormat())) {
            apiInfo.setDataFormat(EaiDataCategoryEnum.JSON.getCodeStr());
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getEncodingType())) {
            apiInfo.setEncodingType(EaiCharsetEnum.UTF8.getCodeStr());
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getRequestType())) {
            apiInfo.setRequestType(EaiRequestTypeEnum.POST.getRequestTypeStr());
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getTestState())) {
            apiInfo.setTestState("0");
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getPublicState())) {
            apiInfo.setPublicState("0");
        }
        apiInfo.setApiState("0");
        apiInfo.setDraftState("0");
        return this.apiInfoService.save((Object)apiInfo);
    }

    private void fillBaseOutInfo(ApiInfoEditVo apiInfoEditVo) {
        if (HussarUtils.isEmpty((Object)apiInfoEditVo)) {
            return;
        }
        ArrayList<EaiParamsItems> outParam = new ArrayList<EaiParamsItems>();
        EaiParamsItems code = new EaiParamsItems();
        EaiParamsItems data = new EaiParamsItems();
        EaiParamsItems msg = new EaiParamsItems();
        EaiParamsItems success = new EaiParamsItems();
        code.setName("code");
        code.setType(Integer.valueOf(1));
        code.setItemType(null);
        code.setMark("code");
        code.setMapping(Integer.valueOf(1));
        code.setMappingName("code");
        code.setQuoteStructureId("");
        code.setValue("1");
        code.setItems(Collections.emptyList());
        data.setName("data");
        data.setMappingName("data");
        if (HussarUtils.isEmpty((Object)apiInfoEditVo.getOutParams())) {
            data.setType(Integer.valueOf(7));
            data.setItemType(null);
            data.setMark("data");
            data.setMapping(Integer.valueOf(1));
            data.setQuoteStructureId("");
            data.setValue("7");
            data.setItems(Collections.emptyList());
        } else {
            EaiParamsItems paramsItem = (EaiParamsItems)apiInfoEditVo.getOutParams().get(0);
            data.setType(paramsItem.getType());
            data.setItemType(paramsItem.getItemType());
            data.setMark(paramsItem.getMark());
            data.setMapping(paramsItem.getMapping());
            data.setQuoteStructureId(paramsItem.getQuoteStructureId());
            data.setValue(paramsItem.getValue());
            data.setItems(paramsItem.getItems());
        }
        msg.setName("msg");
        msg.setType(Integer.valueOf(4));
        msg.setItemType(null);
        msg.setMark("msg");
        msg.setMapping(Integer.valueOf(1));
        msg.setMappingName("msg");
        msg.setQuoteStructureId("");
        msg.setValue("4");
        msg.setItems(Collections.emptyList());
        success.setName("success");
        success.setType(Integer.valueOf(0));
        success.setItemType(null);
        success.setMark("success");
        success.setMapping(Integer.valueOf(1));
        success.setMappingName("success");
        success.setQuoteStructureId("");
        success.setValue("0");
        success.setItems(Collections.emptyList());
        outParam.add(code);
        outParam.add(data);
        outParam.add(msg);
        outParam.add(success);
        apiInfoEditVo.setOutParams(outParam);
    }

    protected EditApi fillEditApi(AddApiInfoDto addApiInfoDto) {
        UserDetails userDetails;
        EditApi editApi = new EditApi();
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getId())) {
            editApi.setApiId(Long.valueOf(addApiInfoDto.getId()));
        }
        editApi.setApiPath(addApiInfoDto.getApiEditPath());
        editApi.setEncodingType(EaiCharsetEnum.UTF8.getCodeStr());
        editApi.setHttpMethod(addApiInfoDto.getHttpMethod());
        editApi.setContentType(addApiInfoDto.getContentType());
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getInParams())) {
            editApi.setInParams(ApiCommonManager.toJSONString(addApiInfoDto.getInParams()));
        }
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getOutParams())) {
            editApi.setOutParams(ApiCommonManager.toJSONString(addApiInfoDto.getOutParams()));
        }
        if (HussarUtils.isNotEmpty((Object)(userDetails = HussarSecurityUtils.getLoginUserDetails()))) {
            editApi.setCreateBy(userDetails.getUserName());
        }
        return editApi;
    }

    protected void fillApiInfo4Update(AddApiInfoDto addApiInfoDto, ApiInfo apiInfo) {
        BeanUtil.copyProperties((Object)addApiInfoDto, (Object)apiInfo);
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getInParams())) {
            apiInfo.setInParams(this.eaiConvertService.toStringDefault(addApiInfoDto.getInParams()));
        }
        if (HussarUtils.isNotEmpty((Object)addApiInfoDto.getOutParams())) {
            EaiParamsConvertDto eaiOutParamDto = addApiInfoDto.getOutParams();
            apiInfo.setOutParams(this.eaiConvertService.toStringDefault(eaiOutParamDto));
        }
        if (HussarUtils.isBlank((CharSequence)addApiInfoDto.getDataFormat())) {
            apiInfo.setDataFormat(EaiDataCategoryEnum.JSON.getCodeStr());
        }
        if (HussarUtils.isBlank((CharSequence)addApiInfoDto.getEncodingType())) {
            apiInfo.setEncodingType(EaiCharsetEnum.UTF8.getCodeStr());
        }
        if (HussarUtils.isBlank((CharSequence)addApiInfoDto.getRequestType())) {
            apiInfo.setRequestType(EaiRequestTypeEnum.POST.getRequestTypeStr());
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getTestState())) {
            apiInfo.setTestState("0");
        }
        if (HussarUtils.isBlank((CharSequence)apiInfo.getPublicState())) {
            apiInfo.setPublicState("0");
        }
        apiInfo.setApiState("0");
        apiInfo.setDraftState("0");
        this.apiInfoService.updateById((Object)apiInfo);
    }

    protected static String toJSONString(Object t) {
        return JSONObject.toJSONString((Object)JSON.toJSON((Object)t));
    }

    protected HttpAuthVerifyDto fillAuthVerify(ApiTestDto apiTestDto) {
        HttpAuthVerifyDto authVerifyDto = new HttpAuthVerifyDto();
        authVerifyDto.setServiceId(apiTestDto.getServiceId());
        List<EaiHttpParamsDto> authParams = this.fillAuthParam(apiTestDto);
        Object body = apiTestDto.getBody();
        if (HussarUtils.isEmpty((Object)apiTestDto.getInParams())) {
            throw new BaseException("\u5165\u53c2\u7ed3\u6784\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Object> httpHeader = Collections.emptyList();
        List<Object> httpQueryParam = Collections.emptyList();
        EaiHttpBodyDto httpBody = new EaiHttpBodyDto();
        if (HussarUtils.isNotEmpty((Object)body)) {
            EaiApiParams obj = ParamsConvertUtil.oEaiParamsItems((Object)body, (String)JSON.toJSONString((Object)apiTestDto.getInParams()));
            httpHeader = this.fillParams(obj, EaiApiParamMappingEnum.HEADER.getCodeStr());
            httpQueryParam = this.fillParams(obj, EaiApiParamMappingEnum.QUERY.getCodeStr());
            httpBody = this.fillHttpBody(apiTestDto.getContentType(), obj);
        } else {
            httpBody = this.fillHttpBody(apiTestDto.getContentType(), null);
        }
        authVerifyDto.setApplicationCode(apiTestDto.getApplicationCode());
        authVerifyDto.setHttpUrl(apiTestDto.getHttpUrl());
        authVerifyDto.setHttpMethod(apiTestDto.getHttpMethod());
        authVerifyDto.setAuthParams(authParams);
        authVerifyDto.setHttpHeader(httpHeader);
        authVerifyDto.setHttpQueryParam(httpQueryParam);
        authVerifyDto.setHttpBody(httpBody);
        if (HussarUtils.isNotEmpty((Object)apiTestDto.getOutParams())) {
            authVerifyDto.setOutMapping(apiTestDto.getOutParams().getBody());
        }
        authVerifyDto.setCallSpecificaList(apiTestDto.getCallSpecificaList());
        return authVerifyDto;
    }

    private List<EaiHttpParamsDto> fillAuthParam(ApiTestDto apiTestDto) {
        ArrayList<EaiHttpParamsDto> authParams = new ArrayList<EaiHttpParamsDto>();
        List header = apiTestDto.getHeader();
        if (HussarUtils.isEmpty((Object)header)) {
            return Collections.emptyList();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (ApiParamItem apiParamItem : header) {
            EaiHttpParamsDto eaiHttpParamsDto = new EaiHttpParamsDto();
            eaiHttpParamsDto.setParamsNameEn(apiParamItem.getName());
            if (HussarUtils.isNotEmpty((Object)apiParamItem.getValue())) {
                eaiHttpParamsDto.setParamsValue(apiParamItem.getValue().toString());
                map.put(apiParamItem.getName(), apiParamItem.getValue());
            }
            eaiHttpParamsDto.setParamsId(Long.valueOf(Long.parseLong(apiParamItem.getAuthParamId())));
            eaiHttpParamsDto.setParamsFrom("2");
            authParams.add(eaiHttpParamsDto);
        }
        TempHttpCode.setParams(map);
        return authParams;
    }

    private void filMap(Map<String, Object> map, List<EaiHttpParamsDto> params) {
        map.forEach((k, v) -> {
            EaiHttpParamsDto eaiHttpParamsDto = new EaiHttpParamsDto();
            eaiHttpParamsDto.setParamsNameEn(k);
            eaiHttpParamsDto.setKeyValue(v);
            params.add(eaiHttpParamsDto);
        });
    }

    private List<EaiHttpParamsDto> fillParams(EaiApiParams obj, String type) {
        ArrayList<EaiHttpParamsDto> params = new ArrayList<EaiHttpParamsDto>();
        if (HussarUtils.isNotEmpty((Object)obj)) {
            Object real = null;
            if (EaiApiParamMappingEnum.BODY.getCodeStr().equals(type)) {
                real = obj.getBody();
            } else if (EaiApiParamMappingEnum.HEADER.getCodeStr().equals(type)) {
                real = obj.getHeader();
            } else if (EaiApiParamMappingEnum.QUERY.getCodeStr().equals(type)) {
                real = obj.getQuery();
            }
            if (HussarUtils.isNotEmpty((Object)real)) {
                if (real instanceof Map) {
                    this.filMap((Map)real, params);
                } else {
                    EaiHttpParamsDto eaiHttpParamsDto = new EaiHttpParamsDto();
                    eaiHttpParamsDto.setParamsNameEn(null);
                    eaiHttpParamsDto.setKeyValue(real);
                    params.add(eaiHttpParamsDto);
                }
            }
        }
        return params;
    }

    private EaiHttpBodyDto fillHttpBody(String contentType, EaiApiParams obj) {
        EaiHttpBodyDto result = new EaiHttpBodyDto();
        List<EaiHttpParamsDto> params = this.fillParams(obj, EaiApiParamMappingEnum.BODY.getCodeStr());
        result.setBodyParam(params);
        result.setContentType(contentType);
        return result;
    }

    protected String deserialize(byte[] bytes) {
        if (HussarUtils.isEmpty((Object)bytes)) {
            throw new HussarException("\u5bfc\u5165\u5931\u8d25\uff0c\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        String result = new String(bytes, StandardCharsets.UTF_8);
        if (HussarUtils.isBlank((CharSequence)result)) {
            throw new HussarException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u5185\u5bb9");
        }
        return result;
    }

    protected List<AddApiInfoDto> dealInfo(String data, String appCode) {
        JSONObject jsonObject = JSON.parseObject((String)data);
        JSONObject paths = (JSONObject)jsonObject.get((Object)"paths");
        JSONObject definitions = (JSONObject)jsonObject.get((Object)"definitions");
        Map structureMap = this.eaiCommonStructureService.addNewStructure(definitions, appCode);
        Map paramMap = (Map)JSONObject.toJavaObject((JSON)definitions, Map.class);
        ArrayList<AddApiInfoDto> result = new ArrayList<AddApiInfoDto>();
        for (Map.Entry entry : paths.entrySet()) {
            AddApiInfoDto addApiInfoDto = new AddApiInfoDto();
            String editPath = (String)entry.getKey();
            JSONObject methodInfo = (JSONObject)entry.getValue();
            for (Map.Entry methodEntry : methodInfo.entrySet()) {
                String requestType = ((String)methodEntry.getKey()).toUpperCase();
                JSONObject requestInfo = (JSONObject)methodEntry.getValue();
                this.fillApiBaseInfo(requestInfo, editPath, appCode, requestType, addApiInfoDto);
                this.fillApiInParam(requestInfo, structureMap, paramMap, addApiInfoDto);
                this.fillApiOutParam(requestInfo, structureMap, paramMap, addApiInfoDto);
            }
            result.add(addApiInfoDto);
        }
        return result;
    }

    private void fillApiBaseInfo(JSONObject requestInfo, String editPath, String appCode, String requestType, AddApiInfoDto addApiInfoDto) {
        String apiName = String.valueOf(requestInfo.get((Object)"summary"));
        String remark = String.valueOf(requestInfo.get((Object)"description"));
        List consumes = (List)requestInfo.get((Object)"consumes");
        String contentType = EaiContentType.X_WWW_FORM.getTypeStr();
        if (HussarUtils.isNotEmpty((Object)consumes)) {
            String arr0 = (String)consumes.get(0);
            contentType = EaiContentType.getByName((String)arr0).getTypeStr();
        }
        Long virtualId = IdGenerateUtils.getId();
        String random = Long.toString(virtualId).substring(Long.toString(virtualId).length() - 4);
        String pathLast = editPath.substring(editPath.lastIndexOf("/") + 1);
        String apiCode = StringUtils.capitalize((String)pathLast) + random;
        addApiInfoDto.setApiName(apiName);
        addApiInfoDto.setApiCode(apiCode);
        addApiInfoDto.setApplicationCode(appCode);
        addApiInfoDto.setApiPath(appCode + "/" + apiCode);
        addApiInfoDto.setRemark(remark);
        addApiInfoDto.setApiEditPath(editPath);
        addApiInfoDto.setHttpMethod(requestType);
        addApiInfoDto.setContentType(contentType);
    }

    private void fillApiInParam(JSONObject requestInfo, Map<String, StructureImportDto> structureMap, Map<String, JSONObject> paramMap, AddApiInfoDto addApiInfoDto) {
        JSONArray parameterJson = (JSONArray)requestInfo.get((Object)"parameters");
        if (HussarUtils.isEmpty((Object)parameterJson)) {
            addApiInfoDto.setContentType(EaiContentType.NONE.getTypeStr());
            addApiInfoDto.setInParams(new EaiParamsConvertDto());
            return;
        }
        List<Object> headerObjects = parameterJson.stream().filter(v -> StringUtil.equals((CharSequence)"header", (CharSequence)((String)((JSONObject)v).get((Object)"in")))).collect(Collectors.toList());
        List<Object> bodyObjects = parameterJson.stream().filter(v -> StringUtil.equals((CharSequence)"body", (CharSequence)((String)((JSONObject)v).get((Object)"in")))).collect(Collectors.toList());
        List<Object> queryObjects = parameterJson.stream().filter(v -> StringUtil.equals((CharSequence)"query", (CharSequence)((String)((JSONObject)v).get((Object)"in")))).collect(Collectors.toList());
        EaiParamsConvertDto eaiParamsConvertDto = new EaiParamsConvertDto();
        List<EaiParamsItems> headerParam = this.dealInParam(structureMap, paramMap, headerObjects);
        List<EaiParamsItems> bodyParam = this.dealInParam(structureMap, paramMap, bodyObjects);
        List<EaiParamsItems> queryParam = this.dealInParam(structureMap, paramMap, queryObjects);
        if (HussarUtils.isNotEmpty(bodyParam)) {
            EaiParamsItems eaiParamsItems = new EaiParamsItems();
            eaiParamsItems.setName("body");
            eaiParamsItems.setRequired(Integer.valueOf(1));
            eaiParamsItems.setMark("body");
            eaiParamsItems.setMappingName("body");
            if (bodyObjects.size() == 1) {
                EaiParamsItems item = bodyParam.get(0);
                BeanUtil.copyProperties((Object)item, (Object)eaiParamsItems, (String[])new String[]{"name", "required", "mark", "mappingName"});
            } else {
                eaiParamsItems.setType(null);
                eaiParamsItems.setItemType(null);
                eaiParamsItems.setQuoteStructureId("");
                eaiParamsItems.setItems(bodyParam);
            }
            eaiParamsConvertDto.setBody(eaiParamsItems);
        } else {
            addApiInfoDto.setContentType(EaiContentType.NONE.getTypeStr());
        }
        eaiParamsConvertDto.setHeader(headerParam);
        eaiParamsConvertDto.setQuery(queryParam);
        addApiInfoDto.setInParams(eaiParamsConvertDto);
    }

    private void fillApiOutParam(JSONObject requestInfo, Map<String, StructureImportDto> structureMap, Map<String, JSONObject> paramMap, AddApiInfoDto addApiInfoDto) {
        JSONObject response = (JSONObject)requestInfo.get((Object)"responses");
        EaiParamsItems responseResult = new EaiParamsItems();
        if (HussarUtils.isEmpty((Object)response)) {
            throw new HussarException("\u5bfc\u5165\u5931\u8d25\uff0c\u63a5\u53e3\u51fa\u53c2\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        JSONObject schema = (JSONObject)((JSONObject)response.get((Object)"200")).get((Object)"schema");
        if (HussarUtils.isEmpty((Object)schema)) {
            addApiInfoDto.setOutParams(new EaiParamsConvertDto());
            return;
        }
        String schemaType = (String)schema.get((Object)"type");
        if (StringUtil.isBlank((CharSequence)schemaType)) {
            String ref = (String)schema.get((Object)"$ref");
            String paramRef = ref.substring(ref.lastIndexOf("/") + 1);
            responseResult.setName("responseBody");
            responseResult.setMappingName("responseBody");
            responseResult.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
            responseResult.setItemType(null);
            responseResult.setRequired(Integer.valueOf(1));
            responseResult.setMark(structureMap.get(paramRef).getRemark());
            responseResult.setQuoteStructureId(structureMap.get(paramRef).getId().toString());
            responseResult.setItems(this.parseResponseToItems(null, paramMap, structureMap, ref));
        } else {
            EaiParamsItems arrParamItem = new EaiParamsItems();
            String ref = (String)((JSONObject)schema.get((Object)"items")).get((Object)"$ref");
            if (HussarUtils.isNotBlank((CharSequence)ref)) {
                String paramRef = ref.substring(ref.lastIndexOf("/") + 1);
                arrParamItem.setItems(this.parseResponseToItems(null, paramMap, structureMap, ref));
                arrParamItem.setName(paramRef);
                arrParamItem.setMappingName(paramRef);
                arrParamItem.setType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                arrParamItem.setItemType(null);
                arrParamItem.setMark(structureMap.get(paramRef).getRemark());
                arrParamItem.setQuoteStructureId(structureMap.get(paramRef).getId().toString());
                responseResult.setName("responseBody");
                responseResult.setMappingName("responseBody");
                responseResult.setType(this.setType(schemaType));
                responseResult.setItemType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                responseResult.setMark("list");
                responseResult.setRequired(Integer.valueOf(1));
                responseResult.setQuoteStructureId("");
                responseResult.setItems(Collections.singletonList(arrParamItem));
            } else {
                String arrType = (String)((JSONObject)schema.get((Object)"items")).get((Object)"type");
                EaiParamsItems arrItems = new EaiParamsItems();
                arrItems.setType(this.setType(arrType));
                arrItems.setName("items");
                arrItems.setMappingName("items");
                arrItems.setMark("items");
                arrItems.setQuoteStructureId("");
                arrItems.setItemType(null);
                arrItems.setItems(Collections.emptyList());
                responseResult.setName("responseBody");
                responseResult.setMappingName("responseBody");
                responseResult.setType(this.setType(schemaType));
                responseResult.setItemType(this.setType(arrType));
                responseResult.setRequired(Integer.valueOf(1));
                responseResult.setMark("list");
                responseResult.setQuoteStructureId("");
                responseResult.setItems(Collections.singletonList(arrItems));
            }
        }
        EaiParamsConvertDto eaiParamsConvertDto = new EaiParamsConvertDto();
        eaiParamsConvertDto.setBody(responseResult);
        addApiInfoDto.setOutParams(eaiParamsConvertDto);
    }

    private List<EaiParamsItems> dealInParam(Map<String, StructureImportDto> structureMap, Map<String, JSONObject> paramMap, List<Object> objectList) {
        if (HussarUtils.isEmpty(objectList)) {
            return Collections.emptyList();
        }
        ArrayList<EaiParamsItems> result = new ArrayList<EaiParamsItems>();
        for (Object obj : objectList) {
            JSONObject jsonObject = (JSONObject)obj;
            String name = (String)jsonObject.get((Object)"name");
            String description = (String)jsonObject.get((Object)"description");
            int required = (Boolean)jsonObject.get((Object)"required") != false ? 1 : 0;
            String type = (String)jsonObject.get((Object)"type");
            EaiParamsItems eaiParamsItems = new EaiParamsItems();
            eaiParamsItems.setName(name);
            eaiParamsItems.setRequired(Integer.valueOf(required));
            eaiParamsItems.setMark(description);
            eaiParamsItems.setMappingName(name);
            if (StringUtil.isNotBlank((CharSequence)type)) {
                eaiParamsItems.setType(this.setType(type));
                eaiParamsItems.setItemType(null);
                eaiParamsItems.setQuoteStructureId("");
                eaiParamsItems.setItems(Collections.emptyList());
            } else {
                JSONObject schema = (JSONObject)jsonObject.get((Object)"schema");
                if (HussarUtils.isEmpty((Object)schema)) {
                    throw new HussarException("\u5bfc\u5165\u5931\u8d25\uff0c\u63a5\u53e3\u5165\u53c2\u683c\u5f0f\u4e0d\u6b63\u786e");
                }
                String schemaType = (String)schema.get((Object)"type");
                if (StringUtil.isBlank((CharSequence)schemaType)) {
                    schemaType = "object";
                    String ref = (String)schema.get((Object)"$ref");
                    String paramRef = ref.substring(ref.lastIndexOf("/") + 1);
                    eaiParamsItems.setType(this.setType(schemaType));
                    eaiParamsItems.setItemType(null);
                    eaiParamsItems.setQuoteStructureId(structureMap.get(paramRef).getId().toString());
                    eaiParamsItems.setItems(this.parseResponseToItems(null, paramMap, structureMap, ref));
                } else {
                    EaiParamsItems arrParamItem = new EaiParamsItems();
                    String ref = (String)((JSONObject)schema.get((Object)"items")).get((Object)"$ref");
                    if (HussarUtils.isNotBlank((CharSequence)ref)) {
                        String paramRef = ref.substring(ref.lastIndexOf("/") + 1);
                        arrParamItem.setItems(this.parseResponseToItems(null, paramMap, structureMap, ref));
                        arrParamItem.setName(paramRef);
                        arrParamItem.setMappingName(paramRef);
                        arrParamItem.setType(this.setType("object"));
                        arrParamItem.setItemType(null);
                        arrParamItem.setRequired(Integer.valueOf(0));
                        arrParamItem.setMark(structureMap.get(paramRef).getRemark());
                        arrParamItem.setQuoteStructureId(structureMap.get(paramRef).getId().toString());
                        eaiParamsItems.setType(this.setType(schemaType));
                        eaiParamsItems.setItemType(Integer.valueOf(EaiDataType.DATA_TYPE_STRUCTURE.getType()));
                        eaiParamsItems.setQuoteStructureId("");
                        eaiParamsItems.setItems(Collections.singletonList(arrParamItem));
                    } else {
                        String arrType = (String)((JSONObject)schema.get((Object)"items")).get((Object)"type");
                        EaiParamsItems arrItems = new EaiParamsItems();
                        arrItems.setType(this.setType(arrType));
                        arrItems.setName("items");
                        arrItems.setMappingName("items");
                        arrItems.setMark("items");
                        arrItems.setQuoteStructureId("");
                        arrItems.setItemType(null);
                        arrItems.setItems(Collections.emptyList());
                        eaiParamsItems.setType(this.setType(schemaType));
                        eaiParamsItems.setItemType(this.setType(arrType));
                        eaiParamsItems.setQuoteStructureId("");
                        eaiParamsItems.setItems(Collections.singletonList(arrItems));
                    }
                }
            }
            result.add(eaiParamsItems);
        }
        return result;
    }

    private List<EaiParamsItems> parseResponseToItems(Map<String, Integer> forEachCache, Map<String, JSONObject> paramMap, Map<String, StructureImportDto> structureMap, String paramRef) {
        Integer forEachCount;
        ArrayList<EaiParamsItems> responseItems = new ArrayList<EaiParamsItems>();
        if (StringUtil.isBlank((CharSequence)paramRef)) {
            return responseItems;
        }
        String paramKey = "";
        if (StringUtil.isNotBlank((CharSequence)paramRef)) {
            paramKey = paramRef.substring(paramRef.lastIndexOf("/") + 1);
        }
        if (HussarUtils.isEmpty(forEachCache)) {
            forEachCache = new HashMap<String, Integer>();
        }
        if (HussarUtils.isNotEmpty((Object)(forEachCount = forEachCache.get(paramKey))) && forEachCount >= 1) {
            return responseItems;
        }
        forEachCache.put(paramKey, 1);
        JSONObject paramJson = paramMap.get(paramKey);
        JSONObject propertiesJson = JSONObject.parseObject((String)String.valueOf(paramJson.get((Object)"properties")));
        for (Map.Entry entry : propertiesJson.entrySet()) {
            String type;
            EaiParamsItems eaiParamsItems = new EaiParamsItems();
            String key = (String)entry.getKey();
            JSONObject valueJson = JSONObject.parseObject((String)String.valueOf(entry.getValue()));
            String description = valueJson.getString("description");
            String ref = valueJson.getString("$ref");
            String shortRef = "";
            if (StringUtil.isNotBlank((CharSequence)ref)) {
                shortRef = ref.substring(ref.lastIndexOf("/") + 1);
            }
            if (HussarUtils.isBlank((CharSequence)(type = valueJson.getString("type")))) {
                type = "object";
                eaiParamsItems.setItemType(null);
                eaiParamsItems.setQuoteStructureId(structureMap.get(shortRef).getId().toString());
                eaiParamsItems.setItems(this.parseResponseToItems(forEachCache, paramMap, structureMap, ref));
            } else if (StringUtil.equals((CharSequence)"array", (CharSequence)type)) {
                this.parseArray(valueJson, eaiParamsItems, paramMap, structureMap, forEachCache);
            } else {
                eaiParamsItems.setItemType(null);
                eaiParamsItems.setQuoteStructureId("");
                eaiParamsItems.setItems(Collections.emptyList());
            }
            eaiParamsItems.setName(key);
            eaiParamsItems.setType(this.setType(type));
            eaiParamsItems.setRequired(Integer.valueOf(0));
            eaiParamsItems.setMark(description);
            eaiParamsItems.setMappingName(key);
            responseItems.add(eaiParamsItems);
        }
        return responseItems;
    }

    private void parseArray(JSONObject valueJson, EaiParamsItems eaiParamsItems, Map<String, JSONObject> paramMap, Map<String, StructureImportDto> structureMap, Map<String, Integer> forEachCache) {
        Object arr = valueJson.get((Object)"items");
        JSONObject property = JSONObject.parseObject((String)String.valueOf(arr));
        String arrType = (String)property.get((Object)"type");
        String arrRef = (String)property.get((Object)"$ref");
        String paramKey = "";
        if (StringUtil.isNotBlank((CharSequence)arrRef)) {
            paramKey = arrRef.substring(arrRef.lastIndexOf("/") + 1);
        }
        if (HussarUtils.isBlank((CharSequence)arrType)) {
            arrType = "object";
            eaiParamsItems.setItemType(this.setType(arrType));
            eaiParamsItems.setQuoteStructureId("");
            EaiParamsItems arrItems = new EaiParamsItems();
            arrItems.setName(paramKey);
            arrItems.setMappingName(paramKey);
            arrItems.setType(this.setType(arrType));
            arrItems.setItemType(null);
            arrItems.setRequired(Integer.valueOf(0));
            arrItems.setMark(structureMap.get(paramKey).getRemark());
            arrItems.setQuoteStructureId(structureMap.get(paramKey).getId().toString());
            arrItems.setItems(this.parseResponseToItems(forEachCache, paramMap, structureMap, arrRef));
            eaiParamsItems.setItems(Collections.singletonList(arrItems));
            if (HussarUtils.isNotEmpty(forEachCache)) {
                forEachCache.remove(paramKey);
            }
        } else if (StringUtil.equals((CharSequence)"array", (CharSequence)arrType)) {
            eaiParamsItems.setItemType(this.setType(arrType));
            EaiParamsItems arrItems = new EaiParamsItems();
            arrItems.setName("items");
            arrItems.setMappingName("items");
            arrItems.setType(this.setType(arrType));
            arrItems.setRequired(Integer.valueOf(0));
            arrItems.setMark("items");
            arrItems.setQuoteStructureId("");
            this.parseArray(property, arrItems, paramMap, structureMap, null);
            eaiParamsItems.setItems(Collections.singletonList(arrItems));
        } else {
            EaiParamsItems arrItems = new EaiParamsItems();
            arrItems.setType(this.setType(arrType));
            arrItems.setName("items");
            arrItems.setMappingName("items");
            arrItems.setMark("items");
            arrItems.setQuoteStructureId("");
            arrItems.setItemType(null);
            arrItems.setItems(Collections.emptyList());
            eaiParamsItems.setItemType(this.setType(arrType));
            eaiParamsItems.setQuoteStructureId("");
            eaiParamsItems.setItems(Collections.singletonList(arrItems));
        }
    }

    private Integer setType(String type) {
        if ("boolean".equals(type)) {
            return 0;
        }
        if ("integer".equals(type)) {
            return 1;
        }
        if ("long".equals(type)) {
            return 2;
        }
        if ("double".equals(type)) {
            return 3;
        }
        if ("string".equals(type)) {
            return 4;
        }
        if ("date".equals(type)) {
            return 5;
        }
        if ("array".equals(type)) {
            return 6;
        }
        if ("object".equals(type)) {
            return 7;
        }
        return null;
    }

    protected List<ApiInfo> saveBatchApiInfos(List<AddApiInfoDto> addApiInfos) {
        AssertUtil.isNotEmpty(addApiInfos, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList<ApiInfo> apiInfos = new ArrayList<ApiInfo>();
        ArrayList<EditApi> editApis = new ArrayList<EditApi>();
        for (AddApiInfoDto dto : addApiInfos) {
            UserDetails userDetails;
            ApiInfo apiInfo = new ApiInfo();
            BeanUtil.copyProperties((Object)dto, (Object)apiInfo);
            if (HussarUtils.isNotEmpty((Object)dto.getInParams())) {
                apiInfo.setInParams(this.eaiConvertService.toStringDefault(dto.getInParams()));
            }
            if (HussarUtils.isNotEmpty((Object)dto.getOutParams())) {
                apiInfo.setOutParams(this.eaiConvertService.toStringDefault(dto.getOutParams()));
            }
            Long id = IdGenerateUtils.getId();
            apiInfo.setId(id);
            apiInfo.setDataFormat(EaiDataCategoryEnum.JSON.getCodeStr());
            apiInfo.setEncodingType(EaiCharsetEnum.UTF8.getCodeStr());
            apiInfo.setRequestType(EaiRequestTypeEnum.POST.getRequestTypeStr());
            if (HussarUtils.isBlank((CharSequence)apiInfo.getTestState())) {
                apiInfo.setTestState("0");
            }
            if (HussarUtils.isBlank((CharSequence)apiInfo.getPublicState())) {
                apiInfo.setPublicState("0");
            }
            apiInfo.setApiState("0");
            apiInfo.setDraftState("0");
            apiInfos.add(apiInfo);
            EaiAppEditManager.getInstance().call(apiInfo.getApplicationCode());
            EditApi editApi = new EditApi();
            editApi.setApiId(id);
            editApi.setApiPath(dto.getApiEditPath());
            editApi.setEncodingType(EaiCharsetEnum.UTF8.getCodeStr());
            editApi.setHttpMethod(dto.getHttpMethod());
            editApi.setContentType(dto.getContentType());
            if (HussarUtils.isNotEmpty((Object)dto.getInParams())) {
                editApi.setInParams(ApiCommonManager.toJSONString(dto.getInParams()));
            }
            if (HussarUtils.isNotEmpty((Object)dto.getOutParams())) {
                editApi.setOutParams(ApiCommonManager.toJSONString(dto.getOutParams()));
            }
            if (HussarUtils.isNotEmpty((Object)(userDetails = HussarSecurityUtils.getLoginUserDetails()))) {
                editApi.setCreateBy(userDetails.getUserName());
            }
            editApis.add(editApi);
        }
        this.apiInfoService.saveBatch(apiInfos);
        this.iEaiEditApiService.saveBatch(editApis);
        return apiInfos;
    }

    private Boolean saveBatchApiInfo(List<AddApiInfoDto> addApiInfos) {
        this.saveBatchApiInfos(addApiInfos);
        return true;
    }

    public String getPublishedVersion(String applicationCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysApplication::getAppCode, (Object)applicationCode)).eq(SysApplication::getAppStatus, (Object)"1");
        SysApplication sysApplication = (SysApplication)this.applicationService.getOne((Wrapper)queryWrapper);
        if (HussarUtils.isEmpty((Object)sysApplication)) {
            throw new BaseException("\u5e94\u7528\u4e0d\u5b58\u5728");
        }
        return EaiVersionUtil.getInstance().getNewVersion(sysApplication.getAppVersion());
    }

    @HussarTransactional(rollbackFor={Exception.class})
    public boolean deleteByAppCode(String appCode) {
        LambdaQueryWrapper apiWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)appCode);
        List apiInfos = this.apiInfoService.list((Wrapper)apiWrapper);
        this.apiInfoService.remove((Wrapper)apiWrapper);
        if (HussarUtils.isNotEmpty((Object)apiInfos)) {
            List ids = apiInfos.stream().map(ApiInfo::getId).collect(Collectors.toList());
            LambdaQueryWrapper editWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(EditApi::getApiId, ids);
            this.iEaiEditApiService.remove((Wrapper)editWrapper);
        }
        EaiAppEditManager.getInstance().call(appCode);
        return true;
    }

    private void fillParamValue(ApiInfoEditVo apiInfoEditVo) {
        List inParam;
        if (HussarUtils.isEmpty((Object)apiInfoEditVo)) {
            return;
        }
        Map map = this.eaiCommonStructureService.getAllStructures();
        if (HussarUtils.isNotEmpty((Object)apiInfoEditVo.getInParams())) {
            inParam = apiInfoEditVo.getInParams();
            this.parseValue(inParam, map);
        }
        if (HussarUtils.isNotEmpty((Object)apiInfoEditVo.getOutParams())) {
            List outParam = apiInfoEditVo.getOutParams();
            this.parseValue(outParam, map);
        }
        if (HussarUtils.isNotEmpty((Object)apiInfoEditVo.getInParamsEdit())) {
            inParam = apiInfoEditVo.getInParamsEdit();
            List header = inParam.getHeader();
            List query = inParam.getQuery();
            EaiParamsItems body = inParam.getBody();
            ArrayList<EaiParamsItems> bodyList = new ArrayList<EaiParamsItems>();
            bodyList.add(body);
            this.parseValue(header, map);
            this.parseValue(query, map);
            this.parseValue(bodyList, map);
        }
        if (HussarUtils.isNotEmpty((Object)apiInfoEditVo.getOutParamsEdit())) {
            EaiOutParamDto eaiOutParamDto = apiInfoEditVo.getOutParamsEdit();
            List body = eaiOutParamDto.getBody();
            this.parseValue(body, map);
        }
        if (StringUtil.isEmpty((Object)apiInfoEditVo.getClassificId())) {
            apiInfoEditVo.setClassificId(Long.valueOf(0L));
            apiInfoEditVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
        } else if (0L == apiInfoEditVo.getClassificId()) {
            apiInfoEditVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
        }
    }

    private void parseValue(List<EaiParamsItems> list, Map<String, CommonStructureVo> map) {
        if (HussarUtils.isEmpty(list)) {
            return;
        }
        for (EaiParamsItems eaiParamsItems : list) {
            if (HussarUtils.isEmpty((Object)eaiParamsItems) || HussarUtils.isEmpty((Object)eaiParamsItems.getType())) continue;
            eaiParamsItems.setValue(String.valueOf(eaiParamsItems.getType()));
            if (eaiParamsItems.getType() == 7 && HussarUtils.isNotBlank((CharSequence)eaiParamsItems.getQuoteStructureId())) {
                CommonStructureVo valueStrVo = map.get(eaiParamsItems.getQuoteStructureId());
                if (HussarUtils.isEmpty((Object)valueStrVo)) continue;
                eaiParamsItems.setValue(valueStrVo.getStructureCode());
            }
            this.parseValue(eaiParamsItems.getItems(), map);
        }
    }

    public List<EaiApiClassificationVo> getApiClassify(String applicationCode) {
        return this.eaiApiClassificationService.getClassifyByAppCode(applicationCode);
    }

    public Boolean addApiClassify(EaiApiClassification apiClassificationDto) {
        return this.apiClassificationService.saveApiClassify(apiClassificationDto);
    }

    public Boolean updateApiClassify(EaiApiClassification apiClassificationDto) {
        return this.apiClassificationService.updateApiClassify(apiClassificationDto);
    }

    public Boolean deleteApiClassify(Long apiClassifyId, String applicationCode) {
        AssertUtil.isFalse((boolean)apiClassifyId.equals(0), (String)"\u9ed8\u8ba4\u7c7b\u578b\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        List apiInfos = this.apiInfoService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ApiInfo::getApplicationCode, (Object)applicationCode)).eq(ApiInfo::getClassificId, (Object)apiClassifyId));
        AssertUtil.isFalse((boolean)CollectionUtil.isNotEmpty((Collection)apiInfos), (String)"\u5206\u7c7b\u4e0b\u5b58\u5728\u63a5\u53e3,\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        return this.apiClassificationService.removeById((Serializable)apiClassifyId);
    }

    public EaiResourceVo getEaiResource(String applicationCode) {
        List commonStructures;
        List commonConstants;
        EaiResourceVo eaiResourceVo = new EaiResourceVo();
        List<ApiInfoVo> apiInfoVos = this.apiInfosByAppCode(applicationCode);
        if (CollectionUtil.isNotEmpty(apiInfoVos)) {
            apiInfoVos.forEach(returnApi -> {
                returnApi.setName(returnApi.getApiCode());
                returnApi.setDesc(returnApi.getApiName());
                if (StringUtil.isEmpty((Object)returnApi.getClassificId())) {
                    returnApi.setClassificId(Long.valueOf(0L));
                    returnApi.setParentId(Long.valueOf(0L));
                }
            });
            Map<Long, List<ApiInfoVo>> apiclassifyMap = apiInfoVos.stream().collect(Collectors.groupingBy(ApiInfoVo::getClassificId));
            ArrayList classificationVos = Lists.newArrayListWithCapacity((int)10);
            if (apiclassifyMap.keySet().contains(0L)) {
                EaiApiClassificationVo classificationVo = new EaiApiClassificationVo();
                classificationVo.setId(Long.valueOf(0L));
                classificationVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
                classificationVo.setName("\u9ed8\u8ba4\u7c7b\u578b");
                classificationVo.setDesc("\u9ed8\u8ba4\u7c7b\u578b");
                classificationVo.setRemark("\u9ed8\u8ba4\u7c7b\u578b");
                classificationVos.add(classificationVo);
            }
            Set<Long> classifyIds = apiclassifyMap.keySet();
            classifyIds.remove(0L);
            if (classifyIds.size() > 1) {
                List apiClassifications = this.apiClassificationService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(EaiApiClassification::getApplicationCode, (Object)applicationCode)).in(EaiApiClassification::getId, (Collection)classifyIds.stream().collect(Collectors.toList())));
                apiClassifications.forEach(apic -> {
                    EaiApiClassificationVo classificationVo = new EaiApiClassificationVo();
                    classificationVo.setId(apic.getId());
                    classificationVo.setName(apic.getClassificName());
                    classificationVo.setDesc(apic.getClassificName());
                    classificationVo.setRemark(apic.getRemark());
                    classificationVos.add(classificationVo);
                });
            }
            eaiResourceVo.setApis(apiInfoVos);
            eaiResourceVo.setApiClassifys((List)classificationVos);
        }
        if (CollectionUtil.isNotEmpty((Collection)(commonConstants = this.commonConstantService.list((Wrapper)new LambdaQueryWrapper().eq(CommonConstant::getApplicationCode, (Object)applicationCode))))) {
            ArrayList returnCommonConstants = Lists.newArrayListWithCapacity((int)10);
            commonConstants.forEach(c -> {
                CommonConstantVo constantVo = new CommonConstantVo();
                BeanUtil.copy((Object)c, (Object)constantVo);
                constantVo.setName(c.getConstantNameEn());
                constantVo.setDesc(c.getConstantName());
                returnCommonConstants.add(constantVo);
            });
            eaiResourceVo.setCommonConstants((List)returnCommonConstants);
        }
        if (CollectionUtil.isNotEmpty((Collection)(commonStructures = this.commonStructureService.list((Wrapper)new LambdaQueryWrapper().eq(CommonStructure::getApplicationCode, (Object)applicationCode))))) {
            ArrayList returnCommonStructureVos = Lists.newArrayListWithCapacity((int)10);
            commonStructures.forEach(c -> {
                CommonStructureVo structureVo = new CommonStructureVo();
                structureVo.setId(String.valueOf(c.getId()));
                structureVo.setName(c.getStructureCode());
                structureVo.setDesc(c.getStructureName());
                structureVo.setRemark(c.getRemark());
                returnCommonStructureVos.add(structureVo);
            });
            eaiResourceVo.setStructures((List)returnCommonStructureVos);
        }
        return eaiResourceVo;
    }

    public ApiInfoEditVo getApiBaseInfoById(String id) {
        AssertUtil.isNotEmpty((String)id, (String)"id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        ApiInfoEditVo apiInfoEditVo = this.eaiReleaseApiMapper.getById(Long.parseLong(id));
        apiInfoEditVo.setName(apiInfoEditVo.getApiCode());
        apiInfoEditVo.setDesc(apiInfoEditVo.getApiName());
        if (StringUtil.isEmpty((Object)apiInfoEditVo.getClassificId())) {
            apiInfoEditVo.setParentId(Long.valueOf(0L));
            apiInfoEditVo.setClassificId(Long.valueOf(0L));
            apiInfoEditVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
        } else {
            if (0L == apiInfoEditVo.getClassificId()) {
                apiInfoEditVo.setClassificName("\u9ed8\u8ba4\u7c7b\u578b");
            }
            apiInfoEditVo.setParentId(apiInfoEditVo.getClassificId());
        }
        return apiInfoEditVo;
    }

    public Boolean checkApiName(CheckApiCodeDto checkApiCodeDto) {
        AssertUtil.isNotNull((Object)checkApiCodeDto, (String)"\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)checkApiCodeDto.getApiName(), (String)"\u63a5\u53e3\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotEmpty((String)checkApiCodeDto.getApplicationCode(), (String)"\u5e94\u7528\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        return this.eaiReleaseApiMapper.countByApiName(checkApiCodeDto) == 0;
    }
}

