/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.ds.process.service.impl;

import com.jxdinfo.hussar.ds.process.model.DpJobInfo;
import com.jxdinfo.hussar.ds.process.service.DataStreamDataSetService;
import com.jxdinfo.hussar.ds.process.service.DpJobInfoService;
import com.jxdinfo.hussar.ds.process.service.HussarDsOutputTaskManager;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.lock.HussarLockGuard;
import com.jxdinfo.hussar.support.lock.HussarLockManager;
import com.jxdinfo.hussar.support.lock.HussarLockType;
import com.jxdinfo.hussar.support.lock.annotation.HussarLockExecutionStrategy;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class HussarDsOutputTaskManagerImpl
implements HussarDsOutputTaskManager,
ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(HussarDsOutputTaskManagerImpl.class);
    private ScheduledExecutorService executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("hussar-ds-schedule-pool-%d").daemon(true).build());
    @Autowired
    private DpJobInfoService dpJobInfoService;
    @Autowired
    private HussarLockManager hussarLockManager;
    @Autowired
    private DataStreamDataSetService dataStreamDataSetService;

    public void run(ApplicationArguments args) throws Exception {
        List dpJobInfos = this.dpJobInfoService.listJobInfoByTime(null, LocalDateTime.now());
        for (DpJobInfo jobInfo : dpJobInfos) {
            LocalDateTime nextTime = this.calcNextTime(jobInfo);
            while (nextTime.isBefore(LocalDateTime.now())) {
                jobInfo.setNextTime(nextTime);
                nextTime = this.calcNextTime(jobInfo);
            }
            this.runJob(jobInfo);
        }
    }

    @Scheduled(fixedRate=5000L)
    public void schedule() {
        LocalDateTime startTime = LocalDateTime.now();
        LocalDateTime endTime = LocalDateTime.now().plusSeconds(10L);
        List jobInfos = this.dpJobInfoService.listJobInfoByTime(startTime, endTime);
        jobInfos.forEach(this::runJob);
    }

    public void runJob(final DpJobInfo jobInfo) {
        HussarLockGuard hussarLockGuard = null;
        try {
            hussarLockGuard = this.lock(String.valueOf(jobInfo.getId()));
            if (HussarUtils.isNotEmpty((Object)hussarLockGuard)) {
                long delayTime = Duration.between(LocalDateTime.now(), jobInfo.getNextTime()).toMillis();
                final HussarLockGuard finalHussarLockGuard = hussarLockGuard;
                ScheduledFuture<?> scheduledFuture = this.executorService.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        log.info("\u5f00\u59cb\u6267\u884c\u4efb\u52a1\uff1a{}", (Object)jobInfo.getId());
                        try {
                            LocalDateTime nextTime = HussarDsOutputTaskManagerImpl.this.calcNextTime(jobInfo);
                            jobInfo.setNextTime(nextTime);
                            if (HussarDsOutputTaskManagerImpl.this.dpJobInfoService.updateById((Object)jobInfo)) {
                                HussarDsOutputTaskManagerImpl.this.dataStreamDataSetService.conductorStartWorkFlow(jobInfo.getDataSetId(), null, null);
                            }
                        }
                        finally {
                            HussarDsOutputTaskManagerImpl.this.releaseLock(finalHussarLockGuard);
                            log.info("\u4efb\u52a1\u6267\u884c\u5b8c\u6210\uff1a{}", (Object)jobInfo.getId());
                        }
                    }
                }, delayTime, TimeUnit.MILLISECONDS);
            }
        }
        catch (HussarException e) {
            log.error("\u83b7\u53d6\u9501\u5931\u8d25\uff1a{}", (Object)jobInfo.getId());
            this.releaseLock(hussarLockGuard);
        }
    }

    private HussarLockGuard lock(String key) {
        String lockKey = "data_stream:job_info_lock:" + key;
        return this.hussarLockManager.acquire(HussarLockType.REENTRANT_LOCK, HussarLockExecutionStrategy.UNLIMITED, lockKey, Duration.ofMinutes(10L));
    }

    private void releaseLock(HussarLockGuard hussarLockGuard) {
        if (HussarUtils.isNotEmpty((Object)hussarLockGuard)) {
            hussarLockGuard.releaseLock();
        }
    }

    private LocalDateTime calcNextTime(DpJobInfo config) {
        LocalDateTime current = LocalDateTime.now();
        LocalDateTime nextTime = config.getNextTime();
        switch (config.getPeriodType()) {
            case "MINUTES": {
                nextTime = nextTime.plusMinutes(config.getMinutes().intValue());
                break;
            }
            case "HOURS": {
                nextTime = nextTime.plusHours(config.getHours().intValue());
                break;
            }
            case "DAYS": {
                LocalTime localTime = LocalTime.parse(config.getTime());
                nextTime = current.toLocalDate().atTime(localTime);
                if (!nextTime.isBefore(current)) break;
                nextTime = nextTime.plusDays(1L);
                break;
            }
            case "WEEK": {
                Integer week = config.getWeek();
                LocalDateTime candidateDate = current.plusDays(week + 1 - current.getDayOfWeek().getValue());
                nextTime = candidateDate.toLocalDate().atTime(LocalTime.parse(config.getTime()));
                if (!nextTime.isBefore(current)) break;
                nextTime = nextTime.plusWeeks(1L);
                break;
            }
            default: {
                throw new HussarException("\u4e0d\u652f\u6301\u7684\u5468\u671f\u7c7b\u578b");
            }
        }
        return nextTime;
    }
}

